/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelInBillListPlugin
extends OcbaseFormMobPlugin
implements TabSelectListener,
MobileSearchTextChangeListener,
CreateListDataProviderListener,
ListRowClickListener {
    private static final String[] billStatusArray = new String[]{"A", "B"};
    private static final String btnadd = "btnadd";
    private static final String btnedit = "btnedit";
    private static final String btndelete = "btndelete";
    private static final String btninstock = "btninstock";
    private static final String btnunsubmit = "btnunsubmit";
    private static final String op_billlistap = "billlistap";
    private static final String op_tabap = "tabap";
    private static final String op_ordersearch = "ordersearch";
    private static final String enddate = "enddate";
    private static final String startdate = "startdate";
    private static final String inbilldatespan = "inbilldatespan";
    private static final String OCDMA_CHANNELINBILL_ADD = "ocdma_channelinbill_add";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{op_tabap});
        this.addClickListeners(new String[]{btnadd, btnedit, btndelete, btninstock, btnunsubmit});
        MobileSearch search = (MobileSearch)this.getControl(op_ordersearch);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(op_billlistap);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object opKey = this.getParameter("opkey");
        if (!ObjectUtils.isEmpty((Object)opKey)) {
            Tab tab = (Tab)this.getControl(op_tabap);
            String tbKey = opKey.toString();
            tab.selectTab(tbKey);
            tab.activeTab(tbKey);
        }
        this.refreshBillList();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        BillList billList = (BillList)this.getControl(op_billlistap);
        switch (key) {
            case "btnadd": {
                break;
            }
            case "btnedit": {
                String billStatus = billList.getCurrentSelectedRowInfo().getBillStatus();
                if (billStatus.equals("A")) {
                    this.showForm(OperationStatus.EDIT, OCDMA_CHANNELINBILL_ADD);
                    break;
                }
                this.getView().showTipNotification("\u53ea\u80fd\u4fee\u6539\u6682\u5b58\u7684\u8ba2\u5355\u3002");
                break;
            }
            case "btndelete": {
                if (billList.getCurrentSelectedRowInfo().getBillStatus().equals("A")) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(btndelete, (IFormPlugin)this);
                    this.getView().showConfirm("\u662f\u5426\u5220\u9664\u9009\u4e2d\u8ba2\u5355\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                this.getView().showTipNotification("\u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u8ba2\u5355\u3002");
                break;
            }
            case "btninstock": {
                String billStatus = billList.getCurrentSelectedRowInfo().getBillStatus();
                this.instock(billStatus);
                break;
            }
            case "btnunsubmit": {
                String billStatus = billList.getCurrentSelectedRowInfo().getBillStatus();
                if (billStatus.equals("B")) {
                    Object billid = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                    if (ObjectUtils.isEmpty((Object)billid)) {
                        this.getView().showTipNotification("\u8bf7\u9009\u4e2d\u6570\u636e\u884c\u3002");
                        return;
                    }
                    Object[] objectIds = new Object[]{billid};
                    OperateOption option = CommonUtils.getOperateOption();
                    OperationResult result = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"ococic_channelinbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                        break;
                    }
                    this.getView().showSuccessNotification("\u64a4\u9500\u6210\u529f");
                    this.refreshBillList();
                    break;
                }
                this.getView().showTipNotification("\u53ea\u6709\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u8ba2\u5355\u624d\u80fd\u64a4\u9500\u3002");
                break;
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String key;
        switch (key = ((Control)mobileSearchTextChangeEvent.getSource()).getKey()) {
            case "ordersearch": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "new": {
                this.showAddForm(OperationStatus.ADDNEW, OCDMA_CHANNELINBILL_ADD);
                break;
            }
        }
        super.afterDoOperation(args);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String key;
        switch (key = ((Control)tabSelectEvent.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                BillList billList = (BillList)this.getControl(op_billlistap);
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter(tabSelectEvent.getTabKey())});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "enddate": 
            case "startdate": 
            case "inbilldatespan": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void showAddForm(OperationStatus operationStatus, String formId) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(formId);
        mobileFormShowParameter.setStatus(operationStatus);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void showForm(OperationStatus operationStatus, String formId) {
        BillList billList = (BillList)this.getControl(op_billlistap);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(formId);
        mobileFormShowParameter.setStatus(operationStatus);
        mobileFormShowParameter.setCustomParam("billid", pkId);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void instock(String billStatus) {
        BillList billList = (BillList)this.getControl(op_billlistap);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        Object[] pkIds = new Object[]{pkId};
        OperateOption option = CommonUtils.getOperateOption();
        switch (billStatus) {
            case "A": {
                OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_channelinbill", (Object[])pkIds, (OperateOption)option);
                if (!result.isSuccess()) {
                    this.getView().showOperationResult(result);
                } else {
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_channelinbill", (Object[])pkIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                    }
                }
                this.refreshBillList();
                break;
            }
            case "B": {
                OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_channelinbill", (Object[])pkIds, (OperateOption)option);
                if (!result.isSuccess()) {
                    this.getView().showOperationResult(result);
                }
                this.refreshBillList();
                break;
            }
            case "C": {
                this.getView().showTipNotification("\u53ea\u80fd\u4e00\u952e\u5165\u5e93\u3010\u5f85\u5b8c\u6210\u3011\u7684\u8ba2\u5355\u3002");
                break;
            }
            default: {
                this.getView().showTipNotification(String.format("\u5165\u5e93\u5931\u8d25\uff1a\u8ba2\u5355\u72b6\u6001\u3010%s\u3011\u4e0d\u5408\u6cd5\u3002", billStatus));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)key, (CharSequence)OCDMA_CHANNELINBILL_ADD)) {
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "btndelete": {
                BillList billList = (BillList)this.getControl(op_billlistap);
                Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ococic_channelinbill");
                OperationResult delResult = OperationUtil.invokeOperation((DynamicObject)bill, (String)"delete");
                if (!delResult.isSuccess()) break;
                this.refreshBillList();
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(op_billlistap);
        Tab tab = (Tab)this.getControl(op_tabap);
        String curTabKey = tab.getCurrentTab();
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter(curTabKey)});
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.showForm(OperationStatus.VIEW, OCDMA_CHANNELINBILL_ADD);
    }

    private QFilter getBillFilter(String key) {
        QFilter filter = this.getBillChannelFilter();
        switch (key) {
            case "tp_all": {
                break;
            }
            case "d": {
                filter.and("billstatus", "in", (Object)billStatusArray);
                break;
            }
            default: {
                filter.and("billstatus", "=", (Object)key.toUpperCase());
            }
        }
        MobileSearch search = (MobileSearch)this.getControl(op_ordersearch);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno,billentry.itemid.name,billentry.itemid.number"}));
        }
        this.setDateFilter(filter);
        return filter;
    }

    private void setDateFilter(QFilter filter) {
        Date startDate = (Date)this.getValue(startdate);
        Date endDate = (Date)this.getValue(enddate);
        if (startDate != null && endDate != null) {
            filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)startDate));
            filter.and("instocktime", "<=", (Object)DateUtil.getDayLast((Date)endDate));
            return;
        }
        Object inbilldateSpan = this.getValue(inbilldatespan);
        String selectDate = "F";
        if (!CommonUtils.isNull((Object)inbilldateSpan)) {
            selectDate = inbilldateSpan.toString();
        }
        switch (selectDate) {
            case "A": {
                filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(6L))));
                break;
            }
            case "B": {
                filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth()));
                break;
            }
            case "C": {
                filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(90L))));
                break;
            }
            case "D": {
                filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                filter.and("instocktime", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                break;
            }
            case "E": {
                filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                filter.and("instocktime", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                break;
            }
            case "G": {
                filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                filter.and("instocktime", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                break;
            }
            default: {
                filter.and("instocktime", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getNowDate()));
                filter.and("instocktime", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getNowDate()));
            }
        }
    }

    private QFilter getBillChannelFilter() {
        QFilter filter = null;
        List channelIds = CUserHelper.getAuthorizedChannelIdList();
        filter = channelIds != null && channelIds.size() > 0 ? new QFilter("inchannelid", "in", (Object)channelIds) : new QFilter("inchannelid", "=", (Object)0L);
        return filter;
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
    }
}

