/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelInBillSNPlugin
extends OcbaseFormMobPlugin {
    private static final Log logger = LogFactory.getLog(ChannelInBillSNPlugin.class);
    private static final String BTNCONFIRM = "btnconfirm";
    private static final String OP_SCANQRCODE = "scanqrcode";
    private static final String BTNSAVE = "btnsave";
    private static final String SERIALLIST = "seriallist";
    private static final String SERIALNUMBER = "serialnumber";
    private static final String SERIALID = "serialid";
    private static final String SNSEARCH = "snsearch";
    private static final String ISWX = "iswx";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNCONFIRM, BTNSAVE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initSN();
        boolean isWx = CommonUtils.isFromWeixin((String)RequestContext.get().getUserAgent());
        if (isWx) {
            this.setValue(ISWX, true);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnconfirm": {
                String snsearch = String.valueOf(this.getValue(SNSEARCH));
                this.scanAdd(snsearch);
                break;
            }
            case "btnsave": {
                JSONObject snJson = new JSONObject();
                DynamicObjectCollection serialList = this.getModel().getEntryEntity(SERIALLIST);
                for (DynamicObject serial : serialList) {
                    String serialnumber = serial.getString(SERIALNUMBER);
                    long serialid = serial.getLong(SERIALID);
                    snJson.put(serialnumber, (Object)serialid);
                }
                this.getView().returnDataToParent((Object)snJson);
                this.getView().close();
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String customKey = e.getKey();
        logger.info(String.format("eventName:%s key:%s value:%s", eventName, customKey, value));
        if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"callappmethod")) {
            Map result;
            String qrCode;
            boolean isAddSuccess;
            if (eventName.equals("scanQRCode") && (isAddSuccess = this.scanAdd(qrCode = String.valueOf((result = (Map)SerializationUtils.fromJsonString((String)value, Map.class)).get("qrcode_str"))))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OP_SCANQRCODE, (IFormPlugin)this);
                this.getView().showConfirm("\u626b\u7801\u6210\u529f\uff0c\u7ee7\u7eed\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"wxscanqrcode") && StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)"scancode")) {
            JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
            String qrCode = CommonUtils.convertObjectToString((Object)result.get((Object)"value"));
            this.scanAdd(qrCode);
        }
    }

    private boolean scanAdd(String qrCode) {
        if (StringUtils.isEmpty((CharSequence)(qrCode = qrCode.trim()))) {
            this.getView().showTipNotification("\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection serialList = model.getEntryEntity(SERIALLIST);
        for (DynamicObject serial : serialList) {
            String serialNumber = serial.getString(SERIALNUMBER);
            if (!StringUtils.equals((CharSequence)serialNumber, (CharSequence)qrCode)) continue;
            this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u5df2\u5b58\u5728", qrCode));
            this.setValue(SNSEARCH, "");
            return false;
        }
        int rowIndex = model.createNewEntryRow(SERIALLIST);
        model.setValue(SERIALNUMBER, (Object)qrCode, rowIndex);
        this.setValue(SNSEARCH, "");
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "scanqrcode": {
                this.getView().invokeOperation(OP_SCANQRCODE);
                break;
            }
        }
    }

    private void initSN() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setValue("itemid", customParams.get("itemid"));
        this.setValue("unitid", customParams.get("unitid"));
        this.setValue("qty", customParams.get("qty"));
        this.setValue("thumbnail", customParams.get("thumbnail"));
        String mulserialnumber = String.valueOf(customParams.get("mulserialnumber"));
        this.setSerialList(mulserialnumber);
    }

    private void setSerialList(String mulserialnumber) {
        JSONObject snJson = JSONObject.parseObject((String)mulserialnumber);
        if (snJson != null && snJson.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(SERIALLIST, snJson.size());
            int rowIndex = 0;
            Set snNumbers = snJson.entrySet();
            for (Map.Entry snEntry : snNumbers) {
                model.setValue(SERIALNUMBER, snEntry.getKey(), rowIndex);
                model.setValue(SERIALID, snEntry.getValue(), rowIndex);
                ++rowIndex;
            }
        }
    }
}

