/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelInventoryList
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener {
    private static final String OP_ITEMSEARCH = "itemsearch";
    private static final String CHANNEL = "channel";
    private static final String ISALLCHANNEL = "isallchannel";
    private static final String BTNCLOSE = "btnclose";
    private static final String SUMMODE = "summode";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery", "btnserial"});
        this.addF7Listener(this, new String[]{CHANNEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long channelId = this.getChannelId();
        this.setValue(CHANNEL, new Long[]{channelId});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setItemInvList();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channel": {
                List channelIdList = CUserHelper.getAuthorizedChannelIdList();
                QFilter qFilter = new QFilter("id", "in", (Object)channelIdList);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String button;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (button = control.getKey()) {
            case "btnquery": {
                this.setItemInvList();
                break;
            }
            case "btnserial": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdma_channelinv_sn");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(9);
                DynamicObject rowEntry = this.getRowInfo("iteminvlist", this.getCurrentRowIndex("iteminvlist"));
                DynamicObject channel = (DynamicObject)this.getValue("channelid");
                DynamicObject item = (DynamicObject)this.getValue("itemid");
                hashMap.put("channelid", DynamicObjectUtils.getPkValue((DynamicObject)channel));
                hashMap.put("itemid", DynamicObjectUtils.getPkValue((DynamicObject)item));
                hashMap.put("materialid", rowEntry.getLong("materialid_id"));
                hashMap.put("stockunitid", rowEntry.getLong("stockunitid_id"));
                hashMap.put("stockqty", rowEntry.getBigDecimal("stockqty"));
                hashMap.put("saleunitid", rowEntry.getLong("saleunitid_id"));
                hashMap.put("saleqty", rowEntry.getBigDecimal("saleqty"));
                hashMap.put("invkeyjson", rowEntry.getString("invkeyjson"));
                hashMap.put("thumbnail", DynamicObjectUtils.getString((DynamicObject)item, (String)"thumbnail"));
                showParameter.setCustomParams(hashMap);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    private void setItemInvList() {
        String searchFields;
        List channelIdList = null;
        Object channels = this.getModel().getValue(CHANNEL);
        boolean isallchannel = (Boolean)this.getModel().getValue(ISALLCHANNEL);
        if (isallchannel) {
            channelIdList = CUserHelper.getAuthorizedChannelIdList();
        } else if (channels instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection resourcestockBaseColl = (MulBasedataDynamicObjectCollection)channels;
            channelIdList = resourcestockBaseColl.stream().map(k -> (Long)((DynamicObject)k.get("fbasedataid")).getPkValue()).collect(Collectors.toList());
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("iteminvlist");
        if (channelIdList == null || channelIdList.size() == 0) {
            return;
        }
        MobileSearch search = (MobileSearch)this.getControl(OP_ITEMSEARCH);
        String searchValue = search.getText().trim();
        DynamicObjectCollection itemDynObjCol = this.queryItemDynObjCol(searchValue, searchFields = "number,name,modelnum");
        if (CollectionUtils.isEmpty((Collection)itemDynObjCol)) {
            return;
        }
        ArrayList<Long> itemidList = new ArrayList<Long>(itemDynObjCol.size());
        HashMap<Long, DynamicObject> itemidObjectMap = new HashMap<Long, DynamicObject>(itemDynObjCol.size());
        for (DynamicObject itemDynObj : itemDynObjCol) {
            long itemid = itemDynObj.getLong("id");
            itemidList.add(itemid);
            itemidObjectMap.put(itemid, itemDynObj);
        }
        List channelInvAccResults = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"ChannelInvAccService", (String)"queryChannelAvailableInventory", (Object[])new Object[]{channelIdList, itemidList});
        if (CollectionUtils.isEmpty((Collection)channelInvAccResults)) {
            return;
        }
        boolean isShowChannel = true;
        List<JSONObject> groupKeyResults = new ArrayList();
        String summode = String.valueOf(this.getModel().getValue(SUMMODE));
        if (StringUtils.equals((CharSequence)summode, (CharSequence)"B")) {
            isShowChannel = false;
            HashMap<String, JSONObject> groupKeyResultMap = new HashMap<String, JSONObject>(channelInvAccResults.size());
            Object object = channelInvAccResults.iterator();
            while (object.hasNext()) {
                JSONObject channelInvAccResult = (JSONObject)object.next();
                String groupKey = channelInvAccResult.getString("itemid");
                JSONObject mapInvAccResult = (JSONObject)groupKeyResultMap.get(groupKey);
                if (mapInvAccResult == null) {
                    groupKeyResults.add(channelInvAccResult);
                    groupKeyResultMap.put(groupKey, channelInvAccResult);
                    continue;
                }
                BigDecimal sumStockQty = mapInvAccResult.getBigDecimal("stockqty").add(channelInvAccResult.getBigDecimal("stockqty"));
                BigDecimal sumBaseQty = mapInvAccResult.getBigDecimal("baseqty").add(channelInvAccResult.getBigDecimal("baseqty"));
                mapInvAccResult.put("stockqty", (Object)sumStockQty);
                mapInvAccResult.put("baseqty", (Object)sumBaseQty);
            }
        } else {
            groupKeyResults = channelInvAccResults;
        }
        int[] indexes = model.batchCreateNewEntryRow("iteminvlist", groupKeyResults.size());
        for (int index : indexes) {
            JSONObject groupKeyResult = (JSONObject)groupKeyResults.get(index);
            long itemid = groupKeyResult.getLong("itemid");
            BigDecimal stockqty = groupKeyResult.getBigDecimal("stockqty");
            BigDecimal baseqty = groupKeyResult.getBigDecimal("baseqty");
            long baseunitid = groupKeyResult.getLong("baseunitid");
            long stockunitid = groupKeyResult.getLong("stockunitid");
            String lotnum = groupKeyResult.getString("lotnum");
            if (isShowChannel) {
                model.setValue("channelid", (Object)groupKeyResult.getLong("channelid"), index);
                JSONObject invkeyJson = new JSONObject();
                invkeyJson.put("saleorgid", (Object)groupKeyResult.getLong("saleorgid"));
                invkeyJson.put("channelid", (Object)groupKeyResult.getLong("channelid"));
                invkeyJson.put("channelstockid", (Object)groupKeyResult.getLong("channelstockid"));
                invkeyJson.put("channellocationid", (Object)groupKeyResult.getLong("channellocationid"));
                invkeyJson.put("itemid", (Object)itemid);
                invkeyJson.put("auxptyid", (Object)groupKeyResult.getLong("auxptyid"));
                invkeyJson.put("lotnum", (Object)lotnum);
                invkeyJson.put("stockunitid", (Object)stockunitid);
                invkeyJson.put("baseunitid", (Object)groupKeyResult.getLong("baseunitid"));
                invkeyJson.put("channelstockstatusid", (Object)groupKeyResult.getLong("channelstockstatusid"));
                invkeyJson.put("channelstocktypeid", (Object)groupKeyResult.getLong("channelstocktypeid"));
                invkeyJson.put("keepertype", (Object)groupKeyResult.getString("keepertype"));
                invkeyJson.put("keeperid", (Object)groupKeyResult.getLong("keeperid"));
                invkeyJson.put("ownertype", (Object)groupKeyResult.getString("ownertype"));
                invkeyJson.put("ownerid", (Object)groupKeyResult.getLong("ownerid"));
                invkeyJson.put("productdate", (Object)groupKeyResult.getDate("productdate"));
                invkeyJson.put("effectivedate", (Object)groupKeyResult.getDate("effectivedate"));
                invkeyJson.put("projectid", (Object)groupKeyResult.getLong("projectid"));
                model.setValue("invkeyjson", (Object)invkeyJson.toJSONString(), index);
            }
            model.setValue("itemid", (Object)itemid, index);
            model.setValue("stockqty", (Object)stockqty, index);
            model.setValue("stockunitid", (Object)stockunitid, index);
            model.setValue("lotnum", (Object)lotnum, index);
            DynamicObject itemDynObj = (DynamicObject)itemidObjectMap.get(itemid);
            if (itemDynObj == null) continue;
            long materialid = itemDynObj.getLong("material");
            long saleunitid = itemDynObj.getLong("saleunit");
            BigDecimal saleqty = UnitConvertHelper.calculateDestQty((BigDecimal)baseqty, (Long)materialid, (Long)baseunitid, (Long)saleunitid);
            model.setValue("saleqty", (Object)saleqty, index);
            model.setValue("saleunitid", (Object)saleunitid, index);
            model.setValue("materialid", (Object)materialid, index);
            model.setValue("enableserial", (Object)itemDynObj.getBoolean("enableserial"), index);
        }
    }

    private DynamicObjectCollection queryItemDynObjCol(String searchValue, String searchFields) {
        String selectFileds = String.join((CharSequence)",", "id", "saleunit", "material", "enableserial", "thumbnail");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(QMatches.ftlike((String[])new String[]{searchValue}, (String[])new String[]{searchFields}));
        return QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFileds, (QFilter[])filter.toArray());
    }

    private long getChannelId() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String cacheChannelId = parentPageCache.get("channelId");
        long channelId = cacheChannelId != null ? Long.parseLong(cacheChannelId) : B2BUserHelper.getLoginChannelId();
        return channelId;
    }
}

