/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.flex.FlexService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.helper.returnorder.ReturnOrderBusinessHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelOutBillEditPlugin
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(ChannelOutBillEditPlugin.class);
    private static final String btnselectitem = "btnselectitem";
    private static final String btnselectsn = "btnselectsn";
    private static final String op_scanqrcode = "scanqrcode";
    private static final String op_add = "add";
    private static final String op_reduce = "reduce";
    private static final String op_save = "save";
    private static final String op_outstock = "outstock";
    private static final String btnmore = "btnmore";
    private static final String ISWX = "iswx";
    private static final String SNINPUT = "sninput";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!this.isView()) {
            this.addClickListeners(new String[]{btnselectitem, btnselectsn, op_add, op_reduce, op_save, op_outstock, btnmore});
        }
        this.addRowClickListener(this, new String[]{"billentry"});
        this.addF7Listener(this, new String[]{"outchannelid", "warehouse", "orderchannelid", "saleorg", "itemid"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("operationStatus", this.getView().getFormShowParameter().getStatus().toString());
        String orderId = (String)this.getView().getFormShowParameter().getCustomParam("orderid");
        if (StringUtils.isNotBlank((CharSequence)orderId)) {
            DynamicObject outBill = this.pushOutStock(Long.parseLong(orderId));
            this.getPageCache().putBigObject(outBill.getDataEntityType().getName() + this.getView().getPageId(), DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{outBill}, (DynamicObjectType)outBill.getDynamicObjectType()));
            this.viewOrder(outBill);
            this.setValue("ispush", Boolean.TRUE);
        } else if (this.isView() || this.isEdit()) {
            Object billid = this.getParameter("billid");
            this.getModel().setValue("id", billid);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"ococic_channeloutbill");
            this.viewOrder(bill);
        } else if (this.isAddNew()) {
            this.initNewBillHead();
        }
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtypeid");
        long billtypeid = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)billtype);
        if (billtypeid == 1028196345158206464L) {
            this.setMustInput("orderchannelid", true);
        } else {
            this.setMustInput("orderchannelid", false);
        }
        boolean isWx = CommonUtils.isFromWeixin((String)RequestContext.get().getUserAgent());
        if (isWx) {
            this.setValue(ISWX, Boolean.TRUE);
        }
    }

    private void viewOrder(DynamicObject bill) {
        this.setValue("billno", bill.get("billno"));
        this.setValue("billtypeid", bill.get("billtypeid"));
        this.setValue("outchannelid", bill.get("outchannelid"));
        this.setValue("orderchannelid", bill.get("orderchannelid"));
        this.setValue("org", bill.get("org"));
        this.setValue("saleorg", bill.get("saleorg"));
        this.setValue("currencyid", bill.get("currencyid"));
        this.setValue("billstatus", bill.get("billstatus"));
        MobExtendHelper.loadMobExtend((IDataModel)this.getModel(), (String)this.getView().getEntityId(), (DynamicObject)bill, (String)"ococic_channeloutbill");
        Map extColsMap = MobExtendHelper.getExtColsMap((String)this.getView().getEntityId(), (String)"ococic_channeloutbill");
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)billEntry)) {
            return;
        }
        int[] rowIndexes = this.getModel().batchCreateNewEntryRow("billentry", billEntry.size());
        DynamicObjectCollection pageItemData = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntry.get(i);
            int rowIndex = rowIndexes[i];
            this.setValue("itemid", entry.get("itemid"), rowIndex);
            this.setValue("materialid", entry.get("materielid"), rowIndex);
            this.setValue("qty", entry.getBigDecimal("quantity"), rowIndex);
            this.setValue("unitid", entry.get("unitid"), rowIndex);
            this.setValue("baseqty", entry.getBigDecimal("basequantity"), rowIndex);
            this.setValue("baseunitid", entry.get("baseunitid"), rowIndex);
            this.setValue("serialqty", entry.getBigDecimal("snquantity"), rowIndex);
            this.setValue("serialunit", entry.get("snunit"), rowIndex);
            this.setValue("auxptyid", entry.get("auxptyid"), rowIndex);
            this.setValue("assistunitid", entry.get("auxptyunitid"), rowIndex);
            this.setValue("warehouse", entry.get("stockid"), rowIndex);
            this.setValue("locationid", entry.get("stockaddrid"), rowIndex);
            this.setValue("stockstatus", entry.get("stockstatusid"), rowIndex);
            this.setValue("stocktype", entry.get("stocktypeid"), rowIndex);
            this.setValue("ownerid", entry.get("ownerid"), rowIndex);
            this.setValue("ownertype", entry.get("ownertype"), rowIndex);
            this.setValue("keeperid", entry.get("keeperid"), rowIndex);
            this.setValue("keepertype", entry.get("keepertype"), rowIndex);
            this.setValue("lotnumber", entry.get("lotnumber"), rowIndex);
            this.setValue("lotnumberid", entry.get("lotid"), rowIndex);
            this.setValue("producedate", entry.get("productdate"), rowIndex);
            this.setValue("expirydate", entry.get("expiredate"), rowIndex);
            this.setValue("projectid", entry.get("projectid"), rowIndex);
            DynamicObject itemDynObj = this.getEntryF7Value("billentry", "itemid", rowIndex);
            if (itemDynObj != null) {
                this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex);
            }
            this.setValue("srcbillentity", entry.get("srcbillentity"), rowIndex);
            this.setValue("srcbillnumber", entry.get("srcbillnumber"), rowIndex);
            this.setValue("srcbillentryseq", entry.get("srcbillentryseq"), rowIndex);
            this.setValue("srcbillentryid", entry.get("srcbillentryid"), rowIndex);
            this.setValue("srcbillid", entry.get("srcbillid"), rowIndex);
            this.setValue("mainbillentity", entry.get("mainbillentity"), rowIndex);
            this.setValue("mainbillnumber", entry.get("mainbillnumber"), rowIndex);
            this.setValue("mainbillentryseq", entry.get("mainbillentryseq"), rowIndex);
            this.setValue("mainbillid", entry.get("mainbillid"), rowIndex);
            this.setValue("mainbillentryid", entry.get("mainbillentryid"), rowIndex);
            this.setValue("priceandtax", entry.get("priceandtax"), rowIndex);
            this.setValue("taxrate", entry.get("taxrate"), rowIndex);
            this.setValue("price", entry.get("price"), rowIndex);
            this.setValue("discountrate", entry.get("discountrate"), rowIndex);
            this.setValue("discounttype", entry.get("discounttype"), rowIndex);
            this.setValue("discountamount", entry.get("discountamount"), rowIndex);
            this.setValue("amountandtax", entry.get("amountandtax"), rowIndex);
            this.setValue("joinqty", entry.get("joinqty"), rowIndex);
            this.setValue("joinbaseqty", entry.get("joinbaseqty"), rowIndex);
            this.setValue("joinassistqty", entry.get("joinassistqty"), rowIndex);
            this.setValue("sendqty", entry.get("sendqty"), rowIndex);
            for (Map.Entry extCols : extColsMap.entrySet()) {
                if (!((DynamicObject)pageItemData.get(0)).containsProperty((String)extCols.getKey()) || !entry.containsProperty((String)extCols.getValue())) continue;
                this.setValue((String)extCols.getKey(), entry.get((String)extCols.getValue()), rowIndex);
            }
            DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("chnloutbill_sn");
            if (CollectionUtils.isEmpty((Collection)subEntryEntity)) continue;
            JSONObject snJson = new JSONObject();
            boolean isFirstRow = true;
            for (DynamicObject subEntry : subEntryEntity) {
                String serialnumber = subEntry.getString("serialnumber");
                Object serialid = subEntry.getPkValue();
                snJson.put(serialnumber, serialid);
                if (!isFirstRow) continue;
                this.setValue("serialnumber", serialnumber, rowIndex);
                this.setValue("serialid", serialid, rowIndex);
                isFirstRow = false;
            }
            this.setValue("mulserialnumber", snJson, rowIndex);
            this.viewIndexSerialNumber(rowIndex);
        }
    }

    private DynamicObject pushOutStock(long orderId) {
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"ocbsoc_saleorder");
        DynamicObjectCollection itemEntry = saleOrder.getDynamicObjectCollection("itementry");
        int row = 0;
        ArrayList<ListSelectedRow> needPushRowList = new ArrayList<ListSelectedRow>();
        if (itemEntry != null && !itemEntry.isEmpty()) {
            for (DynamicObject item : itemEntry) {
                DynamicObjectCollection subEntryEntity = item.getDynamicObjectCollection("subentryentity");
                if (subEntryEntity == null || subEntryEntity.isEmpty()) continue;
                for (DynamicObject subEntry : subEntryEntity) {
                    subEntry.getPkValue();
                    ListSelectedRow srcBill = new ListSelectedRow(saleOrder.getPkValue());
                    srcBill.setRowKey(row);
                    srcBill.setEntryEntityKey("itementry");
                    srcBill.setEntryPrimaryKeyValue(item.getPkValue());
                    srcBill.setSubEntryEntityKey("subentryentity");
                    srcBill.setSubEntryPrimaryKeyValue(subEntry.getPkValue());
                    needPushRowList.add(srcBill);
                    ++row;
                }
            }
        }
        return this.pushChannelOutBill(needPushRowList);
    }

    public DynamicObject pushChannelOutBill(List<ListSelectedRow> selectedRows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("ocbsoc_saleorder");
        pushArgs.setTargetEntityNumber("ococic_channeloutbill");
        pushArgs.setHasRight(false);
        pushArgs.setAppId("");
        pushArgs.setDefOrgId(Long.valueOf(0L));
        pushArgs.setRuleId("1139076397340563456");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder billMessage = new StringBuilder("\u4e0b\u63a8\u5931\u8d25:");
            billMessage.append(pushResult.getMessage());
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                billMessage.append(billReport.getFailMessage());
            }
            throw new KDBizException(billMessage.toString());
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"ococic_channeloutbill");
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        DynamicObject target = null;
        if (targetBillObjs != null && !targetBillObjs.isEmpty()) {
            target = (DynamicObject)targetBillObjs.get(0);
        }
        return target;
    }

    private long getChannelAuthorizeSaleOrgIdSet(Long channelId) {
        long channelSaleOrgId = 0L;
        QFilter channelFilter = new QFilter("orderchannel", "=", (Object)channelId);
        channelFilter.and("enable", "=", (Object)"1");
        DynamicObject channelSaleOrg = QueryServiceHelper.queryOne((String)"ocdbd_channel_authorize", (String)"name,saleorg", (QFilter[])channelFilter.toArray());
        if (channelSaleOrg != null) {
            channelSaleOrgId = channelSaleOrg.getLong("saleorg");
        }
        return channelSaleOrgId;
    }

    public void entryRowClick(RowClickEvent e) {
        int rowIndex = e.getRow();
        this.viewIndexSerialNumber(rowIndex);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "billentry": {
                int rowIndex = this.getCurrentRowIndex("billentry");
                this.viewIndexSerialNumber(rowIndex);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "add": {
                this.addQty(index);
                break;
            }
            case "reduce": {
                this.reduceQty(index);
                break;
            }
            case "btnselectitem": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdbd_itemmobf7");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>(2);
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("billentry");
                List list = entryentity.stream().map(r -> r.getLong("itemid_id")).collect(Collectors.toList());
                hashMap.put("selected", list);
                List<Object> marketItemIds = this.getMarketItemIds();
                hashMap.put("ids", marketItemIds);
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnselectitem);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btnselectsn": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdma_channeloutbill_sn");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
                DynamicObject rowEntry = this.getRowInfo("billentry", this.getCurrentRowIndex("billentry"));
                hashMap.put("itemid", rowEntry.getLong("itemid_id"));
                hashMap.put("unitid", rowEntry.getLong("unitid_id"));
                DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
                hashMap.put("outchannelid", kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel));
                hashMap.put("qty", rowEntry.getBigDecimal("qty"));
                hashMap.put("mulserialnumber", rowEntry.get("mulserialnumber"));
                hashMap.put("thumbnail", rowEntry.get("thumbnail"));
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnselectsn);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btnmore": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdma_channeloutbill_more");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(21);
                DynamicObject rowEntry = this.getRowInfo("billentry", this.getCurrentRowIndex("billentry"));
                DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
                hashMap.put("outchannelid", kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel));
                hashMap.put("itemid", rowEntry.getLong("itemid_id"));
                hashMap.put("materialid", rowEntry.getLong("materialid_id"));
                hashMap.put("unitid", rowEntry.getLong("unitid_id"));
                hashMap.put("qty", rowEntry.getBigDecimal("qty"));
                hashMap.put("thumbnail", rowEntry.get("thumbnail"));
                hashMap.put("auxptyid", rowEntry.get("auxptyid_id"));
                hashMap.put("warehouse", rowEntry.get("warehouse_id"));
                hashMap.put("locationid", rowEntry.get("locationid_id"));
                hashMap.put("lotnumber", rowEntry.get("lotnumber"));
                hashMap.put("lotnumberid", rowEntry.get("lotnumberid_id"));
                hashMap.put("producedate", rowEntry.get("producedate"));
                hashMap.put("expirydate", rowEntry.get("expirydate"));
                hashMap.put("stocktype", rowEntry.get("stocktype_id"));
                hashMap.put("stockstatus", rowEntry.get("stockstatus_id"));
                hashMap.put("ownertype", rowEntry.get("ownertype"));
                hashMap.put("ownerid", rowEntry.get("ownerid_id"));
                hashMap.put("keepertype", rowEntry.get("keepertype"));
                hashMap.put("keeperid", rowEntry.get("keeperid_id"));
                hashMap.put("projectid", rowEntry.get("projectid_id"));
                hashMap.put("id", rowEntry.get("id"));
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnmore);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "outchannelid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getOutChannelFilters());
                break;
            }
            case "warehouse": {
                List<Long> warehouseIds = this.getIdsFromOcocicWareHouse();
                QFilter filter = new QFilter("id", "in", warehouseIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "orderchannelid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getOrderChannelFilters());
                break;
            }
            case "saleorg": {
                DynamicObject outChannel = (DynamicObject)this.getModel().getValue("outchannelid");
                if (null == outChannel) {
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\u3002");
                    e.setCancel(true);
                    break;
                }
                Map customParams = e.getFormShowParameter().getCustomParams();
                customParams.put("range", this.getSaleOrgsFromOcdbdChannelAuthorize());
                break;
            }
        }
    }

    private List<QFilter> getOrderChannelFilters() {
        DynamicObject outChannel = (DynamicObject)this.getModel().getValue("outchannelid");
        if (null == outChannel) {
            this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\u3002");
            return null;
        }
        Long outChannelId = (Long)outChannel.getPkValue();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)"orderchannel", (QFilter[])new QFilter[]{new QFilter("salechannel", "=", (Object)outChannelId).and(new QFilter("enable", "=", (Object)Boolean.TRUE))});
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject relation : relations) {
            ids.add((Long)relation.getDynamicObject("orderchannel").getPkValue());
        }
        QFilter qFilter1 = new QFilter("id", "in", ids);
        qFilters.add(qFilter1);
        return qFilters;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "itemid": {
                this.itemidValueChanged(rowIndex);
                break;
            }
            case "qty": {
                this.qtyValueChanged(rowIndex);
                break;
            }
            case "serialid": {
                this.serialidValueChanged(rowIndex);
                break;
            }
            case "billtypeid": {
                DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtypeid");
                long billtypeid = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)billtype);
                if (billtypeid == 1028196345158206464L) {
                    this.setMustInput("orderchannelid", true);
                    break;
                }
                this.setMustInput("orderchannelid", false);
                break;
            }
            case "outchannelid": {
                this.channelValueChanged(key);
                break;
            }
            case "orderchannelid": {
                this.channelValueChanged(key);
                break;
            }
            case "sninput": {
                String snInput = (String)this.getModel().getValue(SNINPUT);
                if (StringUtils.isNotEmpty((CharSequence)snInput)) {
                    this.scanFillItemEntry(snInput.trim());
                }
                this.getModel().setValue(SNINPUT, (Object)"");
                break;
            }
            default: {
                if (!key.startsWith("$$") || !key.split("__")[0].equals("$$auxptyid")) break;
                this.getAuxptyId();
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String customKey = e.getKey();
        if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"callappmethod")) {
            Map result;
            String scanQRCode;
            boolean isAddSuccess;
            if (StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)op_scanqrcode) && (isAddSuccess = this.scanFillItemEntry(scanQRCode = CommonUtils.convertObjectToString((result = (Map)SerializationUtils.fromJsonString((String)value, Map.class)).get("qrcode_str"))))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(op_scanqrcode, (IFormPlugin)this);
                this.getView().showConfirm("\u626b\u7801\u6210\u529f\uff0c\u7ee7\u7eed\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"wxscanqrcode") && StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)"scancode")) {
            JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
            String qrCode = CommonUtils.convertObjectToString((Object)result.get((Object)"value"));
            this.scanFillItemEntry(qrCode);
        }
    }

    private boolean scanFillItemEntry(String scanQRCode) {
        DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
        long channelWarehouseId = ReturnOrderBusinessHelper.getDefaultReturnWarehouse((long)kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel));
        long outchannelid = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel);
        JSONObject data = this.scanQRCode(scanQRCode, outchannelid);
        if (data == null) {
            this.getView().showTipNotification("\u83b7\u53d6\u5e8f\u5217\u53f7\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return false;
        }
        JSONArray dataArray = data.getJSONArray("data");
        if (dataArray == null || dataArray.isEmpty()) {
            this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u4e0d\u5b58\u5728\u6216\u975e\u5728\u5e93\u72b6\u6001", scanQRCode));
            return false;
        }
        String billstatus = (String)this.getValue("billstatus");
        for (Object item : dataArray) {
            JSONObject itemJson = (JSONObject)item;
            boolean enableSerial = itemJson.getBoolean("enableserial");
            String serialNo = itemJson.getString("serialno");
            long serialId = itemJson.getLong("serialid");
            long itemid = itemJson.getLong("itemid");
            StringBuilder scanBuilder = new StringBuilder();
            scanBuilder.append(itemJson.getLong("itemid"));
            scanBuilder.append(itemJson.getLong("auxptyid"));
            scanBuilder.append(itemJson.getString("lotnum"));
            scanBuilder.append(itemJson.getLong("channelstockid"));
            scanBuilder.append(itemJson.getLong("channellocationid"));
            scanBuilder.append(itemJson.getLong("retailunit"));
            scanBuilder.append(itemJson.getLong("channelstockstatusid"));
            scanBuilder.append(itemJson.getLong("channelstocktypeid"));
            scanBuilder.append(itemJson.getString("keepertype"));
            scanBuilder.append(itemJson.getLong("keeperid"));
            scanBuilder.append(itemJson.getString("ownertype"));
            scanBuilder.append(itemJson.getLong("ownerid"));
            scanBuilder.append(itemJson.getDate("productdate"));
            scanBuilder.append(itemJson.getDate("effectivedate"));
            scanBuilder.append(itemJson.getLong("projectid"));
            String scanKey = scanBuilder.toString();
            DynamicObjectCollection entryColl = this.getModel().getEntryEntity("billentry");
            int rowIndex = 0;
            boolean isMatchEntry = false;
            for (DynamicObject entry : entryColl) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getLong("itemid_id"));
                sb.append(entry.getLong("auxptyid_id"));
                sb.append(entry.getString("lotnumber"));
                sb.append(entry.getLong("warehouse_id"));
                sb.append(entry.getLong("locationid_id"));
                sb.append(entry.getLong("unitid_id"));
                sb.append(entry.getLong("stockstatus_id"));
                sb.append(entry.getLong("stocktype_id"));
                sb.append(entry.getString("keepertype"));
                sb.append(entry.getLong("keeperid_id"));
                sb.append(entry.getString("ownertype"));
                sb.append(entry.getLong("ownerid_id"));
                sb.append(entry.getDate("producedate"));
                sb.append(entry.getDate("expirydate"));
                sb.append(entry.getLong("projectid_id"));
                if (StringUtils.equals((CharSequence)scanKey, (CharSequence)sb.toString())) {
                    BigDecimal snQty;
                    int snEntryCount;
                    JSONObject snJson;
                    isMatchEntry = true;
                    if (!enableSerial || (snJson = JSONObject.parseObject((String)entry.getString("mulserialnumber"))) != null && snJson.containsKey((Object)serialNo)) break;
                    if (snJson != null && StringUtils.equals((CharSequence)billstatus, (CharSequence)"B") && (snEntryCount = snJson.size()) >= (snQty = (BigDecimal)this.getValue("qty")).intValue()) {
                        this.getView().showTipNotification(String.format("\u7b2c%s\u884c\u5206\u5f55\uff0c\u5e8f\u5217\u53f7\u6570\u91cf\u5df2\u8d85\u5546\u54c1\u6570\u91cf\uff01", rowIndex + 1));
                        return false;
                    }
                    this.updateSerialNumberFields(serialNo, serialId, rowIndex);
                    break;
                }
                ++rowIndex;
            }
            if (isMatchEntry) continue;
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
                this.getView().showTipNotification("\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u5546\u54c1\u3002");
                return false;
            }
            rowIndex = this.getModel().createNewEntryRow("billentry");
            this.setValue("itemid", itemid, rowIndex);
            this.setValue("qty", BigDecimal.ONE, rowIndex);
            this.setValue("warehouse", channelWarehouseId, rowIndex);
            this.setValue("ownerid", outchannel, rowIndex);
            this.setValue("keeperid", outchannel, rowIndex);
            if (!enableSerial) continue;
            JSONObject snJson = new JSONObject();
            snJson.put(serialNo, (Object)serialId);
            this.setValue("serialid", serialId, rowIndex);
            this.setValue("serialnumber", serialNo, rowIndex);
            this.setValue("mulserialnumber", snJson, rowIndex);
            this.viewIndexSerialNumber(rowIndex);
        }
        return true;
    }

    private void updateSerialNumberFields(String serialNo, Object serialId, int rowIndex) {
        Object serialnumber;
        JSONObject snJson = JSONObject.parseObject((String)String.valueOf(this.getValue("mulserialnumber", rowIndex)));
        if (snJson == null) {
            snJson = new JSONObject();
        }
        if (ObjectUtils.isEmpty((Object)(serialnumber = this.getValue("serialnumber")))) {
            this.setValue("serialid", serialId, rowIndex);
            this.setValue("serialnumber", serialNo, rowIndex);
        }
        snJson.put(serialNo, serialId);
        String billstatus = (String)this.getValue("billstatus");
        if (!StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
            this.setValue("qty", snJson.size(), rowIndex);
        }
        this.setValue("mulserialnumber", snJson, rowIndex);
        this.viewIndexSerialNumber(rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "save": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                long billid = Long.parseLong(String.valueOf(this.getValue("id")));
                boolean isPush = (Boolean)this.getModel().getValue("ispush");
                if (isPush && billid == 0L) {
                    this.savePushBill();
                    break;
                }
                this.saveBill(billid);
                break;
            }
            case "submit": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                this.submitBill();
                break;
            }
            case "outstock": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                this.auditBill();
                break;
            }
        }
    }

    private void savePushBill() {
        DynamicObject cacheBill = this.getCacheBill();
        DynamicObjectCollection billEntry = this.getModel().getEntryEntity("billentry");
        Map<Long, DynamicObject> pageDataMap = billEntry.stream().collect(Collectors.toMap(k -> k.getLong("srcbillentryid"), v -> v, (r1, r2) -> r1));
        if (cacheBill != null) {
            long outChannelId = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)this.getValue("outchannelid")));
            DynamicObjectCollection entryList = cacheBill.getDynamicObjectCollection("billentry");
            entryList.removeIf(r -> !pageDataMap.containsKey(r.getLong("srcbillentryid")));
            int index = 0;
            for (DynamicObject entry : entryList) {
                ++index;
                long srcBillEntryId = entry.getLong("srcbillentryid");
                DynamicObject pageEntry = pageDataMap.get(srcBillEntryId);
                if (pageEntry == null) continue;
                DynamicObject item = pageEntry.getDynamicObject("itemid");
                long materialId = pageEntry.getLong("materialid_id");
                long unitId = entry.getLong("unitid_id");
                long auxUnitId = entry.getLong("auxptyunitid_id");
                long baseUnitId = entry.getLong("baseunitid_id");
                BigDecimal qty = pageEntry.getBigDecimal("qty");
                BigDecimal serialqty = pageEntry.getBigDecimal("serialqty");
                BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
                BigDecimal auxQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)auxUnitId);
                entry.set("quantity", (Object)qty);
                entry.set("basequantity", (Object)baseQty);
                entry.set("auxquantity", (Object)auxQty);
                entry.set("snquantity", (Object)serialqty);
                entry.set("lotid", pageEntry.get("lotnumberid"));
                entry.set("lotnumber", pageEntry.get("lotnumber"));
                entry.set("productdate", pageEntry.get("producedate"));
                entry.set("expiredate", pageEntry.get("expirydate"));
                boolean enableserial = item.getBoolean("enableserial");
                boolean isNotControlSN = ChannelUtil.queryChannelIsNotControlSN((long)outChannelId);
                if (!enableserial || isNotControlSN) continue;
                String serialnumber = pageEntry.getString("serialnumber");
                if (serialqty.compareTo(BigDecimal.ONE) == 0 && pageEntry.get("serialid") != null && StringUtils.isNotEmpty((CharSequence)serialnumber)) {
                    DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("chnloutbill_sn");
                    DynamicObject subEntry = subentryentity.addNew();
                    subEntry.set("serialid", pageEntry.get("serialid"));
                    subEntry.set("serialnumber", (Object)serialnumber);
                    continue;
                }
                if (serialqty.compareTo(BigDecimal.ONE) <= 0) continue;
                JSONObject snJson = JSONObject.parseObject((String)pageEntry.getString("mulserialnumber"));
                if (snJson == null || serialqty.intValue() != snJson.size()) {
                    throw new KDBizException(String.format("\u7b2c%d\u884c\u5546\u54c1\u5e8f\u5217\u53f7\u6570\u91cf\u548c\u5e8f\u5217\u53f7\u6761\u6570\u4e0d\u4e00\u81f4\u3002", index));
                }
                DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("chnloutbill_sn");
                if (snJson == null) continue;
                Set snNumbers = snJson.entrySet();
                for (Map.Entry snEntry : snNumbers) {
                    DynamicObject subEntry = subentryentity.addNew();
                    subEntry.set("serialid_id", snEntry.getValue());
                    subEntry.set("serialnumber", snEntry.getKey());
                }
            }
            OperateOption saveOption = CommonUtils.getOperateOption();
            OperationResult result = OperationServiceHelper.executeOperate((String)op_save, (String)"ococic_channeloutbill", (DynamicObject[])new DynamicObject[]{cacheBill}, (OperateOption)saveOption);
            if (!result.isSuccess()) {
                this.showMessage(result, false);
            }
            this.setValue("id", cacheBill.getPkValue());
            this.setValue("billno", cacheBill.getString("billno"));
        }
    }

    private DynamicObject getCacheBill() {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"ococic_channeloutbill");
        String cacheBill = this.getPageCache().getBigObject("ococic_channeloutbill" + this.getView().getPageId());
        if (cacheBill == null) {
            return null;
        }
        Object[] objects = DynamicObjectSerializeUtil.deserialize((String)cacheBill, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_channeloutbill"));
        if (objects.length == 1) {
            DynamicObject dyn = (DynamicObject)objects[0];
            DynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)dy);
            return dy;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (key) {
            case "btnselectitem": {
                Object[] selectIds = (Object[])returnData;
                if (selectIds == null || selectIds.length == 0) {
                    return;
                }
                DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
                long channelWarehouseId = ReturnOrderBusinessHelper.getDefaultReturnWarehouse((long)kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel));
                long channelLocationId = this.getDefaultLocationId(channelWarehouseId);
                for (Object itemId : selectIds) {
                    int rowIndex = this.getModel().createNewEntryRow("billentry");
                    this.setValue("itemid", itemId, rowIndex);
                    this.setValue("qty", BigDecimal.ONE, rowIndex);
                    this.setValue("warehouse", channelWarehouseId, rowIndex);
                    this.setValue("locationid", channelLocationId, rowIndex);
                    this.setValue("ownerid", outchannel, rowIndex);
                    this.setValue("keeperid", outchannel, rowIndex);
                }
                break;
            }
            case "btnselectsn": {
                JSONObject snJson = JSONObject.parseObject((String)String.valueOf(returnData));
                int rowIndex = this.getCurrentRowIndex("billentry");
                long serialid = 0L;
                String serialnumber = "";
                if (snJson != null) {
                    String billstatus;
                    Set snNumbers = snJson.entrySet();
                    for (Map.Entry entry : snNumbers) {
                        serialid = Long.parseLong(String.valueOf(entry.getValue()));
                        serialnumber = (String)entry.getKey();
                        if (serialid <= 0L) continue;
                        break;
                    }
                    if (!StringUtils.equals((CharSequence)(billstatus = (String)this.getValue("billstatus")), (CharSequence)"B")) {
                        this.setValue("qty", snNumbers.size(), rowIndex);
                    }
                }
                this.setValue("serialid", serialid, rowIndex);
                this.setValue("serialnumber", serialnumber, rowIndex);
                this.setValue("mulserialnumber", snJson, rowIndex);
                this.viewIndexSerialNumber(rowIndex);
                break;
            }
            case "btnmore": {
                JSONObject resultJson = JSONObject.parseObject((String)String.valueOf(returnData));
                int rowIndex = this.getCurrentRowIndex("billentry");
                this.setValue("auxptyid", resultJson.get((Object)"auxptyid"), rowIndex);
                this.setValue("warehouse", resultJson.get((Object)"warehouse"), rowIndex);
                this.setValue("locationid", resultJson.get((Object)"locationid"), rowIndex);
                this.setValue("lotnumber", resultJson.get((Object)"lotnumber"), rowIndex);
                this.setValue("lotnumberid", resultJson.get((Object)"lotnumberid"), rowIndex);
                this.setValue("producedate", resultJson.getDate("producedate"), rowIndex);
                this.setValue("expirydate", resultJson.getDate("expirydate"), rowIndex);
                this.setValue("stocktype", resultJson.get((Object)"stocktype"), rowIndex);
                this.setValue("stockstatus", resultJson.get((Object)"stockstatus"), rowIndex);
                this.setValue("ownertype", resultJson.get((Object)"ownertype"), rowIndex);
                this.setValue("ownerid", resultJson.get((Object)"ownerid"), rowIndex);
                this.setValue("keepertype", resultJson.get((Object)"keepertype"), rowIndex);
                this.setValue("keeperid", resultJson.get((Object)"keeperid"), rowIndex);
                this.setValue("projectid", resultJson.get((Object)"projectid"), rowIndex);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "scanqrcode": {
                this.getView().invokeOperation(op_scanqrcode);
                break;
            }
        }
    }

    private JSONObject scanQRCode(String serialNo, long channelId) {
        if (StringUtils.isNotEmpty((CharSequence)serialNo) && channelId > 0L) {
            return CSerialHelper.getSerialDataByScanNumber(Collections.singletonList(serialNo), (Long)channelId, (String)SnStatusEnum.INSTOCK.getValue());
        }
        return null;
    }

    private void viewIndexSerialNumber(int rowIndex) {
        JSONObject snJson;
        StringBuilder sb = new StringBuilder();
        if (rowIndex >= 0 && (snJson = JSONObject.parseObject((String)String.valueOf(this.getValue("mulserialnumber", rowIndex)))) != null) {
            Set snNumbers = snJson.keySet();
            for (String snNumber : snNumbers) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(snNumber);
            }
        }
        this.setValue("viewserialnumber", sb.toString());
    }

    private void submitBill() {
        long billid = Long.parseLong(String.valueOf(this.getValue("id")));
        boolean isPush = (Boolean)this.getModel().getValue("ispush");
        if (isPush && billid == 0L) {
            this.savePushBill();
        } else {
            this.saveBill(billid);
        }
        billid = Long.parseLong(String.valueOf(this.getValue("id")));
        if (billid > 0L) {
            OperateOption option;
            Object[] objectIds = new Object[]{billid};
            OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_channeloutbill", (Object[])objectIds, (OperateOption)(option = CommonUtils.getOperateOption()));
            if (!result.isSuccess()) {
                this.showMessage(result, false);
            } else {
                this.setValue("billstatus", "B");
            }
        }
        this.getPageCache().put("nextsubmittime", "0");
    }

    private void auditBill() {
        long billid = Long.parseLong(String.valueOf(this.getValue("id")));
        boolean isPush = (Boolean)this.getModel().getValue("ispush");
        if (isPush && billid == 0L) {
            this.savePushBill();
        } else {
            this.saveBill(billid);
        }
        billid = Long.parseLong(String.valueOf(this.getValue("id")));
        if (billid > 0L) {
            String billstatus;
            Object[] objectIds = new Object[]{billid};
            OperateOption option = CommonUtils.getOperateOption();
            switch (billstatus = String.valueOf(this.getValue("billstatus"))) {
                case "A": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_channeloutbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.showMessage(result, false);
                        break;
                    }
                    this.setValue("billstatus", "B");
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_channeloutbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.showMessage(result, false);
                        break;
                    }
                    this.setValue("billstatus", "C");
                    break;
                }
                case "B": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_channeloutbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.showMessage(result, false);
                        break;
                    }
                    this.setValue("billstatus", "C");
                    break;
                }
            }
        }
        this.getPageCache().put("nextsubmittime", "0");
    }

    private void saveBill(long billid) {
        DynamicObject bill = null;
        BigDecimal sumqty = BigDecimal.ZERO;
        if (billid == 0L) {
            bill = BusinessDataServiceHelper.newDynamicObject((String)"ococic_channeloutbill");
            bill.set("creator", (Object)UserUtil.getUserInfo());
            bill.set("billstatus", (Object)"A");
        } else {
            bill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"ococic_channeloutbill");
            this.setValue("billstatus", bill.getString("billstatus"));
        }
        bill.set("billno", this.getValue("billno"));
        bill.set("billtypeid", this.getValue("billtypeid"));
        bill.set("outdirection", this.getValue("outdirection"));
        bill.set("outchannelid", this.getValue("outchannelid"));
        bill.set("org", this.getValue("org"));
        bill.set("saleorg", this.getValue("saleorg"));
        bill.set("orderchannelid", this.getValue("orderchannelid"));
        bill.set("outtype", this.getValue("outtype"));
        bill.set("outdate", this.getValue("outdate"));
        bill.set("currencyid", this.getValue("currencyid"));
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)bill, (String)this.getView().getEntityId(), (String)"ococic_channeloutbill");
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("billentry");
        entryEntity.clear();
        DynamicObjectCollection mobEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)mobEntryEntity)) {
            this.getView().showTipNotification("\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return;
        }
        long outChannelId = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)this.getValue("outchannelid")));
        int seq = 0;
        for (DynamicObject mobEntry : mobEntryEntity) {
            ++seq;
            DynamicObject item = mobEntry.getDynamicObject("itemid");
            if (item == null) {
                this.getView().showTipNotification("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return;
            }
            BigDecimal serialqty = mobEntry.getBigDecimal("serialqty");
            BigDecimal qty = mobEntry.getBigDecimal("qty");
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", seq));
                return;
            }
            sumqty = sumqty.add(qty);
            DynamicObject entry = entryEntity.addNew();
            entry.set("materielid", mobEntry.get("materialid"));
            entry.set("itemid", (Object)item);
            entry.set("unitid", mobEntry.get("unitid"));
            entry.set("auxptyid", mobEntry.get("auxptyid"));
            entry.set("auxptyunitid", mobEntry.get("assistunitid"));
            entry.set("stockid", mobEntry.get("warehouse"));
            entry.set("stockaddrid", mobEntry.get("locationid"));
            entry.set("quantity", (Object)qty);
            entry.set("baseunitid", mobEntry.get("baseunitid"));
            entry.set("basequantity", mobEntry.get("baseqty"));
            entry.set("snquantity", (Object)serialqty);
            entry.set("snunit", mobEntry.get("serialunit"));
            entry.set("stockstatusid", mobEntry.get("stockstatus"));
            entry.set("stocktypeid", mobEntry.get("stocktype"));
            entry.set("ownerid", mobEntry.get("ownerid"));
            entry.set("ownertype", mobEntry.get("ownertype"));
            entry.set("keeperid", mobEntry.get("keeperid"));
            entry.set("keepertype", mobEntry.get("keepertype"));
            entry.set("lotnumber", mobEntry.get("lotnumber"));
            entry.set("lotid", mobEntry.get("lotnumberid"));
            entry.set("productdate", mobEntry.get("producedate"));
            entry.set("expiredate", mobEntry.get("expirydate"));
            entry.set("projectid", mobEntry.get("projectid"));
            MobExtendHelper.setMobExtToOrmExt((DynamicObject)mobEntry, (DynamicObject)entry, (String)this.getView().getEntityId(), (String)"ococic_channeloutbill");
            boolean enableserial = item.getBoolean("enableserial");
            boolean isNotControlSN = ChannelUtil.queryChannelIsNotControlSN((long)outChannelId);
            if (!enableserial || isNotControlSN) continue;
            String serialnumber = mobEntry.getString("serialnumber");
            if (serialqty.compareTo(BigDecimal.ONE) == 0 && mobEntry.get("serialid") != null && StringUtils.isNotEmpty((CharSequence)serialnumber)) {
                DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("chnloutbill_sn");
                DynamicObject subEntry = subentryentity.addNew();
                subEntry.set("serialid", mobEntry.get("serialid"));
                subEntry.set("serialnumber", (Object)serialnumber);
                continue;
            }
            if (serialqty.compareTo(BigDecimal.ONE) <= 0) continue;
            JSONObject snJson = JSONObject.parseObject((String)mobEntry.getString("mulserialnumber"));
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("chnloutbill_sn");
            if (snJson == null) continue;
            Set snNumbers = snJson.entrySet();
            for (Map.Entry snEntry : snNumbers) {
                DynamicObject subEntry = subentryentity.addNew();
                subEntry.set("serialid_id", snEntry.getValue());
                subEntry.set("serialnumber", snEntry.getKey());
            }
        }
        bill.set("sumqty", (Object)sumqty);
        OperateOption saveOption = CommonUtils.getOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)op_save, (String)"ococic_channeloutbill", (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)saveOption);
        if (!result.isSuccess()) {
            this.showMessage(result, false);
        }
        this.setValue("id", bill.getPkValue());
        this.setValue("billno", bill.getString("billno"));
    }

    private void initNewBillHead() {
        long channelId = this.getChannelId();
        this.setValue("outchannelid", channelId);
        long saleOrgId = this.getChannelAuthorizeSaleOrgIdSet(channelId);
        this.setValue("saleorg", saleOrgId);
        DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
        this.setValue("org", kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel, (String)"saleorg"));
        this.setValue("currencyid", kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel, (String)"currency"));
        this.setValue("billstatus", "A");
    }

    private long getAuxptyId() {
        FlexEdit flexEdit = (FlexEdit)this.getControl("auxptyid");
        IDataModel flexModel = flexEdit.getFlexModel();
        DynamicObject dataEntity = flexModel.getDataEntity();
        MainEntityType dataEntityType = flexModel.getDataEntityType();
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData(dataEntityType, dataEntity);
        long id = FlexService.saveFlexData((MainEntityType)dataEntityType, (FlexEntireData)flexEntireData);
        this.setValue("auxptyid", id, this.getCurrentRowIndex("billentry"));
        return id;
    }

    private long getChannelId() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String cacheChannelId = parentPageCache.get("channelId");
        long channelId = cacheChannelId != null ? Long.parseLong(cacheChannelId) : B2BUserHelper.getLoginChannelId();
        return channelId;
    }

    protected void addQty(int index) {
        Object qtyObj = this.getModel().getValue("qty", index);
        BigDecimal qty = qtyObj == null ? BigDecimal.ZERO : (BigDecimal)qtyObj;
        BigDecimal newQty = qty.add(BigDecimal.ONE);
        this.getModel().setValue("qty", (Object)newQty, index);
    }

    protected void reduceQty(int index) {
        Object qtyObj = this.getModel().getValue("qty", index);
        BigDecimal qty = qtyObj == null ? BigDecimal.ZERO : (BigDecimal)qtyObj;
        BigDecimal newQty = qty.subtract(BigDecimal.ONE);
        if (newQty.compareTo(BigDecimal.ZERO) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue("qty", (Object)newQty, index);
    }

    private void itemidValueChanged(int rowIndex) {
        DynamicObject itemDynObj = this.getEntryF7Value("billentry", "itemid", rowIndex);
        DynamicObject material = null;
        DynamicObject orderunit = null;
        DynamicObject baseunit = null;
        DynamicObject serialunit = null;
        DynamicObject assistunit = null;
        Object thumbnail = null;
        if (itemDynObj != null) {
            material = itemDynObj.getDynamicObject("material");
            orderunit = itemDynObj.getDynamicObject("orderunit");
            baseunit = itemDynObj.getDynamicObject("baseunit");
            serialunit = itemDynObj.getDynamicObject("serialunit");
            assistunit = itemDynObj.getDynamicObject("assistunit");
            thumbnail = itemDynObj.get("thumbnail");
        }
        this.setValue("materialid", material, rowIndex);
        this.setValue("unitid", orderunit, rowIndex);
        this.setValue("baseunitid", baseunit, rowIndex);
        this.setValue("serialunit", serialunit, rowIndex);
        this.setValue("assistunitid", assistunit, rowIndex);
        this.setValue("thumbnail", thumbnail, rowIndex);
        this.triggerChangeEvent = true;
    }

    private void qtyValueChanged(int rowIndex) {
        DynamicObject rowEntry = this.getRowInfo("billentry", rowIndex);
        long materialId = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"materialid");
        long unitId = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"unitid");
        long baseUnitId = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"baseunitid");
        long serialunitId = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"serialunit");
        BigDecimal qty = (BigDecimal)this.getValue("qty", rowIndex);
        BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
        BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)serialunitId);
        this.setValue("baseqty", baseQty, rowIndex);
        this.setValue("serialqty", serialQty, rowIndex);
        this.triggerChangeEvent = true;
    }

    private void channelValueChanged(String key) {
        int rowCount = this.getModel().getEntryRowCount("billentry");
        if (rowCount == 0) {
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"outchannelid")) {
            this.getView().showTipNotification("\u51fa\u5e93\u6e20\u9053\u53d1\u751f\u53d8\u66f4\uff0c\u5df2\u6e05\u7a7a\u5546\u54c1\u660e\u7ec6\u3002");
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"orderchannelid")) {
            this.getView().showTipNotification("\u8981\u8d27\u6e20\u9053\u53d1\u751f\u53d8\u66f4\uff0c\u5df2\u6e05\u7a7a\u5546\u54c1\u660e\u7ec6\u3002");
        }
        this.getModel().deleteEntryData("billentry");
        this.setValue("viewserialnumber", "");
    }

    private void serialidValueChanged(int rowIndex) {
        DynamicObject serialDynObj = this.getEntryF7Value("billentry", "serialid", rowIndex);
        DynamicObject lotid = null;
        String lotnum = "";
        Date productdate = null;
        Date effectivedate = null;
        DynamicObject projectid = null;
        String ownertype = "";
        DynamicObject ownerid = null;
        String keepertype = "";
        DynamicObject keeperid = null;
        DynamicObject auxptyid = null;
        DynamicObject channelstocktypeid = null;
        DynamicObject channelstockstatusid = null;
        DynamicObject channelstockid = null;
        DynamicObject channellocationid = null;
        if (serialDynObj != null) {
            lotid = serialDynObj.getDynamicObject("lotid");
            lotnum = serialDynObj.getString("lotnum");
            productdate = serialDynObj.getDate("productdate");
            effectivedate = serialDynObj.getDate("effectivedate");
            projectid = serialDynObj.getDynamicObject("projectid");
            ownertype = serialDynObj.getString("ownertype");
            ownerid = serialDynObj.getDynamicObject("ownerid");
            keepertype = serialDynObj.getString("keepertype");
            keeperid = serialDynObj.getDynamicObject("keeperid");
            auxptyid = serialDynObj.getDynamicObject("auxptyid");
            channelstocktypeid = serialDynObj.getDynamicObject("channelstocktypeid");
            channelstockstatusid = serialDynObj.getDynamicObject("channelstockstatusid");
            channelstockid = serialDynObj.getDynamicObject("channelstockid");
            channellocationid = serialDynObj.getDynamicObject("channellocationid");
        }
        this.setValue("lotnumberid", lotid, rowIndex);
        this.setValue("lotnumber", lotnum, rowIndex);
        this.setValue("producedate", productdate, rowIndex);
        this.setValue("expirydate", effectivedate, rowIndex);
        this.setValue("projectid", projectid, rowIndex);
        this.setValue("ownertype", ownertype, rowIndex);
        this.setValue("ownerid", ownerid, rowIndex);
        this.setValue("keepertype", keepertype, rowIndex);
        this.setValue("keeperid", keeperid, rowIndex);
        this.setValue("auxptyid", auxptyid, rowIndex);
        this.setValue("stocktype", channelstocktypeid, rowIndex);
        this.setValue("stockstatus", channelstockstatusid, rowIndex);
        this.setValue("warehouse", channelstockid, rowIndex);
        this.setValue("locationid", channellocationid, rowIndex);
        this.triggerChangeEvent = true;
    }

    private List<Object> getMarketItemIds() {
        long orgid = (Long)this.getModel().getValue(String.join((CharSequence)"_", "org", "id"));
        long outchannelid = (Long)this.getModel().getValue(String.join((CharSequence)"_", "outchannelid", "id"));
        long orderchannelid = (Long)this.getModel().getValue(String.join((CharSequence)"_", "orderchannelid", "id"));
        List<QFilter> filters = this.getItemFilter(orgid, outchannelid, orderchannelid);
        return QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_iteminfo", (QFilter[])filters.toArray(new QFilter[filters.size()]), null, (int)99999);
    }

    private List<QFilter> getItemFilter(long saleOrgId, long saleChannelId, long orderChannelId) {
        List<QFilter> filters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)saleChannelId, (long)orderChannelId);
        if (filters == null) {
            filters = Arrays.asList(new QFilter("id", "=", (Object)0L).toArray());
        } else {
            filters.add(new QFilter("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue())));
        }
        return filters;
    }

    private List<QFilter> getOutChannelFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qFilter4 = new QFilter("channeltype.isinsideorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter5 = new QFilter("channelfunctions.fbasedataid.number", "=", (Object)"003");
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        qFilters.add(qFilter4);
        qFilters.add(qFilter5);
        qFilters.add(CUserHelper.getAuthorizedChannelFilter());
        qFilters.add(new QFilter("invcontrolmode", "=", (Object)"A"));
        return qFilters;
    }

    private List<Long> getIdsFromOcocicWareHouse() {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
        long channelId = kd.occ.ocbase.common.util.DynamicObjectUtils.getPkValue((DynamicObject)outchannel);
        if (channelId == 0L) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("ownerchannelid", "=", (Object)channelId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)"id", (QFilter[])filter.toArray());
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("id"));
            }
        }
        return ids;
    }

    private List<Long> getSaleOrgsFromOcdbdChannelAuthorize() {
        ArrayList<Long> ids = new ArrayList<Long>();
        long channelId = this.getOutChannelId();
        if (channelId <= 0L) {
            throw new KDBizException("\u51fa\u5e93\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        QFilter customerFilter = new QFilter("orderchannel", "=", (Object)channelId);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)"saleorg", (QFilter[])new QFilter[]{customerFilter});
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("saleorg.id"));
            }
        }
        return ids;
    }

    private long getOutChannelId() {
        Object obj = this.getF7PKValue("outchannelid");
        return obj == null ? 0L : (Long)obj;
    }

    private long getDefaultLocationId(long channelWarehouseId) {
        if (channelWarehouseId <= 0L) {
            return 0L;
        }
        long channelLocationId = 0L;
        QFilter qFilter = new QFilter("id", "=", (Object)channelWarehouseId);
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"ococic_warehouse", (String)"enablelocation", (QFilter[])qFilter.toArray());
        boolean enableLocation = kd.occ.ocbase.common.util.DynamicObjectUtils.getBoolean((DynamicObject)warehouse, (String)"enablelocation");
        if (enableLocation) {
            QFilter filter = new QFilter("warehouseid", "=", (Object)channelWarehouseId);
            filter.and("isdefault", "=", (Object)Boolean.TRUE);
            filter.and("enable", "=", (Object)"1");
            DynamicObject location = QueryServiceHelper.queryOne((String)"ococic_location", (String)"id", (QFilter[])filter.toArray());
            channelLocationId = kd.occ.ocbase.common.util.DynamicObjectUtils.getLong((DynamicObject)location, (String)"id");
        }
        return channelLocationId;
    }

    private void showMessage(OperationResult result, boolean isSubmit) {
        if (result.isSuccess()) {
            return;
        }
        List allError = result.getAllErrorInfo();
        if (!allError.isEmpty()) {
            ArrayList<String> allErrorMessageList = new ArrayList<String>(1);
            for (OperateErrorInfo error : allError) {
                allErrorMessageList.add(error.getMessage());
            }
            this.getView().showErrorNotification(String.join((CharSequence)",", allErrorMessageList));
            return;
        }
        List validResultList = result.getValidateResult().getValidateErrors();
        ArrayList<String> fatalErrorMessageList = new ArrayList<String>(1);
        ArrayList<String> errorMessageList = new ArrayList<String>(1);
        ArrayList<String> warningMessageList = new ArrayList<String>(1);
        for (ValidateResult validation : validResultList) {
            List allErrorInfo = validation.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                ErrorLevel errorLevel = errorInfo.getLevel();
                switch (errorLevel) {
                    case FatalError: {
                        fatalErrorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Error: {
                        errorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Warning: {
                        warningMessageList.add(errorInfo.getMessage());
                        break;
                    }
                }
            }
        }
        if (!fatalErrorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", fatalErrorMessageList));
        } else if (!errorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", errorMessageList));
        } else if (!warningMessageList.isEmpty() && isSubmit) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitConfirmCallBack", (IFormPlugin)this);
            String message = MessageFormat.format("{0} - {1}", result.getMessage(), String.join((CharSequence)",", warningMessageList));
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
        }
    }
}

