/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.flex.FlexService;
import kd.bos.form.control.Control;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelOutBillMorePlugin
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ChannelOutBillMorePlugin.class);
    private static final String BTNSAVE = "btnsave";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNSAVE});
        this.addF7Listener(this, new String[]{"warehouse", "locationid"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        if (key.startsWith("$$") && key.split("__")[0].equals("$$auxptyid")) {
            this.getAuxptyId();
        } else if (key.equals("warehouse")) {
            DynamicObject warehouse = (DynamicObject)this.getValue("warehouse");
            boolean enableLocation = DynamicObjectUtils.getBoolean((DynamicObject)warehouse, (String)"enablelocation");
            if (enableLocation) {
                this.setValue("locationid", this.getDefaultLocation(DynamicObjectUtils.getPkValue((DynamicObject)warehouse)));
            } else {
                this.setValue("locationid", null);
            }
        } else if (key.equals("lotnumber")) {
            Object producedate = null;
            Object expirydate = null;
            DynamicObject lot = null;
            long itemid = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)this.getValue("itemid")));
            String lotnumber = String.valueOf(this.getValue("lotnumber"));
            if (itemid > 0L && StringUtil.isNotEmpty((String)lotnumber)) {
                DynamicObjectCollection lotDate;
                QFilter qFilter = new QFilter("itemid", "=", (Object)itemid);
                qFilter.and("number", "=", (Object)lotnumber);
                qFilter.and("enable", "=", (Object)"1");
                lot = BusinessDataServiceHelper.loadSingle((String)"ococic_lot", (String)"productdate,expiredate", (QFilter[])qFilter.toArray());
                if (lot != null && (lotDate = lot.getDynamicObjectCollection("ococic_lotdate")).size() > 0) {
                    producedate = ((DynamicObject)lotDate.get(0)).get("productdate");
                    expirydate = ((DynamicObject)lotDate.get(0)).get("expiredate");
                }
            }
            this.setValue("lotnumberid", lot);
            this.setValue("producedate", producedate);
            this.setValue("expirydate", expirydate);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnsave": {
                this.returnToEditParent();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "warehouse": {
                List<Long> warehouseIds = this.getIdsFromOcocicWareHouse();
                QFilter filter = new QFilter("id", "in", warehouseIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "locationid": {
                List<Long> locationIds = this.getIdsFromOcocicLocation();
                QFilter qFilter = new QFilter("id", "in", locationIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                break;
            }
        }
    }

    private void returnToEditParent() {
        JSONObject resultJson = new JSONObject();
        resultJson.put("auxptyid", this.getValue("auxptyid_id"));
        resultJson.put("warehouse", this.getValue("warehouse_id"));
        resultJson.put("locationid", this.getValue("locationid_id"));
        resultJson.put("lotnumber", this.getValue("lotnumber"));
        resultJson.put("lotnumberid", this.getValue("lotnumberid_id"));
        String producedatestr = "";
        Date producedate = this.getDateFieldValue("producedate");
        if (producedate != null) {
            producedatestr = DateUtil.getDateTimeFormat((Date)producedate);
        }
        resultJson.put("producedate", (Object)producedatestr);
        String expirydatestr = "";
        Date expirydate = this.getDateFieldValue("expirydate");
        if (expirydate != null) {
            expirydatestr = DateUtil.getDateTimeFormat((Date)expirydate);
        }
        resultJson.put("expirydate", (Object)expirydatestr);
        resultJson.put("stocktype", this.getValue("stocktype_id"));
        resultJson.put("stockstatus", this.getValue("stockstatus_id"));
        resultJson.put("ownertype", this.getValue("ownertype"));
        resultJson.put("ownerid", this.getValue("ownerid_id"));
        resultJson.put("keepertype", this.getValue("keepertype"));
        resultJson.put("keeperid", this.getValue("keeperid_id"));
        resultJson.put("projectid", this.getValue("projectid_id"));
        this.getView().returnDataToParent((Object)resultJson);
        this.getView().close();
    }

    private void initInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setValue("outchannelid", customParams.get("outchannelid"));
        this.setValue("itemid", customParams.get("itemid"));
        this.setValue("materialid", customParams.get("materialid"));
        this.setValue("unitid", customParams.get("unitid"));
        this.setValue("qty", customParams.get("qty"));
        this.setValue("thumbnail", customParams.get("thumbnail"));
        this.setValue("auxptyid", customParams.get("auxptyid"));
        this.setValue("warehouse", customParams.get("warehouse"));
        this.setValue("locationid", customParams.get("locationid"));
        this.setValue("lotnumber", customParams.get("lotnumber"));
        this.setValue("lotnumberid", customParams.get("lotnumberid"));
        this.setValue("producedate", customParams.get("producedate"));
        this.setValue("expirydate", customParams.get("expirydate"));
        this.setValue("stocktype", customParams.get("stocktype"));
        this.setValue("stockstatus", customParams.get("stockstatus"));
        this.setValue("ownertype", customParams.get("ownertype"));
        this.setValue("ownerid", customParams.get("ownerid"));
        this.setValue("keepertype", customParams.get("keepertype"));
        this.setValue("keeperid", customParams.get("keeperid"));
        this.setValue("projectid", customParams.get("projectid"));
        this.setValue("id", customParams.get("id"));
    }

    private List<Long> getIdsFromOcocicWareHouse() {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)outchannel);
        if (channelId == 0L) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("ownerchannelid", "=", (Object)channelId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ococic_warehouse", (String)"id", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)results)) {
            for (DynamicObject result : results) {
                ids.add(result.getLong("id"));
            }
        }
        return ids;
    }

    private List<Long> getIdsFromOcocicLocation() {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject warehouse = (DynamicObject)this.getValue("warehouse");
        long warehouseId = DynamicObjectUtils.getPkValue((DynamicObject)warehouse);
        if (warehouseId == 0L) {
            return ids;
        }
        QFilter filter = new QFilter("warehouseid", "=", (Object)warehouseId);
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ococic_location", (String)"id", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)results)) {
            for (DynamicObject result : results) {
                ids.add(result.getLong("id"));
            }
        }
        return ids;
    }

    private long getAuxptyId() {
        FlexEdit flexEdit = (FlexEdit)this.getControl("auxptyid");
        IDataModel flexModel = flexEdit.getFlexModel();
        DynamicObject dataEntity = flexModel.getDataEntity();
        MainEntityType dataEntityType = flexModel.getDataEntityType();
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData(dataEntityType, dataEntity);
        long id = FlexService.saveFlexData((MainEntityType)dataEntityType, (FlexEntireData)flexEntireData);
        this.setValue("auxptyid", id, this.getCurrentRowIndex("billentry"));
        return id;
    }

    private DynamicObject getDefaultLocation(long channelWarehouseId) {
        if (channelWarehouseId <= 0L) {
            return null;
        }
        QFilter filter = new QFilter("warehouseid", "=", (Object)channelWarehouseId);
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        filter.and("enable", "=", (Object)"1");
        DynamicObject location = BusinessDataServiceHelper.loadSingle((String)"ococic_location", (String)"id", (QFilter[])filter.toArray());
        return location;
    }
}

