/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelOutBillSNPlugin
extends OcbaseFormMobPlugin {
    private static final Log logger = LogFactory.getLog(ChannelOutBillSNPlugin.class);
    private static final String op_billlistap = "billlistap";
    private static final String BTNCONFIRM = "btnconfirm";
    private static final String OP_SCANQRCODE = "scanqrcode";
    private static final String BTNSAVE = "btnsave";
    private static final String MULSERIALNUMBER = "mulserialnumber";
    private static final String SNSEARCH = "snsearch";
    private static final String ISWX = "iswx";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNCONFIRM, BTNSAVE, "cardflexpanelap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSnFilter();
        boolean isWx = CommonUtils.isFromWeixin((String)RequestContext.get().getUserAgent());
        if (isWx) {
            this.setValue(ISWX, true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        JSONObject snJson = JSONObject.parseObject((String)String.valueOf(this.getValue(MULSERIALNUMBER)));
        if (snJson != null) {
            Set snNumbers = snJson.keySet();
            this.scanSelectedSN(snNumbers);
        }
    }

    private void initSnFilter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setValue("itemid", customParams.get("itemid"));
        this.setValue("unitid", customParams.get("unitid"));
        this.setValue("qty", customParams.get("qty"));
        this.setValue(MULSERIALNUMBER, customParams.get(MULSERIALNUMBER));
        this.setValue("thumbnail", customParams.get("thumbnail"));
        BillList billList = (BillList)this.getControl(op_billlistap);
        QFilter filter = new QFilter("itemid", "=", customParams.get("itemid"));
        filter.and("channelid", "=", customParams.get("outchannelid"));
        filter.and("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue());
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{filter});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            default: 
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnconfirm": {
                String snsearch = String.valueOf(this.getValue(SNSEARCH));
                this.scanAdd(snsearch);
                break;
            }
            case "btnsave": {
                BillList billList = (BillList)this.getView().getControl(op_billlistap);
                JSONObject snJson = JSONObject.parseObject((String)String.valueOf(this.getValue(MULSERIALNUMBER)));
                if (snJson == null) {
                    snJson = new JSONObject();
                }
                ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
                for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                    snJson.put(listSelectedRow.getNumber(), listSelectedRow.getPrimaryKeyValue());
                }
                this.getView().returnDataToParent((Object)snJson);
                this.getView().close();
                break;
            }
            case "cardflexpanelap": {
                BillList billList = (BillList)this.getView().getControl(op_billlistap);
                JSONObject snJson = JSONObject.parseObject((String)String.valueOf(this.getValue(MULSERIALNUMBER)));
                if (snJson == null) break;
                ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
                snJson.remove((Object)listSelectedRow.getNumber());
                this.setValue(MULSERIALNUMBER, snJson);
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String customKey = e.getKey();
        logger.info(String.format("eventName:%s key:%s value:%s", eventName, customKey, value));
        if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"callappmethod")) {
            Map result;
            String qrCode;
            boolean isAddSuccess;
            if (eventName.equals("scanQRCode") && (isAddSuccess = this.scanAdd(qrCode = String.valueOf((result = (Map)SerializationUtils.fromJsonString((String)value, Map.class)).get("qrcode_str"))))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OP_SCANQRCODE, (IFormPlugin)this);
                this.getView().showConfirm("\u626b\u7801\u6210\u529f\uff0c\u7ee7\u7eed\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"wxscanqrcode") && StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)"scancode")) {
            JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
            String qrCode = CommonUtils.convertObjectToString((Object)result.get((Object)"value"));
            this.scanAdd(qrCode);
        }
    }

    private void scanSelectedSN(Set<String> serialnumbers) {
        if (serialnumbers == null || serialnumbers.size() == 0) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl(op_billlistap);
        ListSelectedRowCollection selectedRows = billList.getCurrentListAllRowCollection();
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        int i = 0;
        ArrayList<Integer> listSelectedId = new ArrayList<Integer>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            String snNumber = selectedRow.getNumber();
            if (serialnumbers.contains(snNumber)) {
                selectedRow.setSelected(true);
                listSelectedId.add(i);
            }
            ++i;
        }
        if (listSelectedId.size() > 0) {
            int index = 0;
            int[] selectedIds = new int[listSelectedId.size()];
            for (Integer selectedId : listSelectedId) {
                selectedIds[index++] = selectedId;
            }
            billList.selectRows(selectedIds);
        }
    }

    private boolean scanAdd(String qrCode) {
        if (StringUtils.isEmpty((CharSequence)(qrCode = qrCode.trim()))) {
            this.getView().showTipNotification("\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        BillList billList = (BillList)this.getView().getControl(op_billlistap);
        int i = 0;
        boolean isMatchSN = false;
        ListSelectedRowCollection selectedRows = billList.getCurrentListAllRowCollection();
        for (ListSelectedRow selectedRow : selectedRows) {
            String snNumber = selectedRow.getNumber();
            if (StringUtils.equals((CharSequence)snNumber, (CharSequence)qrCode)) {
                long snId = Long.parseLong(String.valueOf(selectedRow.getPrimaryKeyValue()));
                billList.selectRows(i);
                selectedRow.setSelected(true);
                if (!this.scanAddMulSerialNumber(snNumber, snId)) {
                    return false;
                }
                isMatchSN = true;
                break;
            }
            ++i;
        }
        if (!isMatchSN) {
            this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u4e0d\u5b58\u5728\u6216\u975e\u5728\u5e93\u72b6\u6001\u3002", qrCode));
            return false;
        }
        this.setValue(SNSEARCH, "");
        return true;
    }

    private boolean scanAddMulSerialNumber(String qrCode, long snId) {
        if (StringUtils.isEmpty((CharSequence)(qrCode = qrCode.trim()))) {
            this.getView().showTipNotification("\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        JSONObject snJson = null;
        String mulserialnumber = String.valueOf(this.getValue(MULSERIALNUMBER));
        snJson = StringUtils.isEmpty((CharSequence)mulserialnumber) ? new JSONObject() : JSONObject.parseObject((String)mulserialnumber);
        if (snJson.containsKey((Object)qrCode)) {
            this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u5df2\u52fe\u9009", qrCode));
            return false;
        }
        snJson.put(qrCode, (Object)snId);
        this.setValue(MULSERIALNUMBER, snJson);
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "scanqrcode": {
                this.getView().invokeOperation(OP_SCANQRCODE);
                break;
            }
        }
    }
}

