/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.flex.FlexService;
import kd.bos.form.control.Image;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FlexEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.constants.OcocicLotConst;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.PictureUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class InventoryReportEntryPlugin
extends OcbaseFormMobPlugin {
    public static final String[] FIELDARRAY = new String[]{"auxptyid", "lotnumberid", "lotnumber", "stockstatusid", "stocktypeid", "keeperid", "keepertype", "ownerid", "ownertype", "productdate", "expiredate"};

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("itemid", customParams.get("itemid"));
        this.getModel().setValue("materialid", customParams.get("materialid"));
        this.getModel().setValue("auxptyid", customParams.get("auxptyid"));
        this.getModel().setValue("lotnumberid", customParams.get("lotnumberid"));
        this.getModel().setValue("lotnumber", customParams.get("lotnumber"));
        this.getModel().setValue("stockstatusid", customParams.get("stockstatusid"));
        this.getModel().setValue("stocktypeid", customParams.get("stocktypeid"));
        this.getModel().setValue("keeperid", customParams.get("keeperid"));
        this.getModel().setValue("keepertype", customParams.get("keepertype"));
        this.getModel().setValue("ownerid", customParams.get("ownerid"));
        this.getModel().setValue("ownertype", customParams.get("ownertype"));
        this.getModel().setValue("productdate", customParams.get("productdate"));
        this.getModel().setValue("expiredate", customParams.get("expiredate"));
        this.getModel().setValue("qty", customParams.get("qty"));
        this.getModel().setValue("unitid", customParams.get("unitid"));
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        DynamicObject item = (DynamicObject)this.getModel().getValue("itemid");
        Image imageap = (Image)this.getControl("imageap");
        if (imageap != null && item != null) {
            imageap.setUrl(PictureUtil.getServerPictureUrl((String)item.getString("thumbnail")));
        }
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey;
        switch (opKey = evt.getOperateKey()) {
            case "confirm": {
                int index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
                for (String field : FIELDARRAY) {
                    this.setParentValue(field, index);
                }
                this.getView().close();
                break;
            }
        }
        super.afterDoOperation(evt);
    }

    private void setParentValue(String field, int index) {
        this.getView().getParentView().getModel().setValue(field, this.getModel().getValue(field), index);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        switch (propertyKey = e.getProperty().getName()) {
            case "lotnumber": {
                this.setValue("lotnumberid", null);
                this.setValue("productdate", null);
                this.setValue("expiredate", null);
                String lotNumber = (String)this.getModel().getValue("lotnumber");
                if (!StringUtils.isNotEmpty((String)lotNumber)) break;
                this.setLotInfoByLot(lotNumber);
                break;
            }
        }
        if (propertyKey.startsWith("$$") && propertyKey.split("__")[0].equals("$$auxptyid")) {
            FlexEdit flexEdit = (FlexEdit)this.getControl("auxptyid");
            IDataModel flexModel = flexEdit.getFlexModel();
            DynamicObject dataEntity = flexModel.getDataEntity();
            MainEntityType dataEntityType = flexModel.getDataEntityType();
            FlexEntireData flexEntireData = new FlexEntireData();
            flexEntireData.setFlexData(dataEntityType, dataEntity);
            long auxptyId = FlexService.saveFlexData((MainEntityType)dataEntityType, (FlexEntireData)flexEntireData);
            this.setValue("auxptyid", auxptyId);
        }
        super.propertyChanged(e);
    }

    private List<QFilter> getLotFilterByItemId() {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        DynamicObject itemDynObj = this.getF7Value("itemid");
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)itemDynObj);
        if (itemId == 0L) {
            return filterList;
        }
        filterList.add(new QFilter("itemid", "=", (Object)itemId));
        filterList.add(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("auxptyid"));
        if (auxptyId > 0L) {
            filterList.add(new QFilter("auxptyid", "=", (Object)auxptyId));
        }
        return filterList;
    }

    private void setLotInfoByLot(String lotNumber) {
        List<QFilter> filterList = this.getLotFilterByItemId();
        QFilter lotNumberFilter = null;
        if (StringUtils.isNotEmpty((String)lotNumber)) {
            lotNumberFilter = new QFilter("number", "=", (Object)lotNumber);
            filterList.add(lotNumberFilter);
        }
        DynamicObjectCollection lotDynObjColl = null;
        if (!CommonUtils.isNull(filterList)) {
            lotDynObjColl = QueryServiceHelper.query((String)"ococic_lot", (String)String.join((CharSequence)",", "number", "id", "auxptyid", OcocicLotConst.EF_lotdate_productdate, OcocicLotConst.EF_lotdate_expiredate), (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        }
        if (lotDynObjColl != null && !lotDynObjColl.isEmpty()) {
            DynamicObject lotDynObj = (DynamicObject)lotDynObjColl.get(0);
            this.getModel().setValue("lotnumberid", (Object)lotDynObj.getLong("id"));
            this.getModel().setValue("productdate", (Object)lotDynObj.getDate(OcocicLotConst.EF_lotdate_productdate));
            this.getModel().setValue("expiredate", (Object)lotDynObj.getString(OcocicLotConst.EF_lotdate_expiredate));
        } else {
            this.getModel().setValue("lotnumberid", null);
        }
    }
}

