/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.enums.channel.SystemPresetChannelFuction;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.pagemodel.ococic.OcocicInventoryreport;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobBusinessPlugin;

public class InventoryReportMobEdit
extends OcbaseFormMobBusinessPlugin
implements BeforeF7SelectListener {
    private static final String OP_REDUCE = "reduce";
    private static final String OP_ADD = "add";
    private static final String OP_AUXREDUCE = "auxreduce";
    private static final String OP_AUXADD = "auxadd";
    private static final String DELETE_BTN = "delete_btn";
    private static final String MOREINFO_BTN = "moreinfo_btn";
    private static final String ITEMSELECT_BTN = "itemselect_btn";
    private static final String[] PAGEHEADFIELD = new String[]{"billno", "billtypeid", "reportchannelid", "org", "reportdate", "billstatus", "remark"};
    private static final String[] ENTRYFIELD = new String[]{"itemid", "materialid", "qty", "assistqty", "unitid", "baseunitid", "assistunitid", "baseqty", "warehouseid", "locationid", "stocktypeid", "stockstatusid", "keeperid", "keepertype", "ownerid", "ownertype", "auxptyid", "lotnumberid", "productdate", "expiredate", "lotnumber"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OP_ADD, OP_REDUCE, OP_AUXREDUCE, OP_AUXADD, ITEMSELECT_BTN, DELETE_BTN, MOREINFO_BTN});
        this.addF7Listener(this, new String[]{"billtypeid", "reportchannelid", "warehouseid", "locationid"});
    }

    public void afterCreateNewData(EventObject e) {
        Object billIdObj = this.getView().getFormShowParameter().getCustomParam("billid");
        if (StringUtils.isNotNull((Object)billIdObj)) {
            this.initData(Long.parseLong(billIdObj.toString()));
        } else {
            Object reportChannelId = this.getView().getFormShowParameter().getCustomParam("reportchannelid");
            this.initNewData(StringUtils.isNotNull((Object)reportChannelId) ? Long.parseLong(reportChannelId.toString()) : 0L);
        }
    }

    private void initData(long billId) {
        this.getModel().setValue("id", (Object)billId);
        DynamicObject inventoryReport = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ococic_inventoryreport");
        this.setData(inventoryReport, this.getModel().getDataEntity(), PAGEHEADFIELD);
        MobExtendHelper.loadMobExtend((IDataModel)this.getModel(), (String)this.getView().getEntityId(), (DynamicObject)inventoryReport, (String)"ococic_inventoryreport");
        DynamicObjectCollection itemEntryPageData = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection itemEntry = inventoryReport.getDynamicObjectCollection("entryentity");
        if (itemEntry != null && !itemEntry.isEmpty()) {
            for (DynamicObject item : itemEntry) {
                DynamicObject itemPageData = itemEntryPageData.addNew();
                itemPageData.set("entryid", (Object)item.getLong("id"));
                this.setData(item, itemPageData, ENTRYFIELD);
                MobExtendHelper.setOrmExtToMobExt((DynamicObject)itemPageData, (DynamicObject)item, (String)this.getView().getEntityId(), (String)"ococic_inventoryreport");
            }
        }
        if (!Status.SAVED.toString().equals(inventoryReport.getString("billstatus"))) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void setData(DynamicObject sourceDynamicObject, DynamicObject destDynamicObject, String[] fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (String field : fields) {
            destDynamicObject.set(field, sourceDynamicObject.get(field));
        }
    }

    private void initNewData(long reportChannelId) {
        String billNo = CodeRuleUtil.readCodeRule((String)"ococic_inventoryreport");
        this.getModel().setValue("billno", (Object)billNo);
        this.getModel().setValue("billstatus", (Object)Status.SAVED.toString());
        this.getModel().setValue("billtypeid", (Object)OcocicInventoryreport.BILLTYPE_DEFALUT);
        this.getModel().setValue("reportdate", (Object)TimeServiceHelper.now());
        this.setDefaultReportChannelAndOrg(reportChannelId);
    }

    private void setDefaultReportChannelAndOrg(long reportChannelId) {
        QFilter filter = this.getReportChannelFilter(reportChannelId);
        String selectProperties = String.join((CharSequence)",", "id", "saleorg");
        DynamicObject[] reportChannel = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)selectProperties, (QFilter[])filter.toArray());
        if (reportChannel != null && reportChannel.length > 0) {
            long currentChannelId;
            Map reportChannelMap = Arrays.asList(reportChannel).stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity(), (r1, r2) -> r1));
            if (reportChannelMap.containsKey(currentChannelId = B2BUserHelper.getLoginChannelId())) {
                this.getModel().setValue("reportchannelid", (Object)currentChannelId);
                this.getModel().setValue("org", (Object)((DynamicObject)reportChannelMap.get(currentChannelId)).getLong("saleorg_id"));
            } else {
                this.getModel().setValue("reportchannelid", (Object)reportChannel[0].getLong("id"));
                this.getModel().setValue("org", (Object)reportChannel[0].getLong("saleorg_id"));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "delete_btn": {
                this.getModel().deleteEntryRow("entryentity", index);
                break;
            }
            case "moreinfo_btn": {
                this.openMoreInfo(index);
                break;
            }
            case "itemselect_btn": {
                long channelId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "reportchannelid", "id"));
                if (channelId == 0L) {
                    this.getView().showErrorNotification("\u8bf7\u5148\u9009\u62e9\u4e0a\u62a5\u6e20\u9053");
                    return;
                }
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdbd_itemmobf7");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                List<Object> list = new ArrayList();
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                list = entryentity.stream().map(r -> r.getLong("itemid_id")).collect(Collectors.toList());
                HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
                hashMap.put("selected", list);
                List<Object> marketItemIds = this.getMarketItemIds();
                hashMap.put("ids", marketItemIds);
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ITEMSELECT_BTN);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "add": {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
                this.getModel().setValue("qty", (Object)qty.add(BigDecimal.ONE), index);
                break;
            }
            case "reduce": {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
                if (qty.subtract(BigDecimal.ONE).compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().setValue("qty", (Object)qty.subtract(BigDecimal.ONE), index);
                break;
            }
            case "auxadd": {
                BigDecimal auxQty = (BigDecimal)this.getModel().getValue("assistqty", index);
                this.getModel().setValue("assistqty", (Object)auxQty.add(BigDecimal.ONE), index);
                break;
            }
            case "auxreduce": {
                BigDecimal auxQty = (BigDecimal)this.getModel().getValue("assistqty", index);
                if (auxQty.subtract(BigDecimal.ONE).compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().setValue("assistqty", (Object)auxQty.subtract(BigDecimal.ONE), index);
                break;
            }
        }
    }

    private void openMoreInfo(int index) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("ocdma_inventoryrepentry");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(21);
        this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        this.getModel().getEntryEntity("entryentity");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("entryentity", index);
        hashMap.put("itemid", rowInfo.getLong("itemid_id"));
        hashMap.put("materialid", rowInfo.getLong("materialid_id"));
        hashMap.put("auxptyid", rowInfo.getLong("auxptyid_id"));
        hashMap.put("warehouseid", rowInfo.getLong("warehouseid_id"));
        hashMap.put("locationid", rowInfo.getLong("locationid_id"));
        hashMap.put("lotnumberid", rowInfo.getLong("lotnumberid_id"));
        hashMap.put("lotnumber", rowInfo.get("lotnumber"));
        hashMap.put("stockstatusid", rowInfo.getLong("stockstatusid_id"));
        hashMap.put("stocktypeid", rowInfo.getLong("stocktypeid_id"));
        hashMap.put("keeperid", rowInfo.getLong("keeperid_id"));
        hashMap.put("keepertype", rowInfo.get("keepertype"));
        hashMap.put("ownerid", rowInfo.getLong("ownerid_id"));
        hashMap.put("ownertype", rowInfo.get("ownertype"));
        hashMap.put("productdate", rowInfo.getDate("productdate"));
        hashMap.put("expiredate", rowInfo.getDate("expiredate"));
        hashMap.put("qty", rowInfo.get("qty"));
        hashMap.put("unitid", rowInfo.getLong("unitid_id"));
        hashMap.put("index", index);
        showParameter.setCustomParams(hashMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, MOREINFO_BTN);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = true;
        int index = this.getRowIndex(e);
        switch (key) {
            case "reportchannelid": {
                long reportId = (Long)this.getModel().getValue("reportchannelid_id");
                String selectProperties = String.join((CharSequence)",", "id", "saleorg");
                DynamicObject reportChannel = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"ocdbd_channel", (String)selectProperties);
                if (reportChannel == null) break;
                this.getModel().setValue("org", (Object)reportChannel.getLong("saleorg_id"));
                break;
            }
            case "itemid": {
                DynamicObject item = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (item == null) break;
                this.getModel().setValue("thumbnail", (Object)item.getString("thumbnail"), index);
                this.getModel().setValue("unitid", (Object)item.getLong("orderunit_id"), index);
                this.getModel().setValue("assistunitid", (Object)item.getLong("assistunit_id"), index);
                this.getModel().setValue("baseunitid", (Object)item.getLong("baseunit_id"), index);
                this.getModel().setValue("materialid", (Object)item.getLong("material_id"), index);
                this.getModel().setValue("stockstatusid_id", (Object)1042689155454212096L, index);
                this.getModel().setValue("stocktypeid_id", (Object)1042808009622820864L, index);
                this.getModel().setValue("ownertype", (Object)"ocdbd_channel", index);
                this.getModel().setValue("ownerid_id", this.getModel().getValue("reportchannelid_id"), index);
                this.getModel().setValue("keepertype", (Object)"ocdbd_channel", index);
                this.getModel().setValue("keeperid_id", this.getModel().getValue("reportchannelid_id"), index);
                break;
            }
            case "qty": {
                long unitId = (Long)this.getModel().getValue("unitid_id", index);
                long baseunitId = (Long)this.getModel().getValue("unitid_id", index);
                long assistUnitId = (Long)this.getModel().getValue("assistunitid_id", index);
                long materielId = (Long)this.getModel().getValue("materialid_id", index);
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
                if (unitId != 0L && baseunitId != 0L && materielId != 0L) {
                    BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)unitId, (Long)baseunitId);
                    this.setValue("baseqty", baseQty, index, false);
                }
                if (unitId == 0L || assistUnitId == 0L || materielId == 0L) break;
                BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)unitId, (Long)assistUnitId);
                this.setValue("assistqty", assistQty, index, false);
                break;
            }
            case "assistqty": {
                long unitId = (Long)this.getModel().getValue("unitid_id", index);
                long assistUnitId = (Long)this.getModel().getValue("assistunitid_id", index);
                long materielId = (Long)this.getModel().getValue("materialid_id", index);
                BigDecimal assistQty = (BigDecimal)this.getModel().getValue("assistqty", index);
                if (unitId == 0L || assistUnitId == 0L || materielId == 0L) break;
                BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)assistQty, (Long)materielId, (Long)assistUnitId, (Long)unitId);
                this.setValue("qty", qty, index, true);
                break;
            }
            case "warehouseid": {
                this.getModel().setValue("locationid", null);
                break;
            }
        }
        super.propertyChanged(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "save": {
                this.saveBill();
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f\u3002");
                break;
            }
            case "audit": {
                this.saveBill();
                long id = (Long)this.getModel().getValue("id");
                OperateOption operateOption = CommonUtils.getMutexOperateOption();
                OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_inventoryreport", (Object[])new Long[]{id}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                operateOption = CommonUtils.getMutexOperateOption();
                result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_inventoryreport", (Object[])new Long[]{id}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                this.getView().showSuccessNotification("\u4e00\u952e\u4e0a\u62a5\u6210\u529f\u3002");
                this.getView().close();
                break;
            }
        }
    }

    private void saveBill() {
        long id = (Long)this.getModel().getValue("id");
        DynamicObject inventoryReport = null;
        if (id > 0L) {
            inventoryReport = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ococic_inventoryreport");
            if (inventoryReport == null) {
                throw new KDBizException("\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5220\u9664\u3002");
            }
        } else {
            inventoryReport = BusinessDataServiceHelper.newDynamicObject((String)"ococic_inventoryreport");
            inventoryReport.set("billstatus", this.getModel().getValue("billstatus"));
        }
        this.getPageDataToOrmData(inventoryReport);
        OperateOption operateOption = CommonUtils.getMutexOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ococic_inventoryreport", (DynamicObject[])new DynamicObject[]{inventoryReport}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
        }
        this.getModel().setValue("id", result.getSuccessPkIds().get(0));
    }

    private void getPageDataToOrmData(DynamicObject inventoryReport) {
        inventoryReport.set("billno", this.getModel().getValue("billno"));
        inventoryReport.set("reportchannelid_id", this.getModel().getValue("reportchannelid_id"));
        inventoryReport.set("org_id", this.getModel().getValue("org_id"));
        inventoryReport.set("billtypeid_id", this.getModel().getValue("billtypeid_id"));
        inventoryReport.set("reportdate", this.getModel().getValue("reportdate"));
        inventoryReport.set("remark", this.getModel().getValue("remark"));
        DynamicObjectCollection itemEntryPageData = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection itemEntry = inventoryReport.getDynamicObjectCollection("entryentity");
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)inventoryReport, (String)this.getView().getEntityId(), (String)"ococic_inventoryreport");
        if (itemEntryPageData != null && !itemEntryPageData.isEmpty()) {
            List ormEntryIds = itemEntry.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            Map ormEntryMap = itemEntry.stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity(), (r1, r2) -> r1));
            for (DynamicObject itemPageData : itemEntryPageData) {
                long entryid = itemPageData.getLong("entryid");
                DynamicObject item = null;
                if (entryid != 0L) {
                    item = (DynamicObject)ormEntryMap.get(entryid);
                    ormEntryIds.remove(entryid);
                } else {
                    item = itemEntry.addNew();
                }
                item.set("itemid_id", (Object)itemPageData.getLong("itemid_id"));
                item.set("auxptyid_id", this.getModel().getValue("auxptyid_id"));
                item.set("materialid_id", (Object)itemPageData.getLong("materialid_id"));
                item.set("unitid_id", (Object)itemPageData.getLong("unitid_id"));
                item.set("assistunitid_id", (Object)itemPageData.getLong("assistunitid_id"));
                item.set("baseunitid_id", (Object)itemPageData.getLong("baseunitid_id"));
                item.set("qty", itemPageData.get("qty"));
                item.set("assistqty", itemPageData.get("assistqty"));
                item.set("baseqty", itemPageData.get("baseqty"));
                item.set("warehouseid_id", (Object)itemPageData.getLong("warehouseid_id"));
                item.set("locationid_id", (Object)itemPageData.getLong("locationid_id"));
                item.set("stockstatusid_id", (Object)itemPageData.getLong("stockstatusid_id"));
                item.set("stocktypeid_id", (Object)itemPageData.getLong("stockstatusid_id"));
                item.set("ownertype", itemPageData.get("ownertype"));
                item.set("ownerid_id", this.getModel().getValue("ownerid_id"));
                item.set("keepertype", itemPageData.get("keepertype"));
                item.set("keeperid_id", this.getModel().getValue("keeperid_id"));
                item.set("productdate", itemPageData.get("productdate"));
                item.set("expiredate", itemPageData.get("expiredate"));
                item.set("lotnumberid_id", this.getModel().getValue("lotnumberid_id"));
                item.set("lotnumber", itemPageData.get("lotnumber"));
                MobExtendHelper.setMobExtToOrmExt((DynamicObject)itemPageData, (DynamicObject)item, (String)this.getView().getEntityId(), (String)"ococic_inventoryreport");
            }
            itemEntry.removeIf(r -> ormEntryIds.contains(r.getLong("id")));
        }
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{inventoryReport}, (IDataEntityType)inventoryReport.getDataEntityType());
    }

    private List<Object> getMarketItemIds() {
        long channelId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "reportchannelid", "id"));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ItemNSaleControlUtil.getMyItemFilter((long)channelId, (boolean)false));
        filters.add(new QFilter("goodsbelong", "!=", (Object)"1"));
        return QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_iteminfo", (QFilter[])filters.toArray(new QFilter[filters.size()]), null, (int)99999);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "itemselect_btn": {
                Object[] selectIds = (Object[])evt.getReturnData();
                if (selectIds == null || selectIds.length == 0) {
                    return;
                }
                long channelId = (Long)this.getModel().getValue("reportchannelid_id");
                long defaultStockId = ChannelHelper.getChannelDefaultStockId((long)channelId);
                long defaultLocationId = ChannelHelper.getDefaultLocationId((long)defaultStockId);
                int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", selectIds.length);
                int i = 0;
                for (Object itemId : selectIds) {
                    this.triggerChangeEvent = true;
                    this.setValue("itemid", itemId, rows[i]);
                    this.setValue("qty", BigDecimal.ZERO, rows[i]);
                    this.setValue("assistqty", BigDecimal.ZERO, rows[i]);
                    this.setValue("baseqty", BigDecimal.ZERO, rows[i]);
                    this.setValue("warehouseid", defaultStockId, rows[i]);
                    this.setValue("locationid", defaultLocationId, rows[i]);
                    ++i;
                }
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        int rowIndex = evt.getRow();
        switch (key) {
            case "reportchannelid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)this.getReportChannelFilter(0L));
                break;
            }
            case "billtypeid": {
                QFilter filter = F7Utils.getCommonStatusFilter();
                filter.and("billformid", "=", (Object)"ococic_inventoryreport");
                List returnBillTypeIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_billtype", (QFilter[])filter.toArray(), (String)"", (int)-1);
                if (CollectionUtils.isEmpty((Collection)returnBillTypeIdList)) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)F7Utils.getEveFalseFilter());
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)new QFilter("id", "in", (Object)returnBillTypeIdList));
                break;
            }
            case "warehouseid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)new QFilter("ownerchannelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("reportchannelid"))));
                break;
            }
            case "locationid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)new QFilter("warehouseid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("warehouseid", rowIndex))));
                break;
            }
        }
    }

    private QFilter getReportChannelFilter(long reportChannelId) {
        QFilter filter = new QFilter("channelfunctions.fbasedataid.id", "=", (Object)SystemPresetChannelFuction.STORAGE.toLong());
        filter.and(new QFilter("invcontrolmode", "=", (Object)"B"));
        filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        filter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        if (reportChannelId == 0L) {
            filter.and(new QFilter("id", "in", (Object)CUserHelper.getAuthorizedChannelIdList()));
        } else {
            filter.and(new QFilter("id", "=", (Object)reportChannelId));
        }
        return filter;
    }
}

