/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class InventoryReportMobList
extends OcdmaFormMobPlugin
implements TabSelectListener,
ListRowClickListener,
MobileSearchTextChangeListener {
    private static final String SEARCHAP = "searchap";
    private static final String BILLLISTAP = "billlistap";
    private static final String TABAP = "tabap";
    private static final String TAB_ALL = "all";
    private static final String TAB_A = "status_a";
    private static final String TAB_B = "status_b";
    private static final String TAB_C = "status_c";
    private static final String PAGE_EDIT = "ocdma_inventoryreport";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{TABAP});
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCHAP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(PAGE_EDIT);
        if (BillStatus.A.toString().equals(billList.getCurrentSelectedRowInfo().getBillStatus())) {
            mobileFormShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            mobileFormShowParameter.setStatus(OperationStatus.VIEW);
        }
        mobileFormShowParameter.setCustomParam("billid", pkId);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modify"));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void afterCreateNewData(EventObject e) {
        Object opKey = this.getParameter("opkey");
        if (StringUtils.isNotNull((Object)opKey)) {
            Tab tab = (Tab)this.getView().getControl(TABAP);
            String tbKey = opKey.toString();
            tab.selectTab(tbKey);
            tab.activeTab(tbKey);
        }
        this.refleshBillList();
    }

    private QFilter getBillFilter(String tabKey) {
        QFilter filter = null;
        List authorityCustomerList = CUserHelper.getAuthorizedChannelIdList();
        filter = new QFilter("reportchannelid", "in", (Object)authorityCustomerList);
        switch (tabKey) {
            case "status_a": {
                filter.and("billstatus", "=", (Object)Status.SAVED.toString());
                break;
            }
            case "status_b": {
                filter.and("billstatus", "=", (Object)Status.SUBMITED.toString());
                break;
            }
            case "status_c": {
                filter.and("billstatus", "=", (Object)Status.AUDITED.toString());
                break;
            }
        }
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCHAP);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno"}));
        }
        return filter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "new": {
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileFormShowParameter.setFormId(PAGE_EDIT);
                mobileFormShowParameter.setStatus(OperationStatus.ADDNEW);
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "new"));
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
            case "modify": {
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileFormShowParameter.setFormId(PAGE_EDIT);
                mobileFormShowParameter.setStatus(OperationStatus.EDIT);
                mobileFormShowParameter.setCustomParam("billid", pkId);
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modify"));
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
            case "delete": 
            case "submit": 
            case "unsubmit": 
            case "audit": {
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                Object id = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                OperateOption operateOption = CommonUtils.getMutexOperateOption();
                OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)"ococic_inventoryreport", (Object[])new Object[]{id}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                this.refleshBillList();
                break;
            }
        }
        super.afterDoOperation(args);
    }

    private void refleshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        String curTabKey = tab.getCurrentTab();
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter(curTabKey)});
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String key;
        switch (key = ((Control)mobileSearchTextChangeEvent.getSource()).getKey()) {
            case "searchap": {
                this.refleshBillList();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = ((Control)tabSelectEvent.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter(tabSelectEvent.getTabKey())});
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        switch (key = closedCallBackEvent.getActionId()) {
            case "modify": 
            case "new": {
                this.refleshBillList();
                break;
            }
        }
        super.closedCallBack(closedCallBackEvent);
    }
}

