/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.channelinv;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.ResourcePermHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ResourcePermInventoryList
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener {
    private static final String OP_ITEMSEARCH = "itemsearch";
    private static final String RESOURCESTOCK = "resourcestock";
    private static final String BTNCLOSE = "btnclose";
    private static final String SUMMODE = "summode";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery"});
        this.addF7Listener(this, new String[]{RESOURCESTOCK});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        boolean isExist = QueryServiceHelper.exists((String)"ococic_resourcestock", (QFilter[])filter.toArray());
        if (!isExist) {
            this.getView().showTipNotification("\u65e0\u53ef\u7528\u7684\u5e93\u5b58\u8d44\u6e90\uff0c\u8bf7\u7cfb\u7edf\u7ba1\u7406\u5458\u5728\u5168\u7f51\u5e93\u5b58\u4e2d\u5fc3-\u5e93\u5b58\u8d44\u6e90\u4e2d\u589e\u52a0\uff01");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "resourcestock": {
                List channelIdList = CUserHelper.getAuthorizedChannelIdList();
                List resourceStockIds = ResourcePermHelper.getResourcePermResourceStockIdList((List)channelIdList, null);
                QFilter qFilter = new QFilter("id", "in", (Object)resourceStockIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String button;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (button = control.getKey()) {
            case "btnquery": {
                this.setItemInvList();
                break;
            }
        }
    }

    private void setItemInvList() {
        List resourceidlist = null;
        Object resourcestock = this.getModel().getValue(RESOURCESTOCK);
        if (resourcestock instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection resourcestockBaseColl = (MulBasedataDynamicObjectCollection)resourcestock;
            resourceidlist = resourcestockBaseColl.stream().map(k -> (Long)((DynamicObject)k.get("fbasedataid")).getPkValue()).collect(Collectors.toList());
        }
        List channelIdList = CUserHelper.getAuthorizedChannelIdList();
        MobileSearch search = (MobileSearch)this.getControl(OP_ITEMSEARCH);
        String searchText = search.getText().trim();
        String searchFields = "number,name,modelnum";
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("searchvalue", searchText);
        paramMap.put("searchfields", searchFields);
        paramMap.put("channelidlist", channelIdList);
        paramMap.put("resourcestockidlist", resourceidlist);
        List resourcePermInvAccResults = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"ResourcePermInventoryService", (String)"queryAvailableInventory", (Object[])new Object[]{paramMap});
        IDataModel model = this.getModel();
        model.deleteEntryData("iteminvlist");
        if (CollectionUtils.isEmpty((Collection)resourcePermInvAccResults)) {
            return;
        }
        List<JSONObject> groupKeyResults = new ArrayList();
        Object summode = this.getModel().getValue(SUMMODE);
        if (summode != null) {
            BigDecimal sumBaseQty;
            BigDecimal sumQty;
            JSONObject mapInvAccResult;
            String groupKey;
            JSONObject resourcePermInvAccResult;
            Object object;
            HashMap<String, JSONObject> groupKeyResultMap;
            if (StringUtils.equals((CharSequence)summode.toString(), (CharSequence)"B")) {
                groupKeyResultMap = new HashMap<String, JSONObject>(resourcePermInvAccResults.size());
                object = resourcePermInvAccResults.iterator();
                while (object.hasNext()) {
                    resourcePermInvAccResult = (JSONObject)object.next();
                    groupKey = resourcePermInvAccResult.getString("itemid") + "_" + resourcePermInvAccResult.getString("resourcestockid");
                    mapInvAccResult = (JSONObject)groupKeyResultMap.get(groupKey);
                    if (mapInvAccResult == null) {
                        groupKeyResults.add(resourcePermInvAccResult);
                        groupKeyResultMap.put(groupKey, resourcePermInvAccResult);
                        continue;
                    }
                    sumQty = mapInvAccResult.getBigDecimal("qty").add(resourcePermInvAccResult.getBigDecimal("qty"));
                    sumBaseQty = mapInvAccResult.getBigDecimal("baseqty").add(resourcePermInvAccResult.getBigDecimal("baseqty"));
                    mapInvAccResult.put("qty", (Object)sumQty);
                    mapInvAccResult.put("baseqty", (Object)sumBaseQty);
                }
            } else {
                groupKeyResultMap = new HashMap(resourcePermInvAccResults.size());
                object = resourcePermInvAccResults.iterator();
                while (object.hasNext()) {
                    resourcePermInvAccResult = (JSONObject)object.next();
                    groupKey = resourcePermInvAccResult.getString("itemid");
                    mapInvAccResult = (JSONObject)groupKeyResultMap.get(groupKey);
                    if (mapInvAccResult == null) {
                        groupKeyResults.add(resourcePermInvAccResult);
                        groupKeyResultMap.put(groupKey, resourcePermInvAccResult);
                        continue;
                    }
                    sumQty = mapInvAccResult.getBigDecimal("qty").add(resourcePermInvAccResult.getBigDecimal("qty"));
                    sumBaseQty = mapInvAccResult.getBigDecimal("baseqty").add(resourcePermInvAccResult.getBigDecimal("baseqty"));
                    mapInvAccResult.put("qty", (Object)sumQty);
                    mapInvAccResult.put("baseqty", (Object)sumBaseQty);
                }
            }
        } else {
            groupKeyResults = resourcePermInvAccResults;
        }
        int[] indexes = model.batchCreateNewEntryRow("iteminvlist", groupKeyResults.size());
        for (int index : indexes) {
            JSONObject groupKeyResult = (JSONObject)groupKeyResults.get(index);
            model.setValue("itemid", (Object)groupKeyResult.getLong("itemid"), index);
            model.setValue("materialid", (Object)groupKeyResult.getLong("materialid"), index);
            model.setValue("resourcestockid", (Object)groupKeyResult.getLong("resourcestockid"), index);
            model.setValue("stockqty", (Object)groupKeyResult.getBigDecimal("qty"), index);
            model.setValue("stockunitid", (Object)groupKeyResult.getLong("unitid"), index);
            model.setValue("baseqty", (Object)groupKeyResult.getBigDecimal("baseqty"), index);
            model.setValue("baseunitid", (Object)groupKeyResult.getLong("baseunitid"), index);
        }
    }
}

