/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.home;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.CarouselFigure;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.b2b.ItemBusinessHelper;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.pojo.PromotionItemVo;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class HomePlugin
extends OcdmaFormMobPlugin {
    private static final String CAROUSELFIGUREAP = "carouselfigureap";
    private static final String QUICK_PROMOTION = "activity";
    private static final String QUICK_BUYAHAIN = "buyagain";
    private static final String QUICK_REBATEDETAIL = "rebatedetail";
    private static final String QUICK_SALERPTDETAIL = "salerptdetail";
    private static final String QUICK_CHANNELINVDETAIL = "channelinvdetail";
    private static final String QUICK_ALLAPP = "allapp";
    private static final String QUICK_COSTAPPLY = "costapply";
    private static final String QUICK_MONEYINCOME = "moneyincome";
    private static final String QUICK_FOLLOW = "follow";
    private static final String QUICK_DELIVERYCONFIRM = "deliveryconfirm";
    private static final String QUICK_ORDERSIGN = "ordersign";
    private static final String CHANNELSALEQTYPANEL = "channelsaleqtypanel";
    private static final String CHANNELSALEAMOUNTPANEL = "channelsaleamountpanel";
    protected static Log logger = LogFactory.getLog(OcdmaFormMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{QUICK_BUYAHAIN, QUICK_PROMOTION, QUICK_REBATEDETAIL, CHANNELSALEQTYPANEL, CHANNELSALEAMOUNTPANEL, QUICK_ALLAPP, QUICK_COSTAPPLY, QUICK_MONEYINCOME, QUICK_FOLLOW, QUICK_DELIVERYCONFIRM, QUICK_ORDERSIGN, QUICK_SALERPTDETAIL, QUICK_CHANNELINVDETAIL});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        CarouselFigure carouselFigure = (CarouselFigure)this.getControl(CAROUSELFIGUREAP);
        carouselFigure.setBasdataNumber(this.isMiniMallHome() ? "ocdma_mallbanner" : "ocdma_banner");
        carouselFigure.updateValue();
        long supplyRelationId = this.getChannelAuthorize();
        if (supplyRelationId == 0L) {
            return;
        }
        this.setValue("supplyrelationid", supplyRelationId);
        this.getView().addClientCallBack("loadMoreData");
        this.getView().addClientCallBack("promotiongoods");
    }

    private void loadAttentionItemCount(List<Long> marketableGoodIds) {
        Label followMessage = (Label)this.getControl("followmessage");
        List attentionIds = ItemBusinessHelper.queryAttentionItemIds((String)"ocdbd_item_attention", (String)"itemid", marketableGoodIds);
        int count = attentionIds == null || attentionIds.isEmpty() ? 0 : attentionIds.size();
        followMessage.setText(String.valueOf(count));
    }

    private void loadRebateAmount(long orderChannelId) {
        DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel");
        long balanceChannelId = orderChannel != null ? orderChannel.getLong("balancechannel_id") : 0L;
        Label prepaymentAmountlabel = (Label)this.getControl("prepaymentamount");
        BigDecimal prepaymentAmount = this.getRebateAcount(balanceChannelId, "C");
        prepaymentAmountlabel.setText(prepaymentAmount.setScale(2, RoundingMode.HALF_UP).toEngineeringString());
        Label rebateAmountlabel = (Label)this.getControl("rebateamount");
        BigDecimal rebateAmount = this.getRebateAcount(balanceChannelId, "A");
        rebateAmountlabel.setText(rebateAmount.setScale(2, RoundingMode.HALF_UP).toEngineeringString());
    }

    private BigDecimal getRebateAcount(long orderChannelId, String accountType) {
        BigDecimal prepaymentAcount = BigDecimal.ZERO;
        try {
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"occba", (String)"Occba_rebateService", (String)"getCollectAccountAmount", (Object[])new Object[]{orderChannelId + "", accountType});
            return result.getJSONObject("data").getBigDecimal("totalAmount");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return prepaymentAcount;
        }
    }

    private void loadChannelSaleVolume() {
        Date firstToday = DateUtil.getDayFirst((Date)DateUtil.getNowDate());
        Date lastToday = DateUtil.getDayLast((Date)DateUtil.getNowDate());
        Date firstDayOfWeek = DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfWeek());
        Date lastDayOfWeek = DateUtil.getDayLast((Date)DateUtil.getLastDayOfWeek());
        Date firstDayOfMonth = DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth());
        Date lastDayOfMonth = DateUtil.getDayLast((Date)DateUtil.getLastDayOfMonth());
        Date startDate = firstDayOfMonth;
        Date endDate = lastDayOfMonth;
        if (startDate.compareTo(firstDayOfWeek) > 0) {
            startDate = firstDayOfWeek;
        }
        if (endDate.compareTo(lastDayOfWeek) < 0) {
            endDate = lastDayOfWeek;
        }
        BigDecimal todayamount = BigDecimal.ZERO;
        BigDecimal todayqty = BigDecimal.ZERO;
        BigDecimal weekamount = BigDecimal.ZERO;
        BigDecimal weekqty = BigDecimal.ZERO;
        BigDecimal monthamount = BigDecimal.ZERO;
        BigDecimal monthqty = BigDecimal.ZERO;
        QFilter filter = new QFilter("channel", "in", (Object)CUserHelper.getAuthorizedChannelIdList());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("bizdate", ">=", (Object)startDate);
        filter.and("bizdate", "<", (Object)endDate);
        String selectFields = "bizdate,entryentity.qty,entryentity.amount";
        DynamicObjectCollection saleVolumes = QueryServiceHelper.query((String)"occbo_salevolume", (String)selectFields, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)saleVolumes)) {
            for (DynamicObject saleVolume : saleVolumes) {
                BigDecimal qty = saleVolume.getBigDecimal("entryentity.qty");
                BigDecimal amount = saleVolume.getBigDecimal("entryentity.amount");
                Date bizDate = saleVolume.getDate("bizdate");
                if (bizDate.compareTo(firstToday) >= 0 && bizDate.compareTo(lastToday) <= 0) {
                    todayqty = todayqty.add(qty);
                    todayamount = todayamount.add(amount);
                }
                if (bizDate.compareTo(firstDayOfWeek) >= 0 && bizDate.compareTo(lastDayOfWeek) <= 0) {
                    weekqty = weekqty.add(qty);
                    weekamount = weekamount.add(amount);
                }
                if (bizDate.compareTo(firstDayOfMonth) < 0 || bizDate.compareTo(lastDayOfMonth) > 0) continue;
                monthqty = monthqty.add(qty);
                monthamount = monthamount.add(amount);
            }
        }
        Label channelsaleqty_label = (Label)this.getControl("channelsaleqty");
        channelsaleqty_label.setText(todayqty.stripTrailingZeros().toPlainString());
        Label channelsaleamount_label = (Label)this.getControl("channelsaleamount");
        channelsaleamount_label.setText(this.formatAmount(todayamount));
        Label weeksaleqty_label = (Label)this.getControl("weeksaleqty");
        weeksaleqty_label.setText(weekqty.stripTrailingZeros().toPlainString());
        Label weeksaleamount_label = (Label)this.getControl("weeksaleamount");
        weeksaleamount_label.setText(this.formatAmount(weekamount));
        Label monthsaleqty_label = (Label)this.getControl("monthsaleqty");
        monthsaleqty_label.setText(monthqty.stripTrailingZeros().toPlainString());
        Label monthsaleamount_label = (Label)this.getControl("monthsaleamount");
        monthsaleamount_label.setText(this.formatAmount(monthamount));
    }

    private String formatAmount(BigDecimal amount) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(amount);
    }

    private void loadChannelInv() {
        long loginChannelId = this.getChannelId();
        List channelIdList = CUserHelper.getAuthorizedChannelIdList();
        List channelInvAccResults = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"ChannelInvAccService", (String)"queryChannelAvailableInventory", (Object[])new Object[]{channelIdList, null});
        if (!CollectionUtils.isEmpty((Collection)channelInvAccResults)) {
            BigDecimal suminvqty = BigDecimal.ZERO;
            BigDecimal sumunderinvqty = BigDecimal.ZERO;
            for (JSONObject invAcc : channelInvAccResults) {
                BigDecimal stockqty = invAcc.getBigDecimal("stockqty");
                long channelid = invAcc.getLong("channelid");
                if (channelid == loginChannelId) {
                    suminvqty = suminvqty.add(stockqty);
                    continue;
                }
                sumunderinvqty = sumunderinvqty.add(stockqty);
            }
            Label invqty_label = (Label)this.getControl("invqty");
            invqty_label.setText(suminvqty.stripTrailingZeros().toPlainString());
            Label underinvqty_label = (Label)this.getControl("underinvqty");
            underinvqty_label.setText(sumunderinvqty.stripTrailingZeros().toPlainString());
        }
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "buyagain": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) break;
                parentView.invokeOperation("saleorder");
                this.getView().sendFormAction(parentView);
                break;
            }
            case "activity": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) break;
                IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
                pageCache.put("isFromHomePromotion", "true");
                parentView.invokeOperation("mall");
                this.getView().sendFormAction(parentView);
                break;
            }
            case "rebatedetail": {
                this.jumpToRebatePage();
                break;
            }
            case "allapp": {
                this.jumpToAllAppPage();
                break;
            }
            case "costapply": {
                this.jumoToMarketCostApply();
                break;
            }
            case "moneyincome": {
                this.jumoToMoneyIncome();
                break;
            }
            case "follow": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) break;
                IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
                pageCache.put("isFromHomeAttention", "true");
                parentView.invokeOperation("mall");
                this.getView().sendFormAction(parentView);
                break;
            }
            case "deliveryconfirm": {
                MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
                mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileBillShowParameter.setFormId("ocdma_deliveryconfirm");
                this.getView().showForm((FormShowParameter)mobileBillShowParameter);
                break;
            }
            case "ordersign": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) break;
                parentView.invokeOperation("saleorder");
                parentView.getPageCache().put(QUICK_ORDERSIGN, "true");
                this.getView().sendFormAction(parentView);
                break;
            }
            case "salerptdetail": {
                this.jumpToChannelSaleRpt();
                break;
            }
            case "channelinvdetail": {
                this.jumpToChannelInv();
                break;
            }
        }
    }

    private void jumoToMoneyIncome() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setCustomParam("view", (Object)"paymenthistory");
        mobileBillShowParameter.setFormId("ocdma_amountindex");
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void jumoToMarketCostApply() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_marketcost_apply");
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void jumpToAllAppPage() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_allapp");
        mobileBillShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, QUICK_ALLAPP));
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if (QUICK_ALLAPP.equals(key)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            IFormView parentView = this.getView().getParentView();
            switch (returnData.toString()) {
                case "mall": {
                    if (parentView == null) break;
                    parentView.invokeOperation("mall");
                    this.getView().sendFormAction(parentView);
                    break;
                }
                case "saleorder": {
                    if (parentView == null) break;
                    parentView.invokeOperation("saleorder");
                    this.getView().sendFormAction(parentView);
                    break;
                }
                case "ordersign": {
                    if (parentView == null) break;
                    parentView.invokeOperation("saleorder");
                    parentView.getPageCache().put(QUICK_ORDERSIGN, "true");
                    this.getView().sendFormAction(parentView);
                    break;
                }
                case "moneyincome": {
                    this.jumoToMoneyIncome();
                    break;
                }
                case "returnorder": {
                    this.getView().invokeOperation("openreturnorder");
                    break;
                }
                case "mybalance": {
                    this.jumpToRebatePage();
                    break;
                }
                case "deliveryconfirm": {
                    this.getView().invokeOperation("opendeliveryconfirm");
                    break;
                }
                case "deliveryserivce": {
                    this.getView().invokeOperation("opendeliveryserivce");
                    break;
                }
                case "instockserivce": {
                    this.getView().invokeOperation("openinstockserivce");
                    break;
                }
                case "outstockserivce": {
                    this.getView().invokeOperation("openoutstockserivce");
                    break;
                }
                case "salevolumebill": {
                    this.getView().invokeOperation("opensalevolumebill");
                    break;
                }
                case "channelsalerpt": {
                    this.getView().invokeOperation("openchannelsalerpt");
                    break;
                }
                case "valetorderlist": {
                    this.getView().invokeOperation("openvaletorderlist");
                    break;
                }
                case "channelinvserivce": {
                    this.getView().invokeOperation("openchannelinvserivce");
                    break;
                }
                case "transserivce": {
                    this.getView().invokeOperation("opentransserivce");
                    break;
                }
            }
        }
        super.closedCallBack(closedCallBackEvent);
    }

    private void jumpToRebatePage() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_amountindex");
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void jumpToChannelSaleRpt() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_salevolumerpt");
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void jumpToChannelInv() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_channelinv");
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void getPromotionGoods(List<Long> marketableGoodIds) {
        Label activityMessage = (Label)this.getControl("activitymessage");
        if (marketableGoodIds == null || marketableGoodIds.isEmpty()) {
            activityMessage.setText("0");
            return;
        }
        Map<String, List<PromotionItemVo>> promotionPolicyMap = this.getPromotionPolicy(marketableGoodIds);
        if (promotionPolicyMap == null) {
            return;
        }
        HashSet<Long> promotionItemIds = new HashSet<Long>(promotionPolicyMap.size());
        for (Map.Entry<String, List<PromotionItemVo>> entry : promotionPolicyMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            promotionItemIds.add(Long.valueOf(entry.getKey().split("_")[0]));
        }
        int promotionGoodsNumber = promotionItemIds.size();
        activityMessage.setText(String.valueOf(promotionGoodsNumber));
    }

    private Map<String, List<PromotionItemVo>> getPromotionPolicy(List<Long> marketableGoodsIds) {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        DynamicObjectCollection unitCollection = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)String.join((CharSequence)",", "id", "orderunit.id"), (QFilter[])new QFilter[]{new QFilter("id", "in", marketableGoodsIds)});
        Map<Long, Long> unitMap = unitCollection.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("orderunit.id")));
        List itemInfo = marketableGoodsIds.stream().map(r -> r + "_" + 0L + "_" + unitMap.get(r)).collect(Collectors.toCollection(ArrayList::new));
        return (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"PromotionService", (String)"getPromotionPolicy", (Object[])new Object[]{orderChannelId, saleOrgId, saleChannelId, supplyRelation, itemInfo});
    }

    private QFilter getItemStatusQFilter(QFilter filter) {
        String itemStatusControl = SysParamsUtil.getItemStatusControl();
        boolean ocbmallControl = itemStatusControl.contains("1");
        if (ocbmallControl) {
            if (filter == null) {
                return new QFilter("itemstatus", "=", (Object)"0");
            }
            filter.and("itemstatus", "=", (Object)"0");
            return filter;
        }
        return null;
    }

    private List<Long> getMarketableGoodsId(long orderChannelId, long saleOrgId, long saleChannelId) {
        QFilter filter = this.getItemStatusQFilter(null);
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoodsId", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
    }

    private void showWindow(List<JSONObject> itemList, String title, long supplierId, long supplyRelationId) {
        this.filterItem(itemList, supplierId);
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("ocdma_showwindow");
        OpenStyle openStyle = mobileFormShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.NewTabPage);
        openStyle.setTargetKey("showwindow");
        mobileFormShowParameter.setCustomParam("title", (Object)title);
        mobileFormShowParameter.setCustomParam("itemList", itemList);
        mobileFormShowParameter.setCustomParam("supplyRelationId", (Object)supplyRelationId);
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void filterItem(List<JSONObject> itemList, long supplierId) {
        if (supplierId != 0L && !CollectionUtils.isEmpty(itemList)) {
            itemList.removeIf(item -> {
                String supplyRelation = item.getString("supplyRelation");
                long itemSupplierId = ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation) ? item.getLong("saleCustomerId").longValue() : item.getLong("saleorgid").longValue();
                return itemSupplierId != supplierId;
            });
        }
    }

    private void loadShowWindow() {
        boolean isSameType;
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        long supplierId = ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation) ? saleChannelId : saleOrgId;
        DynamicObject firstPageCfgData = this.findFirstPageCfgData();
        DynamicObjectCollection itemTypeList = this.getItemTypeList(firstPageCfgData);
        IAppCache appCache = AppCache.get((String)"ocdma");
        JSONObject data = (JSONObject)appCache.get("lasttopitem_01" + orderChannelId, JSONObject.class);
        String type = CollectionUtils.isEmpty((Collection)itemTypeList) ? "A" : "B";
        boolean bl = isSameType = data != null && data.getString("type").equalsIgnoreCase(type);
        if (data == null || !isSameType) {
            data = new JSONObject();
            if ("A".equalsIgnoreCase(type)) {
                List itemList = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMostAmountOrderGoods", (Object[])new Object[]{orderChannelId});
                data.put("type", (Object)"A");
                data.put("data", (Object)SerializationUtils.toJsonString((Object)(itemList != null && itemList.size() > 10 ? itemList.subList(0, 10) : itemList)));
            } else {
                Map marketableGoodsMap = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getShowItemListGroupByType", (Object[])new Object[]{orderChannelId, itemTypeList});
                data.put("type", (Object)"B");
                data.put("data", (Object)SerializationUtils.toJsonString(marketableGoodsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SerializationUtils.toJsonString(entry.getValue())))));
            }
            appCache.put("lasttopitem_01" + orderChannelId, (Object)data);
        }
        if ("A".equalsIgnoreCase(type)) {
            this.showWindow(SerializationUtils.fromJsonStringToList((String)data.get((Object)"data").toString(), JSONObject.class), ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u4e2a\u6708\u8ba2\u8d27\u91cf\u6700\u591a\u7684\u5546\u54c1", (String)"HomePlugin_0", (String)"occ-ocdma-formplugin", (Object[])new Object[0]), supplierId, this.getSupplyRelationId());
        } else {
            this.updataItemTypeGoodsExhibition(itemTypeList, ((Map)SerializationUtils.fromJsonString((String)data.get((Object)"data").toString(), Map.class)).entrySet().stream().collect(Collectors.toMap(entry -> Long.valueOf((String)entry.getKey()), entry -> SerializationUtils.fromJsonStringToList((String)entry.getValue().toString(), JSONObject.class))), orderChannelId, supplierId, this.getSupplyRelationId());
        }
    }

    private void updataItemTypeGoodsExhibition(DynamicObjectCollection itemTypeList, Map<Long, List<JSONObject>> marketableGoodsMap, long orderChannelId, long supplierId, long supplyRelationId) {
        itemTypeList.sort(Comparator.comparingInt(itemType -> itemType.getInt("typelevel")));
        for (DynamicObject itemType2 : itemTypeList) {
            long itemTypeId = itemType2.getLong("id");
            List<JSONObject> itemList = marketableGoodsMap.get(itemTypeId);
            this.showWindow(itemList, itemType2.getString("itemtype"), supplierId, supplyRelationId);
        }
    }

    private boolean isMiniMallHome() {
        return "ocdma_mallhomeindex".equals(this.getView().getParentView().getEntityId());
    }

    private DynamicObject findFirstPageCfgData() {
        QFilter filters = new QFilter("number", "=", (Object)(this.isMiniMallHome() ? "SY04" : "SY02"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"ocdbd_firstpageconfig", (QFilter[])filters.toArray());
    }

    private DynamicObjectCollection getItemTypeList(DynamicObject portalCfg) {
        DynamicObjectCollection dynamicObjectCollection = portalCfg.getDynamicObjectCollection("usetypeentity");
        dynamicObjectCollection.removeIf(itemType -> !itemType.getBoolean("typeusestatus"));
        return portalCfg.getDynamicObjectCollection("usetypeentity");
    }

    private long getSupplyRelationId() {
        return (Long)this.getF7PKValue("supplyrelationid");
    }

    private long getOrderChannelId() {
        return this.getF7Value("supplyrelationid").getLong("orderchannel.id");
    }

    private long getSaleOrgId() {
        return this.getF7Value("supplyrelationid").getLong("saleorg.id");
    }

    private long getSaleChannelId() {
        return this.getF7Value("supplyrelationid").getLong("salechannel.id");
    }

    private String getSupplyRelation() {
        return this.getF7Value("supplyrelationid").getString("supplyrelation");
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("promotiongoods".equals(e.getName())) {
            long orderChannelId = this.getOrderChannelId();
            long saleOrgId = this.getSaleOrgId();
            long saleChannelId = this.getSaleChannelId();
            List<Long> marketableGoodIds = this.getMarketableGoodsId(orderChannelId, saleOrgId, saleChannelId);
            this.getPromotionGoods(marketableGoodIds);
            this.loadAttentionItemCount(marketableGoodIds);
        } else if ("loadMoreData".equals(e.getName())) {
            this.loadMoreData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "saledateselect": {
                this.loadChannelSaleVolume();
                break;
            }
        }
        super.propertyChanged(e);
    }

    private long getChannelId() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String cacheChannelId = parentPageCache.get("channelId");
        long channelId = cacheChannelId != null ? Long.parseLong(cacheChannelId) : B2BUserHelper.getLoginChannelId();
        return channelId;
    }

    private void loadMoreData() {
        this.loadShowWindow();
        this.loadRebateAmount(this.getOrderChannelId());
        this.loadChannelSaleVolume();
        this.loadChannelInv();
    }
}

