/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.home;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocdma.business.item.ItemHelper;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class ShowWindowPlugin
extends OcdmaFormMobPlugin
implements RowClickEventListener {
    public static final String META = "ocdma_showwindow";
    public static final String TITLE = "title";
    public static final String ITEMLIST = "itemList";
    public static final String PARAM_SUPPLYRELATIONID = "supplyRelationId";
    private static final String E_GOODS = "goodsentity";
    private static final String EF_GOODS_ID = "goodsid";
    private static final String EF_GOODS_NUMBER = "goodsnumber";
    private static final String EF_GOODS_NAME = "goodsname";
    private static final String EF_GOODS_THUMBNAIL = "goodsthumbnail";
    private static final String EF_SALECUSTOMERID = "salecustomerid";
    private static final String EF_SALEORGID = "saleorgid";
    private static final String EF_SALECUSTOMERNAME = "salecustomername";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry goodsEntity = (CardEntry)this.getControl(E_GOODS);
        goodsEntity.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObject good = this.getModel().getEntryRowEntity(E_GOODS, row);
        long goodId = good.getLong(EF_GOODS_ID);
        long saleChannelId = good.getLong(EF_SALECUSTOMERID);
        long saleOrgId = good.getLong(EF_SALEORGID);
        long supplyRelationId = this.getSupplyRelationId();
        MobileFormShowParameter mobileFormShowParameter = ItemHelper.openGoodsDetail((int)row, (long)goodId, (long)0L, (long)supplyRelationId);
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void afterCreateNewData(EventObject e) {
        this.setData();
    }

    private void setData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null) {
            String title = (String)formShowParameter.getCustomParam(TITLE);
            this.setTitle(title);
            List itemList = (List)formShowParameter.getCustomParam(ITEMLIST);
            this.setShowWindow(itemList);
        }
    }

    private void setShowWindow(List<JSONObject> itemList) {
        if (!CollectionUtils.isEmpty(itemList)) {
            int count = itemList.size();
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(E_GOODS, count);
            for (int i = 0; i < count; ++i) {
                this.getModel().setValue(EF_GOODS_ID, (Object)itemList.get(i).getLong("id"), i);
                this.getModel().setValue(EF_GOODS_NAME, itemList.get(i).get((Object)"name"), i);
                this.getModel().setValue(EF_GOODS_NUMBER, itemList.get(i).get((Object)"number"), i);
                this.getModel().setValue(EF_GOODS_THUMBNAIL, itemList.get(i).get((Object)"thumbnail"), i);
                this.getModel().setValue(EF_SALECUSTOMERNAME, (Object)itemList.get(i).getString("saleCustomerName"), i);
                this.getModel().setValue(EF_SALECUSTOMERID, (Object)itemList.get(i).getString("saleCustomerId"), i);
                this.getModel().setValue(EF_SALEORGID, (Object)itemList.get(i).getString(EF_SALEORGID), i);
            }
            this.getModel().endInit();
            this.getView().updateView("showwindflex");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
    }

    private void setTitle(String title) {
        Label label = (Label)this.getView().getControl(TITLE);
        label.setText(title);
    }

    private long getSupplyRelationId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam(PARAM_SUPPLYRELATIONID);
    }
}

