/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.mall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.container.MessageCarouselContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.ItemBusinessHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.OrderQuantityUtil;
import kd.occ.ocbase.common.util.PictureUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocdma.business.item.ItemHelper;
import kd.occ.ocdma.business.promotion.PromotionHelper;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class MallGoodsDetailPlugin
extends OcdmaFormMobPlugin {
    private static final String CART = "cart";
    private static final String ADD_CART = "addcart";
    private static final String PROMOTION_POLICY = "promotion_policy";
    private static final String PROMOTION_MORE_BTN = "promotion_more";
    private static final String PROMOTION_LESS_BTN = "promotion_less";
    private static final String PROMOTION_ENTITY = "promotion_entity";
    private static final String PROMOTION_POLICY_KEY = "promotion_policy";
    private static final int LABEL_NUMBER = 8;
    private static final int amtPrecision = 2;
    private static final String OCDMA_SELECT_AUXPTY = "ocdma_select_auxpty";
    private static final String ATTENTION_NO = "attention_no";
    private static final String ATTENTION_YES = "attention_yes";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CART, ADD_CART, PROMOTION_MORE_BTN, PROMOTION_LESS_BTN, ATTENTION_NO, ATTENTION_YES});
    }

    public void afterCreateNewData(EventObject e) {
        QFilter filter;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int parentIndex = (Integer)customParams.get("parent_index");
        long itemId = Long.parseLong((String)customParams.get("itemId"));
        long auxptyId = Long.parseLong((String)customParams.get("auxptyId"));
        long supplyRelationId = Long.parseLong((String)customParams.get("supplyRelationId"));
        this.setValue("parent_index", parentIndex);
        this.setValue("itemid", itemId);
        this.setValue("auxptyid", auxptyId);
        this.setValue("supplyrelationid", supplyRelationId);
        long orderChannelId = this.getOrderChannelId();
        DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel");
        long priceChannelId = orderChannel != null ? orderChannel.getLong("pricechannel_id") : 0L;
        long currencyId = orderChannel != null ? orderChannel.getLong("currency_id") : 0L;
        this.getModel().setValue("currencyid", (Object)currencyId);
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        DynamicObject dataObject = this.getModel().getDataEntity();
        if (ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation)) {
            DynamicObject channelInfo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"ChannelService", (String)"getCustomerInfoById", (Object[])new Object[]{saleChannelId});
            String channelName = channelInfo.getString("name");
            dataObject.set("supplier", (Object)channelName);
        } else {
            filter = new QFilter("id", "=", (Object)saleOrgId);
            DynamicObject settleOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])filter.toArray());
            String orgName = settleOrg.getString("name");
            dataObject.set("supplier", (Object)orgName);
        }
        this.promotion(orderChannelId, saleOrgId, saleChannelId, supplyRelation, Collections.singletonList(String.valueOf(itemId)));
        filter = new QFilter("id", "in", (Object)itemId);
        DynamicObjectCollection items = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoods", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
        if (CollectionUtil.isNotNull((List)items)) {
            DynamicObject material;
            DynamicObject taxrate;
            DynamicObject itemInfo = (DynamicObject)items.get(0);
            this.getModel().setValue("itemid", (Object)itemId);
            this.getModel().setValue("materiel", (Object)itemInfo.getLong("material"));
            long unitId = itemInfo.getLong("orderunit.id");
            dataObject.set("unit", (Object)unitId);
            long auxUnitId = itemInfo.getLong("assistunit.id");
            dataObject.set("auxunit", (Object)auxUnitId);
            dataObject.set("unit_name", (Object)itemInfo.getString("orderunit.name"));
            dataObject.set("qty", (Object)BigDecimal.ONE);
            dataObject.set("barcodenumber", (Object)itemInfo.getString("barcodenumber"));
            dataObject.set("modelnum", (Object)itemInfo.getString("modelnum"));
            long materialId = itemInfo.getLong("material");
            BigDecimal taxRate = BigDecimal.ZERO;
            if (materialId != 0L && (taxrate = (material = BusinessDataServiceHelper.loadSingle((Object)materialId, (String)"bd_material")).getDynamicObject("taxrate")) != null) {
                taxRate = taxrate.getBigDecimal("taxrate");
            }
            PriceFetchParam params = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)priceChannelId, (long)itemId, (long)0L, (long)unitId, (long)currencyId, (BigDecimal)BigDecimal.ONE);
            params.setOwnerId(saleChannelId);
            HashMap priceMap = OrderHelper.getPriceMap((PriceFetchParam)params, null, (BigDecimal)BigDecimal.ONE, (BigDecimal)taxRate);
            BigDecimal price = (BigDecimal)priceMap.get("actualtaxprice");
            if (price == null || BigDecimal.ZERO.compareTo(price) == 0) {
                dataObject.set("iszeroprice", (Object)true);
            }
            dataObject.set("pricefield", (Object)BigDecimalUtil.setScale((BigDecimal)price, (int)2));
            filter = new QFilter("id", "=", (Object)itemId);
            DynamicObject item = BusinessDataServiceHelper.loadSingle((String)"ocdbd_iteminfo", (String)String.join((CharSequence)",", "id", "description", "description_tag"), (QFilter[])filter.toArray());
            Html html = (Html)this.getView().getControl("description_tag");
            html.setConent(item.getString("description_tag"));
            MessageCarouselContainer imgGroup = (MessageCarouselContainer)this.getControl("imggroup");
            ArrayList imgGroupList = new ArrayList(6);
            ArrayList<String> urls = new ArrayList<String>(6);
            if (StringUtils.isNotNull((String)itemInfo.getString("thumbnail"))) {
                urls.add(itemInfo.getString("thumbnail"));
            }
            if (StringUtils.isNotNull((String)itemInfo.getString("picture1"))) {
                urls.add(PictureUtil.getServerPictureUrl((String)itemInfo.getString("picture1")));
            }
            if (StringUtils.isNotNull((String)itemInfo.getString("picture2"))) {
                urls.add(PictureUtil.getServerPictureUrl((String)itemInfo.getString("picture2")));
            }
            if (StringUtils.isNotNull((String)itemInfo.getString("picture3"))) {
                urls.add(PictureUtil.getServerPictureUrl((String)itemInfo.getString("picture3")));
            }
            if (StringUtils.isNotNull((String)itemInfo.getString("picture4"))) {
                urls.add(PictureUtil.getServerPictureUrl((String)itemInfo.getString("picture4")));
            }
            if (StringUtils.isNotNull((String)itemInfo.getString("picture5"))) {
                urls.add(PictureUtil.getServerPictureUrl((String)itemInfo.getString("picture5")));
            }
            if (urls.isEmpty()) {
                urls.add("kingdee/drp/p/staticweb/img/defaultm.jpg");
            }
            for (String url : urls) {
                HashMap controlsMap = new HashMap();
                HashMap<String, String> propsMap = new HashMap<String, String>();
                controlsMap.put("labelap", propsMap);
                propsMap.put("imageKey", url);
                controlsMap.put("imageap", propsMap);
                imgGroupList.add(controlsMap);
            }
            imgGroup.setData(imgGroupList);
            dataObject.set("attentionflag", (Object)(ItemBusinessHelper.checkIfAttentionItemId((long)itemId) ? Checked.YES.toString() : Checked.NO.toString()));
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "cart": {
                this.jumpTo(this.getView());
                break;
            }
            case "addcart": {
                this.add();
                break;
            }
            case "promotion_more": {
                this.createNewEntryRows(true);
                this.getView().setVisible(Boolean.FALSE, new String[]{PROMOTION_MORE_BTN});
                this.getView().setVisible(Boolean.TRUE, new String[]{PROMOTION_LESS_BTN});
                break;
            }
            case "promotion_less": {
                this.createNewEntryRows(false);
                this.getView().setVisible(Boolean.TRUE, new String[]{PROMOTION_MORE_BTN});
                this.getView().setVisible(Boolean.FALSE, new String[]{PROMOTION_LESS_BTN});
                break;
            }
            case "attention_no": {
                this.setAttention(true);
                break;
            }
            case "attention_yes": {
                this.setAttention(false);
                break;
            }
        }
    }

    private void setAttention(boolean flag) {
        this.getModel().setValue("attentionflag", (Object)(flag ? Checked.YES.toString() : Checked.NO.toString()));
        DynamicObject item = (DynamicObject)this.getModel().getValue("itemid");
        if (item == null) {
            return;
        }
        if (flag) {
            ItemBusinessHelper.saveItemAttention((long)item.getLong("id"), (String)"ocdbd_item_attention", (String)"itemid");
        } else {
            ItemBusinessHelper.deleteItemAttention((long)item.getLong("id"), (String)"ocdbd_item_attention", (String)"itemid");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        switch (key) {
            case "ocdma_select_auxpty": {
                if (closedCallBackEvent.getReturnData() == null) break;
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                long itemId = (Long)returnData.get("item");
                long auxpty = (Long)returnData.get("auxpty");
                BigDecimal qty = (BigDecimal)returnData.get("qty");
                BigDecimal auxQty = (BigDecimal)returnData.get("auxqty");
                DynamicObject dataEntity = this.getModel().getDataEntity();
                ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ocepfp_cart");
                dynamicObject.set("item", (Object)itemId);
                dynamicObject.set("qty", (Object)qty);
                dynamicObject.set("auxqty", (Object)auxQty);
                dynamicObject.set("unit", this.getValue("unit"));
                dynamicObject.set("auxunit", this.getValue("auxunit"));
                dynamicObject.set("auxpty", (Object)auxpty);
                dynamicObjectList.add(dynamicObject);
                DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"saveCartByQuickOrder", (Object[])new Object[]{orderChannelId, saleOrgId, saleChannelId, supplyRelation, dynamicObjectList});
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u529f\u52a0\u5165\u8d2d\u7269\u8f66\u3002", (String)"MallGoodsDetailPlugin_0", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
                this.setParentView();
                break;
            }
        }
    }

    private void setParentView() {
        IFormView parentView = this.getView().getParentView();
        if ("ocdma_mall".equals(parentView.getEntityId())) {
            long itemId = this.getItemId();
            Map<String, BigDecimal> shippingCartMap = this.getShoppingCartQty(itemId);
            BigDecimal shoppingCartQty = shippingCartMap.get("qty");
            BigDecimal shoppingCartAuxQty = shippingCartMap.get("auxqty");
            parentView.getModel().setValue("auxqty", (Object)shoppingCartAuxQty, this.getParentIndex());
            parentView.getModel().setValue("qty", (Object)shoppingCartQty, this.getParentIndex());
            this.getView().sendFormAction(parentView);
        }
        this.setCartBadgeInfo();
    }

    private void add() {
        boolean isOpenSelectAuxpty;
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        boolean isUseAuxpty = this.isUseAuxpty();
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        boolean bl = isOpenSelectAuxpty = isUseAuxpty && "A".equals(multiUnitOrder) || !"A".equals(multiUnitOrder);
        if (isOpenSelectAuxpty) {
            MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)-1, (boolean)true, (long)this.getItemId(), (long)0L, (long)this.getSupplyRelationId(), (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
            mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            return;
        }
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantityRule();
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        orderMinQty = orderMinQty.compareTo(BigDecimal.ZERO) == 0 ? orderQty : orderMinQty;
        BigDecimal qty = BigDecimal.ZERO;
        DynamicObject cartData = this.getCartData();
        qty = cartData == null || cartData.getBigDecimal("qty").compareTo(BigDecimal.ZERO) <= 0 ? orderMinQty : orderQty;
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ocepfp_cart");
        dynamicObject.set("item", (Object)this.getItemId());
        dynamicObject.set("qty", (Object)qty);
        dynamicObject.set("unit", this.getValue("unit"));
        dynamicObject.set("auxpty", (Object)0L);
        dynamicObjectList.add(dynamicObject);
        DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"saveCartByQuickOrder", (Object[])new Object[]{orderChannelId, saleOrgId, saleChannelId, supplyRelation, dynamicObjectList});
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u529f\u52a0\u5165\u8d2d\u7269\u8f66\u3002", (String)"MallGoodsDetailPlugin_0", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
        this.setParentView();
    }

    private void promotion(long orderChannelId, long saleOrgId, long saleChannelId, String supplyRelation, List<String> marketableGoodIds) {
        Map promotionPolicyMap = PromotionHelper.getPromotionPolicy((long)orderChannelId, (long)saleOrgId, (long)saleChannelId, (String)supplyRelation, marketableGoodIds);
        List promotionPolicyArray = (List)promotionPolicyMap.get(Long.parseLong(marketableGoodIds.get(0)));
        this.getPageCache().put("promotion_policy", JSON.toJSONString((Object)promotionPolicyArray));
        if (CollectionUtil.isNull((List)promotionPolicyArray)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"promotion_policy"});
            return;
        }
        if (promotionPolicyArray.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PROMOTION_MORE_BTN});
        }
        this.createNewEntryRows(false);
    }

    private void createNewEntryRows(boolean isAllRows) {
        int[] indexes;
        IDataModel model = this.getModel();
        model.deleteEntryData(PROMOTION_ENTITY);
        JSONArray promotionPolicyArray = JSON.parseArray((String)this.getPageCache().get("promotion_policy"));
        if (CollectionUtil.isNull((List)promotionPolicyArray)) {
            return;
        }
        int rowNumber = isAllRows ? promotionPolicyArray.size() : 1;
        CardEntry promotionEntity = (CardEntry)this.getView().getControl(PROMOTION_ENTITY);
        for (int index : indexes = this.getModel().batchCreateNewEntryRow(PROMOTION_ENTITY, rowNumber)) {
            JSONObject promotionPolicy = (JSONObject)promotionPolicyArray.get(index);
            DynamicObject dataObject = this.getRowInfo(PROMOTION_ENTITY, index);
            String effectiveDate = promotionPolicy.getString("effectiveDate");
            Timestamp effectiveDateTimestamp = new Timestamp(Long.parseLong(effectiveDate));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String effectiveDateFormat = simpleDateFormat.format(effectiveDateTimestamp);
            String expirationDate = promotionPolicy.getString("expirationDate");
            Timestamp expirationDateTimestamp = new Timestamp(Long.parseLong(expirationDate));
            String expirationDateFormat = simpleDateFormat.format(expirationDateTimestamp);
            dataObject.set("date", (Object)(effectiveDateFormat + " \u81f3 " + expirationDateFormat));
            dataObject.set("content", (Object)promotionPolicy.getString("describe"));
            JSONArray labelArray = promotionPolicy.getJSONArray("lable");
            if (CollectionUtil.isNotNull((List)labelArray)) {
                int i;
                List labelList = labelArray.stream().distinct().filter(k -> StringUtils.isNotEmpty((String)((String)k))).sorted().collect(Collectors.toList());
                for (i = 0; i < labelList.size() && i < 8; ++i) {
                    this.getModel().setValue("label" + i, labelList.get(i), index);
                }
                for (i = labelList.size(); i < 8; ++i) {
                    promotionEntity.setChildVisible(false, index, new String[]{"label" + i});
                }
                continue;
            }
            promotionEntity.setChildVisible(false, index, new String[]{"labelpanel"});
        }
        this.getView().updateView(PROMOTION_ENTITY);
    }

    private Map<String, BigDecimal> getOrderQuantityRule() {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        long auxptyId = this.getAuxptyId();
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        long unitId = dynamicObject.getLong("unit");
        return OrderQuantityUtil.getOrderQuantityRlue((long)saleOrgId, (long)orderChannelId, (long)this.getItemId(), (long)unitId, (long)auxptyId, (IPageCache)this.getPageCache());
    }

    private DynamicObject getCartData() {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        return (DynamicObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{this.getItemId(), 0L, orderChannelId, saleOrgId, saleChannelId, supplyRelation});
    }

    private boolean isUseAuxpty() {
        DynamicObject material = this.getModel().getDataEntity().getDynamicObject("materiel");
        return material != null && material.getBoolean("isuseauxpty");
    }

    private long getItemId() {
        return (Long)this.getF7PKValue("itemid");
    }

    private long getMaterialId() {
        return (Long)this.getF7PKValue("materiel");
    }

    private int getParentIndex() {
        return (Integer)this.getModel().getValue("parent_index");
    }

    private long getSupplyRelationId() {
        return (Long)this.getF7PKValue("supplyrelationid");
    }

    private long getOrderChannelId() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getLong("orderchannel.id");
    }

    private long getSaleOrgId() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getLong("saleorg.id");
    }

    private long getSaleChannelId() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getLong("salechannel.id");
    }

    private String getSupplyRelation() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getString("supplyrelation");
    }

    private long getAuxptyId() {
        Object pkValue = this.getF7PKValue("auxptyid");
        if (pkValue == null) {
            return 0L;
        }
        return (Long)pkValue;
    }

    private Map<String, Map<String, BigDecimal>> getShoppingCartQty(List<Long> marketableGoodsIds) {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        List marketableGoodsIdList = marketableGoodsIds.stream().map(String::valueOf).collect(Collectors.toList());
        DynamicObjectCollection shoppingCartInfo = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{marketableGoodsIdList, orderChannelId, saleOrgId, saleChannelId, supplyRelation});
        HashMap<String, Map<String, BigDecimal>> shipingCartMap = new HashMap<String, Map<String, BigDecimal>>(0);
        shipingCartMap.put("qty", shoppingCartInfo.stream().collect(Collectors.toMap(k -> k.getString("item"), k -> k.getBigDecimal("qty"), BigDecimal::add)));
        shipingCartMap.put("auxqty", shoppingCartInfo.stream().collect(Collectors.toMap(k -> k.getString("item"), k -> k.getBigDecimal("auxqty"), BigDecimal::add)));
        return shipingCartMap;
    }

    private Map<String, BigDecimal> getShoppingCartQty(long marketableGoodsId) {
        Map<String, Map<String, BigDecimal>> shoppingCartMap = this.getShoppingCartQty(Collections.singletonList(marketableGoodsId));
        Map<String, BigDecimal> shoppingCartQty = shoppingCartMap.get("qty");
        Map<String, BigDecimal> shoppingCartAuxQty = shoppingCartMap.get("auxqty");
        BigDecimal qty = shoppingCartQty.get(String.valueOf(marketableGoodsId));
        BigDecimal auxQty = shoppingCartAuxQty.get(String.valueOf(marketableGoodsId));
        HashMap<String, BigDecimal> cartMap = new HashMap<String, BigDecimal>(0);
        cartMap.put("qty", qty == null ? BigDecimal.ZERO : qty);
        cartMap.put("auxqty", auxQty == null ? BigDecimal.ZERO : auxQty);
        return cartMap;
    }

    private void jumpTo(IFormView view) {
        if (view == null || view.getEntityId() == null || !view.getEntityId().startsWith("oc")) {
            return;
        }
        switch (view.getEntityId()) {
            case "ocdma_homeindex": 
            case "ocdma_mallhomeindex": {
                view.invokeOperation(CART);
                this.getView().sendFormAction(view);
                return;
            }
            case "ocsaa_customerorder_add": {
                view.invokeOperation(CART);
                this.getView().sendFormAction(view);
                return;
            }
        }
        view.invokeOperation("close");
        this.getView().sendFormAction(view);
        this.jumpTo(view.getParentView());
    }
}

