/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.mall;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.b2b.ItemBusinessHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.business.helper.BillViewHelper;
import kd.occ.ocbase.common.constants.PC;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.constants.PriceFetchResult;
import kd.occ.ocbase.common.entity.OrderQuantityResult;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.pojo.PromotionItemVo;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OrderQuantityUtil;
import kd.occ.ocbase.common.util.PriceServiceUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocdma.business.item.ItemHelper;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class MallPlugin
extends OcdmaFormMobPlugin
implements TabSelectListener,
MobileSearchTextChangeListener,
EntryGridBindDataListener {
    public static final String PRICE_CLICK_COUNT = "priceclickcount";
    private static final String ITEMCLASS_TAB = "tabap";
    private static final String FIRST_TAB_PAGE_ID = "all";
    private static final String ITEM_LIST = "itemlist";
    private static final String SEARCH = "search";
    private static final String SALEVOLUME_BTN = "salevolumebtn";
    private static final String PRICE_BTN = "pricebtn";
    private static final String ADD = "add";
    private static final String REDUCE = "reduce";
    private static final String AMOUNT = "amount";
    private static final String UNIT_NAME = "unitname";
    private static final BigDecimal QTY_MAX = BigDecimal.valueOf(10000000L);
    private static final String PROMOTION_DETAIL_LABEL = "promotion_detail_label";
    private static final String PROMOTION_LABEL = "promotion_label";
    private static final int LABEL_NUMBER = 6;
    private static final String PROMOTION_ITEM_IDS = "promotionItemIds";
    private static final String PRICE_SORT_ITEM_IDS = "priceSortItemIds";
    private static final String ITEM_HASPRICE_IDS = "itemHasPriceIds";
    private static final String ITEMTABLE_ITEM_PRICES = "itemTableItemPrices";
    private static boolean IS_LOGIN = false;
    private static final String OCDMA_SELECT_AUXPTY = "ocdma_select_auxpty";
    private static final String THUMBNAIL_TAB = "thumbnail_tab";
    private static final String ISZEROPRICE = "iszeroprice";
    private static final String ATTENTION_NO = "attention_no";
    private static final String ATTENTION_YES = "attention_yes";
    private static final int ROWCOUNT = 999;
    protected static Log logger = LogFactory.getLog(MallPlugin.class);

    public void initialize() {
        super.initialize();
        BillViewHelper.setisVirtualLoad((IFormView)this.getView(), (String)ITEM_LIST);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD, REDUCE, PRICE_BTN, SALEVOLUME_BTN, PROMOTION_DETAIL_LABEL, THUMBNAIL_TAB, "attentionpanel", "commonusepanel", ATTENTION_NO, ATTENTION_YES});
        Tab tab = (Tab)this.getControl(ITEMCLASS_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void afterBindData(EventObject e) {
        this.getView().executeClientCommand("loadThirdPartyJS", new Object[]{"./kingdee/drp/ocdma/qtyfocus.js"});
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long supplyRelationId = this.getLoginSupplyRelationId();
        if (supplyRelationId == 0L) {
            IS_LOGIN = false;
            return;
        }
        IS_LOGIN = true;
        this.initGlobalInfo(supplyRelationId);
        this.initItemClass();
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        if ("true".equals(parentPageCache.get("isFromHomePromotion"))) {
            parentPageCache.remove("isFromHomePromotion");
            this.getPromotionItemIds();
        }
        if ("true".equals(parentPageCache.get("isFromHomeAttention"))) {
            parentPageCache.remove("isFromHomeAttention");
            this.getView().getPageCache().put("filterkey", "attention");
        }
        this.initItemsPrice();
        this.getEntryDataEntities(1);
    }

    private void initItemsPrice() {
        if (this.isItemPricePermitZero()) {
            long orderChannelId = this.getOrderChannelId();
            long saleOrgId = this.getSaleOrgId();
            long saleChannelId = this.getSaleChannelId();
            QFilter filter = this.getItemFilter(saleOrgId, saleChannelId, orderChannelId);
            DynamicObjectCollection marketableGoodsCollection = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoods", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
            List<Long> marketableGoodsIds = marketableGoodsCollection.stream().map(k -> k.getLong("id")).collect(Collectors.toList());
            Map<String, Map<String, BigDecimal>> shoppingCartMap = this.getShoppingCartQty(marketableGoodsIds);
            Map<String, BigDecimal> shoppingCartQty = shoppingCartMap.get("qty");
            Map<Long, BigDecimal> priceMap = this.getPriceV2(marketableGoodsCollection, shoppingCartQty);
            List mtgpIds = marketableGoodsIds.stream().filter(p -> priceMap.containsKey(p) && ((BigDecimal)priceMap.get(p)).compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put(ITEMTABLE_ITEM_PRICES, SerializationUtils.toJsonString(priceMap));
            pageCache.put(ITEM_HASPRICE_IDS, SerializationUtils.toJsonString(mtgpIds));
        }
    }

    private boolean isItemPricePermitZero() {
        return SysParamsUtil.isItemPricePermitZero();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String key;
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "all": 
            case "attention": 
            case "commonuse": {
                this.getView().getPageCache().put("filterkey", key);
                this.refreshItemList();
                break;
            }
        }
        super.beforeDoOperation(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex(ITEM_LIST);
        switch (key) {
            case "add": {
                this.add(index);
                break;
            }
            case "reduce": {
                this.reduce(index);
                break;
            }
            case "pricebtn": {
                int priceClickCount = (Integer)this.getModel().getValue(PRICE_CLICK_COUNT);
                priceClickCount = (priceClickCount + 1) % 3;
                this.setValue(PRICE_CLICK_COUNT, priceClickCount);
                this.sortAllGoodsByPrice();
                this.refreshItemList();
                break;
            }
            case "promotion_detail_label": {
                MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
                mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileBillShowParameter.setFormId("ocdma_promotion");
                mobileBillShowParameter.setCustomParam("itemId", (Object)String.valueOf(this.getItemId(index)));
                mobileBillShowParameter.setCustomParam("unitId", (Object)String.valueOf(this.getUnitId(index)));
                mobileBillShowParameter.setCustomParam("orderChannelId", (Object)String.valueOf(this.getOrderChannelId()));
                mobileBillShowParameter.setCustomParam("saleOrgId", (Object)String.valueOf(this.getSaleOrgId()));
                mobileBillShowParameter.setCustomParam("saleChannelId", (Object)String.valueOf(this.getSaleChannelId()));
                mobileBillShowParameter.setCustomParam("supplyRelation", (Object)this.getSupplyRelation());
                this.getView().showForm((FormShowParameter)mobileBillShowParameter);
                break;
            }
            case "thumbnail_tab": {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ITEM_LIST).get(index);
                if (dynamicObject == null) break;
                MobileFormShowParameter mobileBillShowParameter = ItemHelper.openGoodsDetail((int)index, (long)this.getItemId(index), (long)0L, (long)this.getSupplyRelationId());
                mobileBillShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocdma_goods_detail"));
                this.getView().showForm((FormShowParameter)mobileBillShowParameter);
                break;
            }
            case "attentionpanel": {
                this.setAttention(index);
                break;
            }
            case "commonusepanel": {
                this.setCommonuse(index);
                break;
            }
        }
    }

    private void setAttention(int index) {
        boolean flag = (Boolean)this.getModel().getValue("isattention", index);
        this.getModel().setValue("isattention", (Object)(!flag ? 1 : 0), index);
        DynamicObject item = (DynamicObject)this.getModel().getValue("item", index);
        if (item == null) {
            return;
        }
        if (!flag) {
            ItemBusinessHelper.saveItemAttention((long)item.getLong("id"), (String)"ocdbd_item_attention", (String)"itemid");
        } else {
            ItemBusinessHelper.deleteItemAttention((long)item.getLong("id"), (String)"ocdbd_item_attention", (String)"itemid");
        }
    }

    private void setCommonuse(int index) {
        boolean flag = (Boolean)this.getModel().getValue("iscommonuse", index);
        this.getModel().setValue("iscommonuse", (Object)(!flag ? 1 : 0), index);
        DynamicObject item = (DynamicObject)this.getModel().getValue("item", index);
        if (item == null) {
            return;
        }
        if (!flag) {
            ItemBusinessHelper.saveItemAttention((long)item.getLong("id"), (String)"ocdbd_item_commonuse", (String)"itemid");
        } else {
            ItemBusinessHelper.deleteItemAttention((long)item.getLong("id"), (String)"ocdbd_item_commonuse", (String)"itemid");
        }
    }

    private void changeButton() {
        int priceClickCount = (Integer)this.getModel().getValue(PRICE_CLICK_COUNT);
        Control priceUp = this.getView().getControl("priceup");
        Control priceDown = this.getView().getControl("pricedown");
        Control priceBtn = this.getView().getControl(PRICE_BTN);
        MobileControlUtils.ControlSetFontWeight((Control)priceBtn, (boolean)true);
        if (priceClickCount == 1) {
            MobileControlUtils.ControlSetFrontAndBackColor((Control)priceUp, (String)"#000000", null);
            MobileControlUtils.ControlSetFrontAndBackColor((Control)priceDown, (String)"#e5e5e5", null);
        } else if (priceClickCount == 2) {
            MobileControlUtils.ControlSetFrontAndBackColor((Control)priceUp, (String)"#e5e5e5", null);
            MobileControlUtils.ControlSetFrontAndBackColor((Control)priceDown, (String)"#000000", null);
        } else {
            MobileControlUtils.ControlSetFrontAndBackColor((Control)priceUp, (String)"#e5e5e5", null);
            MobileControlUtils.ControlSetFrontAndBackColor((Control)priceDown, (String)"#e5e5e5", null);
        }
    }

    private void sortAllGoodsByPrice() {
        List<Object> sortedMarketableGoodsIds;
        IPageCache pageCache = this.getView().getPageCache();
        int priceClickCount = (Integer)this.getModel().getValue(PRICE_CLICK_COUNT);
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        QFilter filter = this.getItemFilter(saleOrgId, saleChannelId, orderChannelId);
        DynamicObjectCollection marketableGoodsCollection = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoods", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
        if (marketableGoodsCollection == null || marketableGoodsCollection.size() == 0) {
            pageCache.put(PRICE_SORT_ITEM_IDS, SerializationUtils.toJsonString(new ArrayList(0)));
            return;
        }
        if (pageCache.get(PRICE_SORT_ITEM_IDS) != null) {
            sortedMarketableGoodsIds = this.getItemIdsFromCache();
            switch (priceClickCount) {
                case 0: {
                    return;
                }
                case 1: 
                case 2: {
                    Collections.reverse(sortedMarketableGoodsIds);
                    break;
                }
            }
        } else {
            List<Long> marketableGoodsIds = marketableGoodsCollection.stream().map(k -> k.getLong("id")).collect(Collectors.toList());
            Map<String, Map<String, BigDecimal>> shoppingCartMap1 = this.getShoppingCartQty(marketableGoodsIds);
            Map<String, BigDecimal> shoppingCartQty = shoppingCartMap1.get("qty");
            Map<Long, BigDecimal> priceMap = this.getPriceV2(marketableGoodsCollection, shoppingCartQty);
            sortedMarketableGoodsIds = priceClickCount == 1 ? marketableGoodsIds.stream().sorted(Comparator.comparing(priceMap::get)).collect(Collectors.toList()) : (priceClickCount == 2 ? marketableGoodsIds.stream().sorted(Comparator.comparing(priceMap::get).reversed()).collect(Collectors.toList()) : marketableGoodsIds);
        }
        pageCache.put(PRICE_SORT_ITEM_IDS, SerializationUtils.toJsonString(sortedMarketableGoodsIds));
    }

    private void add(int index) {
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        boolean isUseAuxpty = this.isUseAuxpty(index);
        boolean isOpenSelectAuxpty = isUseAuxpty && StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A") || !StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A");
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
        BigDecimal auxQty = (BigDecimal)this.getModel().getValue("auxqty", index);
        if (isOpenSelectAuxpty) {
            MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)true, (long)this.getItemId(index), (long)0L, (long)this.getSupplyRelationId(), (BigDecimal)qty, (BigDecimal)auxQty);
            mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            return;
        }
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        orderMinQty = orderMinQty.compareTo(BigDecimal.ZERO) == 0 ? orderQty : orderMinQty;
        BigDecimal shoppingCartQty = this.getShoppingCartQty(index);
        if (shoppingCartQty.compareTo(BigDecimal.ZERO) <= 0) {
            this.getModel().setValue("qty", (Object)orderMinQty, index);
        } else {
            this.getModel().setValue("qty", (Object)qty.add(orderQty), index);
        }
    }

    private void reduce(int index) {
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        boolean isUseAuxpty = this.isUseAuxpty(index);
        boolean isOpenSelectAuxpty = isUseAuxpty && StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A") || !StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A");
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
        BigDecimal auxQty = (BigDecimal)this.getModel().getValue("auxqty", index);
        if (isOpenSelectAuxpty) {
            MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)true, (long)this.getItemId(index), (long)0L, (long)this.getSupplyRelationId(), (BigDecimal)qty, (BigDecimal)auxQty);
            mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            return;
        }
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal newQty = qty.subtract(orderQty);
        if (newQty.compareTo(orderMinQty) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue("qty", (Object)newQty, index);
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        Tab tabAp = (Tab)this.getControl(ITEMCLASS_TAB);
        String tabKey = tabAp.getCurrentTab();
        if (tabKey != null && !FIRST_TAB_PAGE_ID.equals(tabKey)) {
            tabAp.activeTab(FIRST_TAB_PAGE_ID);
        } else {
            this.refreshItemList();
        }
        this.resetButton();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.refreshItemList();
        this.resetButton();
    }

    private void refreshItemList() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ITEM_LIST);
        cardEntry.setCardScrollBarToTop();
        this.getModel().deleteEntryData(ITEM_LIST);
        this.getModel().setDataChanged(false);
        cardEntry.setPageIndex(1);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        if (!IS_LOGIN) {
            return;
        }
        super.entryGridBindData(e);
        CardEntry itemList = (CardEntry)this.getView().getControl(ITEM_LIST);
        Map entryGridData = e.getData();
        int pageIndex = (Integer)entryGridData.get("pageindex");
        int pageRows = (Integer)entryGridData.get("pagerows");
        int itemCount = 999;
        int rowCount = (Integer)entryGridData.get("rowcount");
        if (rowCount == 0 && itemCount != 0) {
            e.getData().put("pageindex", 1);
            this.getEntryDataEntities(1);
        } else if (pageIndex != 1) {
            this.getEntryDataEntities(pageIndex + 1);
        }
        int pageCount = itemCount / pageRows + (itemCount % pageRows > 0 ? 1 : 0);
        List rows = e.getRows();
        for (RowDataEntity row : rows) {
            this.setNumFmtInfo(row);
        }
        e.getData().put("rowcount", itemCount);
        e.getData().put("datacount", itemCount);
        e.getData().put("pagecount", pageCount);
        for (RowDataEntity row : e.getRows()) {
            int index = row.getRowIndex();
            DynamicObject dataEntity = row.getDataEntity();
            boolean isAllEmpty = true;
            for (int i = 0; i < 6; ++i) {
                if (StringUtils.isEmpty((CharSequence)dataEntity.getString("label" + i))) {
                    itemList.setChildVisible(false, index, new String[]{"label" + i});
                    continue;
                }
                isAllEmpty = false;
            }
            if (!isAllEmpty) continue;
            itemList.setChildVisible(false, index, new String[]{PROMOTION_LABEL});
            itemList.setChildVisible(false, index, new String[]{"labelpanel"});
        }
    }

    private void setNumFmtInfo(RowDataEntity rowObj) {
        CardEntry itemList = (CardEntry)this.getView().getControl(ITEM_LIST);
        EntryProp entryProp = (EntryProp)this.getModel().getProperty(itemList.getEntryKey());
        HashSet<String> ctlNumber = new HashSet<String>();
        for (IDataEntityProperty entryproperty : entryProp.getItemType().getProperties()) {
            String key;
            DynamicObject o;
            if (!(entryproperty instanceof CurrencyProp) && !(entryproperty instanceof UnitProp) || (o = (DynamicObject)entryproperty.getValueFast((Object)rowObj.getDataEntity())) == null || !ctlNumber.add(key = itemList.getKey() + "." + entryproperty.getClass().getName() + "." + o.get("number"))) continue;
            itemList.setNumFmtInfo(entryproperty, o);
        }
    }

    private void getPromotionItemIds() {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        QFilter filter = this.getItemFilter(saleOrgId, saleChannelId, orderChannelId);
        List marketableGoodsIds = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoodsId", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
        Map<String, List<PromotionItemVo>> promotionPolicyMap = this.getPromotionPolicy(marketableGoodsIds);
        if (promotionPolicyMap == null) {
            return;
        }
        HashSet<Long> promotionItemIds = new HashSet<Long>(promotionPolicyMap.size());
        for (Map.Entry<String, List<PromotionItemVo>> entry : promotionPolicyMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            promotionItemIds.add(Long.valueOf(entry.getKey().split("_")[0]));
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(PROMOTION_ITEM_IDS, SerializationUtils.toJsonString(promotionItemIds));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            this.triggerChangeEvent = true;
            return;
        }
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        switch (key) {
            case "qty": {
                long auxptyId;
                long unitId;
                long itemId;
                boolean isUseAuxpty = this.isUseAuxpty(index);
                if (isUseAuxpty) break;
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
                if (qty.compareTo(QTY_MAX) > 0) {
                    this.getModel().setValue("qty", (Object)QTY_MAX, index);
                    return;
                }
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue("qty", (Object)BigDecimal.ZERO, index);
                    return;
                }
                long orderChannelId = this.getOrderChannelId();
                long saleOrgId = this.getSaleOrgId();
                OrderQuantityResult orderQuantityResult = OrderQuantityUtil.calOrderQuantity((long)saleOrgId, (long)orderChannelId, (long)(itemId = ((Long)this.getModel().getValue("item_id")).longValue()), (long)(unitId = ((Long)this.getModel().getValue("unit_id")).longValue()), (long)(auxptyId = 0L), (BigDecimal)qty, (IPageCache)this.getView().getPageCache());
                if (orderQuantityResult.isQuantity()) {
                    this.triggerChangeEvent = false;
                    qty = orderQuantityResult.getSuggestQty();
                    this.getModel().setValue("qty", (Object)orderQuantityResult.getSuggestQty(), index);
                    this.triggerChangeEvent = true;
                    this.getView().showTipNotification(orderQuantityResult.getErrorMsg());
                }
                BigDecimal auxQty = (BigDecimal)this.getModel().getValue("auxqty", index);
                this.updateCartQty(index, this.getItemId(index), auxptyId, qty, auxQty);
                this.setCartBadgeInfo();
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", index);
                this.setValue(AMOUNT, price.multiply(qty), index);
                break;
            }
            case "priceclickcount": {
                this.changeButton();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "ocdma_select_auxpty": {
                if (closedCallBackEvent.getReturnData() == null) break;
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                int index = (Integer)returnData.get("index");
                long itemId = (Long)returnData.get("item");
                long auxpty = (Long)returnData.get("auxpty");
                BigDecimal qty = (BigDecimal)returnData.get("qty");
                BigDecimal auxQty = (BigDecimal)returnData.get("auxqty");
                this.updateCartQty(index, itemId, auxpty, qty, auxQty);
                Map<String, BigDecimal> shoppingCartMap = this.getShoppingCartQty(itemId);
                BigDecimal shoppingCartQty = shoppingCartMap.get("qty");
                BigDecimal shoppingCartAuxQty = shoppingCartMap.get("auxqty");
                this.setValue("qty", shoppingCartQty, index, false);
                this.setValue("auxqty", shoppingCartAuxQty, index, false);
                this.setCartBadgeInfo();
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", index);
                this.setValue(AMOUNT, price.multiply(qty), index);
                this.triggerChangeEvent = true;
                break;
            }
            case "ocdma_goods_detail": {
                DynamicObjectCollection itemList = this.getModel().getEntryEntity(ITEM_LIST);
                List attentionItemIds = ItemBusinessHelper.queryAttentionItemIds((String)"ocdbd_item_attention", (String)"itemid");
                if (itemList == null || itemList.isEmpty()) break;
                AtomicInteger index = new AtomicInteger();
                for (DynamicObject itemInfo : itemList) {
                    int rowId = index.getAndIncrement();
                    if (attentionItemIds.contains(itemInfo.getLong("item_id"))) {
                        this.getModel().setValue("attentionflag", (Object)Checked.YES.toString(), rowId);
                        continue;
                    }
                    this.getModel().setValue("attentionflag", (Object)Checked.NO.toString(), rowId);
                }
                break;
            }
        }
    }

    private void updateCartQty(int index, long itemId, long auxptyId, BigDecimal qty, BigDecimal auxQty) {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            DynamicObject cartData = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{itemId, auxptyId, orderChannelId, saleOrgId, saleChannelId, supplyRelation});
            if (cartData != null) {
                String cartid = cartData.getString("id");
                DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"deleteCartByIds", (Object[])new Object[]{Collections.singletonList(cartid), null});
            }
        } else {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ocepfp_cart");
            dynamicObject.set("item", (Object)itemId);
            dynamicObject.set("qty", (Object)qty);
            dynamicObject.set("auxqty", (Object)auxQty);
            dynamicObject.set("unit", (Object)this.getUnitId(index));
            dynamicObject.set("auxunit", (Object)this.getAuxUnitId(index));
            dynamicObject.set("auxpty", (Object)auxptyId);
            dynamicObjectList.add(dynamicObject);
            DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"replaceCartQtyByQuickOrder", (Object[])new Object[]{orderChannelId, saleOrgId, saleChannelId, supplyRelation, dynamicObjectList});
        }
    }

    private Object getSupplierFromParent() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        FormShowParameter formShowParameter = parentView.getFormShowParameter();
        if (formShowParameter == null) {
            return null;
        }
        return formShowParameter.getCustomParam("supplierid");
    }

    private DynamicObjectCollection getMarketableGoods(int pageIndex) {
        CardEntry itemList = (CardEntry)this.getView().getControl(ITEM_LIST);
        AbstractGrid.GridState entryState = itemList.getEntryState();
        int pageRows = entryState.getPageRows();
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        QFilter filter = this.getItemFilter(saleOrgId, saleChannelId, orderChannelId);
        if (this.isLoadItemIdFromCache()) {
            List<Long> cachedItemIds = this.getItemIdsFromCache();
            int startIndex = (pageIndex - 1) * pageRows;
            int endIndex = pageIndex * pageRows;
            if (pageIndex == 1) {
                pageRows = 2 * pageRows;
                endIndex = pageIndex * pageRows;
            }
            if (startIndex > cachedItemIds.size()) {
                return null;
            }
            endIndex = Math.min(endIndex, cachedItemIds.size());
            ArrayList<Long> currentPageItemIds = new ArrayList<Long>(pageRows);
            for (int i = startIndex; i < endIndex; ++i) {
                currentPageItemIds.add(cachedItemIds.get(i));
            }
            filter.and("id", "in", currentPageItemIds);
            return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoods", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter});
        }
        if (pageIndex == 1) {
            pageRows = 2 * pageRows;
        }
        return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoods", (Object[])new Object[]{saleOrgId, saleChannelId, orderChannelId, filter, pageIndex, pageRows});
    }

    private boolean isLoadItemIdFromCache() {
        IPageCache pageCache = this.getView().getPageCache();
        int priceClickCount = (Integer)this.getModel().getValue(PRICE_CLICK_COUNT);
        return pageCache.get(PRICE_SORT_ITEM_IDS) != null && priceClickCount != 0;
    }

    private List<Long> getItemIdsFromCache() {
        IPageCache pageCache = this.getView().getPageCache();
        if (pageCache.get(PRICE_SORT_ITEM_IDS) != null) {
            return (List)SerializationUtils.fromJsonString((String)pageCache.get(PRICE_SORT_ITEM_IDS), List.class);
        }
        return new ArrayList<Long>(0);
    }

    private Map<String, Map<String, BigDecimal>> getShoppingCartQty(List<Long> marketableGoodsIds) {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        List marketableGoodsIdList = marketableGoodsIds.stream().map(String::valueOf).collect(Collectors.toList());
        DynamicObjectCollection shoppingCartInfo = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{marketableGoodsIdList, orderChannelId, saleOrgId, saleChannelId, supplyRelation});
        HashMap<String, Map<String, BigDecimal>> mapCart = new HashMap<String, Map<String, BigDecimal>>(0);
        mapCart.put("qty", shoppingCartInfo.stream().collect(Collectors.toMap(k -> k.getString("item"), k -> k.getBigDecimal("qty"), BigDecimal::add)));
        mapCart.put("auxqty", shoppingCartInfo.stream().collect(Collectors.toMap(k -> k.getString("item"), k -> k.getBigDecimal("auxqty"), BigDecimal::add)));
        return mapCart;
    }

    private Map<String, BigDecimal> getShoppingCartQty(long marketableGoodsId) {
        Map<String, Map<String, BigDecimal>> mapShoppingCart = this.getShoppingCartQty(Collections.singletonList(marketableGoodsId));
        Map<String, BigDecimal> shoppingCartQty = mapShoppingCart.get("qty");
        Map<String, BigDecimal> shoppingCartAuxQty = mapShoppingCart.get("auxqty");
        BigDecimal qty = shoppingCartQty.get(String.valueOf(marketableGoodsId));
        BigDecimal auxQty = shoppingCartAuxQty.get(String.valueOf(marketableGoodsId));
        HashMap<String, BigDecimal> mapQty = new HashMap<String, BigDecimal>(0);
        mapQty.put("qty", qty);
        mapQty.put("auxqty", auxQty);
        return mapQty;
    }

    private BigDecimal getShoppingCartQty(int index) {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        long itemId = this.getItemId(index);
        DynamicObject shoppingCartInfo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{itemId, 0L, orderChannelId, saleOrgId, saleChannelId, supplyRelation});
        if (shoppingCartInfo == null) {
            return BigDecimal.ZERO;
        }
        return shoppingCartInfo.getBigDecimal("qty");
    }

    private long getLoginSupplyRelationId() {
        long channelAuthorizeId = B2BUserHelper.getLoginSupplyRelationId();
        Object supplier = this.getSupplierFromParent();
        if (supplier != null) {
            channelAuthorizeId = Long.parseLong((String)supplier);
        }
        return channelAuthorizeId;
    }

    private void initGlobalInfo(long supplyRelationId) {
        this.setValue("supplyrelationid", supplyRelationId);
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        long orderChannelId = channelAuthorize.getLong("orderchannel.id");
        long saleOrgId = channelAuthorize.getLong("saleorg.id");
        long saleChannelId = channelAuthorize.getLong("salechannel.id");
        String supplyRelation = channelAuthorize.getString("supplyrelation");
        DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel", (String)"pricechannel,currency");
        long currencyId = 0L;
        if (orderChannel != null) {
            currencyId = orderChannel.getLong("currency_id");
        }
        this.getModel().setValue("orderchannelid", (Object)orderChannelId);
        this.getModel().setValue("saleorgid", (Object)saleOrgId);
        this.getModel().setValue("salechannelid", (Object)saleChannelId);
        this.getModel().setValue("supplyrelation", (Object)supplyRelation);
        this.getModel().setValue("currencyid", (Object)currencyId);
        if (ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation)) {
            this.getModel().setValue("suppliername", (Object)channelAuthorize.getString(String.join((CharSequence)".", "salechannel", "name")));
        } else {
            this.getModel().setValue("suppliername", (Object)channelAuthorize.getString(String.join((CharSequence)".", "saleorg", "name")));
        }
    }

    private void initItemClass() {
        DynamicObject data;
        long orderChannelId = this.getOrderChannelId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("level", "=", (Object)1));
        qFilters.add(new QFilter("standard.id", "=", (Object)1));
        qFilters.add(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        QFilter classTypeFilter = new QFilter("classtype", "=", (Object)"0");
        long supplyRelationId = B2BUserHelper.getLoginSupplyRelationId();
        if (supplyRelationId > 0L && (data = BusinessDataServiceHelper.loadSingle((Object)supplyRelationId, (String)"ocdbd_channel_authorize")) != null && data.getLong(PC.join_id((String)"salechannel")) > 0L) {
            classTypeFilter = classTypeFilter.or("createchannelid", "=", (Object)data.getLong(PC.join_id((String)"salechannel")));
        }
        qFilters.add(classTypeFilter);
        DynamicObject[] itemClasses = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)String.join((CharSequence)",", "id", "name", "number"), (QFilter[])qFilters.toArray(new QFilter[0]), (String)" classtype,number asc");
        ArrayList<Map> tab_items = new ArrayList<Map>(16);
        TabPageAp firstTabPageAp = new TabPageAp();
        firstTabPageAp.setKey(FIRST_TAB_PAGE_ID);
        firstTabPageAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"MallPlugin_0", (String)"occ-ocdma-formplugin", (Object[])new Object[0])));
        Map firstTabPageMap = firstTabPageAp.createControl();
        firstTabPageMap.put(FIRST_TAB_PAGE_ID, firstTabPageAp);
        tab_items.add(firstTabPageMap);
        for (DynamicObject itemClass : itemClasses) {
            TabPageAp tabPageAp = new TabPageAp();
            String tabPageId = itemClass.getString("id");
            tabPageAp.setKey(tabPageId);
            tabPageAp.setId(tabPageId);
            String name = itemClass.getLocaleString("name").getLocaleValue();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = itemClass.getString("name");
            }
            tabPageAp.setName(new LocaleString(name));
            Map tabPageMap = tabPageAp.createControl();
            tabPageMap.put(tabPageId, tabPageAp);
            tab_items.add(tabPageMap);
        }
        Tab tabAp = (Tab)this.getControl(ITEMCLASS_TAB);
        tabAp.addControls(tab_items);
    }

    private void getEntryDataEntities(int pageIndex) {
        int rowCount = 999;
        CardEntry itemList = (CardEntry)this.getView().getControl(ITEM_LIST);
        AbstractGrid.GridState entryState = itemList.getEntryState();
        Integer pageRows = entryState.getPageRows();
        int pageCount = rowCount / pageRows + (rowCount % pageRows > 0 ? 1 : 0);
        if (pageIndex > pageCount) {
            return;
        }
        DynamicObjectCollection marketableGoodsCollection = this.getMarketableGoods(pageIndex);
        if (marketableGoodsCollection == null || marketableGoodsCollection.isEmpty()) {
            return;
        }
        List<Long> marketableGoodsIds = marketableGoodsCollection.stream().map(k -> k.getLong("id")).collect(Collectors.toList());
        Map<String, List<PromotionItemVo>> promotionPolicyMap = this.getPromotionPolicy(marketableGoodsIds);
        Map<String, Map<String, BigDecimal>> shoppingCartMap = this.getShoppingCartQty(marketableGoodsIds);
        Map<String, BigDecimal> shoppingCartQty = shoppingCartMap.get("qty");
        Map<String, BigDecimal> shoppingCartAuxQty = shoppingCartMap.get("auxqty");
        Map<Long, BigDecimal> priceMap = this.getPriceV2(marketableGoodsCollection, shoppingCartQty);
        List<DynamicObject> marketableGoodsList = this.sortGoodsByPrice(marketableGoodsCollection, priceMap);
        this.createNewEntryRows(marketableGoodsList, promotionPolicyMap, shoppingCartQty, shoppingCartAuxQty, priceMap);
    }

    private List<DynamicObject> sortGoodsByPrice(DynamicObjectCollection marketableGoodsCollection, Map<Long, BigDecimal> priceMap) {
        List<Object> marketableGoodsList = new ArrayList<DynamicObject>(marketableGoodsCollection.size());
        String sortType = "";
        int priceCount = (Integer)this.getModel().getValue(PRICE_CLICK_COUNT);
        if (priceCount != 0) {
            sortType = PRICE_BTN;
        }
        switch (sortType) {
            case "pricebtn": {
                if (priceCount == 1) {
                    marketableGoodsList = marketableGoodsCollection.stream().sorted(Comparator.comparing(k -> (BigDecimal)priceMap.get(k.getLong("id")))).collect(Collectors.toList());
                    break;
                }
                if (priceCount == 2) {
                    marketableGoodsList = marketableGoodsCollection.stream().sorted(Comparator.comparing(k -> (BigDecimal)priceMap.get(((DynamicObject)k).getLong("id"))).reversed()).collect(Collectors.toList());
                    break;
                }
                marketableGoodsList = new ArrayList(marketableGoodsCollection);
                break;
            }
            default: {
                marketableGoodsList = new ArrayList(marketableGoodsCollection);
            }
        }
        return marketableGoodsList;
    }

    private Map<String, List<PromotionItemVo>> getPromotionPolicy(List<Long> marketableGoodsIds) {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        DynamicObjectCollection unitCollection = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)String.join((CharSequence)",", "id", "orderunit.id"), (QFilter[])new QFilter[]{new QFilter("id", "in", marketableGoodsIds)});
        Map<Long, Long> unitMap = unitCollection.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("orderunit.id")));
        List itemInfo = marketableGoodsIds.stream().map(r -> r + "_" + 0L + "_" + unitMap.get(r)).collect(Collectors.toCollection(ArrayList::new));
        return (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"PromotionService", (String)"getPromotionPolicy", (Object[])new Object[]{orderChannelId, saleOrgId, saleChannelId, supplyRelation, itemInfo});
    }

    private QFilter getItemFilter(long saleOrgId, long saleChannelId, long orderChannelId) {
        boolean isFromOcsaa;
        Tab tabAp;
        String tabKey;
        QFilter qFilter = new QFilter("enable", "=", (Object)Checked.YES.toString());
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH);
        String searchText = search.getText();
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            qFilter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"name, number, barcodenumber"}));
        }
        if ((tabKey = (tabAp = (Tab)this.getControl(ITEMCLASS_TAB)).getCurrentTab()) != null && !FIRST_TAB_PAGE_ID.equals(tabKey)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(tabKey))};
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mdr_item_class", (String)String.join((CharSequence)",", "number"), (QFilter[])qFilters);
            String number = dynamicObject.getString("number");
            qFilter.and("itemclassentity.goodsclasssid.longnumber", "like", (Object)(number + "%"));
            qFilter.and("itemclassentity.classstandardid", "=", (Object)1);
        }
        IPageCache pageCache = this.getView().getPageCache();
        HashSet itemIds = new HashSet();
        if (pageCache.get(PROMOTION_ITEM_IDS) != null) {
            List promotionItemIds = (List)SerializationUtils.fromJsonString((String)pageCache.get(PROMOTION_ITEM_IDS), List.class);
            qFilter.and("id", "in", (Object)promotionItemIds);
        }
        if (this.isItemPricePermitZero() && pageCache.get(ITEM_HASPRICE_IDS) != null) {
            List hasPriceItemIds = (List)SerializationUtils.fromJsonString((String)pageCache.get(ITEM_HASPRICE_IDS), List.class);
            qFilter.and("id", "in", (Object)hasPriceItemIds);
        }
        qFilter = (isFromOcsaa = this.getIsFromOCSAA()) ? ItemBusinessHelper.getItemStatusSysControlQFilter((long)saleOrgId, (long)saleChannelId, (long)orderChannelId, (QFilter)qFilter, (String)"3") : ItemBusinessHelper.getItemStatusSysControlQFilter((long)saleOrgId, (long)saleChannelId, (long)orderChannelId, (QFilter)qFilter, (String)"1");
        String filterKey = this.getView().getPageCache().get("filterkey");
        if ("attention".equals(filterKey)) {
            qFilter.and("id", "in", (Object)ItemBusinessHelper.queryAttentionItemIds((String)"ocdbd_item_attention", (String)"itemid", new ArrayList(itemIds)));
        } else if ("commonuse".equals(filterKey)) {
            qFilter.and("id", "in", (Object)ItemBusinessHelper.queryAttentionItemIds((String)"ocdbd_item_commonuse", (String)"itemid", new ArrayList(itemIds)));
        }
        return qFilter;
    }

    private boolean getIsFromOCSAA() {
        Object supplier = this.getSupplierFromParent();
        return supplier != null;
    }

    private void createNewEntryRows(List<DynamicObject> marketableGoods, Map<String, List<PromotionItemVo>> promotionPolicyMap, Map<String, BigDecimal> shoppingCartQty, Map<String, BigDecimal> shoppingCartAuxQty, Map<Long, BigDecimal> priceMap) {
        if (marketableGoods.isEmpty()) {
            return;
        }
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get(ITEM_LIST);
        String supplier = this.getSupplier();
        ArrayList<DynamicObject> itemInfoList = new ArrayList<DynamicObject>(marketableGoods.size());
        List attentionItemIds = ItemBusinessHelper.queryAttentionItemIds((String)"ocdbd_item_attention", (String)"itemid");
        List commonuseItemIds = ItemBusinessHelper.queryAttentionItemIds((String)"ocdbd_item_commonuse", (String)"itemid");
        for (DynamicObject marketableGood : marketableGoods) {
            DynamicObject dataObject = new DynamicObject((DynamicObjectType)entityType);
            long itemId = marketableGood.getLong("id");
            dataObject.set("supplier", (Object)supplier);
            dataObject.set("itemnumber", (Object)marketableGood.getString("number"));
            dataObject.set("auxpty", (Object)0L);
            dataObject.set("thumbnail", marketableGood.get("thumbnail"));
            dataObject.set("qty", (Object)shoppingCartQty.getOrDefault(String.valueOf(itemId), BigDecimal.ZERO));
            dataObject.set("auxqty", (Object)shoppingCartAuxQty.getOrDefault(String.valueOf(itemId), BigDecimal.ZERO));
            dataObject.set("price", (Object)priceMap.getOrDefault(itemId, BigDecimal.ZERO));
            if (BigDecimal.ZERO.compareTo(dataObject.getBigDecimal("price")) == 0) {
                dataObject.set(ISZEROPRICE, (Object)true);
            }
            BigDecimal price = DynamicObjectUtils.getBigDecimal((DynamicObject)dataObject, (String)"price");
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataObject, (String)"qty");
            dataObject.set(AMOUNT, (Object)qty.multiply(price));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"item", (long)itemId);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"material", (long)marketableGood.getLong("material"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"unit", (long)marketableGood.getLong("orderunit"));
            dataObject.set(UNIT_NAME, (Object)DynamicObjectUtils.getString((DynamicObject)marketableGood, (String)"orderunit.name"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)dataObject, (String)"auxunit", (long)marketableGood.getLong("assistunit"));
            for (Map.Entry<String, List<PromotionItemVo>> promotionPolicyEntry : promotionPolicyMap.entrySet()) {
                if (!promotionPolicyEntry.getKey().split("_")[0].equals(String.valueOf(itemId))) continue;
                List<PromotionItemVo> promotionPolicyList = promotionPolicyEntry.getValue();
                if (!CollectionUtil.isNotNull(promotionPolicyList)) break;
                List labelList = promotionPolicyList.stream().map(PromotionItemVo::getLable).flatMap(Collection::stream).distinct().filter(StringUtils::isNotEmpty).sorted().collect(Collectors.toList());
                for (int i = 0; i < labelList.size() && i < 6; ++i) {
                    dataObject.set("label" + i, labelList.get(i));
                }
            }
            dataObject.set("isattention", (Object)attentionItemIds.contains(itemId));
            dataObject.set("iscommonuse", (Object)commonuseItemIds.contains(itemId));
            itemInfoList.add(dataObject);
        }
        BusinessDataServiceHelper.loadRefence((Object[])itemInfoList.toArray(), (IDataEntityType)this.getModel().getEntryEntity(ITEM_LIST).getDynamicObjectType());
        DynamicObjectCollection itemListCollection = this.getModel().getEntryEntity(ITEM_LIST);
        itemListCollection.addAll(itemInfoList);
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        for (DynamicObject itemEntry : itemListCollection) {
            DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)itemEntry, (String)"material");
            boolean isUseAuxpty = DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"isuseauxpty");
            boolean isOpenSelectAuxpty = isUseAuxpty && StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A") || !StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)"A");
            if (!isOpenSelectAuxpty) continue;
            itemEntry.set("isuseauxpty", (Object)true);
        }
        this.getModel().updateEntryCache(itemListCollection);
    }

    private long getSupplyRelationId() {
        return (Long)this.getF7PKValue("supplyrelationid");
    }

    private long getOrderChannelId() {
        return this.getF7Value("supplyrelationid").getLong("orderchannel.id");
    }

    private long getSaleOrgId() {
        return this.getF7Value("supplyrelationid").getLong("saleorg.id");
    }

    private long getSaleChannelId() {
        return this.getF7Value("supplyrelationid").getLong("salechannel.id");
    }

    private String getSupplyRelation() {
        return this.getF7Value("supplyrelationid").getString("supplyrelation");
    }

    private String getSupplier() {
        return (String)this.getModel().getValue("suppliername");
    }

    private long getItemId(int index) {
        return (Long)this.getEntryF7PKValue(ITEM_LIST, "item", index);
    }

    private long getAuxptyId(int index) {
        return 0L;
    }

    private long getUnitId(int index) {
        return (Long)this.getEntryF7PKValue(ITEM_LIST, "unit", index);
    }

    private long getAuxUnitId(int index) {
        Object val = this.getEntryF7PKValue(ITEM_LIST, "auxunit", index);
        if (val == null) {
            return 0L;
        }
        return CommonUtils.stringToLong((Object)val);
    }

    private Map<Long, BigDecimal> getPriceV2(DynamicObjectCollection marketableGoods, Map<String, BigDecimal> shoppingCartMap) {
        IPageCache pageCache;
        if (this.isItemPricePermitZero() && (pageCache = this.getView().getPageCache()).get(ITEMTABLE_ITEM_PRICES) != null) {
            Map hasPriceItemIds = (Map)SerializationUtils.fromJsonString((String)pageCache.get(ITEMTABLE_ITEM_PRICES), Map.class);
            HashMap<Long, BigDecimal> destMap = new HashMap<Long, BigDecimal>(hasPriceItemIds.size());
            for (Map.Entry entry : hasPriceItemIds.entrySet()) {
                destMap.put(Long.valueOf(entry.getKey().toString()), new BigDecimal(entry.getValue().toString()));
            }
            return destMap;
        }
        long orderChannelId = this.getOrderChannelId();
        DynamicObject orderChannel = this.queryById("ocdbd_channel", "pricechannel", orderChannelId);
        long priceChannelId = orderChannel != null ? orderChannel.getLong("pricechannel") : 0L;
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("currencyid");
        long currencyId = settleCurrency.getLong("id");
        ArrayList<PriceFetchParam> fetchPriceParamList = new ArrayList<PriceFetchParam>();
        HashMap<String, String> itemPriceMap = new HashMap<String, String>(6);
        String supplyRelation = this.getModel().getValue("supplyrelation").toString();
        for (DynamicObject marketableGood : marketableGoods) {
            long itemId = marketableGood.getLong("id");
            long unitId = marketableGood.getLong("orderunit.id");
            BigDecimal qty = shoppingCartMap.getOrDefault(String.valueOf(itemId), BigDecimal.ZERO);
            PriceFetchParam priceFetchParam = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)priceChannelId, (long)itemId, (long)0L, (long)unitId, (long)currencyId, (BigDecimal)qty);
            priceFetchParam.setOwnerId(saleChannelId);
            priceFetchParam.setChannelSupplyRelation(ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation) ? ChannelSupplyRelation.SUPPLY_CHANNEL : ChannelSupplyRelation.SUPPLY_ORG);
            itemPriceMap.put(String.join((CharSequence)".", Long.toString(itemId), Long.toString(unitId), qty.toString()), priceFetchParam.getParamUniKey());
            fetchPriceParamList.add(priceFetchParam);
        }
        HashMap<Long, BigDecimal> priceResultMap = new HashMap<Long, BigDecimal>(marketableGoods.size());
        Map priceMap = PriceServiceUtil.batchGetItemPrice(fetchPriceParamList);
        for (DynamicObject marketableGood : marketableGoods) {
            long itemId = marketableGood.getLong("id");
            long unitId = marketableGood.getLong("orderunit.id");
            BigDecimal taxRate = marketableGood.getBigDecimal("material.taxrate.taxrate");
            BigDecimal qty = shoppingCartMap.getOrDefault(String.valueOf(itemId), BigDecimal.ZERO);
            String key = String.join((CharSequence)".", Long.toString(itemId), Long.toString(unitId), qty.toString());
            PriceFetchResult priceFetchResult = (PriceFetchResult)priceMap.get(itemPriceMap.get(key));
            BigDecimal price = BigDecimal.ZERO;
            if (priceFetchResult != null) {
                HashMap priceDetailMap = OrderHelper.getPriceMap((PriceFetchResult)priceFetchResult, (DynamicObject)settleCurrency, (BigDecimal)qty, (BigDecimal)taxRate, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
                price = priceDetailMap != null ? (BigDecimal)priceDetailMap.get("actualtaxprice") : BigDecimal.ZERO;
            }
            priceResultMap.put(itemId, price);
        }
        return priceResultMap;
    }

    private DynamicObject queryById(String formId, String selectFields, Object pkValue) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("id", "=", pkValue));
        return QueryServiceHelper.queryOne((String)formId, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    private void resetButton() {
        this.getModel().setValue(PRICE_CLICK_COUNT, (Object)0);
        Control priceBtn = this.getView().getControl(PRICE_BTN);
        MobileControlUtils.ControlSetFontWeight((Control)priceBtn, (boolean)false);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.remove(PRICE_SORT_ITEM_IDS);
    }

    protected Map<String, BigDecimal> getOrderQuantity(int index) {
        return OrderQuantityUtil.getOrderQuantityRlue((long)this.getSaleOrgId(), (long)this.getOrderChannelId(), (long)this.getItemId(index), (long)this.getUnitId(index), (long)this.getAuxptyId(index), (IPageCache)this.getPageCache());
    }

    private boolean isUseAuxpty(int index) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ITEM_LIST, index);
        DynamicObject material = entryRowEntity.getDynamicObject("material");
        return material != null && material.getBoolean("isuseauxpty");
    }
}

