/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.mall;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.occ.ocbase.business.helper.PromotionServiceHelper;
import kd.occ.ocbase.common.pojo.PromotionItemVo;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class PromotionPlugin
extends OcbaseFormMobPlugin {
    private static final String PROMOTION_ENTITY = "promotion_entity";
    private static int LABEL_NUMBER = 8;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long itemId = Long.parseLong((String)customParams.get("itemId"));
        long unitId = Long.parseLong((String)customParams.get("unitId"));
        long orderChannelId = Long.parseLong((String)customParams.get("orderChannelId"));
        long saleOrgId = Long.parseLong((String)customParams.get("saleOrgId"));
        long saleChannelId = Long.parseLong((String)customParams.get("saleChannelId"));
        String key = itemId + "_" + 0L + "_" + unitId;
        List<String> itemInfo = Collections.singletonList(key);
        Map promotionPolicyMap = PromotionServiceHelper.getPromotionPolicy((long)orderChannelId, (long)saleOrgId, (long)saleChannelId, itemInfo);
        List promotionPolicyList = (List)promotionPolicyMap.get(key);
        if (promotionPolicyList != null && !promotionPolicyList.isEmpty()) {
            int[] indexes;
            List promotionPolicyFilteredList = PromotionServiceHelper.filterPromotionPolicy((List)promotionPolicyList);
            CardEntry promotionEntity = (CardEntry)this.getView().getControl(PROMOTION_ENTITY);
            for (int index : indexes = this.getModel().batchCreateNewEntryRow(PROMOTION_ENTITY, promotionPolicyFilteredList.size())) {
                PromotionItemVo promotionPolicy = (PromotionItemVo)promotionPolicyFilteredList.get(index);
                DynamicObject dataObject = this.getRowInfo(PROMOTION_ENTITY, index);
                Date effectiveDate = promotionPolicy.getEffectiveDate();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                String effectiveDateFormat = simpleDateFormat.format(effectiveDate);
                Date expirationDate = promotionPolicy.getExpirationDate();
                String expirationDateFormat = simpleDateFormat.format(expirationDate);
                dataObject.set("date", (Object)(effectiveDateFormat + " \u81f3 " + expirationDateFormat));
                dataObject.set("content", (Object)promotionPolicy.getPolicyName());
                ArrayList promotionLabelList = promotionPolicy.getLable();
                if (CollectionUtil.isNotNull((List)promotionLabelList)) {
                    int i;
                    List labelList = promotionLabelList.stream().distinct().filter(StringUtils::isNotEmpty).sorted().collect(Collectors.toList());
                    for (i = 0; i < labelList.size() && i < LABEL_NUMBER; ++i) {
                        this.getModel().setValue("label" + i, labelList.get(i), index);
                    }
                    for (i = labelList.size(); i < LABEL_NUMBER; ++i) {
                        promotionEntity.setChildVisible(false, index, new String[]{"label" + i});
                    }
                    continue;
                }
                promotionEntity.setChildVisible(false, index, new String[]{"labelpanel"});
            }
        }
    }
}

