/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.mall;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.flex.FlexService;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FlexBeforeClosedEvent;
import kd.bos.form.field.FlexEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.entity.OrderQuantityResult;
import kd.occ.ocbase.common.item.ConversionDirection;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.OrderQuantityUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;
import org.apache.commons.lang.StringUtils;

public class SelectAuxptyPlugin
extends OcdmaFormMobPlugin {
    private static final String ADD = "add";
    private static final String REDUCE = "reduce";
    private static final String ADD_SALEQTY = "add_saleqty";
    private static final String REDUCE_SALEQTY = "reduce_saleqty";
    private static final String ADD_AUXQTY = "add_auxqty";
    private static final String REDUCE_AUXQTY = "reduce_auxqty";
    private static final String CONFIRM = "confirm";
    private static final String AMOUNT_QTY_PANEL = "amount_qty_panel";
    private static final String AUXPTY_PANEL = "fp_auxpty";
    private static final BigDecimal QTY_MAX = BigDecimal.valueOf(10000000L);
    private static final String OCDMA_SALEORDER_ADD = "ocdma_saleorder_add";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        this.getPageCache().put("multiunitorder", multiUnitOrder);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long itemId = Long.parseLong((String)customParams.get("item"));
        long auxptyId = Long.parseLong((String)customParams.get("auxpty"));
        long supplyRelationId = Long.parseLong((String)customParams.get("supplyrelationid"));
        BigDecimal qty = new BigDecimal(CommonUtils.convertObjectToString(customParams.get("qty")));
        BigDecimal auxQty = new BigDecimal(CommonUtils.convertObjectToString(customParams.get("auxqty")));
        this.setValue("item", itemId);
        this.setValue("auxpty", auxptyId);
        this.setValue("supplyrelationid", supplyRelationId);
        QFilter filter = new QFilter("id", "in", (Object)itemId);
        DynamicObjectCollection items = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getMarketableGoods", (Object[])new Object[]{this.getSaleOrgId(), this.getSaleChannelId(), this.getOrderChannelId(), filter});
        if (CollectionUtil.isNotNull((List)items)) {
            DynamicObject itemInfo = (DynamicObject)items.get(0);
            this.getModel().setValue("material", (Object)itemInfo.getLong("material"));
            this.getModel().setValue("thumbnail", (Object)itemInfo.getString("thumbnail"));
            Image imageap = (Image)this.getControl("imageap");
            if (imageap != null) {
                imageap.setUrl(itemInfo.getString("thumbnail"));
            }
            this.getModel().setValue("unit", (Object)itemInfo.getLong("orderunit.id"));
            this.getModel().setValue("saleunit", (Object)itemInfo.getLong("orderunit.id"));
            this.getModel().setValue("auxunit", (Object)itemInfo.getLong("assistunit.id"));
            DynamicObject material = (DynamicObject)this.getModel().getValue("material");
            if (!DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"isuseauxpty") || auxptyId > 0L) {
                this.getModel().setValue("qty", (Object)qty);
                this.getModel().setValue("auxqty", (Object)auxQty);
            }
            DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)this.getOrderChannelId(), (String)"ocdbd_channel", (String)"pricechannel,currency");
            long currencyId = 0L;
            if (orderChannel != null) {
                currencyId = orderChannel.getLong("currency_id");
            }
            this.getModel().setValue("currencyid", (Object)currencyId);
            this.getModel().setValue("price", (Object)this.getPrice());
            this.calSumQtyAmount(multiUnitOrder);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().executeClientCommand("loadThirdPartyJS", new Object[]{"./kingdee/drp/ocdma/ocdma_select_auxpty.js"});
        String multiUnitOrder = this.getPageCache().get("multiunitorder");
        if (StringUtils.isEmpty((String)multiUnitOrder)) {
            multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        }
        this.getView().setVisible(Boolean.valueOf(this.isNeedSelectQty()), new String[]{AMOUNT_QTY_PANEL});
        boolean isUseAuxpty = this.isUseAuxpty();
        if (!isUseAuxpty) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"auxpty"});
        }
        if (StringUtils.equals((String)multiUnitOrder, (String)"B")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"saleunit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"auxunit"});
            Object auxptyUnit = this.getModel().getValue("auxunit");
            if (auxptyUnit == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{AUXPTY_PANEL});
            }
        }
        if (StringUtils.equals((String)multiUnitOrder, (String)"A") || StringUtils.equals((String)multiUnitOrder, (String)"C")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AUXPTY_PANEL});
            this.getView().setEnable(Boolean.FALSE, new String[]{"saleunit"});
        }
        this.calSumQtyAmount(multiUnitOrder);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD, REDUCE, ADD_SALEQTY, ADD_AUXQTY, REDUCE_SALEQTY, REDUCE_AUXQTY, CONFIRM});
    }

    public void flexBeforeClosed(FlexBeforeClosedEvent e) {
        super.flexBeforeClosed(e);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "add_saleqty": {
                this.addQty("qty");
                break;
            }
            case "reduce_saleqty": {
                this.reduceQty("qty");
                break;
            }
            case "add_auxqty": {
                this.addQty("auxqty");
                break;
            }
            case "reduce_auxqty": {
                this.reduceQty("auxqty");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((String)args.getOperateKey(), (String)CONFIRM) && args.getOperationResult().isSuccess()) {
            BigDecimal returnQty = this.getQty();
            BigDecimal auxQty = (BigDecimal)this.getModel().getValue("auxqty");
            if (this.isNeedSelectQty() && (returnQty == null || returnQty.compareTo(BigDecimal.ZERO) <= 0)) {
                this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u6570\u91cf");
                return;
            }
            HashMap<String, Number> returnData = new HashMap<String, Number>(4);
            returnData.put("index", this.getParentIndex());
            returnData.put("item", this.getItemId());
            returnData.put("auxpty", this.getAuxptyId());
            returnData.put("qty", returnQty);
            returnData.put("auxqty", auxQty);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            this.triggerChangeEvent = true;
            return;
        }
        String key = e.getProperty().getName();
        String multiUnitOrder = this.getPageCache().get("multiunitorder");
        if (StringUtils.isEmpty((String)multiUnitOrder)) {
            multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        }
        switch (key) {
            case "qty": {
                BigDecimal qty = (BigDecimal)this.getValue("qty");
                if (qty.compareTo(QTY_MAX) > 0) {
                    this.setValue("qty", QTY_MAX);
                    return;
                }
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    this.setValue("qty", BigDecimal.ZERO);
                    return;
                }
                long saleOrgId = this.getSaleOrgId();
                long orderChannelId = this.getOrderChannelId();
                long itemId = this.getItemId();
                long auxptyId = this.getAuxptyId();
                long unitId = this.getUnitId();
                OrderQuantityResult orderQuantityResult = OrderQuantityUtil.calOrderQuantity((long)saleOrgId, (long)orderChannelId, (long)itemId, (long)unitId, (long)auxptyId, (BigDecimal)qty, (IPageCache)this.getView().getPageCache());
                if (orderQuantityResult.isQuantity()) {
                    qty = orderQuantityResult.getSuggestQty();
                    this.getModel().setValue("qty", (Object)qty);
                    this.getView().showTipNotification(orderQuantityResult.getErrorMsg());
                }
                BigDecimal price = this.getPrice();
                this.getModel().setValue("price", (Object)price);
                this.calQtyCvtAssistQty(true);
                this.calSumQtyAmount(multiUnitOrder);
                break;
            }
            case "auxqty": {
                this.calQtyCvtAssistQty(false);
                this.calSumQtyAmount(multiUnitOrder);
                break;
            }
            default: {
                if (key.startsWith("$$") && key.split("__")[0].equals("$$auxpty")) {
                    this.saveAuxpty();
                    BigDecimal saleQty = this.getQty();
                    if (saleQty.compareTo(BigDecimal.ZERO) != 0) break;
                    BigDecimal shoppingCartQty = this.getShoppingCartQty();
                    if (shoppingCartQty.compareTo(BigDecimal.ZERO) <= 0) {
                        this.setValue("qty", BigDecimal.ZERO, false);
                        this.add();
                    } else {
                        this.setValue("qty", shoppingCartQty);
                    }
                    this.setValue("price", this.getPrice(), false);
                    break;
                }
                BigDecimal price = this.getPrice();
                this.getModel().setValue("price", (Object)price);
            }
        }
    }

    private void calSumQtyAmount(String multiUnitOrder) {
        Label lblQty = (Label)this.getView().getControl("lbl_qty");
        BigDecimal qty = new BigDecimal(CommonUtils.convertObjectToString((Object)this.getValue("qty")));
        BigDecimal price = new BigDecimal(CommonUtils.convertObjectToString((Object)this.getValue("price")));
        DynamicObject unit = (DynamicObject)this.getValue("unit");
        lblQty.setText(qty.stripTrailingZeros().toPlainString());
        Label lblUnit = (Label)this.getView().getControl("lbl_unit");
        DynamicObject auxUnit = (DynamicObject)this.getValue("auxunit");
        BigDecimal auxQty = new BigDecimal(CommonUtils.convertObjectToString((Object)this.getValue("auxqty")));
        if (StringUtils.equals((String)multiUnitOrder, (String)"A") || StringUtils.equals((String)multiUnitOrder, (String)"C") || auxUnit == null) {
            lblUnit.setText(String.format("%s", DynamicObjectUtils.getString((DynamicObject)unit, (String)"name")));
        } else {
            lblUnit.setText(String.format("%s\uff08%s%s\uff09", DynamicObjectUtils.getString((DynamicObject)unit, (String)"name"), auxQty.stripTrailingZeros().toPlainString(), DynamicObjectUtils.getString((DynamicObject)auxUnit, (String)"name")));
        }
        Label lblAmount = (Label)this.getView().getControl("lbl_amount");
        lblAmount.setText(qty.multiply(price).setScale(2, RoundingMode.HALF_UP).toPlainString());
    }

    private Map<String, BigDecimal> getOrderQuantityRule() {
        return OrderQuantityUtil.getOrderQuantityRlue((long)this.getSaleOrgId(), (long)this.getOrderChannelId(), (long)this.getItemId(), (long)this.getUnitId(), (long)this.getAuxptyId(), (IPageCache)this.getPageCache());
    }

    private BigDecimal getShoppingCartQty() {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        long itemId = this.getItemId();
        long auxpty = this.getAuxptyId();
        DynamicObject shoppingCartInfo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{itemId, auxpty, orderChannelId, saleOrgId, saleChannelId, supplyRelation});
        if (shoppingCartInfo == null) {
            return BigDecimal.ZERO;
        }
        return shoppingCartInfo.getBigDecimal("qty");
    }

    private BigDecimal getShoppingCartTotalQty() {
        long orderChannelId = this.getOrderChannelId();
        long saleOrgId = this.getSaleOrgId();
        long saleChannelId = this.getSaleChannelId();
        String supplyRelation = this.getSupplyRelation();
        long itemId = this.getItemId();
        long auxpty = this.getAuxptyId();
        DynamicObjectCollection shoppingCartInfo = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getCartData", (Object[])new Object[]{Collections.singletonList(itemId), orderChannelId, saleOrgId, saleChannelId, supplyRelation});
        Map<String, BigDecimal> shoppingCartInfoMap = shoppingCartInfo.stream().collect(Collectors.toMap(k -> k.getString("item"), k -> k.getBigDecimal("qty"), BigDecimal::add));
        return shoppingCartInfoMap.get(String.valueOf(itemId));
    }

    private long getItemId() {
        return (Long)((DynamicObject)this.getModel().getValue("item")).getPkValue();
    }

    private long getUnitId() {
        return (Long)((DynamicObject)this.getModel().getValue("unit")).getPkValue();
    }

    private BigDecimal getQty() {
        return (BigDecimal)this.getModel().getValue("qty");
    }

    private void calQtyCvtAssistQty(boolean isSaleQtyChange) {
        DynamicObject item = (DynamicObject)this.getModel().getValue("item");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)material);
        DynamicObject saleUnit = (DynamicObject)this.getModel().getValue("saleunit");
        long saleUnitId = DynamicObjectUtils.getPkValue((DynamicObject)saleUnit);
        DynamicObject auxptyUnit = (DynamicObject)this.getModel().getValue("auxunit");
        long auxptyUnitId = DynamicObjectUtils.getPkValue((DynamicObject)auxptyUnit);
        String conversionFor = DynamicObjectUtils.getString((DynamicObject)item, (String)"conversionfor");
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionFor)) {
            if (isSaleQtyChange) {
                this.setAuxQty(materialId, saleUnitId, auxptyUnitId);
            } else {
                this.setQty(materialId, auxptyUnitId, saleUnitId);
            }
        } else if (ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionFor) && isSaleQtyChange) {
            this.setAuxQty(materialId, saleUnitId, auxptyUnitId);
        } else if (ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionFor) && !isSaleQtyChange) {
            this.setQty(materialId, auxptyUnitId, saleUnitId);
        }
    }

    private void setAuxQty(long materialId, long saleUnitId, long auxUnitId) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
        BigDecimal auxptyQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)saleUnitId, (Long)auxUnitId);
        this.getModel().beginInit();
        this.getModel().setValue("auxqty", (Object)auxptyQty);
        this.getModel().endInit();
        this.getView().updateView("auxqty");
    }

    private void setQty(long materialId, long auxUnitId, long saleUnitId) {
        BigDecimal auxqty = (BigDecimal)this.getModel().getValue("auxqty");
        BigDecimal qty = UnitConvertHelper.calculateDestQty((BigDecimal)auxqty, (Long)materialId, (Long)auxUnitId, (Long)saleUnitId);
        if (qty.compareTo(QTY_MAX) > 0) {
            this.clearQty();
            return;
        }
        if (qty.compareTo(BigDecimal.ZERO) < 0) {
            this.clearQty();
            return;
        }
        long saleOrgId = this.getSaleOrgId();
        long orderChannelId = this.getOrderChannelId();
        long itemId = this.getItemId();
        long auxptyId = this.getAuxptyId();
        long unitId = this.getUnitId();
        OrderQuantityResult orderQuantityResult = OrderQuantityUtil.calOrderQuantity((long)saleOrgId, (long)orderChannelId, (long)itemId, (long)unitId, (long)auxptyId, (BigDecimal)qty, (IPageCache)this.getView().getPageCache());
        if (orderQuantityResult.isQuantity()) {
            qty = orderQuantityResult.getSuggestQty();
            this.getModel().setValue("qty", (Object)qty);
            BigDecimal auxptyQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)saleUnitId, (Long)auxUnitId);
            this.setValue("auxqty", auxptyQty, false);
            this.getView().showTipNotification(orderQuantityResult.getErrorMsg());
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue("qty", (Object)qty);
        this.getModel().endInit();
        this.getView().updateView("qty");
    }

    private void clearQty() {
        this.getModel().beginInit();
        this.getModel().setValue("qty", (Object)BigDecimal.ZERO);
        this.getModel().setValue("auxqty", (Object)BigDecimal.ZERO);
        this.getView().updateView("qty");
        this.getView().updateView("auxqty");
        this.getModel().endInit();
    }

    private int getParentIndex() {
        return (Integer)this.getParameter("parent_index");
    }

    private boolean isNeedSelectQty() {
        Object isNeedSelectQty = this.getParameter("isNeedSelectQty");
        return isNeedSelectQty != null && (Boolean)isNeedSelectQty != false;
    }

    private long getOrderChannelId() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getLong("orderchannel.id");
    }

    private long getSaleOrgId() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getLong("saleorg.id");
    }

    private long getSaleChannelId() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getLong("salechannel.id");
    }

    private String getSupplyRelation() {
        DynamicObject channelAuthorize = (DynamicObject)this.getValue("supplyrelationid");
        return channelAuthorize.getString("supplyrelation");
    }

    private long getCurrencyId() {
        return ((DynamicObject)this.getModel().getValue("currencyid")).getLong("id");
    }

    private String getSupplier() {
        return (String)this.getModel().getValue("suppliername");
    }

    private long getAuxptyId() {
        Object pkValue = this.getF7PKValue("auxpty");
        if (pkValue == null) {
            return 0L;
        }
        return (Long)pkValue;
    }

    private boolean isUseAuxpty() {
        DynamicObject material = (DynamicObject)this.getView().getModel().getValue("material");
        return material != null && material.getBoolean("isuseauxpty");
    }

    private boolean isAuxptySelected() {
        long auxpty;
        boolean isUseAuxpty = this.isUseAuxpty();
        if (isUseAuxpty && (auxpty = this.getAuxptyId()) == 0L) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8f85\u52a9\u5c5e\u6027");
            return false;
        }
        return true;
    }

    private void saveAuxpty() {
        FlexEdit flexEdit = (FlexEdit)this.getControl("auxpty");
        IDataModel flexModel = flexEdit.getFlexModel();
        DynamicObject dataEntity = flexModel.getDataEntity();
        MainEntityType dataEntityType = flexModel.getDataEntityType();
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData(dataEntityType, dataEntity);
        long id = FlexService.saveFlexData((MainEntityType)dataEntityType, (FlexEntireData)flexEntireData);
        this.setValue("auxpty", id);
    }

    private BigDecimal getPrice() {
        long taxrateId;
        DynamicObject bdTaxrate;
        DynamicObject taxrate;
        long saleOrgId = this.getSaleOrgId();
        long orderChannelId = this.getOrderChannelId();
        DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel", (String)"pricechannel");
        long priceChannelId = orderChannelId;
        if (orderChannel != null) {
            priceChannelId = orderChannel.getLong("pricechannel_id");
        }
        long itemId = this.getItemId();
        long auxptyId = this.getAuxptyId();
        long unitId = this.getUnitId();
        long currencyId = this.getCurrencyId();
        DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("currencyid");
        BigDecimal qty = this.getQty();
        qty = BigDecimal.ZERO.compareTo(qty) >= 0 ? BigDecimal.ONE : qty;
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material != null && (taxrate = material.getDynamicObject("taxrate")) != null && (bdTaxrate = BusinessDataServiceHelper.loadSingle((Object)(taxrateId = taxrate.getLong("id")), (String)"bd_taxrate")) != null) {
            taxRate = bdTaxrate.getBigDecimal("taxrate");
        }
        PriceFetchParam params = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)priceChannelId, (long)itemId, (long)auxptyId, (long)unitId, (long)currencyId, (BigDecimal)qty);
        long saleChannelId = this.getSaleChannelId();
        if (saleChannelId != 0L) {
            params.setOwnerId(saleChannelId);
        }
        HashMap priceMap = OrderHelper.getPriceMap((PriceFetchParam)params, (DynamicObject)settleCurrency, (BigDecimal)qty, (BigDecimal)taxRate);
        return (BigDecimal)priceMap.get("actualtaxprice");
    }

    private void add() {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantityRule();
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal bigDecimal = orderMinQty = orderMinQty.compareTo(BigDecimal.ZERO) == 0 ? orderQty : orderMinQty;
        if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            this.setValue("qty", orderMinQty);
        } else {
            this.setValue("qty", qty.add(orderQty));
        }
    }

    private void addQty(String qtyKey) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyKey);
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantityRule();
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal bigDecimal = orderMinQty = orderMinQty.compareTo(BigDecimal.ZERO) == 0 ? orderQty : orderMinQty;
        if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            this.setValue(qtyKey, orderMinQty);
        } else {
            this.setValue(qtyKey, qty.add(orderQty));
        }
    }

    private void reduce() {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantityRule();
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal newQty = qty.subtract(orderQty);
        if (newQty.compareTo(orderMinQty) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue("qty", (Object)newQty);
    }

    private void reduceQty(String qtyKey) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyKey);
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantityRule();
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal newQty = qty.subtract(orderQty);
        if (newQty.compareTo(orderMinQty) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue(qtyKey, (Object)newQty);
    }
}

