/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.marketcost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.helper.BudgetCostsHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.OrgUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.common.util.memutil.OCMEMFilterUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class MarketCostApplyAddPlugin
extends OcdmaFormMobPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    public static final String NEWENRTY = "newenrty";
    public static final String DELETEICON = "deleteicon";
    public static final String TOTALAMOUNT = "totalamount";
    public static final String REIMBURSEWAY = "reimburseway";
    public static final String ACCOUNTTYPE = "accounttype";
    public static String[] headFiled = new String[]{"billno", "billdate", "expensetype", "billstatus", "paymenthod", "dept", "settleorgid", "orderchannel", "budget", "number", "begindate", "enddate", "reason", "currency", "totalamount", "reimburseway", "accounttype"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{NEWENRTY, DELETEICON});
        this.addF7Listener(this, new String[]{"orderchannel", "expensetype", ACCOUNTTYPE});
        CardEntry billList = (CardEntry)this.getControl("entryentity");
        billList.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String key;
        switch (key = arg.getProperty().getName()) {
            case "orderchannel": {
                this.setNewCustomerFilter(arg);
                break;
            }
            case "expensetype": {
                List filterList = arg.getCustomQFilters();
                QFilter[] filters = OCMEMFilterUtil.getQFilter((String)"enable", (Object)EnableStatusEnum.ENABLE.getValue());
                DynamicObjectCollection bcc = QueryServiceHelper.query((String)"ocdbd_billconfig", (String)"expensetype", (QFilter[])filters);
                HashSet<Object> set = new HashSet<Object>(bcc.size());
                for (int i = 0; i < bcc.size(); ++i) {
                    set.add(((DynamicObject)bcc.get(i)).get("expensetype"));
                }
                QFilter filter = new QFilter("id", "in", set);
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg, (QFilter)filter);
                break;
            }
            case "accounttype": {
                QFilter accountTypeFilter = new QFilter(ACCOUNTTYPE, "=", (Object)"B");
                arg.getCustomQFilters().add(accountTypeFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        long CustomerChannelId;
        if (this.isEdit()) {
            String billId = (String)this.getParameter("billId");
            this.initInfo(billId);
            return;
        }
        if (this.isView()) {
            String billId = (String)this.getParameter("billId");
            this.initInfo(billId);
            return;
        }
        this.useCodeRule();
        Set adminSet = UserUtil.getAdminOrgIDs();
        if (!adminSet.isEmpty() && adminSet.size() > 0) {
            Object[] ids = adminSet.toArray();
            this.getModel().setValue("dept", ids[0]);
        }
        if ((CustomerChannelId = B2BUserHelper.getLoginChannelId()) != 0L) {
            this.getModel().setValue("orderchannel", (Object)BusinessDataServiceHelper.loadSingle((Object)CustomerChannelId, (String)"ocdbd_channel"));
            this.customerChanged();
            this.setCurrency();
            this.beforeBudgetCompare();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isEdit() || this.isView()) {
            Object billId = this.getModel().getDataEntity().get("marketcostid");
            List attachments = AttachmentServiceHelper.getAttachments((String)"ocmem_marketcost_apply", (Object)billId, (String)"attachmentpanel");
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
            attachmentPanel.bindData(attachments);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.showEnrtyView(OperationStatus.EDIT);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Boolean rs;
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if (this.ifBudget() && StringUtils.equals((CharSequence)key, (CharSequence)"save")) {
            this.BudgetBalanceSheetCompare();
        }
        if (this.ifBudget() && StringUtils.equals((CharSequence)key, (CharSequence)"submit") && !(rs = this.BudgetBalanceSheetCompare()).booleanValue()) {
            this.getView().showMessage("\u5f53\u524d\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u8c03\u6574\u9884\u7b97\u540e\u518d\u63d0\u4ea4");
            e.setCancel(true);
            return;
        }
    }

    private void initInfo(String billId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocmem_marketcost_apply");
        this.setValue("marketcostid", billId);
        this.setValue("billno", bill.get("billno"));
        this.setValue("billdate", bill.get("billdate"));
        this.setValue("expensetype", bill.get("expensetype"));
        this.setValue("paymenthod", bill.get("paymenthod"));
        this.setValue("dept", bill.get("dept"));
        this.setValue("settleorgid", bill.get("settleorgid"));
        this.setValue("orderchannel", bill.get("orderchannel"));
        this.setValue("budget", bill.get("budget"));
        this.setValue("number", bill.get("number"));
        this.setValue("begindate", bill.get("begindate"));
        this.setValue("enddate", bill.get("enddate"));
        this.setValue("reason", bill.get("reason"));
        this.setValue("currency", bill.get("currency"));
        this.setValue("billstatus", bill.get("billstatus"));
        this.setValue(TOTALAMOUNT, bill.get(TOTALAMOUNT));
        this.setValue(REIMBURSEWAY, bill.get(REIMBURSEWAY));
        this.setValue(ACCOUNTTYPE, bill.get(ACCOUNTTYPE));
        DynamicObjectCollection sourceEntries = bill.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection targetEntry = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject sourceEntry : sourceEntries) {
            DynamicObject newEntry = targetEntry.addNew();
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            List listFeEdits = entryGrid.getFieldEdits();
            entryGrid.getCollapseFields();
            for (FieldEdit fieldEdit : listFeEdits) {
                String key = fieldEdit.getKey();
                newEntry.set(key, sourceEntry.get(key));
            }
            newEntry.set("identry", sourceEntry.get("id"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "orderchannel": {
                this.customerChanged();
                this.setCurrency();
                this.beforeBudgetCompare();
                break;
            }
            case "billdate": 
            case "expensetype": 
            case "dept": {
                this.beforeBudgetCompare();
                break;
            }
            case "reimburseway": {
                String reimburseWay = (String)e.getChangeSet()[0].getNewValue();
                if (!StringUtils.equals((CharSequence)reimburseWay, (CharSequence)"A")) {
                    this.setValue("paymenthod", null);
                }
                if (StringUtils.equals((CharSequence)reimburseWay, (CharSequence)"B")) break;
                this.setValue(ACCOUNTTYPE, null);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "newenrty": {
                this.showEnrtyView(OperationStatus.ADDNEW);
                break;
            }
            case "deleteicon": {
                int row = this.getModel().getEntryCurrentRowIndex("entryentity");
                BigDecimal totalamount = this.setSubTotalamount(row);
                this.getModel().deleteEntryRow("entryentity", row);
                this.getModel().setValue(TOTALAMOUNT, (Object)totalamount);
                this.getView().updateView(TOTALAMOUNT);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            DynamicObject returnDataEntity = (DynamicObject)returnData;
            int row = this.getModel().createNewEntryRow("entryentity");
            this.setEntryCallBackValue(returnDataEntity, row);
            BigDecimal amount = returnDataEntity.getBigDecimal("amount");
            this.setValue(TOTALAMOUNT, this.getModel().getDataEntity().getBigDecimal(TOTALAMOUNT).add(amount));
            this.setHeadFiledBeginAndEndDate(returnDataEntity);
            this.updateViewOfHeadAndEntryFiled(row);
        }
    }

    public void updateViewOfHeadAndEntryFiled(int row) {
        this.getView().updateView(TOTALAMOUNT);
        this.getView().updateView("begindate");
        this.getView().updateView("enddate");
        this.getView().updateView("amount", row);
        this.getView().updateView("entrybegindate", row);
        this.getView().updateView("entryenddate", row);
    }

    private void setHeadFiledBeginAndEndDate(DynamicObject returnDataEntity) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        Date minDate = returnDataEntity.getDate("entrybegindate");
        Date maxDate = returnDataEntity.getDate("entryenddate");
        for (DynamicObject entry : entries) {
            Date entryBeginDate = entry.getDate("entrybegindate");
            Date entryEndDate = entry.getDate("entryenddate");
            if (minDate == null) {
                minDate = entryBeginDate;
            } else {
                Date date = minDate = entryBeginDate.compareTo(minDate) < 0 ? entryBeginDate : minDate;
            }
            if (maxDate == null) {
                maxDate = entryEndDate;
                continue;
            }
            maxDate = entryEndDate.compareTo(maxDate) > 0 ? entryEndDate : maxDate;
        }
        this.setValue("begindate", minDate);
        this.setValue("enddate", maxDate);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("marketcostid");
        switch (key) {
            case "save": {
                if (id == 0L) {
                    DynamicObject saveObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocmem_marketcost_apply"));
                    this.SetSaveObjectValue(dataEntity, saveObject);
                    Object pkValue = this.saveObject(saveObject);
                    this.getModel().setValue("marketcostid", pkValue);
                    this.setEntryId(pkValue);
                    this.dealWithAttachment(pkValue);
                    this.getView().updateView("entryentity.identry");
                    this.getView().updateView("marketcostid");
                } else {
                    DynamicObject loadObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ocmem_marketcost_apply");
                    this.setModifyObjectValue(dataEntity, loadObject);
                    this.saveObject(loadObject);
                    this.dealWithModifyAttachment(id);
                }
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f\u3002");
                break;
            }
            case "submit": {
                if (id == 0L) {
                    DynamicObject saveObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocmem_marketcost_apply"));
                    this.SetSaveObjectValue(dataEntity, saveObject);
                    Object pkValue = this.saveObject(saveObject);
                    this.getModel().setValue("marketcostid", pkValue);
                    this.dealWithAttachment(pkValue);
                    this.getView().updateView("marketcostid");
                    this.submitObject(pkValue);
                } else {
                    this.submitObject(id);
                }
                this.getModel().setValue("billstatus", (Object)"B");
                this.getView().showSuccessNotification("\u63d0\u4ea4\u6210\u529f\u3002");
            }
        }
    }

    private void setEntryId(Object pkValue) {
        DynamicObject OcmemBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"ocmem_marketcost_apply");
        DynamicObjectCollection entries = OcmemBill.getDynamicObjectCollection("entryentity");
        int size = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < size; ++i) {
            this.getModel().setValue("identry", ((DynamicObject)entries.get(i)).get("id"), i);
        }
    }

    private void SetSaveObjectValue(DynamicObject source, DynamicObject target) {
        if (source != null) {
            for (String str : headFiled) {
                target.set(str, source.get(str));
            }
            long deptId = source.getLong("dept_id");
            Long companyId = OrgUtil.initCompanyByDept((Long)deptId);
            if (companyId != null && companyId != 0L) {
                DynamicObject company = BusinessDataServiceHelper.loadSingle((Object)companyId, (String)"bos_adminorg");
                target.set("company", (Object)company);
            }
            long userId = RequestContext.get().getCurrUserId();
            target.set("creator_id", (Object)userId);
            target.set("execstatus", (Object)"A");
            DynamicObjectCollection entries = source.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection targetEntries = target.getDynamicObjectCollection("entryentity");
            DynamicObjectType type = targetEntries.getDynamicObjectType();
            if (entries != null && entries.size() > 0) {
                int size = entries.size();
                List<String> keys = this.getEntryFieldNameKeys();
                for (int i = 0; i < size; ++i) {
                    DynamicObject sourceEntry = (DynamicObject)entries.get(i);
                    DynamicObject targetEntry = new DynamicObject(type);
                    for (String str : keys) {
                        targetEntry.set(str, sourceEntry.get(str));
                    }
                    targetEntries.add((Object)targetEntry);
                }
            }
        }
    }

    private void dealWithAttachment(Object pkValue) {
        HashMap<String, List> attachmentMap = new HashMap<String, List>();
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List pageListMap = attachmentPanel.getAttachmentData();
        if (pageListMap != null && pageListMap.size() > 0) {
            attachmentMap.put("attachmentpanel", pageListMap);
            DynamicObjectCollection dynamicObjects = AttachmentServiceHelper.saveTempAttachments((String)"ocmem_marketcost_apply", (Object)pkValue, (String)"ocmem", attachmentMap);
            Map<String, DynamicObject> attachmentNameMap = dynamicObjects.stream().collect(Collectors.toMap(r -> r.getString("fattachmentname") + r.getString("fattachmentsize"), r -> r, (s1, s2) -> s1));
            for (Map map : pageListMap) {
                StringBuilder sb = new StringBuilder();
                sb.append(map.get("name"));
                sb.append(map.get("size"));
                String key = sb.toString();
                Object url = attachmentNameMap.get(key).get("ffileid");
                map.put("url", url);
            }
            AttachmentServiceHelper.upload((String)"ocmem_marketcost_apply", (Object)pkValue, (String)"attachmentpanel", (List)pageListMap);
        }
    }

    private void dealWithModifyAttachment(Object pkValue) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List pageListMap = attachmentPanel.getAttachmentData();
        List attachments = AttachmentServiceHelper.getAttachments((String)"ocmem_marketcost_apply", (Object)pkValue, (String)"attachmentpanel");
        for (Map map : attachments) {
            Object uid = map.get("uid");
            AttachmentServiceHelper.remove((String)"ocmem_marketcost_apply", (Object)pkValue, uid);
        }
        this.dealWithAttachment(pkValue);
    }

    private List<String> getEntryFieldNameKeys() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        List listFieldEdits = cardEntry.getFieldEdits();
        List<String> keys = listFieldEdits.stream().filter(r -> !r.getKey().equals("identry")).map(r -> r.getKey()).collect(Collectors.toList());
        return keys;
    }

    private void setModifyObjectValue(DynamicObject source, DynamicObject target) {
        if (source != null) {
            for (String str : headFiled) {
                target.set(str, source.get(str));
            }
        } else {
            return;
        }
        DynamicObjectCollection sourceEntries = source.getDynamicObjectCollection("entryentity");
        if (sourceEntries != null && sourceEntries.size() > 0) {
            DynamicObjectCollection targetEntries = target.getDynamicObjectCollection("entryentity");
            Set idSet = sourceEntries.stream().map(r -> r.getLong("identry")).collect(Collectors.toSet());
            Iterator iterator = targetEntries.iterator();
            while (iterator.hasNext()) {
                DynamicObject deleteObj = (DynamicObject)iterator.next();
                if (idSet.contains(deleteObj.get("id"))) continue;
                iterator.remove();
            }
            List<String> keys = this.getEntryFieldNameKeys();
            int targetsize = targetEntries.size();
            for (int i = 0; i < sourceEntries.size(); ++i) {
                DynamicObject targetEntry;
                DynamicObject sourceEntry = (DynamicObject)sourceEntries.get(i);
                if (i < targetsize) {
                    targetEntry = (DynamicObject)targetEntries.get(i);
                    for (String str : keys) {
                        targetEntry.set(str, sourceEntry.get(str));
                    }
                    continue;
                }
                targetEntry = targetEntries.addNew();
                for (String str : keys) {
                    targetEntry.set(str, sourceEntry.get(str));
                }
            }
        }
    }

    public Object saveObject(DynamicObject saveObj) {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(true));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)"ocmem_marketcost_apply", (DynamicObject[])new DynamicObject[]{saveObj}, (OperateOption)saveOption);
        if (!saveResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder("\u5e02\u573a\u8d39\u7528\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\uff1a");
            errMessage.append(saveResult.getMessage());
            for (IOperateInfo errInfo : saveResult.getAllErrorOrValidateInfo()) {
                errMessage.append(errInfo.getMessage());
            }
            throw new KDBizException(errMessage.toString());
        }
        return saveResult.getSuccessPkIds().get(0);
    }

    public void submitObject(Object pkValue) {
        OperateOption submitOption = OperateOption.create();
        submitOption.setVariableValue("ignorewarn", String.valueOf(true));
        submitOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        submitOption.setVariableValue("strictvalidation", String.valueOf(true));
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ocmem_marketcost_apply", (Object[])new Object[]{pkValue}, (OperateOption)submitOption);
        if (!submitResult.isSuccess()) {
            StringBuilder detailMessage = new StringBuilder("\u5e02\u573a\u8d39\u7528\u7533\u8bf7\u5355\u63d0\u4ea4\u5931\u8d25\uff1a");
            detailMessage.append(submitResult.getMessage());
            for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
                detailMessage.append(errInfo.getMessage());
            }
            throw new KDBizException(detailMessage.toString());
        }
    }

    private void setEntryCallBackValue(DynamicObject returnDataEntity, int row) {
        if (returnDataEntity != null) {
            List<String> keys = this.getEntryFieldNameKeys();
            for (String field : keys) {
                this.setValue(field, returnDataEntity.get(field), row);
            }
        }
    }

    public void useCodeRule() {
        DynamicObject DT = BusinessDataServiceHelper.newDynamicObject((String)"ocmem_marketcost_apply");
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)DT.getDataEntityType().getName(), (DynamicObject)DT, null);
        String billno = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)DT);
        this.getModel().setValue("billno", (Object)billno);
    }

    private void setNewCustomerFilter(BeforeF7SelectEvent arg) {
        String userId = RequestContext.get().getUserId();
        QFilter userFilter = new QFilter("sysuser", "=", (Object)Long.parseLong(userId));
        DynamicObject[] queryObjects = BusinessDataServiceHelper.load((String)"ocdbd_channeluser", (String)"id,owner", (QFilter[])new QFilter[]{userFilter});
        HashSet<Long> ids = new HashSet<Long>(queryObjects.length);
        if (queryObjects != null && queryObjects.length > 0) {
            for (DynamicObject eachone : queryObjects) {
                ids.add((Long)eachone.get("owner_id"));
            }
        }
        DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)"id,customer", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet<Long> idsFilter = new HashSet<Long>(channelObjects.length);
        for (DynamicObject eachone : channelObjects) {
            if (eachone.get("customer") == null) continue;
            idsFilter.add(eachone.getLong("id"));
        }
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        QFilter filter = new QFilter("id", "in", ids);
        list.add(filter);
        arg.setCustomQFilters(list);
    }

    private void customerChanged() {
        this.setSettleOrg(this.getF7Value("orderchannel"));
    }

    private void setSettleOrg(DynamicObject customerDynObj) {
        DynamicObject saleOrgDynObj;
        Map map;
        Object settleorgId = null;
        if (customerDynObj != null && !CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)(saleOrgDynObj = customerDynObj.getDynamicObject("saleorg")).getLong("id"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            settleorgId = map.get("id");
        }
        this.setValue("settleorgid", settleorgId);
    }

    private void setCurrency() {
        DynamicObject orderChannel = this.getF7Value("orderchannel");
        this.setValue("currency", orderChannel.get("currency"));
    }

    private void showEnrtyView(OperationStatus status) {
        Object orderChannel;
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_marketcost_entry");
        mobileBillShowParameter.setStatus(status);
        Object expensetype = this.getF7PKValue("expensetype");
        if (expensetype != null) {
            mobileBillShowParameter.setCustomParam("expensetypeId", (Object)String.valueOf(this.getF7PKValue("expensetype")));
        }
        if ((orderChannel = this.getF7PKValue("orderchannel")) != null) {
            mobileBillShowParameter.setCustomParam("orderchannel", (Object)String.valueOf(this.getF7PKValue("orderchannel")));
        }
        mobileBillShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocdma_marketcost_entry"));
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private BigDecimal setSubTotalamount(int row) {
        DynamicObject bill = this.getModel().getDataEntity();
        BigDecimal totalamount = bill.getBigDecimal(TOTALAMOUNT);
        DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", row);
        BigDecimal amount = entry.getBigDecimal("amount");
        return totalamount.subtract(amount);
    }

    public Boolean BudgetBalanceSheetCompare() {
        DynamicObject getAvailableAmount;
        this.getModel().setValue("budget", null);
        this.getModel().setValue("number", null);
        Boolean status = true;
        Date billdate = (Date)this.getModel().getValue("billdate");
        DynamicObject org = (DynamicObject)this.getModel().getValue("dept");
        DynamicObject expensetype = (DynamicObject)this.getModel().getValue("expensetype");
        DynamicObject orderchannel = (DynamicObject)this.getModel().getValue("orderchannel");
        BigDecimal totalamount = (BigDecimal)this.getModel().getValue(TOTALAMOUNT);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Boolean ifbudget = expensetype.getBoolean("ifbudget");
        Long orgId = org.getLong("id");
        Long channelId = orderchannel.getLong("id");
        if (!ifbudget.booleanValue()) {
            return true;
        }
        String control = expensetype.getString("control");
        if (!control.contains("1")) {
            orgId = 0L;
        }
        if (!control.contains("2")) {
            channelId = 0L;
        }
        if ((getAvailableAmount = BudgetCostsHelper.queryBudgetCostsInfo((long)orgId, (long)channelId, (long)currency.getLong("id"), (long)expensetype.getLong("id"), (Date)billdate)) == null) {
            return false;
        }
        BigDecimal availableamount = getAvailableAmount.getBigDecimal("availableamount");
        this.getModel().setValue("budget", (Object)availableamount);
        this.getModel().setValue("number", (Object)getAvailableAmount.getString("number"));
        if (availableamount.compareTo(totalamount) < 0) {
            status = false;
        }
        this.getView().updateView("budget");
        this.getView().updateView("number");
        return status;
    }

    private Boolean beforeBudgetCompare() {
        this.getModel().setValue("budget", (Object)BigDecimal.ZERO);
        Object billdate = this.getModel().getValue("billdate");
        Object org = this.getModel().getValue("dept");
        Object expensetype = this.getModel().getValue("expensetype");
        Object orderchannel = this.getModel().getValue("orderchannel");
        if (billdate != null && org != null && expensetype != null && orderchannel != null && ((DynamicObject)expensetype).getBoolean("ifbudget")) {
            return this.BudgetBalanceSheetCompare();
        }
        return true;
    }

    private boolean ifBudget() {
        DynamicObject expensetype = (DynamicObject)this.getModel().getValue("expensetype");
        Boolean ifbudget = expensetype.getBoolean("ifbudget");
        return ifbudget != false;
    }
}

