/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.marketcost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.memutil.OCMEMFilterUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class MarketCostApplyEntryPlugin
extends OcdmaFormMobPlugin
implements BeforeF7SelectListener {
    public static final String TOTALAMOUNT = "totalamount";
    public static final String SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"shop"});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String key;
        Object orderchannel = this.getView().getParentView().getModel().getValue("orderchannel");
        long orderchannelId = 0L;
        if (orderchannel != null) {
            orderchannelId = ((DynamicObject)orderchannel).getLong("id");
        }
        switch (key = arg.getProperty().getName()) {
            case "shop": {
                QFilter filter = new QFilter("parent", "=", (Object)orderchannelId);
                filter.and("enable", "=", (Object)"1");
                filter.and(this.getFilterChannels());
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg, (QFilter)filter);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MobileFormView mobile = (MobileFormView)e.getSource();
        String expensetypeId = (String)mobile.getFormShowParameter().getCustomParam("expensetypeId");
        DynamicObject expenseType = null;
        if (StringUtils.isNotBlank((CharSequence)expensetypeId)) {
            expenseType = BusinessDataServiceHelper.loadSingle((Object)expensetypeId, (String)"ocdbd_expensetype");
        }
        if (expenseType != null) {
            this.disPlayMarketCostEntry(expenseType);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isEdit()) {
            this.setModifyValue();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (key = e.getProperty().getName()) {
            case "price": 
            case "qty": {
                BigDecimal price = dataEntity.getBigDecimal("price");
                BigDecimal qty = dataEntity.getBigDecimal("qty");
                this.getModel().setValue("amount", (Object)price.multiply(qty));
                this.getView().updateView("amount");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                BigDecimal amount;
                long count;
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObject BillConfig;
                DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity();
                long expenseTypePk = parentDataEntity.getLong("expensetype_id");
                if (expenseTypePk <= 0L || (BillConfig = MarketCostApplyEntryPlugin.getBillConfigExpenseType(expenseTypePk)) == null || (dynamicObjectCollection = BillConfig.getDynamicObjectCollection("billconfigentry")) == null || dynamicObjectCollection.size() <= 0 || (count = dynamicObjectCollection.stream().filter(r -> r.getBoolean("isdisplay")).filter(r -> r.getDynamicObject("fieldname").getString("number").equals("amount")).count()) <= 0L || (amount = this.getModel().getDataEntity().getBigDecimal("amount")) != null && amount.compareTo(BigDecimal.ZERO) > 0) break;
                throw new KDBizException("\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                if (this.isAddNew()) {
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    this.getView().returnDataToParent((Object)dataEntity);
                } else if (this.isEdit()) {
                    this.setParentValue();
                }
                this.getView().close();
            }
        }
    }

    private void setModifyValue() {
        MobileFormView parentMobileFormView = (MobileFormView)this.getView().getParentView();
        IDataModel parentDataModel = parentMobileFormView.getModel();
        int row = parentDataModel.getEntryCurrentRowIndex("entryentity");
        DynamicObject enrty = parentDataModel.getEntryRowEntity("entryentity", row);
        DataEntityPropertyCollection properties = this.getView().getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String fieldName = property.getName();
            this.getModel().setValue(fieldName, enrty.get(fieldName));
        }
    }

    public Map<Object, Object> disPlayMarketCostEntry(DynamicObject expenseType) {
        DynamicObject BillConfig;
        List<String> filedStrList = this.getPropertyNames();
        for (String filed : filedStrList) {
            FieldEdit fielEdit = (FieldEdit)this.getView().getControl(filed);
            fielEdit.setVisible("", false);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object expensetypePk = expenseType.getPkValue();
        if (expensetypePk != null && (BillConfig = MarketCostApplyEntryPlugin.getBillConfigExpenseType(expensetypePk)) != null) {
            DynamicObjectCollection dynamicObjectCollection = BillConfig.getDynamicObjectCollection("billconfigentry");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObject fieldName = dynamicObject.getDynamicObject("fieldname");
                if (fieldName == null || !filedStrList.contains(fieldName.getString("number"))) continue;
                FieldEdit fe = (FieldEdit)this.getView().getControl(fieldName.getString("number"));
                fe.setVisible("", dynamicObject.getBoolean("isdisplay"));
                fe.setMustInput(dynamicObject.getBoolean("isrequired"));
                map.put(fieldName.get("number"), dynamicObject.getBoolean("isdisplay"));
            }
        }
        return map;
    }

    private List<String> getPropertyNames() {
        DataEntityPropertyCollection dataEntityPropertyCollection = this.getModel().getDataEntityType().getProperties();
        List<String> propertyNames = dataEntityPropertyCollection.stream().map(r -> r.getName()).filter(s -> !s.contains("_id")).collect(Collectors.toList());
        return propertyNames;
    }

    private void setParentValue() {
        MobileFormView parentMobileFormView = (MobileFormView)this.getView().getParentView();
        IDataModel parentDataModel = parentMobileFormView.getModel();
        int row = parentDataModel.getEntryCurrentRowIndex("entryentity");
        DynamicObject enrty = parentDataModel.getEntryRowEntity("entryentity", row);
        BigDecimal oldAmount = enrty.getBigDecimal("amount");
        BigDecimal totalamount = parentDataModel.getDataEntity().getBigDecimal(TOTALAMOUNT);
        BigDecimal newAmount = this.getModel().getDataEntity().getBigDecimal("amount");
        parentDataModel.setValue(TOTALAMOUNT, (Object)totalamount.subtract(oldAmount).add(newAmount));
        Date beginDate = this.getModel().getDataEntity().getDate("entrybegindate");
        Date endDate = this.getModel().getDataEntity().getDate("entryenddate");
        Date parentBeginDate = parentDataModel.getDataEntity().getDate("begindate");
        Date parentEndDate = parentDataModel.getDataEntity().getDate("enddate");
        if (beginDate != null && parentBeginDate != null && beginDate.compareTo(parentBeginDate) < 0) {
            parentDataModel.setValue("begindate", (Object)beginDate);
        }
        if (endDate != null && parentEndDate != null && endDate.compareTo(parentEndDate) > 0) {
            parentDataModel.setValue("enddate", (Object)endDate);
        }
        DataEntityPropertyCollection properties = this.getView().getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String fieldName = property.getName();
            enrty.set(fieldName, this.getModel().getValue(fieldName));
        }
        parentMobileFormView.updateView("entryentity");
    }

    public static DynamicObject getBillConfigExpenseType(Object expensetypePk) {
        String selectFields = "id,name,number,billconfigentry.fieldname,isdisplay,isrequired";
        QFilter[] qFilters = OCMEMFilterUtil.getQFilter((String)"expensetype", (Object)expensetypePk);
        DynamicObject[] expensetypes = BusinessDataServiceHelper.load((String)"ocdbd_billconfig", (String)selectFields, (QFilter[])qFilters);
        if (expensetypes.length > 0) {
            return expensetypes[0];
        }
        return null;
    }

    private QFilter getFilterChannels() {
        ArrayList<String> typeid = new ArrayList<String>(8);
        typeid.add("B");
        typeid.add("C");
        typeid.add("D");
        typeid.add("E");
        typeid.add("F");
        typeid.add("G");
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"ocdbd_channel_type", (String)"id", (QFilter[])new QFilter[]{new QFilter("typeid", "in", typeid)});
        List ids = Stream.of(dos).map(r -> r.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("channeltype", "in", ids);
        return filter;
    }
}

