/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.marketcost;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class MarketCostApplyList
extends OcbaseFormMobPlugin
implements ListRowClickListener,
MobileSearchTextChangeListener {
    private static final String SEARCH_AP = "search";
    private static final String STATUSSPAN = "statusspan";
    private static final String ORDERDATESPAN = "orderdatespan";
    private static final String BILLLISTAP = "billlistap";
    private static final String BILLDATE = "billdate";
    private static final String CUSTOMERBUTTON = "customerbutton";
    public static final String BT_NEW = "new";
    public static final String SUBMIT = "submit";
    public static final String UNSUBMIT = "unsubmit";
    public static final String DELETE = "delete";
    public static final String MODIFY = "modify";
    public static final String CLOSEBILL = "closebill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CUSTOMERBUTTON, BT_NEW, SUBMIT, UNSUBMIT, DELETE, MODIFY, CLOSEBILL});
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH_AP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        switch (key) {
            case "statusspan": {
                this.setButtonVisiableByStatus();
            }
            case "orderdatespan": {
                List<QFilter> tbFilters = this.getAllFilters();
                this.BillListRefresh(billList, tbFilters, null);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.orderByCustomer();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "customerbutton": {
                this.orderByCustomer();
                break;
            }
            case "new": {
                this.showNewBill();
                break;
            }
            case "submit": {
                this.doOperation(SUBMIT);
                this.getView().showSuccessNotification("\u63d0\u4ea4\u6210\u529f\u3002");
                break;
            }
            case "delete": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteItemCallBack", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"MarketCostApplyList_1", (String)"occ-ocdma-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Wait, confirmCallBacks);
                break;
            }
            case "unsubmit": {
                this.doOperation(UNSUBMIT);
                this.getView().showSuccessNotification("\u64a4\u9500\u6210\u529f\u3002");
                break;
            }
            case "modify": {
                this.validateStatus();
                this.showFormBill(OperationStatus.EDIT);
                break;
            }
            case "closebill": {
                this.doOperation(CLOSEBILL);
                this.getView().showSuccessNotification("\u5173\u95ed\u6210\u529f\u3002");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        boolean isYes = messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes);
        if (!isYes) {
            return;
        }
        switch (callBackId) {
            case "deleteItemCallBack": {
                this.doOperation(DELETE);
                this.getView().showSuccessNotification("\u5220\u9664\u6210\u529f\u3002");
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.showFormBill(OperationStatus.VIEW);
    }

    private void showNewBill() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_marketcost_add");
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void showFormBill(OperationStatus operationStatus) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Object billId = billList.getFocusRowPkId();
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setStatus(operationStatus);
        mobileBillShowParameter.setCustomParam("billId", (Object)String.valueOf(billId));
        mobileBillShowParameter.setFormId("ocdma_marketcost_add");
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void validateStatus() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
        String billStatus = listSelectedRow.getBillStatus();
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            throw new KDBizException("\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u4fee\u6539");
        }
    }

    public void orderByCustomer() {
        String asc = "orderchannel.name asc";
        String desc = "orderchannel.name desc";
        Control iconup = this.getView().getControl("iconup");
        Control icondowm = this.getView().getControl("icondowm");
        int ordernum = (Integer)this.getModel().getValue("ordernum");
        List<QFilter> tbFilters = this.getAllFilters();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (ordernum == 1) {
            MobileControlUtils.ControlSetFrontAndBackColor((Control)iconup, (String)"#16b0f1", null);
            MobileControlUtils.ControlSetFrontAndBackColor((Control)icondowm, (String)"#666666", null);
            this.BillListRefresh(billList, tbFilters, asc);
        } else if (ordernum == 2) {
            MobileControlUtils.ControlSetFrontAndBackColor((Control)iconup, (String)"#666666", null);
            MobileControlUtils.ControlSetFrontAndBackColor((Control)icondowm, (String)"#16b0f1", null);
            this.BillListRefresh(billList, tbFilters, desc);
        } else {
            MobileControlUtils.ControlSetFrontAndBackColor((Control)iconup, (String)"#666666", null);
            MobileControlUtils.ControlSetFrontAndBackColor((Control)icondowm, (String)"#666666", null);
            this.BillListRefresh(billList, tbFilters, "billdate desc, createtime desc");
        }
        ++ordernum;
        this.getModel().setValue("ordernum", (Object)(ordernum %= 3));
    }

    private QFilter getStatusFilter() {
        QFilter filter = null;
        String status = (String)this.getModel().getValue(STATUSSPAN);
        if (!StringUtils.equals((CharSequence)status, (CharSequence)"1") && !StringUtils.equals((CharSequence)status, (CharSequence)"H")) {
            filter = new QFilter("billstatus", "=", (Object)status);
        }
        return filter;
    }

    private QFilter getDateFilter() {
        String orderDate;
        QFilter filter = null;
        switch (orderDate = (String)this.getModel().getValue(ORDERDATESPAN)) {
            case "A": {
                filter = new QFilter(BILLDATE, ">=", (Object)DateUtil.getFirstDayOfWeek());
                filter.and(BILLDATE, "<=", (Object)DateUtil.getLastDayOfWeek());
                break;
            }
            case "B": {
                filter = new QFilter(BILLDATE, ">=", (Object)DateUtil.getFirstDayOfMonth());
                filter.and(BILLDATE, "<=", (Object)DateUtil.getLastDayOfMonth());
                break;
            }
            case "C": {
                filter = new QFilter(BILLDATE, ">", (Object)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(90L)));
            }
        }
        return filter;
    }

    private QFilter getTextSearchFilter() {
        MobileSearch search = (MobileSearch)this.getControl(SEARCH_AP);
        String searchText = search.getText();
        QFilter filter = null;
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno", "orderchannel.name"});
        }
        return filter;
    }

    private List<QFilter> getAllFilters() {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>(4);
        QFilter StatusFilter = this.getStatusFilter();
        QFilter DateFilter = this.getDateFilter();
        QFilter searchFilter = this.getTextSearchFilter();
        if (StatusFilter != null) {
            this.addFilter(tbFilters, StatusFilter);
        }
        if (DateFilter != null) {
            this.addFilter(tbFilters, DateFilter);
        }
        if (searchFilter != null) {
            this.addFilter(tbFilters, searchFilter);
        }
        this.addFilter(tbFilters, this.getLoginUserQFilter());
        return tbFilters;
    }

    public void BillListRefresh(BillList control, List<QFilter> tbFilters, String orderBy) {
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(tbFilters);
        if (orderBy != null && orderBy.length() > 0) {
            control.setOrderBy(orderBy);
        }
        control.setQueryFilterParameter(filterParameter);
        control.refresh();
    }

    private void addFilter(List<QFilter> tbFilters, QFilter filter) {
        if (filter != null) {
            tbFilters.add(filter);
        }
    }

    public void click(MobileSearchTextChangeEvent arg0) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        List<QFilter> tbFilters = this.getAllFilters();
        this.BillListRefresh(billList, tbFilters, null);
    }

    private void setButtonVisiableByStatus() {
        String status;
        switch (status = (String)this.getModel().getValue(STATUSSPAN)) {
            case "A": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SUBMIT, DELETE, MODIFY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{UNSUBMIT, "close"});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{UNSUBMIT});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SUBMIT, DELETE, MODIFY, "close"});
                break;
            }
            case "E": 
            case "F": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"close"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SUBMIT, DELETE, MODIFY, UNSUBMIT});
                break;
            }
            case "1": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SUBMIT, DELETE, MODIFY, UNSUBMIT, "close"});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SUBMIT, DELETE, MODIFY, UNSUBMIT, "close"});
            }
        }
        this.getView().updateView(SUBMIT);
        this.getView().updateView(DELETE);
        this.getView().updateView(MODIFY);
        this.getView().updateView(UNSUBMIT);
        this.getView().updateView("close");
    }

    private void doOperation(String operationKey) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Object billId = billList.getFocusRowPkId();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("strictvalidation", String.valueOf(true));
        OperationResult submitResult = null;
        String message = "";
        switch (operationKey) {
            case "submit": {
                submitResult = OperationServiceHelper.executeOperate((String)SUBMIT, (String)"ocmem_marketcost_apply", (Object[])new Object[]{billId}, (OperateOption)option);
                message = "\u63d0\u4ea4";
                break;
            }
            case "unsubmit": {
                submitResult = OperationServiceHelper.executeOperate((String)UNSUBMIT, (String)"ocmem_marketcost_apply", (Object[])new Object[]{billId}, (OperateOption)option);
                message = "\u64a4\u9500";
                break;
            }
            case "delete": {
                submitResult = OperationServiceHelper.executeOperate((String)DELETE, (String)"ocmem_marketcost_apply", (Object[])new Object[]{billId}, (OperateOption)option);
                message = "\u5220\u9664";
                break;
            }
            case "closebill": {
                submitResult = OperationServiceHelper.executeOperate((String)CLOSEBILL, (String)"ocmem_marketcost_apply", (Object[])new Object[]{billId}, (OperateOption)option);
                message = "\u5173\u95ed";
            }
        }
        if (submitResult != null && !submitResult.isSuccess()) {
            StringBuilder detailMessage = new StringBuilder();
            detailMessage.append("\u5e02\u573a\u8d39\u7528\u7533\u8bf7\u5355");
            detailMessage.append(message);
            detailMessage.append("\u5931\u8d25\uff1a");
            if (submitResult.getMessage() != null && submitResult.getMessage().length() > 0) {
                detailMessage.append(submitResult.getMessage());
            }
            for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
                detailMessage.append(errInfo.getMessage());
            }
            throw new KDBizException(detailMessage.toString());
        }
        billList.refresh();
    }

    private QFilter getLoginUserQFilter() {
        long channelId = B2BUserHelper.getLoginChannelId();
        QFilter Qfilter = new QFilter("orderchannel", "=", (Object)channelId);
        return Qfilter;
    }
}

