/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.mine;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class MinePlugin
extends OcdmaFormMobPlugin
implements BeforeF7SelectListener {
    private static final String F_channelid = "channelid";
    private static final String F_supplierid = "supplierid";
    private static final String op_moreorder = "tp_all";
    private static final String op_unreceiveorder = "d";
    private static final String op_unshipoder = "c";
    private static final String op_submitorder = "b";
    private static final String op_logout = "logout";
    private static final String OCDMA_SALEORDER_LIST = "ocdma_saleorder_list";

    public void afterCreateNewData(EventObject e) {
        this.initUser();
        long channelId = B2BUserHelper.getLoginChannelId();
        this.setValue(F_channelid, channelId, false);
        long supplyRelationId = this.getChannelAuthorize();
        if (supplyRelationId != 0L) {
            this.setValue(F_supplierid, supplyRelationId, false);
        }
        this.initOrder();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{F_channelid, F_supplierid});
        this.addClickListeners(new String[]{op_moreorder, op_unreceiveorder, op_unshipoder, op_submitorder, op_logout});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "tp_all": 
            case "b": 
            case "d": 
            case "c": {
                IFormView parentView = this.getView().getParentView();
                MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
                mobileBillShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                mobileBillShowParameter.getOpenStyle().setTargetKey("show");
                mobileBillShowParameter.setFormId(OCDMA_SALEORDER_LIST);
                mobileBillShowParameter.setCustomParam("opkey", (Object)key);
                parentView.showForm((FormShowParameter)mobileBillShowParameter);
                String currKey = "saleorder";
                String selectedKey = "mine";
                parentView.setVisible(Boolean.FALSE, new String[]{currKey, selectedKey + "_s"});
                parentView.setVisible(Boolean.TRUE, new String[]{currKey + "_s", selectedKey});
                IDataModel parentViewModel = parentView.getModel();
                parentViewModel.setValue("selectedindex", (Object)"saleorder");
                this.getView().sendFormAction(parentView);
                break;
            }
            case "logout": {
                this.logout(this.getView().getParentView().getEntityId());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channelid": {
                List channelIds = CUserHelper.getAuthorizedChannelIdList();
                ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
                filters.add(new QFilter("id", "in", (Object)channelIds));
                filters.add(new QFilter("enable", "=", (Object)Checked.YES.toString()));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, filters);
                break;
            }
            case "supplierid": {
                Object chanel = this.getModel().getValue(F_channelid);
                if (chanel == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u6e20\u9053\u3002", (String)"MinePlugin_0", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("orderchannel", "=", (Object)((DynamicObject)chanel).getLong("id"));
                filter.and(new QFilter("enable", "=", (Object)"1"));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = true;
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "channelid": {
                if (newValue != null) {
                    long orderChannelId = ((DynamicObject)newValue).getLong("id");
                    long supplierId = 0L;
                    QFilter filter = new QFilter("orderchannel", "=", (Object)orderChannelId);
                    filter.and("enable", "=", (Object)Checked.YES.toString());
                    String params = String.join((CharSequence)",", "id", "salechannel", "saleorg");
                    DynamicObject[] channelAuthArray = BusinessDataServiceHelper.load((String)"ocdbd_channel_authorize", (String)params, (QFilter[])filter.toArray(), (String)"isdefault desc ");
                    if (channelAuthArray != null && channelAuthArray.length != 0) {
                        supplierId = (Long)channelAuthArray[0].get("id");
                    }
                    if (supplierId != 0L) {
                        this.setValue(F_supplierid, supplierId, false);
                    } else {
                        this.setValue(F_supplierid, null, false);
                    }
                    B2BUserHelper.updateLoginInfo((long)orderChannelId, (long)supplierId);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u6e20\u9053\u3002", (String)"MinePlugin_1", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
                break;
            }
            case "supplierid": {
                Object f7Value = this.getF7PKValue(F_channelid);
                if (f7Value == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f53\u524d\u6e20\u9053\u3002", (String)"MinePlugin_0", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (newValue == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u65b9\u3002", (String)"MinePlugin_2", (String)"occ-ocdma-formplugin", (Object[])new Object[0]));
                    return;
                }
                long orderChannelId = (Long)f7Value;
                long supplierId = ((DynamicObject)newValue).getLong("id");
                B2BUserHelper.updateLoginInfo((long)orderChannelId, (long)supplierId);
                break;
            }
        }
    }
}

