/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Label;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.b2b.AuxptyHelper;
import kd.occ.ocbase.common.entity.b2b.Auxpty;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class DeliveryDetailMobPlugin
extends OcdmaFormMobPlugin {
    public void afterCreateNewData(EventObject e) {
        String billIdStr = (String)this.getView().getFormShowParameter().getCustomParam("billid");
        if (StringUtils.isNotNull((String)billIdStr)) {
            DynamicObject delivery = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(billIdStr), (String)"ocbsoc_delivery_record");
            this.getModel().setValue("billno", delivery.get("billno"));
            this.getModel().setValue("deliverdate", delivery.get("deliverdate"));
            this.getModel().setValue("owner", delivery.get("owner"));
            String billStatus = this.getBillStatus4View(delivery.get("billstatus"));
            MobileControlUtils.LabelSetValue((Label)((Label)this.getControl("billstatus")), (Object)billStatus);
            BigDecimal totalQty = BigDecimal.ZERO;
            DynamicObjectCollection entryList = delivery.getDynamicObjectCollection("deliverydetail");
            if (entryList != null && !entryList.isEmpty()) {
                int[] rowIndexes = this.getModel().batchCreateNewEntryRow("deliverydetail", entryList.size());
                for (int i = 0; i < entryList.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryList.get(i);
                    int rowIndex = rowIndexes[i];
                    DynamicObject item = entry.getDynamicObject("item");
                    if (item == null) continue;
                    this.setValue("item", item, rowIndex);
                    this.setValue("unit", entry.get("unit"), rowIndex);
                    this.setValue("deliverqty", entry.get("deliverqty"), rowIndex);
                    long auxptyId = entry.getLong("auxpty_id");
                    String auxpty = "-";
                    if (auxptyId != 0L) {
                        Auxpty auxptyInfo = AuxptyHelper.getAuxptyName((long)auxptyId);
                        auxpty = auxptyInfo.getAuxptyName();
                    }
                    this.setValue("auxpty_value", auxpty, rowIndex);
                    totalQty = totalQty.add(entry.getBigDecimal("deliverqty"));
                    DynamicObject itemDynObj = this.getEntryF7Value("deliverydetail", "item", rowIndex);
                    if (itemDynObj != null) {
                        this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex);
                    }
                    boolean enableserial = item.getBoolean("enableserial");
                    this.setValue("enableserial", enableserial, rowIndex);
                    DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
                    if (CollectionUtils.isEmpty((Collection)subentryentity)) continue;
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject subentry : subentryentity) {
                        String serialnumber = subentry.getString("serialnumber");
                        if (sb.length() > 0) {
                            sb.append("\r\n");
                        }
                        sb.append(serialnumber);
                    }
                    this.setValue("mulserialnumber", sb.toString(), rowIndex);
                }
            }
            this.getModel().setValue("totalqty", (Object)totalQty.stripTrailingZeros().toPlainString());
        }
        super.afterCreateNewData(e);
    }

    private String getBillStatus4View(Object v) {
        String billStatus = "";
        if (v == null) {
            return "\u5f02\u5e38\u5355\u636e";
        }
        switch (v.toString()) {
            case "A": {
                billStatus = "\u5f85\u53d1\u8d27";
                break;
            }
            case "B": {
                billStatus = "\u5f85\u7b7e\u6536";
                break;
            }
            case "C": {
                billStatus = "\u5df2\u7b7e\u6536";
                break;
            }
            case "D": {
                billStatus = "\u90e8\u5206\u7b7e\u6536";
                break;
            }
        }
        return billStatus;
    }
}

