/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class DeliveryServiceMobList
extends OcdmaFormMobPlugin
implements TabSelectListener,
MobileSearchTextChangeListener {
    private static final String SEARCHAP = "searchap";
    private static final String BILLLISTAP = "billlistap";
    private static final String TABAP = "tabap";
    private static final String TAB_NOTDELIVERY = "tab_notdelivery";
    private static final String TAB_DELIVERY = "tab_delivery";
    private static final String OP_CANCELCONFIRM = "cancelconfirm";
    private static final String OP_CONFIRMDELIVERY = "confirmdelivery";

    public void registerListener(EventObject e) {
        this.addTabSelectListener(this, new String[]{TABAP});
        MobileSearch search = (MobileSearch)this.getControl(SEARCHAP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getControl(TABAP);
        tab.selectTab(TAB_NOTDELIVERY);
        tab.activeTab(TAB_NOTDELIVERY);
        this.refreshBillList();
        super.afterCreateNewData(e);
    }

    public void click(MobileSearchTextChangeEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "searchap": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getListFilter()});
    }

    private QFilter getListFilter() {
        QFilter filter = new QFilter("distributionchannelid", "=", (Object)B2BUserHelper.getLoginChannelId());
        Tab tab = (Tab)this.getControl(TABAP);
        String curTab = tab.getCurrentTab();
        if (TAB_NOTDELIVERY.equals(curTab)) {
            filter.and("distributionstatus", "=", (Object)"1");
        } else if (TAB_DELIVERY.equals(curTab)) {
            filter.and("distributionstatus", "=", (Object)"2");
        }
        MobileSearch search = (MobileSearch)this.getControl(SEARCHAP);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno"}));
        }
        return filter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "cancelconfirm": 
            case "confirmdelivery": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                Object id = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                OperateOption operateOption = CommonUtils.getOperateOption();
                OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)"ocbsoc_delivery_record", (Object[])new Object[]{id}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                this.refreshBillList();
                break;
            }
        }
        super.afterDoOperation(args);
    }
}

