/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class DeliverySignMobList
extends OcdmaFormMobPlugin
implements TabSelectListener,
MobileSearchTextChangeListener,
ListRowClickListener,
CreateListDataProviderListener {
    private static final String SEARCHAP = "searchap";
    private static final String BILLLISTAP = "billlistap";
    private static final String TABAP = "tabap";
    private static final String TAB_NOTSIGN = "tab_notsign";
    private static final String TAB_SIGN = "tab_sign";
    private static final String OP_COMPLETESIGN = "completesign";
    private static final String OP_ITEMSIGN = "itemsign";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void registerListener(EventObject e) {
        this.addTabSelectListener(this, new String[]{TABAP});
        MobileSearch search = (MobileSearch)this.getControl(SEARCHAP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getControl(TABAP);
        tab.selectTab(TAB_NOTSIGN);
        tab.activeTab(TAB_NOTSIGN);
        this.refreshBillList();
        super.afterCreateNewData(e);
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Object billid = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId("ocdma_deliverydetail");
        mobileFormShowParameter.setCustomParam("billid", (Object)billid.toString());
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        super.listRowClick(evt);
    }

    public void click(MobileSearchTextChangeEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "searchap": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getListFilter()});
    }

    private QFilter getListFilter() {
        QFilter filter = new QFilter("customer", "=", (Object)B2BUserHelper.getLoginChannelId());
        filter.or(new QFilter("receivechannelid", "=", (Object)B2BUserHelper.getLoginChannelId()));
        Tab tab = (Tab)this.getControl(TABAP);
        String curTab = tab.getCurrentTab();
        if (TAB_NOTSIGN.equals(curTab)) {
            filter.and("billstatus", "in", (Object)new String[]{"B", "D"});
        } else if (TAB_SIGN.equals(curTab)) {
            filter.and("billstatus", "in", (Object)new String[]{"C"});
        }
        MobileSearch search = (MobileSearch)this.getControl(SEARCHAP);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno"}));
        }
        return filter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "completesign": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                Object id = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                OperateOption operateOption = CommonUtils.getOperateOption();
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocbsoc_delivery_record");
                DynamicObject[] deliveryDataArray = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (DynamicObjectType)type);
                operateOption.setVariableValue(OP_COMPLETESIGN, "true");
                OperationResult result = OperationServiceHelper.executeOperate((String)"sign", (String)"ocbsoc_delivery_record", (DynamicObject[])deliveryDataArray, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                } else {
                    this.getView().showSuccessNotification(String.format("\u5355\u636e:%s\uff0c\u7b7e\u6536\u6210\u529f", deliveryDataArray[0].getString("billno")));
                }
                this.refreshBillList();
                break;
            }
            case "itemsign": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                Object id = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileFormShowParameter.setFormId("ocdma_saleorder_sign");
                mobileFormShowParameter.setCustomParam("deliveryid", (Object)id.toString());
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_ITEMSIGN));
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
        }
        super.afterDoOperation(args);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs evt) {
        evt.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    if (row.getDynamicObject("owner") == null) {
                        row.set("remark", (Object)row.getString("saleorgid.name"));
                        continue;
                    }
                    row.set("remark", (Object)row.getString("owner.name"));
                }
                return rows;
            }
        });
    }
}

