/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class PromotionPresentEdit
extends OcdmaFormMobPlugin {
    private static final String BTNOK = "btnok";
    private static final String ADD = "add";
    private static final String REDUCE = "reduce";
    private static final String FIRST_RESULT_GROUP_INDEX = "firstResultGroupIndex";
    private static final String FIRST_PRESENT_GROUP_INDEX = "firstPresentGroupIndex";
    private static final String RESULT_GROUP_AMOUNT = "result_group_amount";
    private static final String PRESENT_GROUP_AMOUNT = "present_group_amount";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, ADD, REDUCE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        JSONArray presentJsonArray = (JSONArray)fsp.getCustomParam("presentDynObjList");
        if (presentJsonArray != null) {
            DynamicObjectCollection entryColl = this.getView().getModel().getEntryEntity("entryentity");
            entryColl.clear();
            Map<String, List<Object>> presentJsonObjMap = presentJsonArray.stream().collect(Collectors.groupingBy(obj -> this.getPresentGroupNoKey((JSONObject)obj)));
            List presentJsonObjList = presentJsonArray.stream().sorted(Comparator.comparingInt(jsonObj -> ((JSONObject)jsonObj).getInteger("resultseq")).thenComparingLong(jsonObj -> this.getBaseDataId((JSONObject)jsonObj, "presentgroupno"))).collect(Collectors.toList());
            int seq = 1;
            for (Object obj2 : presentJsonObjList) {
                JSONObject jsonObj2 = (JSONObject)obj2;
                DynamicObject entryDynObj = new DynamicObject(entryColl.getDynamicObjectType());
                this.setEntryDynObj(entryDynObj, jsonObj2);
                entryDynObj.set("rowseq", (Object)seq);
                List<Object> list = presentJsonObjMap.get(this.getPresentGroupNoKey(jsonObj2));
                if (list != null && list.size() == 1) {
                    entryDynObj.set("presentqty", jsonObj2.get((Object)"presentqty"));
                }
                entryColl.add((Object)entryDynObj);
                ++seq;
            }
            BusinessDataServiceHelper.loadRefence((Object[])entryColl.toArray(), (IDataEntityType)entryColl.getDynamicObjectType());
            Map<String, List<DynamicObject>> presentGroupNoMap = entryColl.stream().collect(Collectors.groupingBy(this::getPresentGroupNoKey));
            for (Map.Entry<String, List<DynamicObject>> entry : presentGroupNoMap.entrySet()) {
                List list;
                List<DynamicObject> dynObjList = entry.getValue();
                long betweenGroupTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dynObjList.get(0), (String)"betweengrouptype");
                if (1102930993175991296L != betweenGroupTypeId || (list = dynObjList.stream().filter(obj -> obj.getBigDecimal("presentprice").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList())).size() != 0) continue;
                for (DynamicObject entryDynObj : dynObjList) {
                    entryDynObj.set("isselect", (Object)true);
                }
            }
            this.setGroupAmount();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryColl = this.getView().getModel().getEntryEntity("entryentity");
        if (!CommonUtils.isNull((Object)entryColl)) {
            CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
            Map<String, List<Integer>> firstIndex = this.getFirstIndex();
            List<Integer> firstResultGroupIndex = firstIndex.get(FIRST_RESULT_GROUP_INDEX);
            List<Integer> firstPresentGroupIndex = firstIndex.get(FIRST_PRESENT_GROUP_INDEX);
            for (DynamicObject entryDynObj : entryColl) {
                int rowIndex = entryDynObj.getInt("rowseq") - 1;
                if (firstResultGroupIndex.contains(rowIndex)) {
                    cardEntry.setChildVisible(true, rowIndex, new String[]{"result_group"});
                    cardEntry.setChildVisible(true, rowIndex, new String[]{"group_flex"});
                } else {
                    cardEntry.setChildVisible(false, rowIndex, new String[]{"result_group"});
                    cardEntry.setChildVisible(false, rowIndex, new String[]{"group_flex"});
                }
                if (firstPresentGroupIndex.contains(rowIndex)) {
                    cardEntry.setChildVisible(true, rowIndex, new String[]{"present_group"});
                } else {
                    cardEntry.setChildVisible(false, rowIndex, new String[]{"present_group"});
                }
                long inGroupTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"ingrouptype");
                if (1102930547782602752L == inGroupTypeId) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"presentqty"});
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), rowIndex, new String[]{ADD});
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), rowIndex, new String[]{REDUCE});
                    continue;
                }
                boolean isSelect = entryDynObj.getBoolean("isselect");
                this.getView().setEnable(Boolean.valueOf(isSelect), rowIndex, new String[]{"presentqty"});
                cardEntry.setChildVisible(isSelect, rowIndex, new String[]{ADD});
                cardEntry.setChildVisible(isSelect, rowIndex, new String[]{REDUCE});
                boolean isRed = entryDynObj.getBigDecimal("presentqty").compareTo(BigDecimal.ZERO) == 0;
                this.setPresentQtyCellBackColor(cardEntry, isSelect && isRed, rowIndex);
            }
            Map<String, List<DynamicObject>> presentGroupNoMap = entryColl.stream().collect(Collectors.groupingBy(this::getPresentGroupNoKey));
            for (Map.Entry<String, List<DynamicObject>> entry : presentGroupNoMap.entrySet()) {
                List<DynamicObject> dynObjList = entry.getValue();
                int size = dynObjList.size();
                for (int i = 1; i < size; ++i) {
                    this.getView().setEnable(Boolean.FALSE, dynObjList.get(i).getInt("rowseq") - 1, new String[]{"isselect"});
                }
            }
        }
    }

    private void setEntryDynObj(DynamicObject entryDynObj, JSONObject jsonObj) {
        entryDynObj.set("promotionpolicyid_id", (Object)this.getBaseDataId(jsonObj, "promotionpolicyid"));
        entryDynObj.set("promotiongroupno", (Object)jsonObj.getInteger("resultseq"));
        entryDynObj.set("itemid_id", (Object)this.getBaseDataMasterId(jsonObj, "itemid_p"));
        if (jsonObj.get((Object)"itemid_p") != null && jsonObj.getJSONObject("itemid_p") != null && jsonObj.getJSONObject("itemid_p").get((Object)"thumbnail") != null) {
            entryDynObj.set("thumbnail", jsonObj.getJSONObject("itemid_p").get((Object)"thumbnail"));
        }
        entryDynObj.set("materialid_id", (Object)this.getBaseDataMasterId(jsonObj, "materialid_p"));
        entryDynObj.set("unitid_id", (Object)this.getBaseDataMasterId(jsonObj, "unitid_p"));
        entryDynObj.set("auxptyid_id", (Object)this.getBaseDataId(jsonObj, "auxptyid_p"));
        entryDynObj.set("presentsumamount", jsonObj.get((Object)"presentsumamount"));
        entryDynObj.set("promotionentryid", jsonObj.get((Object)"id"));
        entryDynObj.set("presentgroupno_id", (Object)this.getBaseDataMasterId(jsonObj, "presentgroupno"));
        long betweenGroupTypeId = this.getBaseDataMasterId(jsonObj, "betweengrouptype");
        entryDynObj.set("betweengrouptype_id", (Object)betweenGroupTypeId);
        long inGroupTypdId = this.getBaseDataMasterId(jsonObj, "ingrouptype");
        entryDynObj.set("ingrouptype_id", (Object)inGroupTypdId);
        entryDynObj.set("presentprice", jsonObj.get((Object)"presentprice"));
        if (1102930547782602752L == inGroupTypdId) {
            entryDynObj.set("presentqty", jsonObj.get((Object)"presentqty"));
        } else {
            entryDynObj.set("presentsumqty", jsonObj.get((Object)"presentqty"));
        }
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (key = source.getKey()) {
            case "add": {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("presentqty", index);
                qty = qty.add(BigDecimal.ONE);
                this.getModel().setValue("presentqty", (Object)qty, index);
                break;
            }
            case "reduce": {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("presentqty", index);
                qty = qty.subtract(BigDecimal.ONE);
                this.getModel().setValue("presentqty", (Object)qty, index);
                break;
            }
            case "btnok": {
                DynamicObjectCollection entryColl = this.getView().getModel().getEntryEntity("entryentity");
                JSONArray jsonArray = new JSONArray(10);
                if (!CommonUtils.isNull((Object)entryColl)) {
                    Set selectIndexSet = entryColl.stream().filter(obj -> obj.getBoolean("isselect")).map(obj -> obj.getInt("rowseq") - 1).collect(Collectors.toSet());
                    int[] selectedRows = selectIndexSet.stream().mapToInt(Integer::valueOf).toArray();
                    StringBuilder strBilder = this.verifyPresentData(entryColl, selectedRows);
                    if (strBilder.length() > 0) {
                        this.getView().showTipNotification(strBilder.toString());
                        return;
                    }
                    for (int rowIndex : selectedRows) {
                        JSONObject returnData = new JSONObject(2);
                        DynamicObject entryDynObj = (DynamicObject)entryColl.get(rowIndex);
                        returnData.put("promotionentryid", entryDynObj.get("promotionentryid"));
                        returnData.put("presentqty", entryDynObj.get("presentqty"));
                        returnData.put("presentsumamount", entryDynObj.get("presentsumamount"));
                        jsonArray.add((Object)returnData);
                    }
                }
                if (jsonArray.size() == 0) {
                    JSONObject returnData = new JSONObject(1);
                    returnData.put("promotionentryid", (Object)0);
                    jsonArray.add((Object)returnData);
                }
                this.getView().returnDataToParent((Object)jsonArray);
                this.getView().close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        switch (key) {
            case "presentqty": {
                BigDecimal presentPrice = this.getNullToZero("presentprice", rowIndex);
                FormShowParameter fsp = this.getView().getFormShowParameter();
                int amountprecision = (Integer)fsp.getCustomParam("amountprecision");
                BigDecimal qty = this.getNullToZero("presentqty", rowIndex);
                BigDecimal taxAmount = qty.multiply(presentPrice).setScale(amountprecision, 4);
                this.setValue("presentsumamount", taxAmount, rowIndex);
                boolean red = qty.compareTo(BigDecimal.ZERO) == 0;
                boolean select = this.getBooleanValue("isselect", rowIndex);
                this.setPresentQtyCellBackColor(select && red, rowIndex);
                this.setGroupAmount();
                break;
            }
            case "isselect": {
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
                DynamicObject entryDynObj = (DynamicObject)entryColl.get(rowIndex);
                boolean isSelect = this.getBooleanValue("isselect", rowIndex);
                long betweenGroupTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"betweengrouptype");
                List presentList = entryColl.stream().filter(obj -> this.getPresentGroupNoKey(entryDynObj).equals(this.getPresentGroupNoKey((DynamicObject)obj))).filter(obj -> obj.getBigDecimal("presentprice").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
                if (1102930993175991296L == betweenGroupTypeId && presentList.size() == 0) {
                    if (!isSelect) {
                        this.setValue("isselect", true, rowIndex, false);
                    }
                    return;
                }
                this.setSelectPresentByGroupNoIndex(entryColl, this.getBooleanValue("isselect", rowIndex), rowIndex);
                long inGroupTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"ingrouptype");
                if (1102930620486668288L != inGroupTypeId) break;
                this.getView().setEnable(Boolean.valueOf(isSelect), rowIndex, new String[]{"presentqty"});
                cardEntry.setChildVisible(isSelect, rowIndex, new String[]{ADD});
                cardEntry.setChildVisible(isSelect, rowIndex, new String[]{REDUCE});
                boolean isRed = entryDynObj.getBigDecimal("presentqty").compareTo(BigDecimal.ZERO) == 0;
                this.setPresentQtyCellBackColor(isSelect && isRed, rowIndex);
                break;
            }
        }
    }

    private StringBuilder verifyPresentData(DynamicObjectCollection entryColl, int[] selectedRows) {
        StringBuilder strBilder = new StringBuilder();
        if (selectedRows.length == 0) {
            Map<String, List<DynamicObject>> presentGroupNoMap = entryColl.stream().collect(Collectors.groupingBy(obj -> this.getPresentGroupNoKey((DynamicObject)obj)));
            Map<String, List<DynamicObject>> pricePresentGroupNoMap = entryColl.stream().filter(obj -> obj.getBigDecimal("presentprice").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.groupingBy(obj -> this.getPresentGroupNoKey((DynamicObject)obj)));
            int size = pricePresentGroupNoMap.size();
            if (size == 0 || presentGroupNoMap.size() != size) {
                strBilder.append("\u8bf7\u81f3\u5c11\u52fe\u90091\u4e2a\u8d60\u54c1\u7ec4\u3002");
            }
        } else {
            HashSet<Integer> inTypeRowIndexSet = new HashSet<Integer>(10);
            ArrayList<DynamicObject> selectPresentDynObjList = new ArrayList<DynamicObject>(10);
            for (int selectRow : selectedRows) {
                if (!inTypeRowIndexSet.contains(selectRow + 1)) {
                    strBilder.append(this.verifyInGroupType(entryColl, selectRow, inTypeRowIndexSet));
                }
                selectPresentDynObjList.add((DynamicObject)entryColl.get(selectRow));
            }
            strBilder.append(this.verifyBetweenGroupType(selectPresentDynObjList));
        }
        return strBilder;
    }

    private String verifyInGroupType(DynamicObjectCollection entryColl, int selectRowIndex, Set<Integer> rowIndexSet) {
        String msg = "";
        DynamicObject presentDynObj = (DynamicObject)entryColl.get(selectRowIndex);
        long inGroupTypeId = DynamicObjectUtils.getPkValue((DynamicObject)presentDynObj, (String)"ingrouptype");
        if (1102930620486668288L == inGroupTypeId) {
            String noKey = this.getPresentGroupNoKey(presentDynObj);
            List detailPresentList = entryColl.stream().filter(obj -> noKey.equals(this.getPresentGroupNoKey((DynamicObject)obj))).collect(Collectors.toList());
            BigDecimal sumQty = this.getNullToZero("presentsumqty", selectRowIndex);
            BigDecimal allPresentQty = detailPresentList.stream().map(obj -> obj.getBigDecimal("presentqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List seqList = detailPresentList.stream().map(obj -> obj.getInt("rowseq")).collect(Collectors.toList());
            rowIndexSet.addAll(seqList);
            String promotionGroupNo = ((DynamicObject)detailPresentList.get(0)).getString("promotiongroupno");
            String presentGroupNo = ((DynamicObject)detailPresentList.get(0)).getString("presentgroupno.number");
            if (sumQty.compareTo(allPresentQty) < 0) {
                msg = MessageFormat.format("\u5728\u7ed3\u679c\u7ec4{0}\u7684\u8d60\u54c1\u5305{1}\u4e2d,\u540c\u7ed3\u679c\u7ec4\u4e0b\u540c\u4e00\u4e2a\u8d60\u54c1\u5305\u4e2d\u7684\u6307\u5b9a\u660e\u7ec6\u6570\u91cf\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u6307\u5b9a\u5408\u8ba1\u603b\u6570\u91cf\u3002", promotionGroupNo, presentGroupNo);
            } else if (BigDecimal.ZERO.compareTo(allPresentQty) >= 0) {
                msg = MessageFormat.format("\u5728\u7ed3\u679c\u7ec4{0}\u7684\u8d60\u54c1\u5305{1}\u4e2d,\u540c\u7ed3\u679c\u7ec4\u4e0b\u7684\u540c\u4e00\u4e2a\u8d60\u54c1\u5305\u7684\u6307\u5b9a\u660e\u7ec6\u6570\u91cf\u52a0\u8d77\u6765\u5fc5\u987b\u5927\u4e8e0\u3002", promotionGroupNo, presentGroupNo);
            }
        }
        return msg;
    }

    private String verifyBetweenGroupType(List<DynamicObject> selectPresentDynObjList) {
        Map<Long, List<DynamicObject>> selectPresentDynObjMap = selectPresentDynObjList.stream().filter(obj -> DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"betweengrouptype") != 1102930993175991296L).collect(Collectors.groupingBy(obj -> DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"betweengrouptype")));
        String msg = "";
        for (Map.Entry<Long, List<DynamicObject>> entry : selectPresentDynObjMap.entrySet()) {
            List<DynamicObject> dynObjList = entry.getValue();
            Map<String, List<DynamicObject>> promotionGroupNoMap = dynObjList.stream().collect(Collectors.groupingBy(obj -> this.getPromotionGroupNoKey((DynamicObject)obj)));
            long key = entry.getKey();
            for (Map.Entry<String, List<DynamicObject>> mapEntry : promotionGroupNoMap.entrySet()) {
                List<DynamicObject> promotionGroupDynObjList = mapEntry.getValue();
                long size = promotionGroupDynObjList.stream().map(obj -> this.getPresentGroupNoKey((DynamicObject)obj)).distinct().count();
                if (!(key == 1102931071542367232L && size > 1L || key == 1102931183597146112L && size > 2L || key == 1102931251427677184L && size > 3L || key == 1102931317823262720L && size > 4L) && (key != 1102931412899992576L || size <= 5L)) continue;
                String promotionGroupNo = promotionGroupDynObjList.get(0).getString("promotiongroupno");
                msg = MessageFormat.format("\u7ed3\u679c\u7ec4{0}\u4e2d\u52fe\u9009\u7684\u8d60\u54c1\u7ec4\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u540c\u7ed3\u679c\u7ec4\u4e0b\u201c\u8d60\u54c1\u5305\u9009\u62e9\u65b9\u5f0f\u201d\u4e2d\u7684\u4efb\u9009\u6570\u91cf\u3002", promotionGroupNo);
            }
        }
        return msg;
    }

    private BigDecimal getNullToZero(String key, int i) {
        BigDecimal value = (BigDecimal)this.getValue(key, i);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    private long getBaseDataMasterId(JSONObject jsonObj, String key) {
        long id = 0L;
        if (jsonObj.getJSONObject(key) != null) {
            id = jsonObj.getJSONObject(key).getLong("masterid");
        }
        return id;
    }

    private long getBaseDataId(JSONObject jsonObj, String key) {
        long id = 0L;
        if (jsonObj.getJSONObject(key) != null) {
            id = jsonObj.getJSONObject(key).getLong("id");
        }
        return id;
    }

    private String getPresentGroupNoKey(JSONObject jsonObj) {
        return jsonObj.getString("resultseq") + "_" + this.getBaseDataMasterId(jsonObj, "presentgroupno");
    }

    private String getPresentGroupNoKey(DynamicObject presentDynObj) {
        return presentDynObj.getString("promotiongroupno") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)presentDynObj, (String)"presentgroupno");
    }

    private String getPromotionGroupNoKey(DynamicObject promotionEntryDynObj) {
        return promotionEntryDynObj.getString("promotiongroupno");
    }

    private void setPresentQtyCellBackColor(CardEntry entryGridControl, boolean isSelect, int rowIndex) {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        DynamicObject presentDynObj = (DynamicObject)entryColl.get(rowIndex);
        String noKey = this.getPresentGroupNoKey(presentDynObj);
        List presentList = entryColl.stream().filter(obj -> noKey.equals(this.getPresentGroupNoKey((DynamicObject)obj))).collect(Collectors.toList());
        for (DynamicObject dynObj : presentList) {
            int index = dynObj.getInt("rowseq") - 1;
            if (dynObj.getBigDecimal("presentqty").compareTo(BigDecimal.ZERO) != 0 && isSelect) {
                isSelect = false;
            }
            HashMap mapTextfield = new HashMap(1);
            HashMap<String, String> labelField = new HashMap<String, String>(1);
            labelField.put("bc", isSelect ? "#ffff00" : "#e5e5e5");
            mapTextfield.put("presentqty", labelField);
            entryGridControl.setCustomProperties(entryGridControl.getKey(), index, mapTextfield);
        }
    }

    private void setPresentQtyCellBackColor(boolean isSelect, int rowIndex) {
        CardEntry entryGridControl = (CardEntry)this.getControl("entryentity");
        this.setPresentQtyCellBackColor(entryGridControl, isSelect, rowIndex);
    }

    private void setSelectPresentByGroupNoIndex(DynamicObjectCollection entryColl, boolean isSelect, int rowIndex) {
        DynamicObject presentDynObj = (DynamicObject)entryColl.get(rowIndex);
        String noKey = this.getPresentGroupNoKey(presentDynObj);
        List presentList = entryColl.stream().filter(obj -> noKey.equals(this.getPresentGroupNoKey((DynamicObject)obj))).collect(Collectors.toList());
        for (DynamicObject dynObj : presentList) {
            int index = dynObj.getInt("rowseq") - 1;
            this.setValue("isselect", isSelect, index);
            long inGroupTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"ingrouptype");
            if (1102930547782602752L == inGroupTypeId || isSelect) continue;
            this.setValue("presentqty", BigDecimal.ZERO, index);
        }
    }

    private Map<String, List<Integer>> getFirstIndex() {
        HashMap<String, List<Integer>> firstIndexMap = new HashMap<String, List<Integer>>(2);
        ArrayList<Integer> firstResultGroupIndex = new ArrayList<Integer>(4);
        ArrayList<Integer> firstPresentGroupIndex = new ArrayList<Integer>(4);
        DynamicObjectCollection entryColl = this.getView().getModel().getEntryEntity("entryentity");
        if (!CommonUtils.isNull((Object)entryColl)) {
            int preResultGroupNo = -1;
            long prePresentGroupNo = -1L;
            for (DynamicObject entryDynObj : entryColl) {
                int rowIndex = entryDynObj.getInt("rowseq") - 1;
                int resultGroupNo = entryDynObj.getInt("promotiongroupno");
                long presentGroupNo = entryDynObj.getLong("presentgroupno_id");
                if (preResultGroupNo != resultGroupNo) {
                    firstResultGroupIndex.add(rowIndex);
                }
                if (preResultGroupNo != resultGroupNo || prePresentGroupNo != presentGroupNo) {
                    firstPresentGroupIndex.add(rowIndex);
                }
                preResultGroupNo = resultGroupNo;
                prePresentGroupNo = presentGroupNo;
            }
        }
        firstIndexMap.put(FIRST_RESULT_GROUP_INDEX, firstResultGroupIndex);
        firstIndexMap.put(FIRST_PRESENT_GROUP_INDEX, firstPresentGroupIndex);
        return firstIndexMap;
    }

    private void setGroupAmount() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        Map<String, List<Integer>> firstIndex = this.getFirstIndex();
        List<Integer> firstResultGroupIndex = firstIndex.get(FIRST_RESULT_GROUP_INDEX);
        List<Integer> firstPresentGroupIndex = firstIndex.get(FIRST_PRESENT_GROUP_INDEX);
        for (DynamicObject entryDynObj : entryColl) {
            BigDecimal sum;
            String presentGroupNoKey;
            int rowIndex = entryDynObj.getInt("rowseq") - 1;
            if (firstResultGroupIndex.contains(rowIndex)) {
                presentGroupNoKey = this.getPromotionGroupNoKey(entryDynObj);
                sum = entryColl.stream().filter(k -> presentGroupNoKey.equals(this.getPromotionGroupNoKey((DynamicObject)k))).map(k -> k.getBigDecimal("presentsumamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue(RESULT_GROUP_AMOUNT, (Object)sum, rowIndex);
            }
            if (!firstPresentGroupIndex.contains(rowIndex)) continue;
            presentGroupNoKey = this.getPresentGroupNoKey(entryDynObj);
            sum = entryColl.stream().filter(k -> presentGroupNoKey.equals(this.getPresentGroupNoKey((DynamicObject)k))).map(k -> k.getBigDecimal("presentsumamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue(PRESENT_GROUP_AMOUNT, (Object)sum, rowIndex);
        }
    }
}

