/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.business.b2b.AuxptyHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.b2b.ItemBusinessHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.business.helper.PromotionServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.helper.common.MobDataMutexHelper;
import kd.occ.ocbase.business.helper.saleorder.SaleOrderBusinessHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.constants.BigDecimalConstants;
import kd.occ.ocbase.common.constants.PolicySubItem;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.constants.PriceFetchResult;
import kd.occ.ocbase.common.constants.SaleSubItem;
import kd.occ.ocbase.common.entity.b2b.Auxpty;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.enums.PayTypeEnum;
import kd.occ.ocbase.common.enums.PromotionDiscounTypeEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.ChannelDeployUtil;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.CustomerParamsUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.common.util.OrderQuantityUtil;
import kd.occ.ocbase.common.util.PriceServiceUtil;
import kd.occ.ocbase.common.util.SaleOrderUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocdma.business.algorithm.SaleOrderAlgorithmForForm;
import kd.occ.ocdma.business.algorithm.SaleOrderAlgorithmForMobile;
import kd.occ.ocdma.business.item.ItemHelper;
import kd.occ.ocdma.business.order.SaleOrderHelper;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;
import kd.sdk.occ.ocdma.extpoint.ISaleOrderMoblie;
import kd.sdk.occ.ocdma.extpoint.SaleOrderMobile;

public class SaleOrderBillPlugin
extends OcdmaFormMobPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(SaleOrderBillPlugin.class);
    private static final long DLOCK_TIME = 60000L;
    private static final String DLOCKKEY = "kd.occ.ocdma.formplugin.order.SaleOrderBillPlugin";
    private static final String op_rec_addentry = "rec_newentry";
    private static final String op_rec_deleteentry = "rec_deleteentry";
    private static final String OCDMA_SELECT_AUXPTY = "ocdma_select_auxpty";
    private static final String AUXPTY_VALUE = "auxpty_value";
    private static final String ITEMSELECT_BTN = "itemselect_btn";
    private static final String BTN_PROMOTION = "btnpromotion";
    private static final String BTN_CLOSEPROMOTION = "btn_closepromotion";
    private static final String op_addentry = "addentry";
    private static final String op_deleteentry = "deleteentry";
    private static final String op_add = "add";
    private static final String op_reduce = "reduce";
    private static final String op_selectaddress = "selectaddress";
    private static final String F_receiveaddressid = "receiveaddressid";
    private static final String EF_unitname = "unitname";
    private static final String EF_itemamt = "itemamt";
    private static final String F_incdeduction = "incdeduction";
    private static final String EF_entryid = "entryid";
    private static final String sourceapply_ocdma = "2";
    private static final String sourceapply_ocsaa = "4";
    private static final String OCDMA_SALEORDER_LIST = "ocdma_saleorder_list";
    private static final String OCDMA_CART = "ocdma_cart";
    private static final String page_cart = "ocdma_cart";
    private static final String page_promotion = "ocdma_saleorder_gift";
    private static final String PRESENT_SELECT = "present_select";
    private static final String PRESENT_SELECT_SUBMIT = "present_select_submit";
    private static final Long receiptOffsetId = 1026781252864431104L;
    private static final Long accountTypeId = 1027343189390260224L;
    private static final String orgOrder = "A";
    private static final String channelOrder = "B";
    DynamicObject order = null;
    private SaleOrderAlgorithmForForm orderAlgo = null;
    private SaleOrderAlgorithmForMobile orderAlgoForMobile = null;
    private static final String SPLITKEY = "&";
    PluginProxy<ISaleOrderMoblie> pluginProxy = PluginProxy.create((Object)new SaleOrderMobile(), ISaleOrderMoblie.class, (String)"occ.ocdma.ocdma_saleorder_add.ext", null);

    private SaleOrderAlgorithmForForm getAlgorithm() {
        if (this.orderAlgo == null) {
            this.orderAlgo = new SaleOrderAlgorithmForForm(this.getView());
        }
        return this.orderAlgo;
    }

    private SaleOrderAlgorithmForMobile getAlgorithmForMobile() {
        if (this.orderAlgoForMobile == null) {
            this.orderAlgoForMobile = new SaleOrderAlgorithmForMobile(this.order);
        }
        return this.orderAlgoForMobile;
    }

    private DynamicObject getOrder() {
        Object orderId;
        if (this.order == null && (orderId = this.getValue("id")) != null && (Long)orderId != 0L) {
            this.order = (DynamicObject)SaleOrderHelper.invokeOrderService((String)"getSaleOrder", (Object[])new Object[]{orderId});
        }
        return this.order;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!this.isView()) {
            this.addClickListeners(new String[]{op_addentry, op_deleteentry, op_add, op_reduce, BTN_PROMOTION, BTN_CLOSEPROMOTION, AUXPTY_VALUE, ITEMSELECT_BTN});
            this.addF7Listener(this, new String[]{"itemid", F_receiveaddressid, "invoeicetakerid", "receiptoffset", "orderlinetypeid"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "deleteentry": {
                this.setValue("autodeleterow", false);
                break;
            }
            case "btnpromotion": {
                Date promotionUpdateTime = this.getDateFieldValue("promotionupatetime");
                if (promotionUpdateTime == null) {
                    this.saveOrder(true);
                    this.matchPromotion(true);
                    break;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("matchPromotion", (IFormPlugin)this);
                this.getView().showConfirm("\u5df2\u6267\u884c\u4e86\u4fc3\u9500\u653f\u7b56\uff0c\u518d\u6b21\u6267\u884c\u4fc3\u9500\u5c06\u6e05\u7a7a\u5f53\u524d\u6267\u884c\u7684\u4fc3\u9500\u653f\u7b56\u5e76\u91cd\u65b0\u8ba1\u7b97\uff0c \u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                evt.setCancel(true);
                break;
            }
            case "btn_closepromotion": {
                Date promotionUpdateTime = this.getDateFieldValue("promotionupatetime");
                if (promotionUpdateTime == null) {
                    this.getView().showTipNotification("\u8ba2\u5355\u672a\u6267\u884c\u4efb\u4f55\u4fc3\u9500\uff0c \u65e0\u6cd5\u64a4\u6d88\u4fc3\u9500\u3002");
                    evt.setCancel(true);
                    break;
                }
                this.cancelMatchPromotion();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex("itementry");
        switch (key) {
            case "add": {
                this.add(index);
                break;
            }
            case "reduce": {
                this.reduce(index);
                break;
            }
            case "auxpty_value": {
                Object oQty = this.getModel().getValue("qty", index);
                Object oAuxQty = this.getModel().getValue("auxqty", index);
                BigDecimal qty = oQty == null ? BigDecimal.ZERO : (BigDecimal)oQty;
                BigDecimal auxQty = oAuxQty == null ? BigDecimal.ZERO : (BigDecimal)oAuxQty;
                MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)false, (long)this.getItemId(index), (long)this.getAuxptyId(index), (long)this.getSupplyRelationId(index), (BigDecimal)qty, (BigDecimal)auxQty);
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
            case "itemselect_btn": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdbd_itemmobf7");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
                List<Object> marketItemIds = this.getMarketItemIds();
                hashMap.put("ids", marketItemIds);
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ITEMSELECT_BTN);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    private List<Object> getMarketItemIds() {
        long saleOrgId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "saleorgid", "id"));
        long saleChannelId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "salechannelid", "id"));
        long orderChannelId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "orderchannelid", "id"));
        List filters = SaleOrderUtil.getItemFilter((long)saleOrgId, (long)saleChannelId, (long)orderChannelId);
        this.getItemStatusQFilter(filters, saleOrgId, saleChannelId, orderChannelId);
        return QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_iteminfo", (QFilter[])filters.toArray(new QFilter[filters.size()]), null, (int)99999);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        switch (entryName) {
            case "itementry": {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.setValue("orderlinetypeid", this.getOrderlinetypeId(), rowIndex);
                }
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "itementry": {
                this.calculateRecBillAmount("qty", -1);
                DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
                int entryCount = itemEntryColl.size();
                for (int index = 0; index < entryCount; ++index) {
                    this.fetchTaxPrice(index, entryCount);
                }
                break;
            }
            case "recentryentity": {
                this.paymentInfoChange();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "addentry": 
            case "deleteentry": {
                Date promotionUpateTime = this.getDateFieldValue("promotionupatetime");
                if (promotionUpateTime == null) break;
                e.setCancel(true);
                this.showCancelmatchPromotionConfirm("");
                break;
            }
            case "close": {
                long billId = (Long)this.getModel().getValue("id");
                String parentFormId = this.getView().getFormShowParameter().getParentFormId();
                if (billId != 0L && "ocdma_cart".equals(parentFormId)) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close", (IFormPlugin)this);
                    this.getView().showConfirm("\u8ba2\u5355\u5df2\u4fdd\u5b58\uff0c\u662f\u5426\u5220\u9664\u8ba2\u5355\u5e76\u9000\u51fa\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                } else {
                    this.getView().close();
                }
                e.setCancel(true);
                break;
            }
            case "submit": 
            case "presubmit": {
                String parentFormId = this.getView().getFormShowParameter().getParentFormId();
                if (!OCDMA_SALEORDER_LIST.equals(parentFormId) || this.isEdit()) break;
                String uuid = (String)this.getModel().getValue("uuid");
                QFilter filter = new QFilter("uuid", "=", (Object)uuid);
                filter.and("createtime", ">", (Object)DateUtil.getDayFirst((Date)new Date()));
                DynamicObject data = QueryServiceHelper.queryOne((String)"ocbsoc_saleorderunique", (String)"uuid", (QFilter[])filter.toArray());
                if (data != null) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                    this.getView().showConfirm("\u6709\u91cd\u590d\u7684\u8ba2\u5355\uff0c\u662f\u5426\u8981\u518d\u6b21\u63d0\u4ea4\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    e.setCancel(true);
                    break;
                }
                this.getModel().setValue("uuid", (Object)Long.toString(DB.genGlobalLongId()));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "addentry": {
                this.calcOrderData();
                BasedataEdit bizItem = (BasedataEdit)this.getControl("itemid");
                if (bizItem == null) break;
                bizItem.click();
                break;
            }
            case "deleteentry": {
                this.getAlgorithm().calTotalFields();
                this.calcOrderData();
                CardEntry cardEntry = (CardEntry)this.getView().getControl("itementry");
                cardEntry.selectRows(new int[0], -1);
                break;
            }
            case "rec_newentry": {
                BasedataEdit recItem = (BasedataEdit)this.getControl("receiptoffset");
                if (recItem == null) break;
                recItem.click();
                break;
            }
            case "rec_deleteentry": {
                BigDecimal sumUsedAmount = this.getAlgorithm().sumRecEntryUsedAmount();
                this.getModel().setValue("sumrecamount", (Object)sumUsedAmount);
                this.getAlgorithm().calTotalFields();
                break;
            }
            case "submit": 
            case "presubmit": {
                if (!e.getOperationResult().isSuccess()) break;
                this.submitByLock();
                break;
            }
            case "selectaddress": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdbd_channeladdressmobf7");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Object oOrderChannel = this.getModel().getValue("orderchannelid");
                String channelId = "";
                if (oOrderChannel != null) {
                    DynamicObject orderChannel = (DynamicObject)oOrderChannel;
                    channelId = CommonUtils.convertObjectToString((Object)DynamicObjectUtils.getPkValue((DynamicObject)orderChannel, (String)"orderchannel"));
                }
                hashMap.put("channelid", channelId);
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, op_selectaddress);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    protected void add(int index) {
        BigDecimal auxQty;
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        boolean isUseAuxpty = this.isUseAuxpty(index);
        boolean isOpenSelectAuxpty = isUseAuxpty && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)orgOrder) || !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)orgOrder);
        Object oQty = this.getModel().getValue("qty", index);
        Object oAuxQty = this.getModel().getValue("auxqty", index);
        BigDecimal qty = oQty == null ? BigDecimal.ZERO : (BigDecimal)oQty;
        BigDecimal bigDecimal = auxQty = oAuxQty == null ? BigDecimal.ZERO : (BigDecimal)oAuxQty;
        if (isOpenSelectAuxpty) {
            MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)true, (long)this.getItemId(index), (long)this.getAuxptyId(index), (long)this.getSupplyRelationId(index), (BigDecimal)qty, (BigDecimal)auxQty);
            mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            return;
        }
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal bigDecimal2 = orderMinQty = orderMinQty.compareTo(BigDecimal.ZERO) == 0 ? orderQty : orderMinQty;
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("qty", (Object)orderMinQty, index);
        } else {
            this.getModel().setValue("qty", (Object)qty.add(orderQty), index);
        }
    }

    protected void reduce(int index) {
        BigDecimal auxQty;
        String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
        boolean isUseAuxpty = this.isUseAuxpty(index);
        boolean isOpenSelectAuxpty = isUseAuxpty && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)orgOrder) || !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)orgOrder);
        Object oQty = this.getModel().getValue("qty", index);
        Object oAuxQty = this.getModel().getValue("qty", index);
        BigDecimal qty = oQty == null ? BigDecimal.ZERO : (BigDecimal)oQty;
        BigDecimal bigDecimal = auxQty = oAuxQty == null ? BigDecimal.ZERO : (BigDecimal)oAuxQty;
        if (isOpenSelectAuxpty) {
            MobileFormShowParameter mobileFormShowParameter = ItemHelper.openSelectAuxpty((int)index, (boolean)true, (long)this.getItemId(index), (long)0L, (long)this.getSupplyRelationId(index), (BigDecimal)qty, (BigDecimal)auxQty);
            mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCDMA_SELECT_AUXPTY));
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            return;
        }
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal newQty = qty.subtract(orderQty);
        if (newQty.compareTo(orderMinQty) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue("qty", (Object)newQty, index);
    }

    private boolean isUseAuxpty(int index) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("itementry", index);
        DynamicObject material = entryRowEntity.getDynamicObject("materialid");
        return material != null && material.getBoolean("isuseauxpty");
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp prop = e.getEntryProp();
        if ("itementry".equals(prop.getName())) {
            Date promotionUpateTime;
            int[] selectIndex;
            for (int rowIndex : selectIndex = e.getRowIndexs()) {
                DynamicObject entry = this.getModel().getEntryRowEntity("itementry", rowIndex);
                if (entry.getLong("combineparentid") == 0L) continue;
                e.setCancel(true);
                this.getView().showTipNotification("\u4e0d\u80fd\u5220\u9664\u7ec4\u5408\u5546\u54c1\u5b50\u4ef6\u3002");
                return;
            }
            boolean autoDeleteRow = this.getBooleanValue("autodeleterow");
            if (!autoDeleteRow && (promotionUpateTime = this.getDateFieldValue("promotionupatetime")) != null) {
                this.setValue("autodeleterow", true);
                e.setCancel(true);
                this.showCancelmatchPromotionConfirm("");
                return;
            }
            this.removeCombineEntry(selectIndex, false);
        } else if ("recentryentity".equals(prop.getName())) {
            int[] rowIndexs;
            for (int rowIndex : rowIndexs = e.getRowIndexs()) {
                DynamicObject offsetDynObj = this.getEntryF7Value("recentryentity", "receiptoffset", rowIndex);
                if (!sourceapply_ocdma.equals(DynamicObjectUtils.getString((DynamicObject)offsetDynObj, (String)"type"))) continue;
                e.setCancel(true);
                this.getView().showMessage("\u4e0d\u80fd\u5220\u9664\u6536\u6b3e\u62b5\u6263\u7c7b\u578b\u4e3a\u9884\u4ed8\u6b3e\u7684\u5206\u5f55\u884c\u3002");
            }
        }
    }

    private void removeCombineEntry(int[] currentRowIndexs, boolean deleteCurrentRow) {
        Set<Integer> deleteIndexSet = this.getDeleteIndexSet(currentRowIndexs, deleteCurrentRow);
        if (!CommonUtils.isNull(deleteIndexSet)) {
            int[] deleteIndexs = deleteIndexSet.stream().mapToInt(Integer::valueOf).toArray();
            this.getModel().beginInit();
            this.getModel().deleteEntryRows("itementry", deleteIndexs);
            this.getModel().endInit();
            this.getView().updateView("itementry");
        }
    }

    private Set<Integer> getDeleteIndexSet(int[] currentRowIndexs, boolean deleteCurrentRow) {
        HashSet<Integer> deleteIndexSet = new HashSet<Integer>(10);
        for (int currentRowIndex : currentRowIndexs) {
            Object parentEntryId;
            DynamicObject rowInfo = this.getRowInfo("itementry", currentRowIndex);
            Object object = parentEntryId = rowInfo != null ? rowInfo.getPkValue() : null;
            if (deleteCurrentRow) {
                deleteIndexSet.add(currentRowIndex);
            }
            if (parentEntryId == null || Long.parseLong(parentEntryId.toString()) <= 0L) continue;
            int index = 1;
            DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
            int count = entryColl.size() - currentRowIndex;
            for (int i = 1; i < count; ++i) {
                index = currentRowIndex + i;
                DynamicObject entryDynObj = this.getRowInfo("itementry", index);
                if (!parentEntryId.equals(entryDynObj.get("combineparentid"))) continue;
                deleteIndexSet.add(index);
            }
        }
        return deleteIndexSet;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex;
        Object newValue;
        Object oldValue;
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        if (this.cancelMatchPromotion(key, oldValue = e.getChangeSet()[0].getOldValue(), newValue = e.getChangeSet()[0].getNewValue(), rowIndex = this.getRowIndex(e))) {
            this.setValue(key, oldValue, rowIndex, false);
            return;
        }
        switch (key) {
            case "itemid": {
                DynamicObject goodItem = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (goodItem == null) {
                    this.clearItemData(rowIndex);
                    this.calcOrderData();
                    return;
                }
                this.setItemEntityFieldInfo(rowIndex);
                break;
            }
            case "qty": {
                DynamicObject unit = (DynamicObject)this.getValue("unit", rowIndex);
                String unitName = "";
                if (unit != null) {
                    unitName = unit.getString("name");
                }
                BigDecimal itemQty = BigDecimalUtil.toBigDecimal((Object)newValue);
                BigDecimal oldItemQty = BigDecimalUtil.toBigDecimal((Object)oldValue);
                boolean isAdd = true;
                if (itemQty.compareTo(oldItemQty) < 0) {
                    isAdd = false;
                }
                boolean isPresent = (Boolean)this.getValue("ispresent", rowIndex);
                long parentEntryId = (Long)this.getValue("combineparentid", rowIndex);
                String errorMsg = this.getOrderQuantityMsg(rowIndex, unitName, itemQty, isAdd);
                if (!isPresent && parentEntryId == 0L && !StringUtils.isEmpty((String)errorMsg)) {
                    itemQty = new BigDecimal(errorMsg.split(SPLITKEY)[1]);
                    errorMsg = errorMsg.split(SPLITKEY)[0];
                    if (SysParamsUtil.isOrderQuantityStrongControl()) {
                        this.setValue("qty", itemQty, rowIndex, true);
                    } else if (itemQty.compareTo(BigDecimal.ZERO) <= 0) {
                        itemQty = BigDecimal.ONE;
                        this.setValue("qty", itemQty, rowIndex, true);
                    }
                    this.getView().showTipNotification(errorMsg);
                    return;
                }
                if (SysParamsUtil.getIsAuxUnitOrder()) {
                    DynamicObject auxunit = (DynamicObject)this.getValue("auxunit", rowIndex);
                    DynamicObject material = (DynamicObject)this.getValue("materialid", rowIndex);
                    if (unit != null && auxunit != null && material != null) {
                        BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)itemQty, (Long)material.getLong("id"), (Long)unit.getLong("id"), (Long)auxunit.getLong("id"));
                        this.setValue("auxqty", assistQty, rowIndex, true);
                    }
                }
                this.setCombineItemQty(itemQty, rowIndex);
                break;
            }
            case "ispresent": {
                this.setPriceByPresent(rowIndex);
                break;
            }
            case "auxptyid": {
                this.setAuxptyValue(rowIndex);
                this.triggerChangeEvent = true;
                break;
            }
            case "invoicetype": {
                this.setFeildMustInputByInvoiceType();
                break;
            }
            case "usedamount": {
                this.usedAmountChange(oldValue, rowIndex);
                this.clearPaymentRecEntry();
                this.paymentInfoChange();
                break;
            }
            case "billamount": {
                this.setTipMsgByBillAmount(rowIndex);
                break;
            }
            case "orderlinetypeid": {
                if (newValue == null) {
                    this.setValue("orderlinetypeid", this.getOrderlinetypeId(), rowIndex);
                }
                this.setOrderLineTypeEnable();
                break;
            }
        }
        this.getAlgorithm().calByChange(e);
        this.setCombineSubItemField(key, rowIndex);
        this.fetchTaxPrice(key, rowIndex);
        this.calcOrderData();
        this.calculateRecBillAmount(key, rowIndex);
    }

    private void setCombineItemQty(BigDecimal itemQty, int rowIndex) {
        DynamicObject entryRow = this.getModel().getEntryRowEntity("itementry", rowIndex);
        long combineItemId = entryRow.getLong("combinationid_id");
        long combineParentId = entryRow.getLong("combineparentid");
        if (combineItemId != 0L && combineParentId == 0L) {
            long entryId = entryRow.getLong("id");
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("itementry");
            for (DynamicObject entry : entryList) {
                if (entry.getLong("combineparentid") != entryId) continue;
                int rowId = entryList.indexOf((Object)entry);
                this.setValue("qty", itemQty.multiply(entry.getBigDecimal("subitemqty")), rowId);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection recEntries;
        this.getPageCache().put("operationStatus", this.getView().getFormShowParameter().getStatus().toString());
        if (this.isView()) {
            this.viewOrder();
            return;
        }
        if (this.isEdit()) {
            this.modifyOrder();
            String billNo = (String)this.getModel().getValue("billno");
            long orderId = (Long)this.getModel().getValue("id");
            if (!super.createDataMutex("ocbsoc_saleorder", billNo, orderId + "", true)) {
                this.toOrderList(this.getView());
                return;
            }
        } else if (this.isAddNew()) {
            String parentFormId = this.getView().getFormShowParameter().getParentFormId();
            if ("ocdma_cart".equals(parentFormId)) {
                this.loadOrderFromCart();
            } else if (OCDMA_SALEORDER_LIST.equals(parentFormId)) {
                this.loadOrderFromList();
            }
            this.initBaseData();
        }
        this.initRecEntryEntity();
        this.getAlgorithm().calTotalFields();
        this.calcOrderData();
        if (this.isEdit() && (recEntries = this.order.getDynamicObjectCollection("recentryentity")) != null && !recEntries.isEmpty()) {
            for (int i = 0; i < recEntries.size(); ++i) {
                DynamicObject recEntry = (DynamicObject)recEntries.get(i);
                this.setValue("usedamount", recEntry.getBigDecimal("usedamount"), i);
            }
        }
        this.paymentInfoChange();
        boolean enablePresubmit = SysParamsUtil.isEnablePreSubmit((String)"ocbsoc_saleorder");
        this.getView().setVisible(Boolean.valueOf(!enablePresubmit), new String[]{"btnsubmit"});
        this.getView().setVisible(Boolean.valueOf(enablePresubmit), new String[]{"btnpresubmit"});
        if (enablePresubmit) {
            this.getView().getPageCache().put("enablepresubmit", "1");
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection recEntityColl;
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("itementry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.setAuxptyValue(i);
        }
        this.setFiledEnableAndVisible();
        if (!"ocdma_saleorder_view".equals(this.getView().getEntityId()) && !CommonUtils.isNull((Object)(recEntityColl = this.getModel().getEntryEntity("recentryentity")))) {
            this.getRebateAccountAmountInfo("orderchannelid", 0);
            this.getView().updateView("recentryentity");
        }
    }

    private void getRebateAccountAmountInfo(String key, int rowIndex) {
        switch (key) {
            case "salechannelid": 
            case "accounttypeid": 
            case "settlecurrencyid": 
            case "settleorgid": 
            case "orderchannelid": 
            case "balancechannelid": {
                DynamicObjectCollection recEntryColl;
                boolean isuserebateamount = SysParamsUtil.isUseRebateAmount();
                boolean isEnableBalModel = SysParamsUtil.isEnableBalModel();
                if (isuserebateamount) {
                    if ("accounttypeid".equals(key)) {
                        DynamicObject accounTypeDynObj = this.getEntryF7Value("recentryentity", "accounttype", rowIndex);
                        this.setAvailableBalance(accounTypeDynObj, rowIndex);
                    } else {
                        recEntryColl = this.getModel().getEntryEntity("recentryentity");
                        rowIndex = 0;
                        for (DynamicObject recEntryDynObj : recEntryColl) {
                            DynamicObject accounTypeDynObj = recEntryDynObj.getDynamicObject("accounttype");
                            this.setAvailableBalance(accounTypeDynObj, rowIndex);
                            ++rowIndex;
                        }
                    }
                } else if (isEnableBalModel) {
                    this.setAvailableBalanceByDefined();
                }
                recEntryColl = this.getModel().getEntryEntity("recentryentity");
                int size = recEntryColl.size();
                for (int i = 0; i < size; ++i) {
                    boolean isPayment = sourceapply_ocdma.equals(DynamicObjectUtils.getString((DynamicObject)this.getEntryF7Value("recentryentity", "receiptoffset", i), (String)"type"));
                    if (!isPayment) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"receiptoffset", "usedamount"});
                }
                break;
            }
        }
    }

    private void setAvailableBalance(DynamicObject receiptOffsetDynObj, int rowIndex) {
        long accountId = DynamicObjectUtils.getPkValue((DynamicObject)receiptOffsetDynObj);
        long settleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("settleorgid"));
        long customerId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("balancechannelid"), (String)"customer");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("balancechannelid"));
        long settleCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("settlecurrencyid"));
        long saleChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("salechannelid"));
        BigDecimal availableBalanceAmount = SaleOrderBusinessHelper.getAvailableBalanceAmount((long)settleOrgId, (long)customerId, (long)channelId, (long)saleChannelId, (long)settleCurrencyId, (long)accountId);
        this.setValue("availablebalance", availableBalanceAmount, rowIndex);
    }

    private void setAvailableBalanceByDefined() {
        DynamicObject orderDynObj = this.getModel().getDataEntity(true);
        DynamicObject[] balanceDynObjs = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"occ", (String)"occba", (String)"Occba_RebateAccountPoolService", (String)"getRebateAccounts", (Object[])new Object[]{orderDynObj, 0L});
        DynamicObjectCollection recEntryColl = this.getModel().getEntryEntity("recentryentity");
        int rowIndex = 0;
        for (DynamicObject recEntryDynObj : recEntryColl) {
            BigDecimal availableBalanceAmount = BigDecimal.ZERO;
            long cashPoolId = 0L;
            if (balanceDynObjs != null && balanceDynObjs.length > 0) {
                for (DynamicObject balanceDynObj : balanceDynObjs) {
                    long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"accounttype");
                    if (accountTypeId != DynamicObjectUtils.getPkValue((DynamicObject)balanceDynObj, (String)"accounttype")) continue;
                    long balanceId = balanceDynObj.getLong("id");
                    BigDecimal usedAmount = recEntryDynObj.getBigDecimal("usedamount");
                    if (usedAmount.compareTo(ZERO) == 0 || usedAmount.compareTo(ZERO) != 0 && balanceId == DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"cashpoolid")) {
                        availableBalanceAmount = availableBalanceAmount.add(balanceDynObj.getBigDecimal("availablebalance"));
                    }
                    if (cashPoolId != 0L) continue;
                    cashPoolId = balanceId;
                }
            }
            this.setValue("availablebalance", availableBalanceAmount, rowIndex);
            if (DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"cashpoolid") == 0L) {
                this.setValue("cashpoolid", cashPoolId, rowIndex);
            }
            ++rowIndex;
        }
    }

    private void modifyOrder() {
        DynamicObjectCollection recEntries;
        DynamicObjectCollection promotionEntries;
        int rowIndex;
        long orderId = (Long)this.getParameter("orderId");
        this.getModel().setValue("id", (Object)orderId);
        this.getOrder();
        this.setValue("billno", this.order.get("billno"));
        this.setValue("orderdate", this.order.get("orderdate"));
        this.setValue("uuid", this.order.get("uuid"));
        DynamicObjectCollection itemEntry = this.order.getDynamicObjectCollection("itementry");
        this.setValue(F_receiveaddressid, ((DynamicObject)itemEntry.get(0)).get("entryreceiveaddressid"));
        this.setValue("saleorgid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"saleorgid"));
        this.setValue("salechannelid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"salechannelid"));
        this.setValue("orderchannelid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"orderchannelid"));
        this.setValue("balancechannelid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"balancechannelid"));
        this.setValue("pricechannelid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"pricechannelid"));
        this.setValue("paytype", this.order.getString("paytype"));
        this.setValue("supplierid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"supplierid"));
        this.setValue("supplyrelation", this.order.getString("supplyrelation"));
        this.setValue("settleorgid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"settleorgid"));
        this.setValue("settlecurrencyid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)this.order, (String)"settlecurrencyid"));
        this.setValue("vehicleid", this.order.get("vehicleid"));
        this.setValue("orderremark", this.order.get("orderremark"));
        this.setValue("invoicetype", this.order.get("invoicetype"));
        this.setValue("invoeicetakerid", this.order.get("invoeicetakerid"));
        this.setValue("invoicephone", this.order.get("invoicephone"));
        this.setValue("invoiceaddress", this.order.get("invoiceaddress"));
        this.setValue("promotionupatetime", this.order.get("promotionupatetime"));
        this.setValue("rebateaccounttype", this.order.get("rebateaccounttype"));
        MobExtendHelper.loadMobExtend((IDataModel)this.getModel(), (String)this.getView().getEntityId(), (DynamicObject)this.order, (String)"ocbsoc_saleorder");
        Map extColsMap = MobExtendHelper.getExtColsMap((String)this.getView().getEntityId(), (String)"ocbsoc_saleorder");
        if (!itemEntry.isEmpty()) {
            int[] rowIndexes = this.getModel().batchCreateNewEntryRow("itementry", itemEntry.size());
            DynamicObjectCollection pageItemData = this.getModel().getEntryEntity("itementry");
            for (int i = 0; i < itemEntry.size(); ++i) {
                DynamicObject item = (DynamicObject)itemEntry.get(i);
                rowIndex = rowIndexes[i];
                long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"itemid");
                this.getModel().getEntryRowEntity("itementry", rowIndex).set("id", (Object)item.getLong("id"));
                this.setValue("itemid", itemId, rowIndex);
                this.setValue("auxptyid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"auxptyid"), rowIndex);
                this.setValue("materialid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"materialid"), rowIndex);
                this.setValue("unit", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"unit"), rowIndex);
                this.setValue("auxunit", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"assistunitid"), rowIndex);
                this.setValue("qty", item.getBigDecimal("approveqty"), rowIndex);
                this.setValue("auxqty", item.getBigDecimal("approveassistqty"), rowIndex);
                this.setValue("ispromotion", item.getBoolean("ispromotion"), rowIndex);
                this.setValue("isjoinpromotion", item.getBoolean("isjoinpromotion"), rowIndex);
                this.setValue("ispresent", item.getBoolean("ispresent"), rowIndex);
                this.setValue(EF_entryid, item.getPkValue(), rowIndex);
                this.setItemEntityFieldInfo(rowIndex);
                this.setValue("taxprice", item.getBigDecimal("taxprice"), rowIndex);
                this.setValue("standardprice", item.getBigDecimal("standardprice"), rowIndex);
                this.setValue("lowestprice", item.getBigDecimal("lowestprice"), rowIndex);
                this.setValue("pricediscount", item.getBigDecimal("pricediscount"), rowIndex);
                this.setValue("oldpricediscount", item.getBigDecimal("oldpricediscount"), rowIndex);
                this.setValue("promotiondiscount", item.getBigDecimal("promotiondiscount"), rowIndex);
                this.getAlgorithm().calByChange("taxprice", rowIndex);
                this.setValue("orderlinetypeid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"orderlinetypeid"), rowIndex);
                this.setValue("combinationid", item.get("combinationid"), rowIndex);
                this.setValue("combineparentid", item.get("combineparentid"), rowIndex);
                this.setValue("pricepercent", item.get("pricepercent"), rowIndex);
                this.setValue("subitemqty", item.get("subitemqty"), rowIndex);
                for (Map.Entry extCols : extColsMap.entrySet()) {
                    if (!((DynamicObject)pageItemData.get(0)).containsProperty((String)extCols.getKey()) || !item.containsProperty((String)extCols.getValue())) continue;
                    this.setValue((String)extCols.getKey(), item.get((String)extCols.getValue()), rowIndex);
                }
                this.setItemAmount(rowIndex);
            }
        }
        if ((promotionEntries = this.order.getDynamicObjectCollection("promotion_entry")) != null && !promotionEntries.isEmpty()) {
            int[] rowIndexes = this.getModel().batchCreateNewEntryRow("promotion_entry", promotionEntries.size());
            DynamicObjectCollection pageItemData = this.getModel().getEntryEntity("promotion_entry");
            for (int i = 0; i < promotionEntries.size(); ++i) {
                rowIndex = rowIndexes[i];
                DynamicObject promotionEntry = (DynamicObject)promotionEntries.get(rowIndex);
                this.getModel().getEntryRowEntity("promotion_entry", rowIndex).set("id", (Object)promotionEntry.getLong("id"));
                this.setValue("promotionpolicyid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"promotionpolicyid"), rowIndex);
                this.setValue("promotiongroupno", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"promotiongroupno"), rowIndex);
                this.setValue("promotionispresent", promotionEntry.get("promotionispresent"), rowIndex);
                this.setValue("itemid_p", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"itemid_p"), rowIndex);
                this.setValue("materialid_p", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"materialid_p"), rowIndex);
                this.setValue("unitid_p", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"unitid_p"), rowIndex);
                this.setValue("auxptyid_p", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"auxptyid_p"), rowIndex);
                this.setValue("achieveqty", promotionEntry.get("achieveqty"), rowIndex);
                this.setValue("achieveamount", promotionEntry.get("achieveamount"), rowIndex);
                this.setValue("billachieveqty", promotionEntry.get("billachieveqty"), rowIndex);
                this.setValue("billachieveamount", promotionEntry.get("billachieveamount"), rowIndex);
                this.setValue("pricediscountamount", promotionEntry.get("pricediscountamount"), rowIndex);
                this.setValue("promotionprice", promotionEntry.get("promotionprice"), rowIndex);
                this.setValue("promotiondiscountamount", promotionEntry.get("promotiondiscountamount"), rowIndex);
                this.setValue("discountrate", promotionEntry.get("discountrate"), rowIndex);
                this.setValue("billdiscountrate", promotionEntry.get("billdiscountrate"), rowIndex);
                this.setValue("planedeductamount", promotionEntry.get("planedeductamount"), rowIndex);
                this.setValue("actualdeductamount", promotionEntry.get("actualdeductamount"), rowIndex);
                this.setValue("presentqty", promotionEntry.get("presentqty"), rowIndex);
                this.setValue("presentsumamount", promotionEntry.get("presentsumamount"), rowIndex);
                this.setValue("orderentryid", promotionEntry.get("orderentryid"), rowIndex);
                this.setValue("presentgroupno", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"presentgroupno"), rowIndex);
                this.setValue("betweengrouptype", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"betweengrouptype"), rowIndex);
                this.setValue("ingrouptype", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)promotionEntry, (String)"ingrouptype"), rowIndex);
                this.setValue("presentprice", promotionEntry.get("presentprice"), rowIndex);
                this.setValue("processstatus", promotionEntry.get("processstatus"), rowIndex);
                this.setValue("selectpresent", promotionEntry.get("selectpresent"), rowIndex);
                this.setValue("resultseq", promotionEntry.get("resultseq"), rowIndex);
                for (Map.Entry extCols : extColsMap.entrySet()) {
                    if (!((DynamicObject)pageItemData.get(0)).containsProperty((String)extCols.getKey()) || !promotionEntry.containsProperty((String)extCols.getValue())) continue;
                    this.setValue((String)extCols.getKey(), promotionEntry.get((String)extCols.getValue()), rowIndex);
                }
            }
        }
        if ((recEntries = this.order.getDynamicObjectCollection("recentryentity")) != null && !recEntries.isEmpty()) {
            int[] rowIndexes = this.getModel().batchCreateNewEntryRow("recentryentity", recEntries.size());
            DynamicObjectCollection pageEntryData = this.getModel().getEntryEntity("recentryentity");
            for (int i = 0; i < recEntries.size(); ++i) {
                int rowIndex2 = rowIndexes[i];
                DynamicObject recEntry = (DynamicObject)recEntries.get(rowIndex2);
                this.setValue("receiptoffset", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)recEntry, (String)"receiptoffsetid"), rowIndex2);
                this.setValue("accounttype", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)recEntry, (String)"accounttypeid"), rowIndex2);
                this.setValue("billamount", recEntry.getBigDecimal("billamount"), rowIndex2);
                this.setValue("usedamount", recEntry.getBigDecimal("usedamount"), rowIndex2);
                this.setValue("tipmsg", recEntry.get("tipmsg"), rowIndex2);
                this.setValue("isenough", recEntry.get("isenough"), rowIndex2);
                this.setValue("cashpoolid", recEntry.get("cashpoolid"), rowIndex2);
                for (Map.Entry extCols : extColsMap.entrySet()) {
                    if (!((DynamicObject)pageEntryData.get(0)).containsProperty((String)extCols.getKey()) || !recEntry.containsProperty((String)extCols.getValue())) continue;
                    this.setValue((String)extCols.getKey(), recEntry.get((String)extCols.getValue()), rowIndex2);
                }
            }
        }
        this.pluginProxy.callAfter(p -> {
            p.afterLoadEditData(this.getModel(), this.order);
            return null;
        });
    }

    private void setSettleOrg(DynamicObject saleOrgDynObj) {
        Map map;
        Object settleorgId = null;
        if (saleOrgDynObj != null && !CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrgDynObj.getLong("id"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            settleorgId = map.get("id");
        }
        this.setValue("settleorgid", settleorgId);
    }

    private Date getRequestDate() {
        DynamicObject channelAuthDynObj = (DynamicObject)this.getModel().getValue("supplierid");
        if (channelAuthDynObj != null) {
            int date = channelAuthDynObj.getInt("leadtime");
            return DateUtil.getNextDate((Date)DateUtil.getNowDate(), (int)date);
        }
        return DateUtil.getNowDate();
    }

    private void initBaseData() {
        IDataModel model = this.getModel();
        String billNo = CodeRuleUtil.readCodeRule((String)"ocbsoc_saleorder");
        this.setValue("billno", billNo);
        this.setValue("orderdate", TimeServiceHelper.now());
        this.setSettleOrg(this.getF7Value("saleorgid"));
        this.setSettleCurrency();
        DynamicObject orderChanel = (DynamicObject)model.getValue("orderchannelid");
        if (orderChanel != null) {
            Long prePriceChannelId;
            DynamicObject receiveAddress;
            DynamicObject receiveChannel = orderChanel.getDynamicObject("orderchannel");
            if (receiveChannel != null && (receiveAddress = ChannelHelper.getDefaultDeliveryAddressByChannelId((long)receiveChannel.getLong("id"))) != null) {
                this.setValue(F_receiveaddressid, receiveAddress.getLong("id"));
            }
            this.setValue("pricechannelid", (prePriceChannelId = Long.valueOf(DynamicObjectUtils.getPkValue((DynamicObject)orderChanel, (String)"pricechannel"))) == null || prePriceChannelId == 0L ? orderChanel.getPkValue() : prePriceChannelId);
            this.setValue("balancechannelid", DynamicObjectUtils.getPkValue((DynamicObject)orderChanel, (String)"balancechannel"));
            String payType = PayTypeEnum.CHARGE_SALES.getFlagStr();
            DynamicObject supplier = (DynamicObject)model.getValue("supplierid");
            if (supplier != null && supplier.getBoolean("onlycash")) {
                payType = PayTypeEnum.ONLY_CASH.getFlagStr();
            } else if (StringUtils.isNotNull((String)orderChanel.getString("paytype"))) {
                payType = orderChanel.getString("paytype");
            }
            this.setValue("paytype", payType);
            List<Long> vehicleIdList = this.queryVehicle(orderChanel.getLong("id")).get(orderChanel.getLong("id"));
            if (!CollectionUtils.isEmpty(vehicleIdList)) {
                this.setValue("vehicleid", vehicleIdList.get(0));
            }
        }
        this.getModel().setValue("requestdate", (Object)this.getRequestDate());
        int entryRowCount = this.getModel().getEntryRowCount("itementry");
        HashMap<String, PriceFetchParam> priceFetchParamMap = new HashMap<String, PriceFetchParam>(entryRowCount);
        HashMap<Integer, String> indexPriceKeyMap = new HashMap<Integer, String>(entryRowCount);
        HashMap priceKeyIndexMap = new HashMap(entryRowCount);
        Long saleOrgId = (Long)this.getF7PKValue("saleorgid");
        Long priceChannelId = (Long)this.getF7PKValue("pricechannelid");
        long saleChannelId = (Long)this.getModel().getValue("salechannelid_id");
        Long currencyId = (Long)this.getF7PKValue("settlecurrencyid");
        String supplyRelation = (String)this.getValue("supplyrelation");
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("itementry");
        this.getModel().setValue("rebateaccounttype", (Object)(saleChannelId != 0L ? channelOrder : orgOrder));
        if (itemList != null && !itemList.isEmpty()) {
            boolean isMerGetPrice = SysParamsUtil.isMerGetPrice();
            for (DynamicObject rowItem : itemList) {
                int rowIndex = itemList.indexOf((Object)rowItem);
                this.setItemEntityFieldInfo(rowIndex);
                long orderlineTypeId = this.getOrderlinetypeId();
                this.setValue("orderlinetypeid", orderlineTypeId, rowIndex);
                if (rowItem.getLong("combineparentid") != 0L) continue;
                long itemId = (Long)this.getF7PKValue("itemid", rowIndex);
                Long auxpty = (Long)this.getF7PKValue("auxptyid", rowIndex);
                long unitId = (Long)this.getF7PKValue("unit", rowIndex);
                BigDecimal qty = (BigDecimal)this.getValue("qty", rowIndex);
                if (qty.compareTo(BigDecimal.ZERO) == 0) {
                    qty = BigDecimal.ONE;
                }
                PriceFetchParam priceFetchParam = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)priceChannelId, (long)itemId, (long)(auxpty != null ? auxpty : 0L), (long)unitId, (long)currencyId, (BigDecimal)qty);
                priceFetchParam.setCombItem(this.getModel().getValue("combinationid", rowIndex) != null);
                priceFetchParam.setOwnerId(saleChannelId);
                priceFetchParam.setChannelSupplyRelation(ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyRelation) ? ChannelSupplyRelation.SUPPLY_CHANNEL : ChannelSupplyRelation.SUPPLY_ORG);
                if (isMerGetPrice) {
                    List<Integer> indexList;
                    if (priceFetchParamMap.containsKey(priceFetchParam.getParamUniKeyIgnoreQty())) {
                        priceFetchParam = (PriceFetchParam)priceFetchParamMap.get(priceFetchParam.getParamUniKeyIgnoreQty());
                        priceFetchParam.setQty(priceFetchParam.getQty().add(qty));
                        indexList = (List)priceKeyIndexMap.get(priceFetchParam.getParamUniKeyIgnoreQty());
                        indexList.add(rowIndex);
                        priceKeyIndexMap.put(priceFetchParam.getParamUniKeyIgnoreQty(), indexList);
                        for (Integer index : indexList) {
                            indexPriceKeyMap.put(index, priceFetchParam.getParamUniKey());
                        }
                        continue;
                    }
                    priceFetchParamMap.put(priceFetchParam.getParamUniKeyIgnoreQty(), priceFetchParam);
                    indexList = new ArrayList<Integer>();
                    indexList.add(rowIndex);
                    priceKeyIndexMap.put(priceFetchParam.getParamUniKeyIgnoreQty(), indexList);
                    indexPriceKeyMap.put(rowIndex, priceFetchParam.getParamUniKey());
                    continue;
                }
                priceFetchParamMap.put(priceFetchParam.getParamUniKey(), priceFetchParam);
                indexPriceKeyMap.put(rowIndex, priceFetchParam.getParamUniKey());
            }
        }
        Map priceMap = PriceServiceUtil.batchGetItemPrice(new ArrayList(priceFetchParamMap.values()));
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            this.fetchTaxPriceV2(rowIndex, (PriceFetchResult)priceMap.get(indexPriceKeyMap.get(rowIndex)));
            this.getAlgorithm().calByChange("taxprice", rowIndex);
            this.setItemAmount(rowIndex);
        }
        this.createRecEntityAndUseAmount();
        this.pluginProxy.callAfter(p -> {
            p.afterCreateNewData(this.getModel());
            return null;
        });
    }

    private void loadOrderFromCart() {
        Object supplyRelationId = this.getParameter("supplyrelationid");
        this.setValue("supplierid", supplyRelationId);
        DynamicObject supplyRelationAuth = (DynamicObject)this.getValue("supplierid");
        this.setValue("saleorgid", DynamicObjectUtils.getPkValue((DynamicObject)supplyRelationAuth, (String)"saleorg"));
        this.setValue("salechannelid", DynamicObjectUtils.getPkValue((DynamicObject)supplyRelationAuth, (String)"salechannel"));
        this.setValue("orderchannelid", DynamicObjectUtils.getPkValue((DynamicObject)supplyRelationAuth, (String)"orderchannel"));
        this.setValue("supplyrelation", DynamicObjectUtils.getString((DynamicObject)supplyRelationAuth, (String)"supplyrelation"));
        this.setValue("uuid", this.getNewUuid());
        List<Long> cartIdList = this.getCartIdList();
        QFilter filter = new QFilter("id", "in", cartIdList);
        DynamicObjectCollection cartInfos = SaleOrderHelper.getCartData((QFilter)filter);
        if (cartInfos != null && !cartInfos.isEmpty()) {
            List itemIds = cartInfos.stream().map(r -> r.getLong("item")).collect(Collectors.toList());
            DynamicObjectCollection combineItemDynColl = this.queryCombineItemDynColl(itemIds.toArray());
            int size = combineItemDynColl.size();
            Map<Object, Object> combineItemDynMap = new HashMap(size);
            if (!CommonUtils.isNull((Object)combineItemDynColl)) {
                combineItemDynMap = combineItemDynColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("combitemid")));
            }
            long[] genLongIds = new long[]{};
            if (combineItemDynMap.size() > 0) {
                genLongIds = DB.genGlobalLongIds((int)combineItemDynMap.size());
            }
            int i = 0;
            for (DynamicObject cart : cartInfos) {
                int rowIndex = this.getModel().createNewEntryRow("itementry");
                long itemId = cart.getLong("item");
                this.setValue("itemid", itemId, rowIndex);
                this.setValue("auxptyid", cart.getLong("auxpty"), rowIndex);
                this.setValue("qty", cart.getBigDecimal("qty"), rowIndex);
                this.setValue("auxqty", cart.getBigDecimal("auxqty"), rowIndex);
                this.setValue("auxunit", cart.getLong("auxunit"), rowIndex);
                this.setValue("cartid", cart.getLong("id"), rowIndex);
                if (combineItemDynMap.containsKey(itemId)) {
                    long genLongId = genLongIds[i++];
                    this.setValue(EF_entryid, genLongId, rowIndex);
                    this.getModel().getEntryRowEntity("itementry", rowIndex).set("id", (Object)genLongId);
                    List combineItemDynList = (List)combineItemDynMap.get(itemId);
                    if (combineItemDynList == null) continue;
                    this.setValue("combinationid", ((DynamicObject)combineItemDynList.get(0)).getLong("id"), rowIndex);
                    for (DynamicObject combineItem : combineItemDynList) {
                        int combineIndex = this.getModel().createNewEntryRow("itementry");
                        this.setValue("combinationid", combineItem.getLong("id"), combineIndex);
                        this.setValue("itemid", combineItem.getLong("item"), combineIndex);
                        this.setValue("auxptyid", combineItem.getLong("materialassist"), combineIndex);
                        this.setValue("qty", cart.getBigDecimal("qty").multiply(combineItem.getBigDecimal("qty")), combineIndex);
                        this.setValue("combineparentid", genLongId, combineIndex);
                        this.setValue("subitemqty", combineItem.getBigDecimal("qty"), combineIndex);
                        this.setValue("pricepercent", combineItem.getBigDecimal("pricepercent"), combineIndex);
                        this.setValue("auxptyid", combineItem.getLong("materialassist"), combineIndex);
                    }
                }
                this.setItemAmount(rowIndex);
            }
        }
    }

    private void loadOrderFromList() {
        long orderId = (Long)this.getParameter("orderId");
        DynamicObject order = (DynamicObject)SaleOrderHelper.invokeOrderService((String)"getSaleOrder", (Object[])new Object[]{orderId});
        this.setValue("saleorgid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)order, (String)"saleorgid"));
        this.setValue("salechannelid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)order, (String)"salechannelid"));
        this.setValue("orderchannelid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)order, (String)"orderchannelid"));
        this.setValue("supplierid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)order, (String)"supplierid"));
        this.setValue("supplyrelation", order.getString("supplyrelation"));
        this.setValue("uuid", this.getNewUuid());
        DynamicObjectCollection itemEntry = order.getDynamicObjectCollection("itementry");
        List<Object> marketItemId = this.getMarketItemIds();
        if (!itemEntry.isEmpty()) {
            itemEntry.removeIf(r -> r.getLong("combineparentid") != 0L || r.getBoolean("ispresent"));
            StringBuilder resultMsg = new StringBuilder();
            for (DynamicObject item : itemEntry) {
                if (marketItemId.contains(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"itemid"))) continue;
                resultMsg.append(item.getString("itemid.name")).append(",");
            }
            if (resultMsg.length() > 0) {
                this.getView().showTipNotification(String.format("\u5546\u54c1\uff1a%s\u4e0d\u5728\u53ef\u9500\u8303\u56f4\uff0c\u4e0d\u80fd\u518d\u6b21\u8d2d\u4e70\u3002", resultMsg.substring(0, resultMsg.length() - 1)));
                itemEntry.removeIf(r -> !marketItemId.contains(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"itemid")));
            }
            List itemIds = itemEntry.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"itemid")).collect(Collectors.toList());
            DynamicObjectCollection combineItemDynColl = this.queryCombineItemDynColl(itemIds.toArray());
            int size = combineItemDynColl.size();
            Map<Object, Object> combineItemDynMap = new HashMap(size);
            if (!CommonUtils.isNull((Object)combineItemDynColl)) {
                combineItemDynMap = combineItemDynColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("combitemid")));
            }
            long[] genLongIds = new long[]{};
            if (combineItemDynMap.size() > 0) {
                genLongIds = DB.genGlobalLongIds((int)combineItemDynMap.size());
            }
            int i = 0;
            if (!itemEntry.isEmpty()) {
                for (DynamicObject item : itemEntry) {
                    int rowIndex = this.getModel().createNewEntryRow("itementry");
                    long itemId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"itemid");
                    this.setValue("itemid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"itemid"), rowIndex);
                    this.setValue("auxptyid", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"auxptyid"), rowIndex);
                    this.setValue("qty", item.getBigDecimal("approveqty"), rowIndex);
                    this.setValue("auxqty", item.getBigDecimal("approveassistqty"), rowIndex);
                    this.setValue("auxunit", DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)item, (String)"assistunitid"), rowIndex);
                    if (!combineItemDynMap.containsKey(itemId)) continue;
                    long genLongId = genLongIds[i++];
                    this.getModel().getEntryRowEntity("itementry", rowIndex).set("id", (Object)genLongId);
                    List combineItemDynList = (List)combineItemDynMap.get(itemId);
                    if (combineItemDynList == null) continue;
                    this.setValue("combinationid", ((DynamicObject)combineItemDynList.get(0)).getLong("id"), rowIndex);
                    for (DynamicObject combineItem : combineItemDynList) {
                        int combineIndex = this.getModel().createNewEntryRow("itementry");
                        this.setValue("combinationid", combineItem.getLong("id"), combineIndex);
                        this.setValue("itemid", combineItem.getLong("item"), combineIndex);
                        this.setValue("auxptyid", combineItem.getLong("materialassist"), combineIndex);
                        this.setValue("qty", item.getBigDecimal("approveqty").multiply(combineItem.getBigDecimal("qty")), combineIndex);
                        this.setValue("combineparentid", genLongId, combineIndex);
                        this.setValue("subitemqty", combineItem.getBigDecimal("qty"), combineIndex);
                        this.setValue("pricepercent", combineItem.getBigDecimal("pricepercent"), combineIndex);
                        this.setValue("auxptyid", combineItem.getLong("materialassist"), combineIndex);
                    }
                }
            }
        }
    }

    private List<Long> getCartIdList() {
        String[] cartIds = this.getParameter("cartids").toString().split(",");
        ArrayList<Long> cIdList = new ArrayList<Long>(cartIds.length);
        Arrays.asList(cartIds).stream().forEach(c -> cIdList.add(Long.parseLong(c)));
        return cIdList;
    }

    private String getObjectPK(String key) {
        return String.join((CharSequence)"_", key, "id");
    }

    public long getSettleOrg(long saleOrgId) {
        Map map;
        long settleorgid = 0L;
        if (saleOrgId != 0L && !CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            settleorgid = Long.parseLong(map.get("id").toString());
        }
        return settleorgid;
    }

    private void setExRateTable(long settleOrgId, DynamicObject data) {
        long exratetableId;
        DynamicObjectCollection accountingsys;
        Date now = new Date();
        data.set("exratedate", (Object)now);
        this.setDefaultExRate(data);
        if (settleOrgId != 0L && !CommonUtils.isNull((Object)(accountingsys = QueryServiceHelper.query((String)"bd_accountingsys_base", (String)"id,exratetable,basecurrrency", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", (Object)settleOrgId)}))) && (exratetableId = ((DynamicObject)accountingsys.get(0)).getLong("exratetable")) > 0L) {
            data.set(this.getObjectPK("exchangeratetable"), (Object)exratetableId);
            long basecurrencyId = ((DynamicObject)accountingsys.get(0)).getLong("basecurrrency");
            data.set(this.getObjectPK("basecurrencyid"), (Object)basecurrencyId);
            DynamicObject settleCurrency = data.getDynamicObject("settlecurrencyid");
            BigDecimal exchangeRate = BigDecimal.ONE;
            if (settleCurrency != null) {
                exchangeRate = this.getExchangeRate(settleCurrency.getLong("id"), basecurrencyId, exratetableId, now);
            }
            data.set("exchangerate", (Object)exchangeRate);
        }
    }

    private void setDefaultExRate(DynamicObject data) {
        data.set(this.getObjectPK("exchangeratetable"), (Object)0L);
        data.set("exchangerate", (Object)1);
        data.set(this.getObjectPK("basecurrencyid"), (Object)0L);
    }

    private BigDecimal getExchangeRate(long srcCurId, long targetCurId, long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == targetCurId) {
            exchangeRate = BigDecimal.ONE;
        } else {
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targetCurId, (Date)date);
            if (null == exchangeRate || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
                exchangeRate = BigDecimal.ONE;
            }
        }
        return exchangeRate;
    }

    private void viewOrder() {
        long orderId = (Long)this.getParameter("orderId");
        this.getModel().setValue("id", (Object)orderId);
        DynamicObject order = this.getOrder();
        IDataModel model = this.getModel();
        model.setValue("billno", order.get("billno"));
        String billStatus = this.getBillStatus4View(order.get("billstatus"));
        String signStatus = this.getSignStatus4View(order.get("signstatus"));
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl("signstatus")), (Object)signStatus);
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl("billstatus")), (Object)billStatus);
        model.setValue("orderdate", order.get("orderdate"));
        model.setValue("supplierid", order.get("supplierid"));
        model.setValue("orderchannelid", order.get("orderchannelid"));
        model.setValue("balancechannelid", order.get("balancechannelid"));
        model.setValue("pricechannelid", order.get("pricechannelid"));
        model.setValue("settlecurrencyid", order.get("settlecurrencyid"));
        model.setValue("billtypeid", order.get("billtypeid"));
        model.setValue("exchangerate", order.get("exchangerate"));
        model.setValue("sumdiscountamount", order.get("sumdiscountamount"));
        model.setValue("orderamount", order.get("sumreceivableamount"));
        model.setValue("payamount", order.get("sumunrecamount"));
        DynamicObjectCollection recEntryEntity = order.getDynamicObjectCollection("recentryentity");
        BigDecimal incdeduction = BigDecimal.ZERO;
        if (recEntryEntity != null && recEntryEntity.size() > 0) {
            for (DynamicObject entry : recEntryEntity) {
                DynamicObject receiptOffsetDynObj = entry.getDynamicObject("receiptoffsetid");
                DynamicObject accountTypeDynObj = entry.getDynamicObject("accounttypeid");
                if (receiptOffsetDynObj == null || accountTypeDynObj == null || receiptOffsetDynObj.getLong("id") != receiptOffsetId.longValue() || accountTypeDynObj.getLong("id") != accountTypeId.longValue()) continue;
                incdeduction = incdeduction.add(entry.getBigDecimal("usedamount"));
            }
        }
        if (incdeduction.compareTo(BigDecimal.ZERO) > 0) {
            model.setValue(F_incdeduction, (Object)incdeduction);
            this.setVisible(new String[]{"flexpanelapinc"});
        } else {
            this.setDisVisible(new String[]{"flexpanelapinc"});
        }
        model.setValue("auditor", order.get("auditor"));
        model.setValue("auditdate", order.get("auditdate"));
        model.setValue("orderremark", order.get("orderremark"));
        model.setValue("vehicleid", order.get("vehicleid"));
        this.setValue("invoicetype", order.get("invoicetype"));
        this.setValue("invoeicetakerid", order.get("invoeicetakerid"));
        this.setValue("invoicephone", order.get("invoicephone"));
        this.setValue("invoiceaddress", order.get("invoiceaddress"));
        DynamicObjectCollection itemEntry = order.getDynamicObjectCollection("itementry");
        if (itemEntry != null && !itemEntry.isEmpty()) {
            int[] rowIndexes = model.batchCreateNewEntryRow("itementry", itemEntry.size());
            model.setValue("entrycount", (Object)itemEntry.size());
            for (int i = 0; i < itemEntry.size(); ++i) {
                DynamicObject item = (DynamicObject)itemEntry.get(i);
                int rowIndex = rowIndexes[i];
                this.setValue("itemid", item.get("itemid"), rowIndex);
                this.setValue("materialid", item.get("materialid"), rowIndex);
                this.setValue("auxptyid", item.get("auxptyid"), rowIndex);
                this.setValue("qty", item.getBigDecimal("approveqty"), rowIndex);
                this.setValue("auxqty", item.getBigDecimal("approveassistqty"), rowIndex);
                this.setValue("unit", item.get("unit"), rowIndex);
                this.setValue("auxunit", item.get("assistunitid"), rowIndex);
                this.setValue("price", item.getBigDecimal("price"), rowIndex);
                this.setValue("combinationid", item.get("combinationid"), rowIndex);
                this.setValue("combineparentid", item.get("combineparentid"), rowIndex);
                this.setValue("actualtaxprice", item.getBigDecimal("actualtaxprice"), rowIndex);
                this.setValue("taxamount", item.get("taxamount"), rowIndex);
                DynamicObject itemDynObj = this.getEntryF7Value("itementry", "itemid", rowIndex);
                if (itemDynObj == null) continue;
                this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex);
            }
        }
        Map<String, BigDecimal> totalMap = this.calcTotalQty();
        BigDecimal totalQty = totalMap.get("qty");
        BigDecimal totalAuxQty = totalMap.get("auxqty");
        model.setValue("totalqty", (Object)totalQty.stripTrailingZeros().toPlainString());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.getDynamicObjectType().getProperties().containsKey((Object)"totalauxqty")) {
            model.setValue("totalauxqty", (Object)totalAuxQty.stripTrailingZeros().toPlainString());
        }
    }

    private String getBillStatus4View(Object v) {
        String billStatus = "";
        if (v == null) {
            return "null";
        }
        switch (v.toString()) {
            case "A": {
                billStatus = "\u6682\u5b58";
                break;
            }
            case "B": {
                billStatus = "\u5df2\u63d0\u4ea4";
                break;
            }
            case "C": {
                billStatus = "\u5df2\u5ba1\u6838";
                break;
            }
            case "D": {
                billStatus = "\u90e8\u5206\u53d1\u8d27";
                break;
            }
            case "E": {
                billStatus = "\u5df2\u53d1\u8d27";
                break;
            }
            case "F": {
                billStatus = "\u5df2\u5b8c\u6210";
                break;
            }
            case "P": {
                billStatus = "\u9884\u63d0\u4ea4";
                break;
            }
        }
        return billStatus;
    }

    private String getSignStatus4View(Object v) {
        String signStatus = "";
        if (v == null) {
            return "null";
        }
        switch (v.toString()) {
            case "A": {
                signStatus = "\u672a\u53d1\u8d27";
                break;
            }
            case "B": {
                signStatus = "\u5f85\u7b7e\u6536";
                break;
            }
            case "C": {
                signStatus = "\u90e8\u5206\u7b7e\u6536";
                break;
            }
            case "D": {
                signStatus = "\u7b7e\u6536\u5b8c\u6210";
                break;
            }
        }
        return signStatus;
    }

    private void setItemEntityFieldInfo(int rowIndex) {
        DynamicObject itemDynObj = this.getEntryF7Value("itementry", "itemid", rowIndex);
        long materialId = 0L;
        long unitId = 0L;
        long auxUnitId = 0L;
        if (itemDynObj != null) {
            materialId = itemDynObj.getDynamicObject("material") != null ? itemDynObj.getDynamicObject("material").getLong("id") : 0L;
            unitId = itemDynObj.getDynamicObject("orderunit") != null ? itemDynObj.getDynamicObject("orderunit").getLong("id") : 0L;
            auxUnitId = itemDynObj.getDynamicObject("assistunit") != null ? itemDynObj.getDynamicObject("assistunit").getLong("id") : 0L;
            this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex, false);
        }
        this.setValue("materialid", materialId, rowIndex, true);
        this.setValue("unit", unitId, rowIndex, false);
        Object objUnit = this.getValue("unit", rowIndex);
        if (objUnit != null) {
            DynamicObject unit = (DynamicObject)objUnit;
            this.setValue(EF_unitname, DynamicObjectUtils.getString((DynamicObject)unit, (String)"name"), rowIndex, false);
        }
        if (SysParamsUtil.getIsAuxUnitOrder()) {
            this.setValue("auxunit", auxUnitId, rowIndex, false);
        }
        this.setTaxrateTable(rowIndex, materialId);
        DynamicObject material = (DynamicObject)this.getValue("materialid", rowIndex);
        if (material != null) {
            boolean isOpenSelectAuxpty;
            String multiUnitOrder = SysParamsUtil.getMultiUnitOrder();
            boolean isUseAuxpty = DynamicObjectUtils.getBoolean((DynamicObject)material, (String)"isuseauxpty");
            boolean bl = isOpenSelectAuxpty = isUseAuxpty && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)orgOrder) || !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)multiUnitOrder, (CharSequence)orgOrder);
            if (isOpenSelectAuxpty) {
                this.setValue("isuseauxpty", true, rowIndex);
            }
        }
        this.triggerChangeEvent = true;
    }

    private void clearItemData(int rowIndex) {
        this.setValue("materialid", null, rowIndex, true);
        this.setValue("unit", null, rowIndex, false);
        this.setValue("thumbnail", null, rowIndex, false);
        this.setValue("taxrateid", null, rowIndex, false);
        this.setValue("taxrate", BigDecimal.ZERO, rowIndex, false);
        this.setValue("taxprice", BigDecimal.ZERO, rowIndex, false);
        this.setValue("pricediscount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("discountamount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("unitdiscount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("taxamount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("tax", BigDecimal.ZERO, rowIndex, false);
        this.setValue("amount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("actualtaxprice", BigDecimal.ZERO, rowIndex, false);
        this.setValue("actualprice", BigDecimal.ZERO, rowIndex, false);
        this.setValue("price", BigDecimal.ZERO, rowIndex, false);
    }

    private void setTaxrateTable(int rowIndex, long materialId) {
        DynamicObject taxrate;
        if (materialId == 0L) {
            return;
        }
        DynamicObject material = BusinessDataServiceHelper.loadSingle((Object)materialId, (String)"bd_material");
        if (material != null && (taxrate = material.getDynamicObject("taxrate")) != null) {
            this.setValue("taxrateid", taxrate, rowIndex);
            this.setValue("taxrate", taxrate.get("taxrate"), rowIndex);
        }
    }

    private Map<String, BigDecimal> calcTotalQty() {
        IDataModel model = this.getModel();
        DynamicObjectCollection itemList = model.getDataEntity(true).getDynamicObjectCollection("itementry");
        List itemEntryList = itemList.stream().filter(r -> r.getLong("combinationid_id") == 0L || r.getLong("combinationid_id") != 0L && r.getLong("combineparentid") != 0L).collect(Collectors.toList());
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAuxQty = BigDecimal.ZERO;
        if (itemEntryList != null && !itemEntryList.isEmpty()) {
            for (DynamicObject item : itemEntryList) {
                totalQty = totalQty.add(item.getBigDecimal("qty"));
                if (!item.getDynamicObjectType().getProperties().containsKey((Object)"auxqty")) continue;
                totalAuxQty = totalAuxQty.add(item.getBigDecimal("auxqty"));
            }
        }
        HashMap<String, BigDecimal> totalMap = new HashMap<String, BigDecimal>(0);
        totalMap.put("qty", totalQty);
        totalMap.put("auxqty", totalAuxQty);
        return totalMap;
    }

    private void calcOrderData() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObjectCollection itemList = model.getDataEntity(true).getDynamicObjectCollection("itementry");
        List itemEntryList = itemList.stream().filter(r -> r.getLong("combinationid_id") == 0L || r.getLong("combinationid_id") != 0L && r.getLong("combineparentid") != 0L).collect(Collectors.toList());
        if (itemEntryList != null && !itemEntryList.isEmpty()) {
            model.setValue("entrycount", (Object)itemEntryList.size());
            Map<String, BigDecimal> totalMap = this.calcTotalQty();
            BigDecimal totalQty = totalMap.get("qty");
            BigDecimal totalAuxQty = totalMap.get("auxqty");
            model.setValue("totalqty", (Object)totalQty.stripTrailingZeros().toPlainString());
            if (dataEntity.getDynamicObjectType().getProperties().containsKey((Object)"totalauxqty")) {
                model.setValue("totalauxqty", (Object)totalAuxQty.stripTrailingZeros().toPlainString());
            }
        } else {
            model.setValue("entrycount", (Object)0);
            model.setValue("totalqty", (Object)0);
            if (dataEntity.getDynamicObjectType().getProperties().containsKey((Object)"totalauxqty")) {
                model.setValue("totalauxqty", (Object)0);
            }
        }
    }

    private synchronized DynamicObject buildSaleOrder() {
        if (!this.validator()) {
            return null;
        }
        this.getOrder();
        if (this.order != null && !Status.SAVED.toString().equals(this.order.getString("billstatus"))) {
            throw new KDBizException("\u53ea\u6709\u6682\u5b58\u72b6\u6001\u624d\u5141\u8bb8\u63d0\u4ea4");
        }
        if (this.order == null) {
            this.order = BusinessDataServiceHelper.newDynamicObject((String)"ocbsoc_saleorder");
        }
        this.buildHeaderData(this.order);
        this.getAlgorithmForMobile();
        this.buildRecEntryData(this.order);
        BigDecimal sumReceivableAmount = this.getNullToZero(this.getModel().getValue("sumreceivableamount"));
        BigDecimal sumRecAmount = this.getNullToZero(this.getModel().getValue("sumrecamount"));
        this.order.set("sumrecamount", (Object)sumRecAmount);
        this.order.set("sumunrecamount", (Object)sumReceivableAmount.subtract(sumRecAmount));
        this.order.set("uuid", this.getValue("uuid"));
        this.buildItemEntryData(this.order);
        this.buildPromotionEntryData(this.order);
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSubmitTime() {
        DLock dLock = null;
        try {
            dLock = this.createDLock();
            if (dLock.tryLock(60000L)) {
                String submitTime = this.getPageCache().get("nextsubmittime");
                long currentTime = KDDateUtils.now().getTime();
                if (submitTime == null || currentTime >= Long.parseLong(submitTime)) {
                    this.getPageCache().put("nextsubmittime", Long.toString(currentTime + 5000L));
                    long l = 0L;
                    return l;
                }
                long t = (Long.parseLong(submitTime) - currentTime) / 1000L;
                long l = t == 0L ? 1L : t;
                return l;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (dLock != null) {
                dLock.unlock();
            }
        }
        return 5L;
    }

    private void submitByLock() {
        boolean isShowWindow;
        long sumbitTime = this.getSubmitTime();
        if (sumbitTime > 0L) {
            this.getView().showErrorNotification(MessageFormat.format("\u8ba2\u5355\u6b63\u5728\u63d0\u4ea4\u4e2d\uff0c\u8bf7{0}\u79d2\u540e\u518d\u63d0\u4ea4", sumbitTime));
            return;
        }
        this.saveOrder(true);
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("saleorgid"));
        boolean isOpenPromotion = ChannelDeployUtil.getOpenPromotion((long)saleOrgId);
        boolean isOpenAutoPromotion = ChannelDeployUtil.getOpenAutoPromotion((long)saleOrgId);
        if (isOpenPromotion && isOpenAutoPromotion && (isShowWindow = this.matchPromotion(false))) {
            return;
        }
        this.submit();
        this.getPageCache().put("nextsubmittime", "0");
    }

    private void saveOrder(boolean ignoreAutoPromotion) {
        OperationResult result;
        DynamicObjectCollection itemEntry;
        MobDataMutexHelper.checkMobDataMutex((IFormView)this.getView(), (boolean)true);
        this.order = this.buildSaleOrder();
        if (this.order == null) {
            return;
        }
        if (this.isEdit() && (itemEntry = this.order.getDynamicObjectCollection("itementry")) != null) {
            for (DynamicObject item : itemEntry) {
                item.getDynamicObjectCollection("subentryentity").clear();
            }
        }
        this.pluginProxy.callAfter(p -> {
            p.beforeSubmit(this.getModel(), this.order);
            return null;
        });
        OperateOption saveOption = CommonUtils.getMutexOperateOption();
        saveOption.setVariableValue("isStrict", String.valueOf(false));
        long orderId = this.order.getLong("id");
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (this.isAddNew() && orderId == 0L && !OCDMA_SALEORDER_LIST.equals(parentFormId)) {
            saveOption.setVariableValue("forceuuid", "1");
        }
        if (ignoreAutoPromotion) {
            saveOption.setVariableValue("ignoreautopromotion", "1");
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"save", (String)"ocbsoc_saleorder", (DynamicObject[])new DynamicObject[]{this.order}, (OperateOption)saveOption)).isSuccess()) {
            this.showMessage(result, false);
            return;
        }
        orderId = Long.parseLong(result.getSuccessPkIds().get(0).toString());
        this.getModel().setValue("id", (Object)orderId);
        this.order = (DynamicObject)SaleOrderHelper.invokeOrderService((String)"getSaleOrder", (Object[])new Object[]{orderId});
        String billNo = this.order.getString("billno");
        super.createDataMutex("ocbsoc_saleorder", billNo, orderId + "", false);
        DynamicObjectCollection orderItemEntryEntity = this.order.getDynamicObjectCollection("itementry");
        if (orderItemEntryEntity != null && !orderItemEntryEntity.isEmpty()) {
            for (int i = 0; i < orderItemEntryEntity.size(); ++i) {
                DynamicObject itemEntry2 = (DynamicObject)orderItemEntryEntity.get(i);
                long itemEntryId = itemEntry2.getLong("id");
                this.setValue("itementry.id", itemEntryId, i);
                this.setValue(EF_entryid, itemEntryId, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit() {
        boolean isSuccess;
        long id;
        block11: {
            Object cartIds = this.getParameter("cartids");
            id = (Long)this.getModel().getValue("id");
            String fromPage = StringUtils.isNotNull((Object)cartIds) ? "ocdma_cart" : OCDMA_SALEORDER_LIST;
            isSuccess = false;
            try {
                OperationResult result = null;
                if (this.getView().getPageCache().get("enablepresubmit") != null) {
                    OperateOption submitOption = CommonUtils.getMutexOperateOption();
                    result = OperationServiceHelper.executeOperate((String)"presubmit", (String)"ocbsoc_saleorder", (Object[])new Long[]{id}, (OperateOption)submitOption);
                } else {
                    OperateOption submitOption = CommonUtils.getMutexOperateOption();
                    submitOption.setVariableValue("isfrommobilesubmit", "1");
                    submitOption.setVariableValue("resetsubentry", String.valueOf(true));
                    submitOption.setVariableValue("isStrict", String.valueOf(false));
                    result = OperationServiceHelper.executeOperate((String)"submit", (String)"ocbsoc_saleorder", (Object[])new Long[]{id}, (OperateOption)submitOption);
                }
                if (result.isSuccess()) {
                    if (fromPage.equals("ocdma_cart")) {
                        this.deleteCartAfterSave(this.order);
                        this.setCartBadgeInfo();
                    }
                    this.setValue("id", id);
                    this.getPageCache().put("operationStatus", OperationStatus.EDIT.toString());
                    this.toOrderList(this.getView());
                    isSuccess = true;
                    break block11;
                }
                this.showMessage(result, true);
            }
            catch (Exception e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (!isSuccess && !this.isEdit()) {
                        OperationServiceHelper.executeOperate((String)"delete", (String)"ocbsoc_saleorder", (Object[])new Long[]{id}, (OperateOption)CommonUtils.getOperateOption());
                        this.setValue("id", 0L);
                        DeleteServiceHelper.delete((String)"ocbsoc_saleorderunique", (QFilter[])new QFilter[]{new QFilter("uuid", "=", (Object)((String)this.getModel().getValue("uuid")))});
                    }
                    throw throwable;
                }
                if (!isSuccess && !this.isEdit()) {
                    OperationServiceHelper.executeOperate((String)"delete", (String)"ocbsoc_saleorder", (Object[])new Long[]{id}, (OperateOption)CommonUtils.getOperateOption());
                    this.setValue("id", 0L);
                    DeleteServiceHelper.delete((String)"ocbsoc_saleorderunique", (QFilter[])new QFilter[]{new QFilter("uuid", "=", (Object)((String)this.getModel().getValue("uuid")))});
                }
            }
        }
        if (!isSuccess && !this.isEdit()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"ocbsoc_saleorder", (Object[])new Long[]{id}, (OperateOption)CommonUtils.getOperateOption());
            this.setValue("id", 0L);
            DeleteServiceHelper.delete((String)"ocbsoc_saleorderunique", (QFilter[])new QFilter[]{new QFilter("uuid", "=", (Object)((String)this.getModel().getValue("uuid")))});
        }
    }

    private void showMessage(OperationResult result, boolean isSubmit) {
        if (result.isSuccess()) {
            return;
        }
        List allError = result.getAllErrorInfo();
        if (!allError.isEmpty()) {
            ArrayList<String> allErrorMessageList = new ArrayList<String>(1);
            for (OperateErrorInfo error : allError) {
                allErrorMessageList.add(error.getMessage());
            }
            this.getView().showErrorNotification(String.join((CharSequence)",", allErrorMessageList));
            return;
        }
        List validResultList = result.getValidateResult().getValidateErrors();
        ArrayList<String> fatalErrorMessageList = new ArrayList<String>(1);
        ArrayList<String> errorMessageList = new ArrayList<String>(1);
        ArrayList<String> warningMessageList = new ArrayList<String>(1);
        for (ValidateResult validation : validResultList) {
            List allErrorInfo = validation.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                ErrorLevel errorLevel = errorInfo.getLevel();
                switch (errorLevel) {
                    case FatalError: {
                        fatalErrorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Error: {
                        errorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Warning: {
                        warningMessageList.add(errorInfo.getMessage());
                        break;
                    }
                }
            }
        }
        if (!fatalErrorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", fatalErrorMessageList));
        } else if (!errorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", errorMessageList));
        } else if (!warningMessageList.isEmpty() && isSubmit) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitConfirmCallBack", (IFormPlugin)this);
            String message = MessageFormat.format("{0} - {1}", result.getMessage(), String.join((CharSequence)",", warningMessageList));
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
        } else if (StringUtils.isNotNull((String)result.getMessage())) {
            this.getView().showErrorNotification(result.getMessage());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        boolean isYes = e.getResult().equals((Object)MessageBoxResult.Yes);
        switch (callBackId) {
            case "submitConfirmCallBack": {
                if (!isYes) break;
                DynamicObject newOrder = this.buildSaleOrder();
                if (newOrder == null) {
                    return;
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ignorewarn", String.valueOf(true));
                String operationMsg = OperationUtil.invokeOperationToStr((DynamicObject[])new DynamicObject[]{newOrder}, (String)"submit", (OperateOption)operateOption);
                if (StringUtils.isEmpty((String)operationMsg)) {
                    this.toOrderList(this.getView());
                    break;
                }
                this.getView().showErrorNotification(operationMsg);
                break;
            }
            case "matchPromotion": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.cancelMatchPromotion();
                this.saveOrder(true);
                this.matchPromotion(true);
                break;
            }
            case "cancelmatchPromotion": {
                String customVaule;
                if (isYes) {
                    this.cancelMatchPromotion();
                }
                if (StringUtils.isNotEmpty((String)(customVaule = e.getCustomVaule()))) {
                    int size;
                    String[] strs = customVaule.split("_");
                    String keyStr = strs[0];
                    String rowIndex = strs[1];
                    String oldValue = "null".equals(strs[2]) ? null : strs[2];
                    String newValue = "null".equals(strs[3]) ? null : strs[3];
                    String value = isYes ? newValue : oldValue;
                    DynamicObjectCollection itemEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
                    int editRowIndex = Integer.parseInt(rowIndex);
                    if (editRowIndex >= (size = itemEntryColl.size())) {
                        editRowIndex = size - 1;
                    }
                    this.setValue(keyStr, StringUtils.isNotEmpty((String)value) ? value : null, editRowIndex, isYes);
                }
                this.setValue("autoedititementry", false);
                this.calcOrderData();
                break;
            }
            case "close": {
                if (isYes) {
                    long billId = (Long)this.getModel().getValue("id");
                    OperationServiceHelper.executeOperate((String)"delete", (String)"ocbsoc_saleorder", (Object[])new Object[]{billId}, (OperateOption)CommonUtils.getOperateOption());
                    this.getView().close();
                    break;
                }
                this.toOrderList(this.getView());
                break;
            }
            case "submit": {
                if (!isYes) break;
                this.getModel().setValue("uuid", (Object)Long.toString(DB.genGlobalLongId()));
                this.submitByLock();
                break;
            }
        }
    }

    private boolean validator() {
        Long supplierId;
        DynamicObject channelAuthorize;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject receiveAddress = dataEntity.getDynamicObject(F_receiveaddressid);
        if (receiveAddress == null) {
            throw new KDBizException("\u8bf7\u586b\u5199\u6536\u8d27\u5730\u5740\u3002");
        }
        Long orderChannelId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "orderchannelid", "id"));
        Long saleChannelId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "salechannelid", "id"));
        if (saleChannelId < 1L && (channelAuthorize = BusinessDataServiceHelper.loadSingle((Object)(supplierId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "supplierid", "id"))), (String)"ocdbd_channel_authorize", (String)String.join((CharSequence)",", "saleorg", String.join((CharSequence)".", "saleorg", "name"), "salechannel", String.join((CharSequence)".", "salechannel", "name")))) != null && channelAuthorize.get("salechannel") != null) {
            DynamicObject saleChannel = channelAuthorize.getDynamicObject("salechannel");
            saleChannelId = saleChannel.getLong("id");
        }
        ArrayList<Long> channelIds = new ArrayList<Long>(2);
        channelIds.add(orderChannelId);
        channelIds.add(saleChannelId);
        DynamicObject channels = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)String.join((CharSequence)",", "name", "enable", "id"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)channelIds.toArray())});
        if (channels == null || channelIds.isEmpty()) {
            throw new KDBizException("\u8ba2\u8d27\u6e20\u9053\u6216\u9500\u552e\u6e20\u9053\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
        }
        for (DynamicObject temp : channels) {
            if (!StringUtils.isNotEmpty((String)temp.getString("enable")) || !EnableStatusEnum.DISABLE.getValue().equals(temp.getString("enable"))) continue;
            throw new KDBizException("\u8ba2\u8d27\u6e20\u9053\u6216\u9500\u552e\u6e20\u9053\u5df2\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("itementry");
        if (entries == null || entries.isEmpty()) {
            throw new KDBizException("\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5546\u54c1\u660e\u7ec6\u5206\u5f55\u3002");
        }
        int rowIndex = 0;
        for (DynamicObject entry : entries) {
            ++rowIndex;
            Object qty = entry.get("qty");
            if (BigDecimalUtil.toBigDecimal((Object)qty).compareTo(BigDecimal.ZERO) <= 0) {
                throw new KDBizException(String.format("\u7b2c%1$s\u884c\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", rowIndex));
            }
            BigDecimal price = entry.getBigDecimal("price");
            boolean isPresent = entry.getBoolean("ispresent");
            if (isPresent || price.compareTo(BigDecimal.ZERO) > 0) continue;
            throw new KDBizException(String.format("\u7b2c%1$s\u884c\u5546\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a0\uff0c \u8bf7\u8054\u7cfb\u4ef7\u683c\u7ba1\u7406\u5458\u7ef4\u62a4\u6b63\u786e\u7684\u4ef7\u683c\u3002", rowIndex));
        }
        return true;
    }

    private void buildRecEntryData(DynamicObject newOrder) {
        DynamicObjectCollection recEntrys = newOrder.getDynamicObjectCollection("recentryentity");
        recEntrys.clear();
        boolean isUseRebateAmount = SysParamsUtil.isUseRebateAmount();
        boolean isEnableBalModel = SysParamsUtil.isEnableBalModel();
        if (!isUseRebateAmount && !isEnableBalModel) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection modelRecEntries = model.getEntryEntity("recentryentity");
        if (modelRecEntries != null) {
            for (int rowIndex = 0; rowIndex < modelRecEntries.size(); ++rowIndex) {
                Object accountTypeObject;
                DynamicObject entry = (DynamicObject)modelRecEntries.get(rowIndex);
                DynamicObject newRecEntry = recEntrys.addNew();
                newRecEntry.set("seq", (Object)(rowIndex + 1));
                Object receiptOffsetObject = this.getEntryF7PKValue("recentryentity", "receiptoffset", rowIndex);
                if (receiptOffsetObject != null) {
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newRecEntry, (String)"receiptoffsetid", (long)((Long)receiptOffsetObject));
                }
                if ((accountTypeObject = this.getEntryF7PKValue("recentryentity", "accounttype", rowIndex)) != null) {
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newRecEntry, (String)"accounttypeid", (long)((Long)accountTypeObject));
                }
                newRecEntry.set("availablebalance", entry.get("availablebalance"));
                newRecEntry.set("billamount", entry.get("billamount"));
                newRecEntry.set("usedamount", entry.get("usedamount"));
                newRecEntry.set("isenough", entry.get("isenough"));
                newRecEntry.set("isshareoffset", entry.get("isshareoffset"));
                newRecEntry.set("tipmsg", entry.get("tipmsg"));
                newRecEntry.set("cashpoolid", entry.get("cashpoolid"));
                MobExtendHelper.setMobExtToOrmExt((DynamicObject)entry, (DynamicObject)newRecEntry, (String)this.getView().getEntityId(), (String)"ocbsoc_saleorder");
            }
        }
        if (!CommonUtils.isNull((Object)recEntrys)) {
            BusinessDataServiceHelper.loadRefence((Object[])recEntrys.toArray(), (IDataEntityType)recEntrys.getDynamicObjectType());
        }
    }

    private boolean isCombEntry(DynamicObject itemDynObj) {
        return itemDynObj != null && GoodsTypeEnum.COMBINEGOODS.getValue().equals(itemDynObj.getString(String.join((CharSequence)"_", "itemtypeid", "id")));
    }

    protected void setDeliverPlanEntry(DynamicObject deliverEntryDynObj, DynamicObject parentEntryDynObj) {
        deliverEntryDynObj.set("seq", (Object)1);
        this.setSubRowInfo(deliverEntryDynObj, parentEntryDynObj);
    }

    private void setSubRowInfo(DynamicObject planEntryDynObj, DynamicObject parentEntryDynObj) {
        planEntryDynObj.set("sub_itemid", parentEntryDynObj.get("itemid"));
        planEntryDynObj.set("sub_saleattrid", parentEntryDynObj.get("saleattrid"));
        planEntryDynObj.set("sub_unitid", parentEntryDynObj.get("unit"));
        planEntryDynObj.set("sub_qty", parentEntryDynObj.get("approveqty"));
        planEntryDynObj.set("sub_baseunitid", parentEntryDynObj.get("baseunit"));
        planEntryDynObj.set("sub_baseqty", parentEntryDynObj.get("approvebaseqty"));
        planEntryDynObj.set("sub_assistunitid", parentEntryDynObj.get("assistunitid"));
        planEntryDynObj.set("sub_assistqty", parentEntryDynObj.get("approveassistqty"));
        planEntryDynObj.set("sub_requestdate", parentEntryDynObj.get("entryrequestdate"));
    }

    private void deleteCartAfterSave(DynamicObject newOrder) {
        int deleteCount;
        DynamicObjectCollection pageEntry = this.getModel().getEntryEntity("itementry");
        List cartIdList = pageEntry.stream().filter(r -> r.getLong("cartid") != 0L).map(r -> r.getLong("cartid")).collect(Collectors.toList());
        ArrayList itemIds = new ArrayList();
        if (newOrder != null) {
            DynamicObjectCollection itemEntry = newOrder.getDynamicObjectCollection("itementry");
            List ids = itemEntry.stream().filter(r -> r.getLong("combineparentid") == 0L).map(r -> r.getLong(String.join((CharSequence)"_", "itemid", "id"))).collect(Collectors.toList());
            itemIds.addAll(ids);
        }
        if (StringUtils.isNotNull(cartIdList) && (deleteCount = SaleOrderHelper.deleteCartByIds(cartIdList, itemIds)) < cartIdList.size()) {
            this.getView().close();
            this.getView().showTipNotification("\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u8d2d\u7269\u8f66\u6709\u5546\u54c1\u5df2\u88ab\u4ed6\u4eba\u4e0b\u5355");
            this.setCartBadgeInfo();
            long id = (Long)this.getModel().getValue("id");
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)"ocbsoc_saleorder", (Object[])new Long[]{id}, (OperateOption)CommonUtils.getOperateOption());
            throw new KDBizException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u8d2d\u7269\u8f66\u6709\u5546\u54c1\u5df2\u88ab\u4ed6\u4eba\u4e0b\u5355");
        }
    }

    private void buildHeaderData(DynamicObject order) {
        IDataModel model = this.getModel();
        order.set("modifier_id", model.getValue("modifier_id"));
        order.set("modifytime", model.getValue("modifytime"));
        order.set("requestdate", model.getValue("requestdate"));
        order.set("orderremark", model.getValue("orderremark"));
        if (this.isAddNew()) {
            order.set("creator_id", model.getValue("creator_id"));
            order.set("createtime", model.getValue("createtime"));
            String sourceApply = this.getSourceApp(this.getView());
            order.set("sourceapply", (Object)sourceApply);
            order.set("sourceplatform", (Object)sourceapply_ocdma);
            order.set("orderdate", model.getValue("orderdate"));
            order.set("billstatus", (Object)orgOrder);
            order.set("confirmstatus", (Object)orgOrder);
            order.set("signstatus", (Object)orgOrder);
            order.set("closestatus", (Object)orgOrder);
            order.set("isvaletorder", (Object)"0");
            long orderChannelId = (Long)this.getF7PKValue("orderchannelid");
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"orderchannelid", (long)orderChannelId);
            DynamicObject orderChannelDynObj = this.getF7Value("orderchannelid");
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"customerid", (long)DynamicObjectUtils.getPkValue((DynamicObject)orderChannelDynObj, (String)"customer"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"rebatechannelid", (long)DynamicObjectUtils.getPkValue((DynamicObject)orderChannelDynObj, (String)"rebatechannel"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"businesschannelid", (long)DynamicObjectUtils.getPkValue((DynamicObject)orderChannelDynObj, (String)"businesschannel"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"pricechannelid", (long)DynamicObjectUtils.getPkValue((DynamicObject)orderChannelDynObj, (String)"pricechannel"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"balancechannelid", (long)DynamicObjectUtils.getPkValue((DynamicObject)orderChannelDynObj, (String)"balancechannel"));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"distributionchannelid", (long)DynamicObjectUtils.getPkValue((DynamicObject)orderChannelDynObj, (String)"dispatchchannel"));
            long distributionChannelId = order.getLong("distributionchannelid_id");
            order.set("distributionstatus", (Object)(distributionChannelId > 0L ? "1" : "0"));
            List channelSaleOrgInfoList = SaleOrderBusinessHelper.getChannelSaleOrgInfoList((DynamicObject)orderChannelDynObj, (long)((Long)model.getValue("saleorgid_id")));
            if (!CommonUtils.isNull((Object)channelSaleOrgInfoList)) {
                DynamicObject dynObj = (DynamicObject)channelSaleOrgInfoList.get(0);
                order.set("salerid_id", (Object)DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"saler"));
                order.set("departmentid_id", (Object)DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"department"));
            }
            this.initDefaultRegion(order);
            order.set("invoicetype", this.getValue("invoicetype"));
            Object invoeiceTakerObject = this.getF7PKValue("invoeicetakerid");
            if (invoeiceTakerObject != null) {
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"invoeicetakerid", (long)((Long)invoeiceTakerObject));
            }
            order.set("invoeicetakerid_id", this.getValue("invoeicetakerid_id"));
            order.set("invoicephone", this.getValue("invoicephone"));
            order.set("invoiceaddress", this.getValue("invoiceaddress"));
            BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{order}, (IDataEntityType)order.getDynamicObjectType());
            DynamicObject saleOrg = (DynamicObject)model.getValue("saleorgid");
            order.set("saleorgid", (Object)saleOrg);
            order.set("settleorgid", model.getValue("settleorgid"));
            order.set("settlecurrencyid", model.getValue("settlecurrencyid"));
            order.set("salechannelid", model.getValue("salechannelid"));
            this.setExRateTable(saleOrg.getLong("id"), order);
            DynamicObject supplier = this.getF7Value("supplierid");
            long billTypeId = 0L;
            if (supplier != null) {
                long suplierId = supplier.getLong("id");
                order.set("supplierid", (Object)suplierId);
                String supplyrelation = supplier.getString("supplyrelation");
                order.set("supplyrelation", (Object)supplyrelation);
                DynamicObject orderChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel");
                billTypeId = orderChannel.getLong("orderbilltype_id");
                if (billTypeId != 0L) {
                    DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameterByConstants((String)"ocbsoc_saleorder", (long)billTypeId);
                    if (billTypeParam != null) {
                        String bbcCustomerOwenr = billTypeParam.getString("customerowner");
                        if (bbcCustomerOwenr.equalsIgnoreCase(orgOrder) && ChannelSupplyRelation.SUPPLY_CHANNEL.getValue().equals(supplyrelation)) {
                            billTypeId = 100004L;
                        } else if (bbcCustomerOwenr.equalsIgnoreCase(channelOrder) && ChannelSupplyRelation.SUPPLY_ORG.getValue().equals(supplyrelation)) {
                            billTypeId = 100000L;
                        }
                    }
                } else if (orgOrder.equals(supplyrelation)) {
                    billTypeId = 100000L;
                } else if (channelOrder.equals(supplyrelation)) {
                    billTypeId = 100004L;
                }
            }
            order.set(String.join((CharSequence)"_", "billtypeid", "id"), (Object)billTypeId);
            DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameterByConstants((String)"ocbsoc_saleorder", (long)billTypeId);
            long businessTypeId = 0L;
            String tradeType = "";
            String accountUseModel = orgOrder;
            if (billTypeParam != null) {
                DynamicObject businesstype = billTypeParam.getDynamicObject("businesstype");
                if (businesstype != null) {
                    businessTypeId = businesstype.getLong("id");
                }
                tradeType = DynamicObjectUtils.getString((DynamicObject)billTypeParam, (String)"tradetype");
                accountUseModel = DynamicObjectUtils.getString((DynamicObject)billTypeParam, (String)"accountusemodel");
            }
            order.set("pursalemodel", (Object)tradeType);
            order.set("accountusemodel", (Object)accountUseModel);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)order, (String)"businesstypeid", (long)businessTypeId);
            order.set("istax", (Object)Boolean.TRUE);
            order.set("paytype", model.getValue("paytype"));
            order.set("paystatus", (Object)orgOrder);
            order.set("changestatus", (Object)orgOrder);
            order.set("version", (Object)1);
            order.set("closestatus", (Object)orgOrder);
            if (model.getValue("vehicleid") != null) {
                order.set("vehicleid", model.getValue("vehicleid"));
                order.set("deliveryway", (Object)channelOrder);
            }
            order.set("iscontrolorderqty", orderChannelDynObj.get("iscontrolorderqty"));
            order.set("pickingstatus", (Object)orgOrder);
            order.set("rebateaccounttype", model.getValue("rebateaccounttype"));
        } else if (this.isEdit()) {
            // empty if block
        }
        order.set("promotionupatetime", model.getValue("promotionupatetime"));
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)order, (String)this.getView().getEntityId(), (String)"ocbsoc_saleorder");
    }

    private void initDefaultRegion(DynamicObject saleOrder) {
        long departmentId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"departmentid");
        long regionId = SaleOrderBusinessHelper.getRegionidByDepartment((long)departmentId);
        if (regionId != 0L) {
            saleOrder.set("regionid_id", (Object)regionId);
        }
    }

    private String getSourceApp(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null || parentView.getEntityId() == null || !parentView.getEntityId().startsWith("oc")) {
            return view.getEntityId().startsWith("ocdma") ? sourceapply_ocdma : sourceapply_ocsaa;
        }
        return this.getSourceApp(parentView);
    }

    private void setEntryReceiveAddress(DynamicObject entry) {
        DynamicObject receiveAddressDynObj = this.getF7Value(F_receiveaddressid);
        entry.set("entrycontactname", receiveAddressDynObj == null ? "" : receiveAddressDynObj.get("contactname"));
        entry.set("entrytelephone", receiveAddressDynObj == null ? "" : receiveAddressDynObj.get("telephone"));
        entry.set("entryaddressid", receiveAddressDynObj == null ? null : receiveAddressDynObj.get("address"));
        entry.set("entrydetailaddress", receiveAddressDynObj == null ? "" : receiveAddressDynObj.get("address2"));
    }

    private void toOrderList(IFormView view) {
        if (view == null || view.getEntityId() == null || !view.getEntityId().startsWith("oc")) {
            return;
        }
        switch (view.getEntityId()) {
            case "ocdma_saleorder_list": {
                return;
            }
            case "ocdma_homeindex": 
            case "ocdma_mallhomeindex": {
                view.invokeOperation("saleorder");
                this.getView().sendFormAction(view);
                return;
            }
            case "ocsaa_customerorder_add": {
                view.invokeOperation("order");
                this.getView().sendFormAction(view);
                return;
            }
        }
        this.getView().close();
        this.getView().sendFormAction(view);
        this.toOrderList(view.getParentView());
    }

    private void showPromotionPresentForm(List<DynamicObject> presentDynObjList, boolean isFromBtn) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(page_promotion);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("presentDynObjList", presentDynObjList);
        parameter.setCustomParam("amountprecision", (Object)this.getAmtPrecision());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isFromBtn ? PRESENT_SELECT : PRESENT_SELECT_SUBMIT));
        this.getView().showForm(parameter);
    }

    private int getAmtPrecision() {
        int amountPrecision = 2;
        DynamicObject settleCurrencyDynObj = this.getF7Value("settlecurrencyid");
        if (settleCurrencyDynObj != null) {
            amountPrecision = settleCurrencyDynObj.getInt("amtprecision");
        }
        return amountPrecision;
    }

    private void buildItemEntryData(DynamicObject order) {
        IDataModel model = this.getModel();
        DynamicObjectCollection newEntries = order.getDynamicObjectCollection("itementry");
        newEntries.beginInit();
        DynamicObjectCollection modelEntries = model.getEntryEntity("itementry");
        if (modelEntries != null && !modelEntries.isEmpty()) {
            HashMap<Long, DynamicObject> entryMap = this.initNewOrderRow(newEntries, modelEntries);
            for (int rowIndex = 0; rowIndex < modelEntries.size(); ++rowIndex) {
                DynamicObject modelEntry = (DynamicObject)modelEntries.get(rowIndex);
                long eId = modelEntry.getLong(EF_entryid);
                DynamicObject newEntry = this.isAddNew() || eId == 0L || entryMap.get(eId) == null ? newEntries.addNew() : entryMap.get(eId);
                if (eId != 0L && this.isAddNew()) {
                    newEntry.set("id", (Object)eId);
                }
                this.setNewEntry(newEntry, "itementry", "combinationid", rowIndex);
                newEntry.set("combinationid", modelEntry.get("combinationid"));
                newEntry.set("combineparentid", modelEntry.get("combineparentid"));
                newEntry.set("pricepercent", modelEntry.get("pricepercent"));
                newEntry.set("subitemqty", modelEntry.get("subitemqty"));
                newEntry.set("saleattrid", null);
                newEntry.set("stocktype", null);
                newEntry.set("seq", (Object)(rowIndex + 1));
                DynamicObject itemDynObj = modelEntry.getDynamicObject("itemid");
                long itemId = (Long)this.getEntryF7PKValue("itementry", "itemid", rowIndex);
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"itemid", (long)itemId);
                newEntry.set("ispresent", modelEntry.get("ispresent"));
                newEntry.set("ispromotion", modelEntry.get("ispromotion"));
                newEntry.set("isjoinpromotion", modelEntry.get("isjoinpromotion"));
                Object materialObject = this.getEntryF7PKValue("itementry", "materialid", rowIndex);
                long materialId = materialObject == null ? 0L : (Long)materialObject;
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"materialid", (long)materialId);
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"auxptyid", (long)this.getAuxptyId(rowIndex));
                long unitId = (Long)this.getEntryF7PKValue("itementry", "unit", rowIndex);
                long auxUnitId = 0L;
                Object auxUnit = this.getEntryF7PKValue("itementry", "auxunit", rowIndex);
                if (auxUnit != null) {
                    auxUnitId = CommonUtils.stringToLong((Object)auxUnit);
                }
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"unit", (long)unitId);
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"assistunitid", (long)auxUnitId);
                long baseUnitId = 0L;
                long assistUnitId = 0L;
                if (itemDynObj != null) {
                    DynamicObject baseUnit = itemDynObj.getDynamicObject("baseunit");
                    DynamicObject assistUnit = itemDynObj.getDynamicObject("assistunit");
                    baseUnitId = baseUnit != null ? baseUnit.getLong("id") : 0L;
                    assistUnitId = assistUnit != null ? assistUnit.getLong("id") : 0L;
                }
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"baseunit", (long)baseUnitId);
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"assistunitid", (long)assistUnitId);
                newEntry.set("reqqty", modelEntry.get("qty"));
                newEntry.set("approveqty", modelEntry.get("qty"));
                newEntry.set("assistreqqty", modelEntry.get("auxqty"));
                newEntry.set("approveassistqty", modelEntry.get("auxqty"));
                BigDecimal alterQty = modelEntry.getBigDecimal("qty");
                BigDecimal qty = modelEntry.getBigDecimal("qty");
                BigDecimal alterBaseQty = BigDecimal.ZERO;
                BigDecimal baseQty = BigDecimal.ZERO;
                if (unitId != 0L && baseUnitId != 0L) {
                    alterBaseQty = SaleOrderHelper.unitConvert((BigDecimal)alterQty, (long)baseUnitId, (long)unitId, (long)materialId);
                    baseQty = SaleOrderHelper.unitConvert((BigDecimal)qty, (long)baseUnitId, (long)unitId, (long)materialId);
                }
                newEntry.set("reqbaseqty", (Object)(alterBaseQty.compareTo(BigDecimal.ZERO) == 0 ? qty : alterBaseQty));
                newEntry.set("approvebaseqty", (Object)(baseQty.compareTo(BigDecimal.ZERO) == 0 ? qty : baseQty));
                BigDecimal alterAssistQty = BigDecimal.ZERO;
                BigDecimal assistQty = BigDecimal.ZERO;
                if (unitId != 0L && assistUnitId != 0L) {
                    alterAssistQty = SaleOrderHelper.unitConvert((BigDecimal)alterQty, (long)assistUnitId, (long)unitId, (long)materialId);
                    assistQty = SaleOrderHelper.unitConvert((BigDecimal)qty, (long)assistUnitId, (long)unitId, (long)materialId);
                }
                newEntry.set("assistreqqty", (Object)alterAssistQty);
                newEntry.set("approveassistqty", (Object)assistQty);
                newEntry.set("taxprice", modelEntry.get("taxprice"));
                newEntry.set("lowestprice", modelEntry.get("lowestprice"));
                Object taxrateObject = this.getEntryF7PKValue("itementry", "taxrateid", rowIndex);
                if (taxrateObject != null) {
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"taxrateid", (long)((Long)taxrateObject));
                }
                newEntry.set("taxrate", modelEntry.get("taxrate"));
                newEntry.set("pricediscount", modelEntry.get("pricediscount"));
                newEntry.set("oldpricediscount", modelEntry.get("oldpricediscount"));
                newEntry.set("unitdiscount", modelEntry.get("unitdiscount"));
                newEntry.set("promotiondiscount", modelEntry.get("promotiondiscount"));
                newEntry.set("recdiscount", modelEntry.get("recdiscount"));
                newEntry.set("discountamount", modelEntry.get("discountamount"));
                newEntry.set("entryrequestdate", model.getValue("requestdate"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"entryreceivechannelid", (long)((Long)this.getF7PKValue("orderchannelid")));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"entryreceiveaddressid", (long)((Long)this.getF7PKValue(F_receiveaddressid)));
                this.setEntryReceiveAddress(newEntry);
                long channelWarehouseId = 0L;
                long billTypeId = order.getLong("billtypeid_id");
                if (100002L == billTypeId) {
                    channelWarehouseId = SaleOrderBusinessHelper.getDefaultErpChanelWarehouse((long)((Long)this.getF7PKValue("orderchannelid")));
                    DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"channelwarehouseid", (long)channelWarehouseId);
                }
                newEntry.set("entrypickingstatus", (Object)orgOrder);
                newEntry.set("entryclosestatus", (Object)orgOrder);
                Object orderlineTypeId = this.getEntryF7PKValue("itementry", "orderlinetypeid", rowIndex);
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"orderlinetypeid", (long)(orderlineTypeId == null ? this.getOrderlinetypeId() : ((Long)orderlineTypeId).longValue()));
                DynamicObject orderLindeTypeDynObj = modelEntry.getDynamicObject("orderlinetypeid");
                if (orderLindeTypeDynObj != null) {
                    newEntry.set("issale", (Object)orderLindeTypeDynObj.getBoolean("issale"));
                    newEntry.set("isrebate", (Object)orderLindeTypeDynObj.getBoolean("isrebate"));
                    newEntry.set("isbudget", (Object)orderLindeTypeDynObj.getBoolean("isbudget"));
                }
                this.setIsKneadPrice(rowIndex, newEntry);
                MobExtendHelper.setMobExtToOrmExt((DynamicObject)modelEntry, (DynamicObject)newEntry, (String)this.getView().getEntityId(), (String)"ocbsoc_saleorder");
            }
        } else {
            newEntries.clear();
        }
        if (!CommonUtils.isNull((Object)newEntries)) {
            BusinessDataServiceHelper.loadRefence((Object[])newEntries.toArray(), (IDataEntityType)newEntries.getDynamicObjectType());
        }
        for (int i = 0; i < newEntries.size(); ++i) {
            DynamicObject newEntry = (DynamicObject)newEntries.get(i);
            int seq = newEntry.getInt("seq");
            int rowIndex = seq - 1;
            new SaleOrderAlgorithmForMobile(order).calByEntryChange("taxprice", rowIndex);
            boolean isPresent = this.getBooleanValue("ispresent", rowIndex);
            if (!isPresent) {
                newEntry.set("standardprice", this.getValue("actualtaxprice", rowIndex));
            } else {
                newEntry.set("standardprice", this.getValue("standardprice", rowIndex));
            }
            BigDecimal standardprice = (BigDecimal)newEntry.get("standardprice");
            BigDecimal qty = (BigDecimal)newEntry.get("approveqty");
            BigDecimal standardAmount = qty.multiply(standardprice).setScale(this.getAmtPrecision(), 4);
            newEntry.set("standardamount", (Object)standardAmount);
        }
        newEntries.endInit();
    }

    private void buildPromotionEntryData(DynamicObject order) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection promotionEntry = order.getDynamicObjectCollection("promotion_entry");
        promotionEntry.clear();
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("promotion_entry");
        if (entries != null && !entries.isEmpty()) {
            for (int rowIndex = 0; rowIndex < entries.size(); ++rowIndex) {
                DynamicObject entry = (DynamicObject)entries.get(rowIndex);
                DynamicObject newEntry = promotionEntry.addNew();
                newEntry.set("seq", (Object)(rowIndex + 1));
                this.setNewEntry(newEntry, "promotion_entry", "promotionpolicyid", rowIndex);
                this.setNewEntry(newEntry, "promotion_entry", "promotiongroupno", rowIndex);
                newEntry.set("promotionispresent", entry.get("promotionispresent"));
                this.setNewEntry(newEntry, "promotion_entry", "itemid_p", rowIndex);
                this.setNewEntry(newEntry, "promotion_entry", "materialid_p", rowIndex);
                this.setNewEntry(newEntry, "promotion_entry", "unitid_p", rowIndex);
                this.setNewEntry(newEntry, "promotion_entry", "auxptyid_p", rowIndex);
                newEntry.set("achieveqty", entry.get("achieveqty"));
                newEntry.set("achieveamount", entry.get("achieveamount"));
                newEntry.set("billachieveqty", entry.get("billachieveqty"));
                newEntry.set("billachieveamount", entry.get("billachieveamount"));
                newEntry.set("pricediscountamount", entry.get("pricediscountamount"));
                newEntry.set("promotionprice", entry.get("promotionprice"));
                newEntry.set("promotiondiscountamount", entry.get("promotiondiscountamount"));
                newEntry.set("discountrate", entry.get("discountrate"));
                newEntry.set("billdiscountrate", entry.get("billdiscountrate"));
                newEntry.set("planedeductamount", entry.get("planedeductamount"));
                newEntry.set("actualdeductamount", entry.get("actualdeductamount"));
                newEntry.set("presentqty", entry.get("presentqty"));
                newEntry.set("presentsumamount", entry.get("presentsumamount"));
                newEntry.set("orderentryid", entry.get("orderentryid"));
                this.setNewEntry(newEntry, "promotion_entry", "presentgroupno", rowIndex);
                this.setNewEntry(newEntry, "promotion_entry", "betweengrouptype", rowIndex);
                this.setNewEntry(newEntry, "promotion_entry", "ingrouptype", rowIndex);
                newEntry.set("presentprice", entry.get("presentprice"));
                newEntry.set("processstatus", entry.get("processstatus"));
                newEntry.set("selectpresent", entry.get("selectpresent"));
                newEntry.set("resultseq", entry.get("resultseq"));
                MobExtendHelper.setMobExtToOrmExt((DynamicObject)entry, (DynamicObject)newEntry, (String)this.getView().getEntityId(), (String)"ocbsoc_saleorder");
            }
        } else {
            promotionEntry.clear();
        }
        if (!CommonUtils.isNull((Object)promotionEntry)) {
            BusinessDataServiceHelper.loadRefence((Object[])promotionEntry.toArray(), (IDataEntityType)promotionEntry.getDynamicObjectType());
        }
    }

    private HashMap<Long, DynamicObject> initNewOrderRow(DynamicObjectCollection newEntries, DynamicObjectCollection modelEntries) {
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
        if (this.isAddNew()) {
            newEntries.clear();
        } else {
            List eIdList = modelEntries.stream().filter(k -> k.getLong(EF_entryid) != 0L).map(k -> k.getLong(EF_entryid)).collect(Collectors.toList());
            for (DynamicObject newEntry : newEntries) {
                long entryId = (Long)newEntry.getPkValue();
                if (!eIdList.contains(entryId)) continue;
                entryMap.put(entryId, newEntry);
            }
            newEntries.clear();
            newEntries.addAll(entryMap.values());
        }
        return entryMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (key) {
            case "selectaddress": {
                if (returnData == null) break;
                this.getModel().setValue(F_receiveaddressid, null);
                this.getModel().setValue(F_receiveaddressid, returnData);
                break;
            }
            case "itemid": {
                ListSelectedRowCollection returnRowCollection = (ListSelectedRowCollection)returnData;
                if (returnRowCollection.isEmpty()) {
                    Button button = (Button)this.getControl(op_deleteentry);
                    if (button == null) break;
                    button.click();
                    break;
                }
                this.setValue("itemid", returnRowCollection.get(0).getPrimaryKeyValue(), this.getCurrentRowIndex("itementry"));
                int currentRowIndex = this.getCurrentRowIndex("itementry");
                this.add(currentRowIndex);
                this.setValue("orderlinetypeid", this.getOrderlinetypeId(), currentRowIndex);
                break;
            }
            case "ocdma_select_auxpty": {
                if (returnData == null) break;
                HashMap returnDataAuxpty = (HashMap)returnData;
                int index = (Integer)returnDataAuxpty.get("index");
                long auxptyId = (Long)returnDataAuxpty.get("auxpty");
                BigDecimal qty = (BigDecimal)returnDataAuxpty.get("qty");
                BigDecimal auxQty = (BigDecimal)returnDataAuxpty.get("auxqty");
                this.setValue("auxptyid", auxptyId, index);
                this.setValue("auxqty", auxQty, index);
                this.setValue("qty", qty, index);
                break;
            }
            case "present_select": 
            case "present_select_submit": {
                List itemEntryRowIndexList;
                JSONArray jsonArray = (JSONArray)returnData;
                DynamicObjectCollection promotionEntryColl = this.getModel().getEntryEntity("promotion_entry");
                DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
                if (!CommonUtils.isNull((Object)itemEntryColl) && !CommonUtils.isNull(itemEntryRowIndexList = itemEntryColl.stream().filter(obj -> obj.getBoolean("ispromotion")).map(obj -> obj.getInt("seq") - 1).collect(Collectors.toList()))) {
                    this.getModel().deleteEntryRows("itementry", itemEntryRowIndexList.stream().mapToInt(Integer::valueOf).toArray());
                }
                HashSet<Long> selectPromEntryIdSet = new HashSet<Long>(0);
                Set selectIds2 = promotionEntryColl.stream().filter(obj -> "1".equals(obj.getString("processstatus")) && obj.getBoolean("promotionispresent") && !obj.getBoolean("selectpresent")).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
                selectPromEntryIdSet.addAll(selectIds2);
                if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                    Set<Long> selectIds1 = this.setSelectPresentPromotionEntry(jsonArray, promotionEntryColl);
                    selectPromEntryIdSet.addAll(selectIds1);
                }
                this.createPresentItemEntry(promotionEntryColl, selectPromEntryIdSet);
                this.deletePromotionPresentEntry(promotionEntryColl, selectPromEntryIdSet);
                this.getView().updateView("promotion_entry");
                this.setValue("autodeleterow", true);
                Date promotionUpdateTime = this.getDateFieldValue("promotionupatetime");
                this.setIsJoinPromotionByPromotinoEntry();
                if (promotionUpdateTime == null) {
                    this.calculatePromotionDiscount();
                    this.setPromotionEntityEnable();
                    int rowCount = this.getModel().getEntryRowCount("promotion_entry");
                    this.getModel().setValue("promotionupatetime", (Object)(rowCount > 0 ? TimeServiceHelper.now() : null));
                }
                if (!PRESENT_SELECT_SUBMIT.equals(key)) break;
                this.saveOrder(true);
                this.submit();
                break;
            }
            case "itemselect_btn": {
                Object[] selectIds = (Object[])closedCallBackEvent.getReturnData();
                if (selectIds == null || selectIds.length == 0) {
                    return;
                }
                DynamicObjectCollection combineItemDynColl = this.queryCombineItemDynColl(selectIds);
                int size = combineItemDynColl.size();
                Map<Object, Object> combineItemDynMap = new HashMap(size);
                if (!CommonUtils.isNull((Object)combineItemDynColl)) {
                    combineItemDynMap = combineItemDynColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("combitemid")));
                }
                long[] genLongIds = new long[]{};
                if (combineItemDynMap.size() > 0) {
                    genLongIds = DB.genGlobalLongIds((int)combineItemDynMap.size());
                }
                int i = 0;
                for (Object itemId : selectIds) {
                    int rowIndex = this.getModel().createNewEntryRow("itementry");
                    this.setValue("itemid", itemId, rowIndex);
                    if (combineItemDynMap.containsKey(itemId)) {
                        long genLongId = genLongIds[i++];
                        this.getModel().getEntryRowEntity("itementry", rowIndex).set("id", (Object)genLongId);
                        List combineItemDynList = (List)combineItemDynMap.get(itemId);
                        if (combineItemDynList == null) continue;
                        this.setValue("combinationid", ((DynamicObject)combineItemDynList.get(0)).getLong("id"), rowIndex);
                        for (DynamicObject combineItem : combineItemDynList) {
                            int combineIndex = this.getModel().createNewEntryRow("itementry");
                            this.setValue("combineparentid", genLongId, combineIndex);
                            this.setValue("subitemqty", combineItem.getBigDecimal("qty"), combineIndex);
                            this.setValue("pricepercent", combineItem.getBigDecimal("pricepercent"), combineIndex);
                            this.setValue("auxptyid", combineItem.getLong("materialassist"), combineIndex);
                            this.setValue("combinationid", combineItem.getLong("id"), combineIndex);
                            this.setValue("itemid", combineItem.getLong("item"), combineIndex);
                            this.setValue("auxptyid", combineItem.getLong("materialassist"), combineIndex);
                        }
                    }
                    this.setValue("orderlinetypeid", this.getOrderlinetypeId(), rowIndex);
                    this.setValue("qty", BigDecimal.ONE, rowIndex);
                }
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "receiptoffset": {
                QFilter qFilter = new QFilter("type", "in", (Object)new String[]{"1", "3", sourceapply_ocsaa});
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                DynamicObjectCollection recEntityColl = this.getModel().getEntryEntity("recentryentity");
                Set idSet = recEntityColl.stream().map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"receiptoffset")).collect(Collectors.toSet());
                if (CommonUtils.isNull(idSet)) break;
                qFilter = new QFilter("id", "not in", idSet);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                break;
            }
            case "receiveaddressid": {
                DynamicObject receiveChannel = this.getModel().getDataEntity().getDynamicObject("orderchannelid");
                if (receiveChannel == null) {
                    this.getView().showTipNotification("\u8bf7\u5148\u8bbe\u7f6e\u6e20\u9053\u6536\u8d27\u5730\u5740\u3002");
                    e.setCancel(true);
                    break;
                }
                QFilter addressFilter = new QFilter("orderchannel", "=", (Object)receiveChannel.getLong("id"));
                addressFilter.and("status", "=", (Object)"C");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)addressFilter);
                break;
            }
            case "invoeicetakerid": {
                e.getFormShowParameter().setCustomParam("externalUserType", (Object)"all");
                e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)true);
                long orderChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("orderchannelid"));
                long balanceChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("balancechannelid"));
                HashSet<Long> idSet = new HashSet<Long>(2);
                idSet.add(orderChannelId);
                idSet.add(balanceChannelId);
                idSet.remove(0L);
                QFilter filter = new QFilter("orderchannelid", "in", idSet);
                filter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
                filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
                DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"ocdbd_bizpartneruser", (String)"user", (QFilter[])filter.toArray());
                Set userIdSet = dynColl.stream().map(o -> o.getLong("user")).collect(Collectors.toSet());
                e.getCustomQFilters().add(new QFilter("id", "in", userIdSet));
                break;
            }
            case "orderlinetypeid": {
                QFilter filter = QFilter.join((String)"moneyaccountid", (String)String.join((CharSequence)".", "ocdbd_incentiveaccount", "id"), (QFilter)new QFilter(String.join((CharSequence)".", "ocdbd_incentiveaccount", "issupportitem"), "=", (Object)"0"));
                DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"ocdbd_orderlinetype", (String)"moneyaccountid", (QFilter[])filter.toArray());
                QFilter qfilter = new QFilter("offsettype", "in", (Object)new String[]{sourceapply_ocdma, "0"});
                if (!CommonUtils.isNull((Object)dynColl)) {
                    Set accountIdSet = dynColl.stream().map(dynObj -> dynObj.getLong("moneyaccountid")).collect(Collectors.toSet());
                    qfilter = qfilter.or(new QFilter("moneyaccountid", "in", accountIdSet));
                }
                qfilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                DynamicObject userInfo = UserUtil.getUserInfo();
                MulBasedataDynamicObjectCollection usertypes = (MulBasedataDynamicObjectCollection)userInfo.get("usertypes");
                List pks = usertypes.stream().map(k -> (Long)((DynamicObject)k.get("fbasedataid")).getPkValue()).collect(Collectors.toList());
                if (!pks.contains(1L)) {
                    qfilter.and("id", "!=", (Object)1275450424601722880L);
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qfilter);
                break;
            }
        }
    }

    protected Map<String, BigDecimal> getOrderQuantity(int index) {
        return OrderQuantityUtil.getOrderQuantityRlue((long)this.getSaleOrgId(), (long)this.getOrderChannelId(), (long)this.getItemId(index), (long)this.getUnitId(index), (long)this.getAuxptyId(index), (IPageCache)this.getPageCache());
    }

    private void setSettleCurrency() {
        DynamicObject orderChannelDynObj = this.getF7Value("orderchannelid");
        if (orderChannelDynObj != null) {
            this.setValue("settlecurrencyid", orderChannelDynObj.getLong("currency.id"));
        } else {
            this.setValue("settlecurrencyid", null);
        }
    }

    private boolean matchPromotion(boolean isFromBtn) {
        List orderPromotionEntryList;
        boolean isShowWindow;
        block17: {
            isShowWindow = false;
            DynamicObjectCollection pagePromotionEntry = this.getModel().getEntryEntity("promotion_entry");
            if (pagePromotionEntry != null && !pagePromotionEntry.isEmpty()) {
                if (!isFromBtn) {
                    List<DynamicObject> notProcessEntry = pagePromotionEntry.stream().filter(r -> r.getBoolean("promotionispresent") && "0".equals(r.getString("processstatus"))).collect(Collectors.toList());
                    if (notProcessEntry != null && !notProcessEntry.isEmpty()) {
                        this.showPromotionPresentForm(notProcessEntry, isFromBtn);
                        return true;
                    }
                    return false;
                }
                return isShowWindow;
            }
            long orderId = (Long)this.getModel().getValue("id");
            DynamicObject newSaleOrder = this.getOrder();
            if (newSaleOrder == null) {
                return false;
            }
            DynamicObjectCollection promotionEntryColl = newSaleOrder.getDynamicObjectCollection("promotion_entry");
            orderPromotionEntryList = null;
            try {
                orderPromotionEntryList = PromotionServiceHelper.getSaleOrderPromotionPolicyResult((long)orderId, (DynamicObjectType)promotionEntryColl.getDynamicObjectType());
            }
            catch (Exception e) {
                if (!isFromBtn) break block17;
                this.getView().showTipNotification("\u8ba2\u5355\u5df2\u4fdd\u5b58,\u672a\u5339\u914d\u5230\u4fc3\u9500\u653f\u7b56\u3002");
            }
        }
        if (orderPromotionEntryList != null && !orderPromotionEntryList.isEmpty()) {
            this.createPromotionEntry(orderPromotionEntryList);
            Object[] selectPresent = orderPromotionEntryList.stream().filter(obj -> obj.getBoolean("selectpresent")).toArray();
            if (!CommonUtils.isNull((Object)selectPresent)) {
                List<DynamicObject> presentDynObjList = orderPromotionEntryList.stream().filter(obj -> obj.getBoolean("promotionispresent") && obj.getBoolean("selectpresent")).collect(Collectors.toList());
                this.showPromotionPresentForm(presentDynObjList, isFromBtn);
                isShowWindow = true;
            } else {
                DynamicObjectCollection promotionEntry = this.getModel().getEntryEntity("promotion_entry");
                HashSet<Long> selectPromEntryIdSet = new HashSet<Long>(10);
                for (DynamicObject promotionEntryDynObj : promotionEntry) {
                    if (!promotionEntryDynObj.getBoolean("promotionispresent")) continue;
                    selectPromEntryIdSet.add(promotionEntryDynObj.getLong("id"));
                }
                this.createPresentItemEntry(promotionEntry, selectPromEntryIdSet);
                this.calculatePromotionDiscount();
                this.setPromotionEntityEnable();
                if (isFromBtn) {
                    this.getView().showTipNotification("\u8ba2\u5355\u5df2\u4fdd\u5b58,\u4fc3\u9500\u6267\u884c\u6210\u529f\u3002");
                }
                this.setIsJoinPromotionByPromotinoEntry();
                int rowCount = this.getModel().getEntryRowCount("promotion_entry");
                this.getModel().setValue("promotionupatetime", (Object)(rowCount > 0 ? TimeServiceHelper.now() : null));
                if (!isFromBtn) {
                    OperationResult result;
                    DynamicObjectCollection itemEntry;
                    this.buildRecEntryData(this.order);
                    BigDecimal sumReceivableAmount = this.getNullToZero(this.getModel().getValue("sumreceivableamount"));
                    BigDecimal sumRecAmount = this.getNullToZero(this.getModel().getValue("sumrecamount"));
                    this.order.set("sumrecamount", (Object)sumRecAmount);
                    this.order.set("sumunrecamount", (Object)sumReceivableAmount.subtract(sumRecAmount));
                    this.order.set("uuid", this.getValue("uuid"));
                    this.buildItemEntryData(this.order);
                    this.buildPromotionEntryData(this.order);
                    OperateOption saveOption = CommonUtils.getOperateOption();
                    if (this.isEdit() && (itemEntry = this.order.getDynamicObjectCollection("itementry")) != null) {
                        for (DynamicObject item : itemEntry) {
                            item.getDynamicObjectCollection("subentryentity").clear();
                        }
                    }
                    if (!(result = OperationServiceHelper.executeOperate((String)"save", (String)"ocbsoc_saleorder", (DynamicObject[])new DynamicObject[]{this.order}, (OperateOption)saveOption)).isSuccess()) {
                        this.showMessage(result, false);
                        return false;
                    }
                }
            }
        } else if (isFromBtn) {
            this.getView().showTipNotification("\u8ba2\u5355\u5df2\u4fdd\u5b58,\u672a\u5339\u914d\u5230\u4fc3\u9500\u653f\u7b56\u3002");
        }
        return isShowWindow;
    }

    private void cancelMatchPromotion() {
        List itemEntryRowIndexList;
        DynamicObjectCollection itemEntryColl;
        DynamicObjectCollection promotionEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("promotion_entry");
        if (!CommonUtils.isNull((Object)promotionEntryColl)) {
            List promoEntryRowIndexList = promotionEntryColl.stream().map(obj -> obj.getInt("seq") - 1).collect(Collectors.toList());
            this.getModel().deleteEntryRows("promotion_entry", promoEntryRowIndexList.stream().mapToInt(Integer::valueOf).toArray());
        }
        if (!CommonUtils.isNull((Object)(itemEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry"))) && !(itemEntryRowIndexList = itemEntryColl.stream().filter(obj -> obj.getBoolean("ispromotion")).map(obj -> obj.getInt("seq") - 1).collect(Collectors.toList())).isEmpty()) {
            this.getModel().deleteEntryRows("itementry", itemEntryRowIndexList.stream().mapToInt(Integer::valueOf).toArray());
        }
        this.getModel().setValue("promotionupatetime", null);
        this.calculatePromotionDiscount();
        this.setValue("autoedititementry", true);
        for (DynamicObject itemEntryObj : itemEntryColl) {
            int rowIndex = itemEntryObj.getInt("seq") - 1;
            this.setValue("pricediscount", this.getValue("oldpricediscount", rowIndex), rowIndex);
        }
        this.setValue("autoedititementry", false);
        this.cancelPricediscountByPromotion(itemEntryColl);
    }

    private void createPromotionEntry(List<DynamicObject> orderPromotionEntryList) {
        this.getModel().deleteEntryData("promotion_entry");
        int size = orderPromotionEntryList.size();
        this.getModel().batchCreateNewEntryRow("promotion_entry", orderPromotionEntryList.size());
        DynamicObjectCollection promotionEntryColl = this.getModel().getEntryEntity("promotion_entry");
        DataEntityPropertyCollection propertyColl = promotionEntryColl.getDynamicObjectType().getProperties();
        for (int i = 0; i < size; ++i) {
            DynamicObject entryDynObj = (DynamicObject)promotionEntryColl.get(i);
            DynamicObject orderPromotionEntry = orderPromotionEntryList.get(i);
            for (IDataEntityProperty iDataEntityProperty : propertyColl) {
                String key = iDataEntityProperty.getName();
                entryDynObj.set(key, orderPromotionEntry.get(key));
            }
            entryDynObj.set("seq", (Object)(i + 1));
            entryDynObj.set("processstatus", (Object)"1");
        }
        this.getView().updateView("promotion_entry");
    }

    private void createPresentItemEntry(DynamicObjectCollection promotionEntryColl, Set<Long> selectPromEntryIdSet) {
        if (!selectPromEntryIdSet.isEmpty()) {
            List selectPresentDynObjList = promotionEntryColl.stream().filter(obj -> selectPromEntryIdSet.contains(obj.getLong("id")) && obj.getBigDecimal("presentqty").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            List itemIdList = selectPresentDynObjList.stream().map(obj -> DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"itemid_p")).collect(Collectors.toList());
            DynamicObjectCollection combineItemDynColl = this.queryCombineItemDynColl(itemIdList.toArray());
            int entryCount = selectPresentDynObjList.size();
            if (entryCount == 0) {
                return;
            }
            this.setValue("autoedititementry", true);
            Map<Object, Object> combineItemDynMap = new HashMap(10);
            if (!CommonUtils.isNull((Object)combineItemDynColl)) {
                combineItemDynMap = combineItemDynColl.stream().collect(Collectors.groupingBy(obj -> obj.getLong("combitemid")));
                for (Long itemId : itemIdList) {
                    List combineItemDynList = (List)combineItemDynMap.get(itemId);
                    if (CommonUtils.isNull((Object)combineItemDynList)) continue;
                    entryCount += combineItemDynList.size();
                }
            }
            int[] addRowIndexs = this.getModel().batchCreateNewEntryRow("itementry", entryCount);
            int index = 0;
            for (DynamicObject promotionEntryDynObj : selectPresentDynObjList) {
                long selectItemId = DynamicObjectUtils.getPkValue((DynamicObject)promotionEntryDynObj, (String)"itemid_p");
                List combineItemDynList = (List)combineItemDynMap.get(selectItemId);
                int rowIndex = addRowIndexs[index];
                DynamicObject itemEntryDym = this.getModel().getEntryRowEntity("itementry", rowIndex);
                this.setValue("orderentryid", itemEntryDym.get("seq"), promotionEntryDynObj.getInt("seq") - 1);
                this.setValue("ispromotion", true, rowIndex);
                this.setValue("isjoinpromotion", true, rowIndex);
                BigDecimal presentPrice = promotionEntryDynObj.getBigDecimal("presentprice");
                this.setValue("ispresent", BigDecimal.ZERO.compareTo(presentPrice) == 0, rowIndex);
                if (CommonUtils.isNull((Object)combineItemDynList)) {
                    this.setValue("itemid", selectItemId, rowIndex);
                    this.setAddPresentDynObj(promotionEntryDynObj, rowIndex);
                    ++index;
                    continue;
                }
                this.fillSubItemEntryData(combineItemDynList, selectItemId, ((DynamicObject)combineItemDynList.get(0)).getLong("id"), rowIndex);
                this.setAddPresentDynObj(promotionEntryDynObj, rowIndex);
                index += combineItemDynList.size() + 1;
            }
        }
        this.setValue("autoedititementry", false);
    }

    private void calculatePromotionDiscount() {
        DynamicObjectCollection promotionEntryColl = this.getModel().getEntryEntity("promotion_entry");
        Map<Long, BigDecimal> planeDeductAmountMap = this.getPlaneDeductAmountMap((List<DynamicObject>)promotionEntryColl);
        DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
        String discountType = ChannelDeployUtil.getPromotionType();
        boolean isSelectPromotionDiscount = false;
        boolean isSelectPriceDiscount = true;
        int amountPrecision = this.getAmtPrecision();
        for (DynamicObject itemEntryObj : itemEntryColl) {
            if (itemEntryObj.getBoolean("ispromotion") || itemEntryObj.getLong("combineparentid") > 0L) continue;
            long entryId = itemEntryObj.getLong("id");
            BigDecimal planeDeductAmount = planeDeductAmountMap.get(entryId);
            BigDecimal bigDecimal = planeDeductAmount = planeDeductAmount != null ? planeDeductAmount : BigDecimal.ZERO;
            if (planeDeductAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal priceDiscount = BigDecimal.ZERO;
                if (PromotionDiscounTypeEnum.CUSOMTER_PROMOTIONDISCOUNT.getValue().equals(discountType) || PromotionDiscounTypeEnum.COMPANY_PROMOTIONDISCOUNT.getValue().equals(discountType)) {
                    priceDiscount = itemEntryObj.getBigDecimal("qty").multiply(itemEntryObj.getBigDecimal("pricediscount")).setScale(amountPrecision, 4);
                }
                boolean[] selectDiscount = this.getDiscountType(discountType, priceDiscount, planeDeductAmount);
                isSelectPromotionDiscount = selectDiscount[0];
                isSelectPriceDiscount = selectDiscount[1];
            }
            int rowIndex = itemEntryObj.getInt("seq") - 1;
            BigDecimal promotionDiscount = BigDecimal.ZERO;
            if (isSelectPromotionDiscount) {
                BigDecimal taxAmount;
                BigDecimal bigDecimal2 = taxAmount = isSelectPriceDiscount ? (BigDecimal)this.getValue("taxamount", rowIndex) : (BigDecimal)this.getValue("beforetaxamount", rowIndex);
                if (taxAmount.compareTo(BigDecimal.ZERO) > 0 && planeDeductAmount.compareTo(BigDecimal.ZERO) > 0) {
                    promotionDiscount = BigDecimalUtil.min((BigDecimal)taxAmount, (BigDecimal[])new BigDecimal[]{planeDeductAmount});
                    this.setActualDeductAmount((List<DynamicObject>)promotionEntryColl, entryId, promotionDiscount);
                }
            }
            this.setValue("promotiondiscount", promotionDiscount, rowIndex);
            if (isSelectPriceDiscount) continue;
            this.setValue("autoedititementry", true);
            this.setValue("pricediscount", null, rowIndex);
            this.setValue("autoedititementry", false);
        }
    }

    private void setPromotionEntityEnable() {
        DynamicObjectCollection itemEntityColl = this.getModel().getEntryEntity("itementry");
        int size = itemEntityColl.size();
        for (int i = 0; i < size; ++i) {
            Boolean isPromotionEntry = (Boolean)this.getValue("ispromotion", i);
            this.getView().setEnable(Boolean.valueOf(isPromotionEntry == false), i, new String[]{"qty"});
        }
    }

    private void cancelPricediscountByPromotion(DynamicObjectCollection itemEntryColl) {
        if (itemEntryColl != null && itemEntryColl.size() > 0) {
            this.setValue("autoedititementry", true);
            for (DynamicObject itemEntryObj : itemEntryColl) {
                int rowIndex = itemEntryObj.getInt("seq") - 1;
                this.setValue("pricediscount", this.getValue("oldpricediscount", rowIndex), rowIndex);
                this.setValue("isjoinpromotion", false, rowIndex);
            }
            this.setValue("autoedititementry", false);
        }
    }

    private DynamicObjectCollection queryCombineItemDynColl(Object[] itemIds) {
        String selectFields = String.join((CharSequence)",", "id", "combitemid", this.getEntityFieldKey("itemdetail", "item"), this.getEntityFieldKey("itemdetail", "qty"), this.getEntityFieldKey("itemdetail", "pricepercent"), this.getEntityFieldKey("itemdetail", "materialassist"));
        QFilter qFilter = new QFilter("combitemid", "in", (Object)itemIds);
        qFilter = qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter = qFilter.and(new QFilter("isonsell", "=", (Object)"1"));
        return QueryServiceHelper.query((String)"ocdbd_itemcombination", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private void setAddPresentDynObj(DynamicObject promotionEntryDynObj, int rowIndex) {
        this.setValue("unit", DynamicObjectUtils.getPkValue((DynamicObject)promotionEntryDynObj, (String)"unitid_p"), rowIndex);
        this.setValue("auxptyid", DynamicObjectUtils.getPkValue((DynamicObject)promotionEntryDynObj, (String)"auxptyid_p"), rowIndex);
        this.setValue("qty", promotionEntryDynObj.getBigDecimal("presentqty"), rowIndex);
        this.setValue("taxprice", promotionEntryDynObj.getBigDecimal("presentprice"), rowIndex);
        this.setValue("isjoinpromotion", true, rowIndex);
    }

    private void fillSubItemEntryData(List<DynamicObject> combineItemDynList, long comParentItemId, long combinationId, int currentRowIndex) {
        this.setValue("itemid", comParentItemId, currentRowIndex, false);
        this.setItemEntityFieldInfo(currentRowIndex);
        Object orderlineTypeId = this.getF7PKValue("orderlinetypeid", currentRowIndex);
        this.setValue("combinationid", combinationId, currentRowIndex, false);
        this.setValue("qty", null, currentRowIndex, true);
        DynamicObject newEntry = BusinessDataServiceHelper.newDynamicObject((String)this.getModelName()).getDynamicObjectCollection("itementry").addNew();
        long genLongId = DB.genLongId((String)newEntry.getDataEntityType().getAlias());
        DynamicObject combineEntryRow = this.getModel().getEntryRowEntity("itementry", currentRowIndex);
        combineEntryRow.set("id", (Object)genLongId);
        boolean isPresent = this.getBooleanValue("ispresent", currentRowIndex);
        boolean isPromotion = this.getBooleanValue("ispromotion", currentRowIndex);
        boolean isJoinPromotion = this.getBooleanValue("isjoinpromotion", currentRowIndex);
        ++currentRowIndex;
        for (DynamicObject subItemDynObj : combineItemDynList) {
            long subItemId = subItemDynObj.getLong("item");
            this.setValue("itemid", subItemId, currentRowIndex, false);
            this.setValue("combineparentid", genLongId, currentRowIndex, false);
            this.setValue("qty", subItemDynObj.getBigDecimal("qty"), currentRowIndex, false);
            this.setValue("subitemqty", subItemDynObj.getBigDecimal("qty"), currentRowIndex, false);
            this.setValue("pricepercent", subItemDynObj.getBigDecimal("pricepercent"), currentRowIndex, false);
            this.setValue("auxptyid", subItemDynObj.getLong("materialassist"), currentRowIndex, false);
            this.setValue("ispresent", isPresent, currentRowIndex, false);
            this.setValue("ispromotion", isPromotion, currentRowIndex, false);
            this.setValue("isjoinpromotion", isJoinPromotion, currentRowIndex, false);
            this.setValue("orderlinetypeid", orderlineTypeId, currentRowIndex, false);
            this.triggerChangeEvent = true;
            this.combineSubItemChange(subItemDynObj.getLong("id"), currentRowIndex);
            long auxptyid = subItemDynObj.getLong("materialassist");
            if (auxptyid > 0L) {
                BusinessDataServiceHelper.loadRefence((Object[])new Object[]{subItemDynObj}, (IDataEntityType)subItemDynObj.getDynamicObjectType());
                this.setValue("auxptyid", subItemDynObj.getLong("materialassist"), currentRowIndex, false);
                this.triggerChangeEvent = true;
            }
            ++currentRowIndex;
        }
    }

    private Map<Long, BigDecimal> getPlaneDeductAmountMap(List<DynamicObject> promotionEntryColl) {
        HashMap<Long, BigDecimal> planeDeductAmountMap = new HashMap<Long, BigDecimal>(10);
        for (DynamicObject entryDynObj : promotionEntryColl) {
            long orderEntryId = entryDynObj.getLong("orderentryid");
            BigDecimal planeDeductAmount = entryDynObj.getBigDecimal("planedeductamount");
            if (planeDeductAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (!planeDeductAmountMap.containsKey(orderEntryId)) {
                planeDeductAmountMap.put(orderEntryId, planeDeductAmount);
                continue;
            }
            planeDeductAmountMap.put(orderEntryId, ((BigDecimal)planeDeductAmountMap.get(orderEntryId)).add(planeDeductAmount));
        }
        return planeDeductAmountMap;
    }

    private boolean[] getDiscountType(String discountType, BigDecimal priceDiscount, BigDecimal planeDeductAmount) {
        boolean[] select = new boolean[2];
        boolean isSelectPromotionDiscount = false;
        boolean isSelectPriceDiscount = false;
        if (PromotionDiscounTypeEnum.PROMOTIONDISCOUNT.getValue().equals(discountType)) {
            isSelectPromotionDiscount = true;
            isSelectPriceDiscount = false;
        } else if (PromotionDiscounTypeEnum.PROMOTION_PRICEDISCOUNT.getValue().equals(discountType)) {
            isSelectPromotionDiscount = true;
            isSelectPriceDiscount = true;
        } else if (PromotionDiscounTypeEnum.CUSOMTER_PROMOTIONDISCOUNT.getValue().equals(discountType)) {
            if (priceDiscount.compareTo(planeDeductAmount) > 0) {
                isSelectPromotionDiscount = false;
                isSelectPriceDiscount = true;
            } else {
                isSelectPromotionDiscount = true;
                isSelectPriceDiscount = false;
            }
        } else if (PromotionDiscounTypeEnum.COMPANY_PROMOTIONDISCOUNT.getValue().equals(discountType)) {
            if (priceDiscount.compareTo(planeDeductAmount) < 0) {
                isSelectPromotionDiscount = false;
                isSelectPriceDiscount = true;
            } else {
                isSelectPromotionDiscount = true;
                isSelectPriceDiscount = false;
            }
        }
        select[0] = isSelectPromotionDiscount;
        select[1] = isSelectPriceDiscount;
        return select;
    }

    private void setActualDeductAmount(List<DynamicObject> promotionEntryColl, long entryId, BigDecimal promotionDiscount) {
        int size = promotionEntryColl.size();
        for (int i = 0; i < size; ++i) {
            long orderEntryId = promotionEntryColl.get(i).getLong("orderentryid");
            DynamicObject promotionEntryDynObj = promotionEntryColl.get(i);
            BigDecimal planeAmount = promotionEntryDynObj.getBigDecimal("planedeductamount");
            if (orderEntryId != entryId || promotionDiscount.compareTo(BigDecimal.ZERO) <= 0 || planeAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal actualAmount = planeAmount.compareTo(promotionDiscount) <= 0 ? planeAmount : promotionDiscount;
            this.getModel().setValue("actualdeductamount", (Object)actualAmount, promotionEntryDynObj.getInt("seq") - 1);
            promotionDiscount = promotionDiscount.subtract(planeAmount);
        }
    }

    private String getEntityFieldKey(String entityKey, String fieldKey) {
        return String.join((CharSequence)".", entityKey, fieldKey) + " " + fieldKey;
    }

    private void combineSubItemChange(long combineItemId, int rowIndex) {
        this.setItemEntityFieldInfo(rowIndex);
        this.setValue("combinationid", combineItemId, rowIndex, false);
        this.triggerChangeEvent = true;
    }

    private long getAuxptyId(int index) {
        Object auxpty = this.getEntryF7PKValue("itementry", "auxptyid", index);
        return auxpty == null ? 0L : (Long)auxpty;
    }

    private long getItemId(int index) {
        return (Long)this.getEntryF7PKValue("itementry", "itemid", index);
    }

    private long getUnitId(int index) {
        return (Long)this.getEntryF7PKValue("itementry", "unit", index);
    }

    private long getSupplyRelationId(int index) {
        return (Long)this.getF7PKValue("supplierid");
    }

    private void setAuxptyValue(int index) {
        Auxpty auxpty;
        CardEntry cardEntry = (CardEntry)this.getControl("itementry");
        long auxptyId = this.getAuxptyId(index);
        if (auxptyId != 0L && (auxpty = AuxptyHelper.getAuxptyName((long)auxptyId)) != null) {
            HashMap mapTextfield = new HashMap(1);
            HashMap<String, String> labelField = new HashMap<String, String>(1);
            labelField.put("text", auxpty.getAuxptyName());
            mapTextfield.put(AUXPTY_VALUE, labelField);
            cardEntry.setCustomProperties(cardEntry.getKey(), index, mapTextfield);
        }
    }

    private void setFiledEnableAndVisible() {
        this.setItemEntityFiledVisible();
        this.setFeildMustInputByInvoiceType();
    }

    private void setFeildMustInputByInvoiceType() {
        Object invoiceType = this.getValue("invoicetype");
        boolean flag = !StringUtils.isEmpty((Object)invoiceType) && !sourceapply_ocdma.equals(invoiceType);
        this.setMustInput("invoeicetakerid", flag);
        this.setMustInput("invoicephone", flag);
        this.setMustInput("invoiceaddress", flag);
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"invoeicetakerid", "invoiceaddress"});
    }

    private long getOrderChannelId() {
        return (Long)this.getF7PKValue("orderchannelid");
    }

    private long getSaleOrgId() {
        return (Long)this.getF7PKValue("saleorgid");
    }

    private void createRecEntityAndUseAmount() {
        this.createRecEntityNewEntryRow();
        this.setUseAmountByRecEntity();
    }

    private void createRecEntityNewEntryRow() {
        DynamicObjectCollection offsetDynObjColl = SaleOrderBusinessHelper.getReceiptOffsetDynObjColl();
        if (!CommonUtils.isNull((Object)offsetDynObjColl)) {
            DynamicObjectCollection recEntryColl = this.getModel().getEntryEntity("recentryentity");
            Set offsetIdSet = recEntryColl.stream().map(obj -> DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"receiptoffsetid")).collect(Collectors.toSet());
            List offsetDynObjList = offsetDynObjColl.stream().filter(obj -> !offsetIdSet.contains(obj.getLong("id"))).collect(Collectors.toList());
            if (!CommonUtils.isNull(offsetDynObjList)) {
                int[] addRowIndexs = this.getModel().batchCreateNewEntryRow("recentryentity", offsetDynObjList.size());
                int index = 0;
                this.triggerChangeEvent = false;
                for (DynamicObject offsetDynObj : offsetDynObjList) {
                    int rowIndex = addRowIndexs[index];
                    this.setValue("receiptoffset", offsetDynObj.getLong("id"), rowIndex);
                    this.setValue("accounttype", offsetDynObj.getLong("moneyaccountid"), rowIndex);
                    this.setValue("isshareoffset", offsetDynObj.getLong("isshareoffset"), rowIndex);
                    ++index;
                }
                this.triggerChangeEvent = true;
            }
        }
    }

    private void setUseAmountByRecEntity() {
        DynamicObjectCollection recEntryColl = this.getModel().getEntryEntity("recentryentity");
        if (!CommonUtils.isNull((Object)recEntryColl)) {
            DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
            for (DynamicObject entryDynObj : itemEntryColl) {
                this.calculateRecBillAmount("orderlinetypeid", entryDynObj.getInt("seq") - 1);
            }
        }
    }

    private void calculateRecBillAmount(String key, int index) {
        switch (key) {
            case "orderlinetypeid": 
            case "qty": 
            case "price": 
            case "taxprice": 
            case "pricediscount": 
            case "promotiondiscount": {
                boolean isPresent;
                long orderLineTypeId;
                if (index < 0) break;
                boolean autoEdit = this.getBooleanValue("autoedititementry");
                if ("orderlinetypeid".equals(key) && !autoEdit && 1275450424601722880L == (orderLineTypeId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("orderlinetypeid", index)))) {
                    this.setValue("ispresent", true, index);
                }
                if (isPresent = this.getBooleanValue("ispresent", index)) break;
                this.setValue("standardprice", this.getValue("actualtaxprice", index), index);
                break;
            }
            case "settlecurrencyid": 
            case "settleorgid": {
                break;
            }
            default: {
                return;
            }
        }
        DynamicObjectCollection recEntryColl = this.getModel().getEntryEntity("recentryentity");
        ArrayList recEntryList = new ArrayList(recEntryColl);
        DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
        Map<Long, List<DynamicObject>> orderLindeTypeMap = itemEntryColl.stream().filter(dynObj -> "1".equals(DynamicObjectUtils.getString((DynamicObject)dynObj.getDynamicObject("orderlinetypeid"), (String)"offsettype"))).collect(Collectors.groupingBy(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj.getDynamicObject("orderlinetypeid"), (String)"moneyaccountid")));
        for (DynamicObject dynamicObject : recEntryList) {
            int rowIndex = dynamicObject.getInt("seq") - 1;
            this.setValue("billamount", null, rowIndex);
            this.setValue("usedamount", null, rowIndex);
            this.setValue("tipmsg", null, rowIndex);
            this.setValue("isenough", Boolean.FALSE, rowIndex);
        }
        for (Map.Entry entry : orderLindeTypeMap.entrySet()) {
            long accountId = (Long)entry.getKey();
            if (accountId == 0L) continue;
            List itemEntryDynObjList = (List)entry.getValue();
            BigDecimal sumTaxAmount = itemEntryDynObjList.stream().filter(dynObj -> !this.isCombEntry(dynObj.getDynamicObject("itemid"))).map(dynObj -> dynObj.getBigDecimal("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List recEntryDynObjList = recEntryList.stream().filter(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"accounttype") == accountId).collect(Collectors.toList());
            if (CommonUtils.isNull(recEntryDynObjList)) continue;
            DynamicObject recEntryDynObj = (DynamicObject)recEntryDynObjList.get(0);
            int rowIndex = recEntryDynObj.getInt("seq") - 1;
            this.setValue("usedamount", null, rowIndex);
            this.setValue("billamount", sumTaxAmount, rowIndex);
        }
        this.setRecentryentityEnable(recEntryColl);
    }

    private void setRecentryentityEnable(int rowIndex) {
        DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
        List itemEntryList = itemEntryColl.stream().filter(dynObj -> "1".equals(DynamicObjectUtils.getString((DynamicObject)dynObj.getDynamicObject("orderlinetypeid"), (String)"offsettype"))).map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj.getDynamicObject("orderlinetypeid"), (String)"moneyaccountid")).collect(Collectors.toList());
        String type = DynamicObjectUtils.getString((DynamicObject)this.getF7Value("receiptoffset", rowIndex), (String)"type");
        DynamicObject accountDynObj = this.getF7Value("accounttype", rowIndex);
        long accountId = DynamicObjectUtils.getPkValue((DynamicObject)accountDynObj);
        Boolean isEnable = Boolean.TRUE;
        if (sourceapply_ocdma.equals(type) || itemEntryList.contains(accountId) || DynamicObjectUtils.getBoolean((DynamicObject)accountDynObj, (String)"issupportitem")) {
            isEnable = Boolean.FALSE;
        }
        this.getView().setEnable(isEnable, rowIndex, new String[]{"receiptoffset"});
        String recUseTypeStr = CustomerParamsUtil.getRecUseType((Object)this.getF7PKValue("saleorgid"));
        boolean flag = "1".equals(recUseTypeStr);
        boolean isManuleUse = !DynamicObjectUtils.getBoolean((DynamicObject)this.getF7Value("receiptoffset", rowIndex), (String)"isautouse");
        this.getView().setEnable(Boolean.valueOf(flag && isEnable != false && isManuleUse), rowIndex, new String[]{"usedamount"});
        this.setCellBackColor("recentryentity", "usedamount", rowIndex, flag && isEnable != false && isManuleUse ? "#ffffff" : "#f2f2f2");
    }

    private void setRecentryentityEnable(DynamicObjectCollection recEntryColl) {
        for (DynamicObject recEntryDynObj : recEntryColl) {
            this.setRecentryentityEnable(recEntryDynObj.getInt("seq") - 1);
        }
    }

    private void usedAmountChange(Object oldValue, int rowIndex) {
        BigDecimal availableBalanceAmount;
        BigDecimal usedAmount;
        BigDecimal usedAmount2;
        DynamicObject receiptOffsetDynObj = this.getEntryF7Value("recentryentity", "receiptoffset", rowIndex);
        String typeStr = "";
        if (receiptOffsetDynObj != null) {
            typeStr = receiptOffsetDynObj.getString("type");
        }
        if (!"3".equals(typeStr) && (usedAmount2 = (BigDecimal)this.getValue("usedamount", rowIndex)).compareTo(BigDecimal.ZERO) < 0) {
            this.setValue("usedamount", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u624b\u5de5\u8c03\u6574\u7684\u6536\u6b3e\u62b5\u6263\u7c7b\u578b\u4e0d\u5141\u8bb8\u8f93\u5165\u8d1f\u6570\u3002", (String)"SaleOrderEdit_9", (String)"occ-ocbsoc-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isuserebateamount = SysParamsUtil.isUseRebateAmount();
        if (isuserebateamount && "1".equals(typeStr) && (usedAmount = (BigDecimal)this.getValue("usedamount", rowIndex)).compareTo(availableBalanceAmount = (BigDecimal)this.getValue("availablebalance", rowIndex)) > 0) {
            this.setValue("usedamount", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u62b5\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u53ef\u7528\u4f59\u989d\u3002", (String)"SaleOrderEdit_10", (String)"occ-ocbsoc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.calcualteSumUnRecAmount();
    }

    private void clearPaymentRecEntry() {
        DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
        Set accountIdSet = itemEntryColl.stream().filter(dynObj -> "1".equals(DynamicObjectUtils.getString((DynamicObject)dynObj.getDynamicObject("orderlinetypeid"), (String)"offsettype"))).map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj.getDynamicObject("orderlinetypeid"), (String)"moneyaccountid")).collect(Collectors.toSet());
        DynamicObjectCollection recEntryColl = this.getModel().getEntryEntity("recentryentity");
        for (DynamicObject recEntryDynObj : recEntryColl) {
            if (DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"receiptoffset") != 1026781817216422912L || accountIdSet.contains(DynamicObjectUtils.getPkValue((DynamicObject)recEntryDynObj, (String)"accounttype"))) continue;
            this.setValue("usedamount", null, recEntryDynObj.getInt("seq") - 1, false);
        }
        this.triggerChangeEvent = true;
    }

    private void calcualteSumUnRecAmount() {
        DynamicObjectCollection recEntryColl = this.getModel().getEntryEntity("recentryentity");
        BigDecimal sumUsedAmount = recEntryColl.stream().filter(obj -> "1".equals(DynamicObjectUtils.getString((DynamicObject)obj.getDynamicObject("receiptoffset"), (String)"type")) || sourceapply_ocsaa.equals(DynamicObjectUtils.getString((DynamicObject)obj.getDynamicObject("receiptoffset"), (String)"type"))).map(obj -> obj.getBigDecimal("usedamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal manualUsedAmount = recEntryColl.stream().filter(obj -> "3".equals(DynamicObjectUtils.getString((DynamicObject)obj.getDynamicObject("receiptoffset"), (String)"type"))).map(obj -> obj.getBigDecimal("usedamount")).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
        sumUsedAmount = sumUsedAmount.add(manualUsedAmount);
        BigDecimal sumReceivableaAmount = new BigDecimal(this.getValue("sumreceivableamount").toString());
        this.setValue("sumrecamount", sumUsedAmount);
        this.setValue("sumunrecamount", sumReceivableaAmount.subtract(sumUsedAmount));
    }

    private void setTipMsgByBillAmount(int rowIndex) {
        BigDecimal billAmount = (BigDecimal)this.getValue("billamount", rowIndex);
        String tipMsg = "";
        if (billAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        boolean isEnough = this.getBooleanValue("isenough", rowIndex);
        if (isEnough) {
            return;
        }
        BigDecimal availableBalanceAmount = (BigDecimal)this.getValue("availablebalance", rowIndex);
        if (availableBalanceAmount.compareTo(billAmount) >= 0) {
            tipMsg = "\u4f59\u989d\u5145\u8db3";
            this.setValue("usedamount", billAmount, rowIndex);
            this.setValue("isenough", Boolean.TRUE, rowIndex);
        } else {
            String accounType = DynamicObjectUtils.getString((DynamicObject)this.getF7Value("accounttype", rowIndex), (String)"accounttype");
            tipMsg = "C".equals(accounType) ? MessageFormat.format("\u8ba2\u5355\u8d85\u989d\uff0c\u81f3\u5c11\u8fd8\u9700\u6253\u6b3e{0}\u5143", billAmount.subtract(availableBalanceAmount).setScale(this.getAmtPrecision()).toString()) : "\u8ba2\u5355\u8d85\u989d";
            this.setValue("usedamount", null, rowIndex);
            this.setValue("isenough", Boolean.FALSE, rowIndex);
        }
        this.setValue("tipmsg", tipMsg, rowIndex);
    }

    protected void fetchTaxPrice(String key, int rowIndex) {
        switch (key) {
            case "orderchannelid": 
            case "settlecurrencyid": 
            case "orderdate": 
            case "pricetypeid": {
                DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
                int entryCount = itemEntryColl.size();
                for (int index = 0; index < entryCount; ++index) {
                    this.fetchTaxPrice(index, entryCount);
                }
                break;
            }
            case "stocktype": 
            case "operationmodeid": 
            case "itemid": 
            case "unit": 
            case "saleattrid": 
            case "qty": 
            case "auxptyid": 
            case "approveassistqty": 
            case "ispresent": {
                DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
                this.fetchTaxPrice(rowIndex, itemEntryColl.size());
                break;
            }
        }
    }

    private void fetchTaxPriceV2(int rowIndex, PriceFetchResult priceFetchResult) {
        Object itemId = this.getValue("itemid", rowIndex);
        Object parentEntryId = this.getValue("combineparentid", rowIndex);
        if (itemId == null || parentEntryId != null && Long.parseLong(parentEntryId.toString()) > 0L) {
            return;
        }
        boolean isPresent = this.getBooleanValue("ispresent", rowIndex);
        boolean isPromotionEntry = this.getBooleanValue("ispromotion", rowIndex);
        if (isPromotionEntry && !isPresent) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrencyid");
        DynamicObjectCollection itemList = model.getEntryEntity("itementry");
        DynamicObject item = (DynamicObject)itemList.get(rowIndex);
        BigDecimal qty = BigDecimalUtil.getNullToZero((DynamicObject)item, (String)"qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            qty = BigDecimal.ONE;
        }
        BigDecimal taxRate = item.getBigDecimal("taxrate");
        HashMap priceMap = OrderHelper.getPriceMap((PriceFetchResult)priceFetchResult, (DynamicObject)settleCurrency, (BigDecimal)qty, (BigDecimal)taxRate, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        if (isPresent) {
            this.setValue("standardprice", priceMap.get("taxprice"), rowIndex, true);
            return;
        }
        this.setValue("lowestprice", priceFetchResult.getLowestPrice(), rowIndex);
        this.setValue("pricediscount", null, rowIndex);
        this.setValue("oldpricediscount", null, rowIndex);
        model.setValue("taxprice", priceMap.get("taxprice"), rowIndex);
        model.setValue("pricediscount", priceMap.get("pricediscount"), rowIndex);
        model.setValue("oldpricediscount", priceMap.get("pricediscount"), rowIndex);
        this.setTaxPriceByPolicy(priceFetchResult, rowIndex, itemList.size());
        this.setSubItemPriceDiscount(rowIndex);
        this.triggerChangeEvent = true;
    }

    private void setSubItemPriceDiscount(int rowIndex) {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
        long combineParentId = this.getCombineParentId(rowIndex);
        if (combineParentId > 0L) {
            BigDecimal priceDiscount = (BigDecimal)this.getValue("pricediscount", rowIndex);
            BigDecimal sumSubPriceDiscount = BigDecimal.ZERO;
            List subEntryDynObjList = entryColl.stream().filter(entryDynObj -> combineParentId == DynamicObjectUtils.getLong((DynamicObject)entryDynObj, (String)"combineparentid")).collect(Collectors.toList());
            int count = 1;
            subEntryDynObjList = subEntryDynObjList.stream().sorted(Comparator.comparing(obj -> obj.getBigDecimal("taxprice"))).collect(Collectors.toList());
            for (DynamicObject entryDynObj2 : subEntryDynObjList) {
                BigDecimal subPriceDiscount;
                int index = entryDynObj2.getInt("seq") - 1;
                if (count == subEntryDynObjList.size()) {
                    subPriceDiscount = priceDiscount.subtract(sumSubPriceDiscount);
                } else {
                    subPriceDiscount = this.getSubItemPriceDiscount(entryColl, priceDiscount, combineParentId, index);
                    sumSubPriceDiscount = sumSubPriceDiscount.add(subPriceDiscount);
                }
                BigDecimal subItemQty = BigDecimalUtil.toBigDecimal((Object)this.getValue("subitemqty", index));
                subPriceDiscount = BigDecimal.ZERO.compareTo(subItemQty) == 0 ? BigDecimal.ZERO : subPriceDiscount.divide(subItemQty, 10, 4);
                this.setValue("pricediscount", subPriceDiscount, index);
                this.setValue("oldpricediscount", subPriceDiscount, index);
                boolean isPresent = this.getBooleanValue("ispresent", index);
                if (!isPresent) {
                    this.setValue("standardprice", this.getValue("actualtaxprice", index), index);
                }
                ++count;
            }
        }
    }

    private BigDecimal getSubItemAmount(DynamicObjectCollection entryColl, BigDecimal parentAmount, long combineParentId, int index, int amountPrecision) {
        BigDecimal sumTaxAmount = entryColl.stream().filter(obj -> combineParentId == obj.getLong("combineparentid")).map(obj -> obj.getBigDecimal("taxprice").multiply(obj.getBigDecimal("qty"))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal subTaxAmount = ((BigDecimal)this.getValue("taxprice", index)).multiply((BigDecimal)this.getValue("qty", index));
        BigDecimal subItemQty = (BigDecimal)this.getValue("subitemqty", index);
        BigDecimal subAmount = BigDecimal.ZERO.compareTo(sumTaxAmount) == 0 ? BigDecimal.ZERO : subTaxAmount.multiply(parentAmount).divide(sumTaxAmount, amountPrecision, 4);
        subAmount = BigDecimal.ZERO.compareTo(subItemQty) == 0 ? BigDecimal.ZERO : subAmount.divide(subItemQty, amountPrecision, 4);
        return subAmount;
    }

    private BigDecimal getSubItemPriceDiscount(DynamicObjectCollection entryColl, BigDecimal priceDiscount, long combineParentId, int index) {
        BigDecimal sumTaxPrice = entryColl.stream().filter(obj -> combineParentId == obj.getLong("combineparentid")).map(obj -> obj.getBigDecimal("taxprice").multiply(obj.getBigDecimal("subitemqty"))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal subItemQty = BigDecimalUtil.toBigDecimal((Object)this.getValue("subitemqty", index));
        BigDecimal subTaxPrice = BigDecimalUtil.toBigDecimal((Object)this.getValue("taxprice", index)).multiply(subItemQty);
        BigDecimal subPriceDiscount = BigDecimal.ZERO.compareTo(sumTaxPrice) == 0 ? BigDecimal.ZERO : subTaxPrice.multiply(priceDiscount).divide(sumTaxPrice, 10, 4);
        return subPriceDiscount;
    }

    private void setTaxPriceByPolicy(PriceFetchResult result, int rowIndex, int entryCount) {
        boolean isPresent;
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("itementry");
        DynamicObject entryInfo = (DynamicObject)itemList.get(rowIndex);
        if (entryInfo == null) {
            return;
        }
        if (!CommonUtils.isNull((Object)result.getPolicySubItem()) || !CommonUtils.isNull((Object)result.getSaleSubItem())) {
            if (result.getPolicyPrice().compareTo(BigDecimal.ZERO) == 0) {
                this.setValue("taxprice", result.getItemPrice(), rowIndex);
            } else {
                this.setValue("taxprice", result.getPolicyPrice(), rowIndex);
            }
            if (entryCount > 0) {
                this.setSubItemTaxPrice(result, rowIndex, entryCount);
            }
        } else if (result.getPolicyPrice().compareTo(BigDecimal.ZERO) == 0) {
            this.setValue("taxprice", result.getItemPrice(), rowIndex);
        } else {
            this.setValue("taxprice", result.getPolicyPrice(), rowIndex);
        }
        if (!(isPresent = entryInfo.getBoolean("ispresent"))) {
            this.setValue("standardprice", this.getValue("actualtaxprice", rowIndex), rowIndex);
        }
    }

    private void setSubItemTaxPrice(PriceFetchResult result, int rowIndex, int entryCount) {
        int index = 1;
        long entryId = this.getCombineParentId(rowIndex);
        int count = entryCount - rowIndex;
        for (int i = 1; i < count; ++i) {
            index = rowIndex + i;
            DynamicObject entryDynObj = this.getModel().getEntryRowEntity("itementry", index);
            if (entryDynObj == null || entryId <= 0L || entryId != entryDynObj.getLong("combineparentid")) continue;
            BigDecimal taxPrice = this.getSubItemTaxPrice(result, index);
            this.setValue("taxprice", taxPrice, index);
            boolean isPresent = this.getBooleanValue("ispresent", index);
            if (isPresent) continue;
            this.setValue("standardprice", this.getValue("actualtaxprice", index), index);
        }
    }

    private BigDecimal getSubItemTaxPrice(PriceFetchResult result, int index) {
        BigDecimal taxPrice = BigDecimal.ZERO;
        DynamicObject entryDynObj = this.getModel().getEntryRowEntity("itementry", index);
        long subItemId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"itemid");
        if (!CommonUtils.isNull((Object)result.getPolicySubItem())) {
            for (PolicySubItem policySubItem : result.getPolicySubItem()) {
                if (policySubItem.getItemId() != subItemId) continue;
                taxPrice = policySubItem.getSalePrice();
            }
        } else {
            for (SaleSubItem saleSubItem : result.getSaleSubItem()) {
                if (saleSubItem.getItemId() != subItemId) continue;
                taxPrice = saleSubItem.getSalePrice();
            }
        }
        return taxPrice;
    }

    public PriceFetchParam builderPriceFetchParam(int rowIndex) {
        PriceFetchParam params = new PriceFetchParam();
        Date date = this.getValue("orderdate") == null ? null : (Date)this.getValue("orderdate");
        long itemPK = 0L;
        long unitPK = 0L;
        long auxptyid = 0L;
        long storeTypeId = 0L;
        long businessType = 0L;
        long itemSaleAttr = 0L;
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("itementry");
        DynamicObject itemEntryDynObj = (DynamicObject)itemList.get(rowIndex);
        if (itemEntryDynObj != null) {
            DynamicObject itemDynObj = itemEntryDynObj.getDynamicObject("itemid");
            if (this.isCombEntry(itemDynObj)) {
                params.setCombItem(true);
            }
            itemPK = DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj, (String)"itemid");
            unitPK = DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj, (String)"unit");
            auxptyid = DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj, (String)"auxptyid");
            storeTypeId = DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj, (String)"stocktype");
            businessType = DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj, (String)"operationmodeid");
            itemSaleAttr = DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj, (String)"saleattrid");
        }
        params.setOwnerId(DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("salechannelid")));
        params.setSaleorgId(DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("saleorgid")));
        params.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("pricechannelid")));
        params.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("settlecurrencyid")));
        params.setPolicyPriceId(0L);
        params.setOrderDate(date);
        BigDecimal qty = BigDecimalUtil.getNullToZero((DynamicObject)itemEntryDynObj, (String)"qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            qty = BigDecimal.ONE;
        }
        params.setQty(qty);
        params.setItemId(itemPK);
        params.setUnitId(unitPK);
        params.setItemSaleAttr(itemSaleAttr);
        params.setItemAssistattrId(0L);
        params.setMaterialAssistattrId(auxptyid);
        params.setStoreTypeId(storeTypeId);
        params.setBusinessType(businessType);
        String supplyRelation = this.getValue("supplyrelation") == null ? "" : this.getValue("supplyrelation").toString();
        params.setChannelSupplyRelation(channelOrder.equals(supplyRelation) ? ChannelSupplyRelation.SUPPLY_CHANNEL : ChannelSupplyRelation.SUPPLY_ORG);
        return params;
    }

    private void fetchTaxPrice(int rowIndex, int entryCount) {
        DynamicObject itemEntryDynObj;
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
        DynamicObject dynamicObject = itemEntryDynObj = rowIndex >= 0 && rowIndex < entryColl.size() ? (DynamicObject)entryColl.get(rowIndex) : null;
        if (itemEntryDynObj == null) {
            return;
        }
        long itemId = itemEntryDynObj.getLong("itemid_id");
        long parentEntryId = itemEntryDynObj.getLong("combineparentid");
        parentEntryId = (Long)this.getValue("combineparentid", rowIndex);
        if (itemId == 0L || parentEntryId > 0L) {
            return;
        }
        boolean isPresent = itemEntryDynObj.getBoolean("ispresent");
        boolean isPromotionEntry = itemEntryDynObj.getBoolean("ispromotion");
        if (isPromotionEntry && !isPresent) {
            return;
        }
        if (SysParamsUtil.isMerGetPrice()) {
            Map resultList;
            boolean flag;
            ArrayList<PriceFetchParam> paramsList = new ArrayList<PriceFetchParam>(16);
            PriceFetchParam priceParam = this.builderPriceFetchParam(rowIndex);
            int groupNo = 1;
            priceParam.setGroupNo(groupNo);
            paramsList.add(priceParam);
            HashMap<Integer, PriceFetchParam> rowIndexMap = new HashMap<Integer, PriceFetchParam>(16);
            rowIndexMap.put(rowIndex, priceParam);
            boolean bl = flag = itemEntryDynObj.getBoolean("ispresent") || itemEntryDynObj.getBoolean("ispromotion") || itemEntryDynObj.getLong("combineparentid") > 0L || priceParam.getItemId() != DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj, (String)"itemid");
            if (!flag) {
                for (DynamicObject entryDynObj : entryColl) {
                    int index = entryDynObj.getInt("seq") - 1;
                    if (entryDynObj.getBoolean("ispresent") || entryDynObj.getBoolean("ispromotion") || entryDynObj.getLong("combineparentid") > 0L || priceParam.getItemId() != DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"itemid") || index == rowIndex) continue;
                    PriceFetchParam priceFetchParam = this.builderPriceFetchParam(index);
                    priceFetchParam.setGroupNo(groupNo);
                    paramsList.add(priceFetchParam);
                    rowIndexMap.put(index, priceFetchParam);
                }
            }
            if (!CommonUtils.isNull((Object)(resultList = PriceServiceUtil.batchGetItemPrice(paramsList)))) {
                for (Map.Entry mapEntry : rowIndexMap.entrySet()) {
                    PriceFetchResult priceFetchResult = (PriceFetchResult)resultList.get(((PriceFetchParam)mapEntry.getValue()).getParamUniKey());
                    if (priceFetchResult == null) continue;
                    this.setTaxPriceByPriceFetchResult(priceFetchResult, (Integer)mapEntry.getKey(), entryCount);
                }
            }
        } else {
            PriceFetchParam params = this.builderPriceFetchParam(rowIndex);
            PriceFetchResult result = PriceServiceUtil.getItemPrice((PriceFetchParam)params);
            this.setTaxPriceByPriceFetchResult(result, rowIndex, entryCount);
        }
    }

    public void setTaxPriceByPriceFetchResult(PriceFetchResult result, int rowIndex, int entryCount) {
        DynamicObject item;
        DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrencyid");
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("itementry");
        DynamicObject dynamicObject = item = rowIndex >= 0 && rowIndex < itemList.size() ? (DynamicObject)itemList.get(rowIndex) : null;
        if (item == null) {
            return;
        }
        boolean isPresent = item.getBoolean("ispresent");
        BigDecimal qty = BigDecimalUtil.getNullToZero((DynamicObject)item, (String)"qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            qty = BigDecimal.ONE;
        }
        BigDecimal taxRate = item.getBigDecimal("taxrate");
        HashMap priceMap = OrderHelper.getPriceMap((PriceFetchResult)result, (DynamicObject)settleCurrency, (BigDecimal)qty, (BigDecimal)taxRate, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        this.setValue("pricediscount", null, rowIndex);
        this.setValue("oldpricediscount", null, rowIndex);
        if (isPresent) {
            this.setValue("standardprice", priceMap.get("taxprice"), rowIndex, true);
            this.setValue("lowestprice", BigDecimal.ZERO, rowIndex);
            this.setValue("taxprice", BigDecimal.ZERO, rowIndex);
            return;
        }
        this.setValue("lowestprice", result.getLowestPrice(), rowIndex);
        this.getModel().setValue("taxprice", priceMap.get("taxprice"), rowIndex);
        this.getModel().setValue("pricediscount", priceMap.get("pricediscount"), rowIndex);
        this.getModel().setValue("oldpricediscount", priceMap.get("pricediscount"), rowIndex);
        this.setTaxPriceByPolicy(result, rowIndex, entryCount);
        this.setCombineSubItemField("pricediscount", rowIndex);
        this.setItemAmount(rowIndex);
        this.triggerChangeEvent = true;
    }

    private void setCombineSubItemField(String key, int rowIndex) {
        DynamicObject item;
        int amountPrecision = this.getAmtPrecision();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
        DynamicObject dynamicObject = item = rowIndex >= 0 && rowIndex < entryColl.size() ? (DynamicObject)entryColl.get(rowIndex) : null;
        if (item == null) {
            return;
        }
        long entryId = item.getLong("id");
        if (entryId == 0L) {
            return;
        }
        switch (key) {
            case "saleattrid": 
            case "operationmodeid": 
            case "stocktype": 
            case "taxrateid": 
            case "entryrequestdate": 
            case "entryreceivechannelid": 
            case "entryreceiveaddressid": 
            case "ispresent": 
            case "orderlinetypeid": 
            case "channelwarehouseid": 
            case "ispromotion": 
            case "isjoinpromotion": {
                int index = 1;
                int count = entryColl.size() - rowIndex;
                for (int i = 1; i < count; ++i) {
                    index = rowIndex + i;
                    DynamicObject entryDynObj = (DynamicObject)entryColl.get(index);
                    if (entryDynObj == null || entryId <= 0L || entryId != entryDynObj.getLong("combineparentid")) continue;
                    this.setValue(key, item.get(key), index);
                }
                break;
            }
            case "taxprice": {
                int count = entryColl.size() - rowIndex;
                for (int i = 1; i < count; ++i) {
                    int index = rowIndex + i;
                    DynamicObject entryDynObj = (DynamicObject)entryColl.get(index);
                    if (entryDynObj == null || entryId <= 0L || entryId != entryDynObj.getLong("combineparentid")) continue;
                    BigDecimal taxPrice = item.getBigDecimal("taxprice");
                    BigDecimal pricePercent = entryDynObj.getBigDecimal("pricepercent");
                    BigDecimal subItemQty = entryDynObj.getBigDecimal("subitemqty");
                    BigDecimal subTaxPrice = BigDecimal.ZERO.compareTo(subItemQty) == 0 ? BigDecimal.ZERO : taxPrice.multiply(pricePercent.divide(BigDecimalConstants.ONEHUNDRED)).divide(subItemQty, amountPrecision, 4);
                    this.setValue("taxprice", subTaxPrice, index);
                }
                this.setSubItemPriceDiscount(entryColl, entryId, rowIndex);
                break;
            }
            case "approveqty": 
            case "pricediscount": {
                this.setSubItemPriceDiscount(entryColl, entryId, rowIndex);
                break;
            }
            case "promotiondiscount": {
                this.setSubItemPromotionDiscount(entryColl, entryId, rowIndex);
                break;
            }
        }
    }

    private void paymentInfoChange() {
        DynamicObjectCollection recEntryEntity = this.getModel().getEntryEntity("recentryentity");
        List recFilteredEntryEntity = recEntryEntity.stream().filter(k -> k.getBigDecimal("usedamount").compareTo(BigDecimal.ZERO) > 0).filter(k -> (Long)k.getDynamicObject("accounttype").getPkValue() != 1176015964144286720L).collect(Collectors.toList());
        this.getModel().deleteEntryData("paymententryentity");
        if (recFilteredEntryEntity.size() > 0) {
            int[] addRowIndexs = this.getModel().batchCreateNewEntryRow("paymententryentity", recFilteredEntryEntity.size());
            int index = 0;
            for (DynamicObject dynamicObject : recFilteredEntryEntity) {
                int rowIndex = addRowIndexs[index];
                this.setValue("usedamount_p", dynamicObject.get("usedamount"), rowIndex);
                this.setValue("accounttypeid_p", dynamicObject.get("accounttype"), rowIndex);
                ++index;
            }
        }
    }

    private void initRecEntryEntity() {
        this.setUseAmountByRecEntity();
        DynamicObjectCollection recEntityColl = this.getModel().getEntryEntity("recentryentity");
        for (DynamicObject recEntryDynObj : recEntityColl) {
            this.setRecentryentityEnable(recEntryDynObj.getInt("seq") - 1);
        }
        if (!CommonUtils.isNull((Object)recEntityColl)) {
            this.getRebateAccountAmountInfo("orderchannelid", 0);
            for (DynamicObject recEntryDynObj : recEntityColl) {
                int index = recEntryDynObj.getInt("seq") - 1;
                this.setTipMsgByBillAmount(index);
            }
        }
    }

    private void setIsKneadPrice(int rowIndex, DynamicObject newEntry) {
        boolean param_isKneadPrice = CustomerParamsUtil.isKneadPrice((Object)this.getF7PKValue("saleorgid"));
        DynamicObject itemDynObj = this.getF7Value("itemid", rowIndex);
        boolean isKneadPrice = param_isKneadPrice && DynamicObjectUtils.getBoolean((DynamicObject)itemDynObj, (String)"iskneadprice");
        newEntry.set("iskneadprice", (Object)isKneadPrice);
    }

    private void setOrderLineTypeEnable() {
        DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
        if (!CommonUtils.isNull((Object)itemEntryColl)) {
            List idList = itemEntryColl.stream().map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"orderlinetypeid")).collect(Collectors.toList());
            QFilter filter = QFilter.join((String)"moneyaccountid", (String)String.join((CharSequence)".", "ocdbd_incentiveaccount", "id"), (QFilter)new QFilter(String.join((CharSequence)".", "ocdbd_incentiveaccount", "issupportitem"), "=", (Object)"1"));
            filter = filter.and(new QFilter("id", "in", idList));
            DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"ocdbd_orderlinetype", (String)"id", (QFilter[])filter.toArray());
            List<Integer> rowIndexList = itemEntryColl.stream().map(dynObj -> dynObj.getInt("seq") - 1).collect(Collectors.toList());
            if (!CommonUtils.isNull((Object)dynColl)) {
                List lineTypeIdList = dynColl.stream().map(dynObj -> dynObj.getLong("id")).collect(Collectors.toList());
                List<Integer> indexList = itemEntryColl.stream().filter(dynObj -> lineTypeIdList.contains(DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"orderlinetypeid"))).map(dynObj -> dynObj.getInt("seq") - 1).collect(Collectors.toList());
                this.setOrderLineTypeEnable(indexList, Boolean.FALSE);
                rowIndexList.removeAll(indexList);
            }
            this.setOrderLineTypeEnable(rowIndexList, Boolean.TRUE);
        }
    }

    private void setOrderLineTypeEnable(List<Integer> rowIndexList, Boolean isEnable) {
        for (Integer rowIndex : rowIndexList) {
            this.getView().setEnable(isEnable, rowIndex.intValue(), new String[]{"orderlinetypeid"});
        }
    }

    private void setPriceByPresent(int rowIndex) {
        boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
        boolean isTax = (Boolean)this.getValue("istax");
        if (isTax) {
            if (isPresent) {
                this.setValue("pricediscount", null, rowIndex);
                this.setValue("oldpricediscount", null, rowIndex);
                this.setValue("taxprice", null, rowIndex);
                this.setUnEnable(rowIndex, new String[]{"taxprice", "pricediscount"});
            } else {
                this.setEnable(rowIndex, new String[]{"taxprice", "pricediscount"});
            }
        } else if (isPresent) {
            this.setValue("pricediscount", null, rowIndex);
            this.setValue("oldpricediscount", null, rowIndex);
            this.setValue("price", null, rowIndex);
            this.setUnEnable(rowIndex, new String[]{"price", "pricediscount"});
        } else {
            this.setEnable(rowIndex, new String[]{"price", "pricediscount"});
        }
        long orderLindeType = isPresent ? 1275450424601722880L : this.getOrderlinetypeId();
        this.setValue("orderlinetypeid", orderLindeType, rowIndex);
    }

    protected BigDecimal getNullToZero(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)value;
    }

    private Set<Long> setSelectPresentPromotionEntry(JSONArray jsonArray, DynamicObjectCollection promotionEntryColl) {
        HashSet<Long> selectPromEntryIdSet = new HashSet<Long>(10);
        for (Object object : jsonArray) {
            JSONObject jsonObj = (JSONObject)object;
            for (DynamicObject promotionEntryDynObj : promotionEntryColl) {
                long promEntryId = promotionEntryDynObj.getLong("id");
                if (promEntryId != jsonObj.getLongValue("promotionentryid")) continue;
                int rowIndex = promotionEntryDynObj.getInt("seq") - 1;
                promotionEntryDynObj.set("presentqty", jsonObj.get((Object)"presentqty"));
                this.setValue("presentqty", jsonObj.get((Object)"presentqty"), rowIndex);
                promotionEntryDynObj.set("presentsumamount", jsonObj.get((Object)"presentsumamount"));
                this.setValue("presentsumamount", jsonObj.get((Object)"presentsumamount"), rowIndex);
                promotionEntryDynObj.set("processstatus", (Object)"1");
                this.setValue("processstatus", "1", rowIndex);
                selectPromEntryIdSet.add(promEntryId);
            }
        }
        return selectPromEntryIdSet;
    }

    /*
     * WARNING - void declaration
     */
    private void deletePromotionPresentEntry(DynamicObjectCollection promotionEntryColl, Set<Long> selectPromEntryIdSet) {
        HashSet<Integer> deleteIndexSet = new HashSet<Integer>(10);
        HashSet<String> promotionGroupNoSet = new HashSet<String>(10);
        for (Object promotionEntryDynObj : promotionEntryColl) {
            if (!promotionEntryDynObj.getBoolean("promotionispresent") || !promotionEntryDynObj.getBoolean("selectpresent") || selectPromEntryIdSet.contains(promotionEntryDynObj.getLong("id"))) continue;
            deleteIndexSet.add(promotionEntryDynObj.getInt("seq") - 1);
            promotionGroupNoSet.add(this.getPromotionGroupNoKey((DynamicObject)promotionEntryDynObj));
            promotionEntryDynObj.set("promotionispresent", (Object)false);
        }
        Map<String, List<DynamicObject>> promotionEntryMap = promotionEntryColl.stream().collect(Collectors.groupingBy(obj -> this.getPromotionGroupNoKey((DynamicObject)obj)));
        for (Map.Entry entry : promotionEntryMap.entrySet()) {
            List promotionDynObjList;
            List presentDynObjList;
            if (!promotionGroupNoSet.contains(entry.getKey()) || !CommonUtils.isNull(presentDynObjList = (promotionDynObjList = (List)entry.getValue()).stream().filter(obj -> obj.getBoolean("promotionispresent")).collect(Collectors.toList()))) continue;
            for (DynamicObject promotionEntryDynObj : promotionDynObjList) {
                deleteIndexSet.add(promotionEntryDynObj.getInt("seq") - 1);
            }
        }
        if (!CommonUtils.isNull(deleteIndexSet)) {
            int[] deleteIndexs = deleteIndexSet.stream().mapToInt(Integer::valueOf).toArray();
            this.getModel().deleteEntryRows("promotion_entry", deleteIndexs);
            promotionEntryColl = this.getModel().getEntryEntity("promotion_entry");
            boolean bl = true;
            for (DynamicObject promotionEntryDynObj : promotionEntryColl) {
                void var7_9;
                promotionEntryDynObj.set("seq", (Object)((int)var7_9));
                ++var7_9;
            }
        }
    }

    private String getPromotionGroupNoKey(DynamicObject promotionEntryDynObj) {
        return DynamicObjectUtils.getPkValue((DynamicObject)promotionEntryDynObj, (String)"promotionpolicyid") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)promotionEntryDynObj, (String)"promotiongroupno") + "_" + promotionEntryDynObj.getInt("resultseq");
    }

    private void setNewEntry(DynamicObject newEntry, String entryName, String key, int rowIndex) {
        Object entryF7PKValue = this.getEntryF7PKValue(entryName, key, rowIndex);
        long id = entryF7PKValue == null ? 0L : (Long)entryF7PKValue;
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)key, (long)id);
    }

    private long getCombineParentId(int rowIndex) {
        DynamicObject itemEntryDynObj = this.getRowInfo("itementry", rowIndex);
        long entryId = DynamicObjectUtils.getPkValue((DynamicObject)itemEntryDynObj);
        return entryId;
    }

    private void setSubItemPriceDiscount(DynamicObjectCollection entryColl, long combineParentId, int rowIndex) {
        if (combineParentId > 0L) {
            DynamicObject item = (DynamicObject)entryColl.get(rowIndex);
            if (item == null) {
                return;
            }
            BigDecimal priceDiscount = item.getBigDecimal("pricediscount");
            BigDecimal sumSubPriceDiscount = BigDecimal.ZERO;
            List subEntryDynObjList = entryColl.stream().filter(entryDynObj -> combineParentId == DynamicObjectUtils.getLong((DynamicObject)entryDynObj, (String)"combineparentid")).collect(Collectors.toList());
            int count = 1;
            subEntryDynObjList = subEntryDynObjList.stream().sorted(Comparator.comparing(obj -> obj.getBigDecimal("taxprice"))).collect(Collectors.toList());
            for (DynamicObject entryDynObj2 : subEntryDynObjList) {
                BigDecimal subPriceDiscount;
                int index = entryDynObj2.getInt("seq") - 1;
                if (count == subEntryDynObjList.size()) {
                    subPriceDiscount = priceDiscount.subtract(sumSubPriceDiscount);
                } else {
                    subPriceDiscount = this.getSubItemPriceDiscount(entryColl, priceDiscount, combineParentId, index);
                    sumSubPriceDiscount = sumSubPriceDiscount.add(subPriceDiscount);
                }
                BigDecimal subItemQty = entryDynObj2.getBigDecimal("subitemqty");
                subPriceDiscount = BigDecimal.ZERO.compareTo(subItemQty) == 0 ? BigDecimal.ZERO : subPriceDiscount.divide(subItemQty, 10, 4);
                this.setValue("pricediscount", subPriceDiscount, index);
                ++count;
            }
        }
    }

    private void setSubItemPromotionDiscount(DynamicObjectCollection entryColl, long combineParentId, int rowIndex) {
        if (combineParentId > 0L) {
            DynamicObject item = (DynamicObject)entryColl.get(rowIndex);
            if (item == null) {
                return;
            }
            BigDecimal promotionDiscount = item.getBigDecimal("promotiondiscount");
            BigDecimal sumSubPromotionDiscount = BigDecimal.ZERO;
            int amountPrecision = this.getAmtPrecision();
            List subEntryDynObjList = entryColl.stream().filter(entryDynObj -> combineParentId == DynamicObjectUtils.getLong((DynamicObject)entryDynObj, (String)"combineparentid")).collect(Collectors.toList());
            int count = 1;
            for (DynamicObject entryDynObj2 : subEntryDynObjList) {
                BigDecimal subPromotionDiscount;
                int index = entryDynObj2.getInt("seq") - 1;
                if (count == subEntryDynObjList.size()) {
                    subPromotionDiscount = promotionDiscount.subtract(sumSubPromotionDiscount);
                } else {
                    subPromotionDiscount = this.getSubItemAmount(entryColl, promotionDiscount, combineParentId, index, amountPrecision);
                    sumSubPromotionDiscount = sumSubPromotionDiscount.add(subPromotionDiscount);
                }
                this.setValue("promotiondiscount", subPromotionDiscount, index);
                ++count;
            }
        }
    }

    private boolean cancelMatchPromotion(String key, Object oldValue, Object newValue, int rowIndex) {
        boolean autoCancel = this.getBooleanValue("autoedititementry");
        Date promotionUpateTime = this.getDateFieldValue("promotionupatetime");
        boolean isShowConfirm = false;
        if (!autoCancel && promotionUpateTime != null) {
            String customValue = null;
            String newCustomValue = null;
            switch (key) {
                case "ispresent": 
                case "reqqty": 
                case "assistreqqty": 
                case "qty": 
                case "approveassistqty": 
                case "taxprice": 
                case "price": 
                case "pricediscount": {
                    customValue = oldValue != null ? oldValue.toString() : null;
                    newCustomValue = newValue != null ? newValue.toString() : null;
                    isShowConfirm = true;
                    break;
                }
                case "orderdate": {
                    customValue = oldValue != null ? DateUtil.getDateFormat((Date)((Date)oldValue), (String)"yyyy-MM-dd HH:mm:ss") : null;
                    newCustomValue = newValue != null ? DateUtil.getDateFormat((Date)((Date)newValue), (String)"yyyy-MM-dd HH:mm:ss") : null;
                    isShowConfirm = true;
                    break;
                }
                case "itemid": 
                case "auxptyid": 
                case "unit": 
                case "settlecurrencyid": 
                case "stocktype": 
                case "saleattrid": {
                    customValue = oldValue != null ? ((DynamicObject)oldValue).getPkValue().toString() : null;
                    newCustomValue = newValue != null ? ((DynamicObject)newValue).getPkValue().toString() : null;
                    isShowConfirm = true;
                    break;
                }
            }
            if (isShowConfirm) {
                this.showCancelmatchPromotionConfirm(StringUtils.join((CharSequence)"_", (Object[])new Object[]{key, rowIndex, customValue, newCustomValue}));
                this.setValue("autoedititementry", true);
            }
        }
        return isShowConfirm;
    }

    private void showCancelmatchPromotionConfirm(String customValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("cancelmatchPromotion", (IFormPlugin)this);
        this.getView().showConfirm("\u68c0\u6d4b\u5230\u5df2\u6267\u884c\u4fc3\u9500\uff0c\u5982\u9700\u53d8\u52a8\u8ba2\u5355\u5185\u5bb9\u9700\u8981\u5148\u64a4\u9500\u539f\u6709\u4fc3\u9500\uff0c\u786e\u8ba4\u64a4\u9500\u5417\uff1f", "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, customValue);
    }

    private void setItemEntityFiledVisible() {
        if (!this.isView()) {
            boolean isOpenPromotion = ChannelDeployUtil.getOpenPromotion((long)this.getSaleOrgId());
            this.getView().setVisible(Boolean.valueOf(isOpenPromotion), new String[]{"promotion_execute_flex"});
        }
    }

    private Map<Long, List<Long>> queryVehicle(long orderChannelId) {
        DynamicObjectCollection resultCol = QueryServiceHelper.query((String)"ocdbd_vehicle", (String)"id,channelentryentity.channelid", (QFilter[])new QFilter("channelentryentity.channelid", "=", (Object)orderChannelId).and("status", "=", (Object)"C").and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()).toArray());
        if (!CollectionUtils.isEmpty((Collection)resultCol)) {
            return resultCol.stream().collect(Collectors.groupingBy(r -> r.getLong("channelentryentity.channelid"), Collectors.mapping(r -> r.getLong("id"), Collectors.toList())));
        }
        return new HashMap<Long, List<Long>>(0);
    }

    private DLock createDLock() {
        return DLock.create((String)(DLOCKKEY + this.getView().getPageId()), (String)"\u5168\u6e20\u9053\u4e91\u79fb\u52a8\u7aef\u8ba2\u5355\u63d0\u4ea4\u5206\u5e03\u5f0f\u9501");
    }

    private String getNewUuid() {
        long orderId;
        QFilter filter;
        DynamicObject data;
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (OCDMA_SALEORDER_LIST.equals(parentFormId) && (data = QueryServiceHelper.queryOne((String)"ocbsoc_saleorder", (String)"uuid", (QFilter[])(filter = new QFilter("id", "=", (Object)(orderId = ((Long)this.getParameter("orderId")).longValue()))).toArray())) != null) {
            return data.getString("uuid");
        }
        return Long.toString(DB.genGlobalLongId());
    }

    private long getOrderlinetypeId() {
        long saleChannelId = (Long)this.getModel().getValue("salechannelid_id");
        if (saleChannelId != 0L) {
            return 1275450144497713152L;
        }
        return super.getDefaultOrderlinetypeId();
    }

    private void getItemStatusQFilter(List<QFilter> filters, long saleOrgId, long saleChannelId, long orderChannelId) {
        boolean isFromOcsaa = this.getIsFromOCSAA();
        QFilter filter = null;
        filter = isFromOcsaa ? ItemBusinessHelper.getItemStatusSysControlQFilter((long)saleOrgId, (long)saleChannelId, (long)orderChannelId, filter, (String)"3") : ItemBusinessHelper.getItemStatusSysControlQFilter((long)saleOrgId, (long)saleChannelId, (long)orderChannelId, filter, (String)"1");
        if (filter != null) {
            filters.add(filter);
        }
    }

    private boolean getIsFromOCSAA() {
        return sourceapply_ocsaa.equals(this.getSourceApp(this.getView()));
    }

    private void setIsJoinPromotionByPromotinoEntry() {
        DynamicObjectCollection promotionEntryColl = this.getModel().getEntryEntity("promotion_entry");
        DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity("itementry");
        Set orderEntryIdSet = promotionEntryColl.stream().filter(obj -> "1".equals(obj.getString("processstatus"))).map(obj -> obj.getLong("orderentryid")).collect(Collectors.toSet());
        for (DynamicObject itemEntryObj : itemEntryColl) {
            long entryId = itemEntryObj.getLong("id");
            int rowIndex = itemEntryObj.getInt("seq") - 1;
            this.setValue("isjoinpromotion", orderEntryIdSet.contains(entryId), rowIndex);
        }
    }

    private void setItemAmount(int rowIndex) {
        DynamicObject itemEntry = this.getModel().getEntryRowEntity("itementry", rowIndex);
        if (itemEntry != null) {
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntry, (String)"qty");
            BigDecimal actualTaxPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntry, (String)"actualtaxprice");
            this.setValue(EF_itemamt, qty.multiply(actualTaxPrice), rowIndex);
        }
    }
}

