/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.helper.BotpHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocdma.business.order.SaleOrderHelper;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class SaleOrderListPlugin
extends OcdmaFormMobPlugin
implements TabSelectListener,
MobileSearchTextChangeListener,
CreateListDataProviderListener,
ListRowClickListener {
    public static final String OCSAA_CHANNEL = "ocsaa_channel";
    public static final String OCSAA_BUSINESS = "ocsaa_business";
    public static final String BTNCLOSE = "btnclose";
    private static final String[] billStatusArray = new String[]{"D", "E"};
    private static final String op_billlistap = "billlistap";
    private static final String op_tabap = "tabap";
    private static final String op_ordersearch = "ordersearch";
    private static final String enddate = "enddate";
    private static final String startdate = "startdate";
    private static final String orderremark = "orderremark";
    private static final String synerrormsg = "synerrormsg";
    private static final String op_btnadd = "btnadd";
    private static final String op_btnsign = "btnsign";
    private static final String op_btnedit = "btnedit";
    private static final String op_delete = "btndelete";
    private static final String op_retorder = "btnretorder";
    private static final String op_unsubmit = "unsubmit";
    private static final String orderdatespan = "orderdatespan";
    private static final String OCDMA_SALEORDER_ADD = "ocdma_saleorder_add";
    private static final String OCDMA_SALEORDER_VIEW = "ocdma_saleorder_view";
    private static final String OCSAA_RETORDER_REQ_ADD = "ocsaa_retorder_req_add";
    private static final String page_sign = "ocdma_saleorder_sign";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(op_billlistap);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{op_tabap});
        this.addClickListeners(new String[]{op_btnadd, op_btnedit, op_delete, op_retorder, op_btnsign});
        MobileSearch search = (MobileSearch)this.getControl(op_ordersearch);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(op_billlistap);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String formid;
        String isOrderSign;
        String tbKey;
        Object opKey = this.getParameter("opkey");
        if (StringUtils.isNotNull((Object)opKey)) {
            Tab tab = (Tab)this.getControl(op_tabap);
            tbKey = opKey.toString();
            tab.selectTab(tbKey);
            tab.activeTab(tbKey);
        }
        if (StringUtils.isNotNull((String)(isOrderSign = this.getView().getParentView().getPageCache().get("ordersign")))) {
            tbKey = "d";
            Tab tab = (Tab)this.getControl(op_tabap);
            tab.selectTab(tbKey);
            tab.activeTab(tbKey);
        }
        this.refreshBillList();
        String supplierIdStr = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("supplierid");
        if (StringUtils.isNotNull((String)supplierIdStr)) {
            this.getModel().setValue("isfromocsaa", (Object)true);
        }
        if ("ocsaa_home".equals(formid = this.getView().getParentView().getFormShowParameter().getFormId()) || OCSAA_BUSINESS.equals(formid) || OCSAA_CHANNEL.equals(formid)) {
            this.getModel().setValue("isfromocsaa", (Object)true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object fromFormId = this.getParameter("fromFormId");
        if ("ocsaa_home".equals(fromFormId) || OCSAA_CHANNEL.equals(fromFormId) || OCSAA_BUSINESS.equals(fromFormId)) {
            this.setVisible(new String[]{BTNCLOSE});
        } else {
            this.setDisVisible(new String[]{BTNCLOSE});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "btndelete": {
                BillList billList = (BillList)this.getControl(op_billlistap);
                Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                DynamicObject order = (DynamicObject)SaleOrderHelper.invokeOrderService((String)"getSaleOrder", (Object[])new Object[]{pkId});
                OperationResult delResult = OperationUtil.invokeOperation((DynamicObject)order, (String)"delete");
                if (!delResult.isSuccess()) break;
                this.refreshBillList();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        BillList billList = (BillList)this.getControl(op_billlistap);
        Object id = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        switch (key) {
            case "audit": 
            case "unaudit": {
                OperateOption operateOption = CommonUtils.getMutexOperateOption();
                OperationResult result = OperationServiceHelper.executeOperate((String)key, (String)"ocbsoc_saleorder", (Object[])new Object[]{id}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                this.refreshBillList();
                break;
            }
            case "unsubmit": {
                OperateOption operateOption = CommonUtils.getMutexOperateOption();
                OperationResult result = SysParamsUtil.isEnablePreSubmit((String)"ocbsoc_saleorder") ? OperationServiceHelper.executeOperate((String)"cancelpresubmit", (String)"ocbsoc_saleorder", (Object[])new Object[]{id}, (OperateOption)operateOption) : OperationServiceHelper.executeOperate((String)op_unsubmit, (String)"ocbsoc_saleorder", (Object[])new Object[]{id}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                this.refreshBillList();
                break;
            }
        }
    }

    private void showForm(OperationStatus operationStatus, String formId) {
        BillList billList = (BillList)this.getControl(op_billlistap);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(formId);
        mobileFormShowParameter.setStatus(operationStatus);
        mobileFormShowParameter.setCustomParam("orderId", pkId);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "ocdma_saleorder_add": {
                String orderDateSpan = (String)this.getModel().getValue(orderdatespan);
                if ("F".equals(orderDateSpan)) {
                    this.refreshBillList();
                    break;
                }
                this.setValue(orderdatespan, "F");
                break;
            }
            case "ocdma_saleorder_sign": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(op_billlistap);
        Tab tab = (Tab)this.getControl(op_tabap);
        String curTabKey = tab.getCurrentTab();
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getOrderFilter(curTabKey)});
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.showForm(OperationStatus.VIEW, OCDMA_SALEORDER_VIEW);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        BillList billList = (BillList)this.getControl(op_billlistap);
        long orderId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"ocbsoc_saleorder");
        long supplyRelationId = 0L;
        if (saleOrder != null) {
            supplyRelationId = saleOrder.getLong("supplierid.id");
        }
        switch (key) {
            case "btnadd": {
                if (this.isSupplyRelationExist(supplyRelationId)) {
                    this.showForm(OperationStatus.ADDNEW, OCDMA_SALEORDER_ADD);
                    break;
                }
                this.getView().showTipNotification("\u8981\u8d27\u8ba2\u5355\u4f9b\u8d27\u5173\u7cfb\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u542f\u7528\u4f9b\u8d27\u5173\u7cfb\u518d\u7ee7\u7eed\u64cd\u4f5c\u3002");
                break;
            }
            case "btnedit": {
                if (billList.getCurrentSelectedRowInfo().getBillStatus().equals("A")) {
                    if (this.isSupplyRelationExist(supplyRelationId)) {
                        this.showForm(OperationStatus.EDIT, OCDMA_SALEORDER_ADD);
                        break;
                    }
                    this.getView().showTipNotification("\u8981\u8d27\u8ba2\u5355\u4f9b\u8d27\u5173\u7cfb\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u542f\u7528\u4f9b\u8d27\u5173\u7cfb\u518d\u7ee7\u7eed\u64cd\u4f5c\u3002");
                    break;
                }
                this.getView().showTipNotification("\u53ea\u80fd\u4fee\u6539\u6682\u5b58\u7684\u8ba2\u5355\u3002");
                break;
            }
            case "btndelete": {
                if (billList.getCurrentSelectedRowInfo().getBillStatus().equals("A")) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(op_delete, (IFormPlugin)this);
                    this.getView().showConfirm("\u662f\u5426\u5220\u9664\u9009\u4e2d\u8ba2\u5355\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                this.getView().showTipNotification("\u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u8ba2\u5355\u3002");
                break;
            }
            case "btnretorder": {
                if (billList.getCurrentSelectedRowInfo().getBillStatus().equals("A") || billList.getCurrentSelectedRowInfo().getBillStatus().equals("B")) {
                    this.getView().showTipNotification("\u4e0d\u80fd\u5bf9\u6682\u5b58\uff0c\u5df2\u63d0\u4ea4\uff0c\u53d8\u66f4\u4e2d\u8ba2\u5355\u8fdb\u884c\u9000\u8d27");
                } else {
                    List<ListSelectedRow> needPushRowList;
                    List pushList;
                    if (saleOrder != null && saleOrder.get("itementry") != null) {
                        DynamicObjectCollection itemEntry = saleOrder.getDynamicObjectCollection("itementry");
                        BigDecimal retSumQty = itemEntry.stream().filter(temp -> temp.get("joinreturnbaseqty") != null && temp.getBigDecimal("joinreturnbaseqty").compareTo(BigDecimal.ZERO) > 0).map(a -> a.getBigDecimal("joinreturnbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal reqSumQty = itemEntry.stream().filter(temp -> temp.get("reqqty") != null && temp.getBigDecimal("reqqty").compareTo(BigDecimal.ZERO) > 0).map(a -> a.getBigDecimal("reqqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (reqSumQty.compareTo(retSumQty) <= 0) {
                            this.getView().showTipNotification("\u8be5\u5355\u636e\u5df2\u8fdb\u884c\u6574\u5355\u9000\u8d27\uff0c\u8bf7\u68c0\u67e5\u5355\u636e");
                            break;
                        }
                    }
                    if (CommonUtils.isNull((Object)(pushList = BotpHelper.getConvertResultBill(needPushRowList = this.getNeedPushSelectRowList(orderId), (String)"ocbsoc_saleorder", (String)"ocbsoc_returnorder", (String)"1068008610845813760")))) break;
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"save", (String)"ocbsoc_returnorder", (DynamicObject[])pushList.toArray(new DynamicObject[0]), (OperateOption)CommonUtils.getOperateOption());
                    List successPkIds = submitResult.getSuccessPkIds();
                    if (CommonUtils.isNull((Object)successPkIds)) {
                        if (submitResult.isSuccess()) break;
                        this.getView().showMessage(MessageFormat.format("\u81ea\u52a8\u63d0\u4ea4\u5931\u8d25\uff1a{0}", CommonUtils.getErrDetail((OperationResult)submitResult)));
                        break;
                    }
                    long returnOrderId = (Long)successPkIds.get(0);
                    MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                    mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                    mobileFormShowParameter.setFormId(OCSAA_RETORDER_REQ_ADD);
                    mobileFormShowParameter.setCustomParam("returnOrderId", (Object)String.valueOf(returnOrderId));
                    mobileFormShowParameter.setCustomParam("orderId", (Object)String.valueOf(orderId));
                    mobileFormShowParameter.setStatus(OperationStatus.EDIT);
                    mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OCSAA_RETORDER_REQ_ADD));
                    this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                    break;
                }
            }
            case "btnsign": {
                this.showForm(OperationStatus.ADDNEW, page_sign);
                break;
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String key;
        switch (key = ((Control)mobileSearchTextChangeEvent.getSource()).getKey()) {
            case "ordersearch": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String key;
        switch (key = ((Control)tabSelectEvent.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                BillList billList = (BillList)this.getControl(op_billlistap);
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getOrderFilter(tabSelectEvent.getTabKey())});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "enddate": 
            case "startdate": 
            case "orderdatespan": {
                this.refreshBillList();
                break;
            }
        }
    }

    private QFilter getOrderFilter(String key) {
        QFilter filter = SaleOrderHelper.getOrderChannelFilter();
        filter.and("billtypeid", "!=", (Object)100001L);
        switch (key) {
            case "tp_all": {
                break;
            }
            case "d": {
                filter.and("billstatus", "in", (Object)billStatusArray);
                break;
            }
            default: {
                filter.and("billstatus", "=", (Object)key.toUpperCase());
            }
        }
        MobileSearch search = (MobileSearch)this.getControl(op_ordersearch);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno,itementry.itemid.name,itementry.itemid.number"}));
        }
        this.setDateFilter(filter);
        Object fromFormId = this.getParameter("fromFormId");
        if (OCSAA_CHANNEL.equals(fromFormId)) {
            long channelId = (Long)this.getParameter("channelId");
            filter.and("orderchannelid", "=", (Object)channelId);
        }
        return filter;
    }

    private void setDateFilter(QFilter filter) {
        Date startDate = (Date)this.getValue(startdate);
        Date endDate = (Date)this.getValue(enddate);
        if (startDate != null && endDate != null) {
            filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)startDate));
            filter.and("orderdate", "<=", (Object)DateUtil.getDayLast((Date)endDate));
            return;
        }
        Object orderDateSpan = this.getValue(orderdatespan);
        String selectDate = "F";
        if (!CommonUtils.isNull((Object)orderDateSpan)) {
            selectDate = orderDateSpan.toString();
        }
        switch (selectDate) {
            case "A": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(6L))));
                break;
            }
            case "B": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth()));
                break;
            }
            case "C": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(90L))));
                break;
            }
            case "D": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                break;
            }
            case "E": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                break;
            }
            case "G": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                break;
            }
            default: {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getNowDate()));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getNowDate()));
            }
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                ArrayList<Long> orderIds = new ArrayList<Long>(rows.size());
                for (DynamicObject row : rows) {
                    orderIds.add(row.getLong("id"));
                }
                Map results = (Map)SaleOrderHelper.invokeOrderService((String)"getOrderItemsQty", (Object[])new Object[]{orderIds});
                if (results != null) {
                    for (DynamicObject row : rows) {
                        long orderId = row.getLong("id");
                        Map mapQty = (Map)results.get(orderId);
                        if (mapQty == null) continue;
                        BigDecimal qty = (BigDecimal)mapQty.get("qty");
                        BigDecimal auxQty = (BigDecimal)mapQty.get("auxqty");
                        row.set(SaleOrderListPlugin.orderremark, (Object)qty.stripTrailingZeros().toPlainString());
                        row.set(SaleOrderListPlugin.synerrormsg, (Object)auxQty.stripTrailingZeros().toPlainString());
                    }
                }
                return rows;
            }
        });
    }

    private List<ListSelectedRow> getNeedPushSelectRowList(long orderId) {
        QFilter filter = new QFilter("id", "=", (Object)orderId);
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)String.join((CharSequence)",", "id", String.join((CharSequence)".", "itementry", "id")), (QFilter[])filter.toArray());
        ArrayList<ListSelectedRow> needPushRowList = new ArrayList<ListSelectedRow>(1);
        for (DynamicObject dynObj : dynColl) {
            ListSelectedRow selectRow = new ListSelectedRow((Object)dynObj.getLong("id"));
            selectRow.setEntryEntityKey("itementry");
            selectRow.setEntryPrimaryKeyValue((Object)dynObj.getLong(String.join((CharSequence)".", "itementry", "id")));
            needPushRowList.add(selectRow);
        }
        return needPushRowList;
    }
}

