/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class SaleOrderSignPlugin
extends OcdmaFormMobPlugin
implements MobileSearchTextChangeListener,
MobileSearchCancelListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final String selectField = String.join((CharSequence)",", "id", "billno", "deliverdate", "settlecurrency", String.join((CharSequence)".", "deliverydetail", "id"), String.join((CharSequence)".", "deliverydetail", "item"), String.join((CharSequence)".", "deliverydetail", "taxprice"), String.join((CharSequence)".", "deliverydetail", "amountandtax"), String.join((CharSequence)".", "deliverydetail", "unit"), String.join((CharSequence)".", "deliverydetail", "unit", "name"), String.join((CharSequence)".", "deliverydetail", "assistunit"), String.join((CharSequence)".", "deliverydetail", "deliverqty"), String.join((CharSequence)".", "deliverydetail", "deliverbaseqty"), String.join((CharSequence)".", "deliverydetail", "deliverassitqty"), String.join((CharSequence)".", "deliverydetail", "mainbillentryid"), String.join((CharSequence)".", "deliverydetail", "mainbillnumber"), String.join((CharSequence)".", "deliverydetail", "mainbillid"), String.join((CharSequence)".", "deliverydetail", "refuseqty"), String.join((CharSequence)".", "deliverydetail", "signqty"), String.join((CharSequence)".", "deliverydetail", "orderchannelid"), String.join((CharSequence)".", "deliverydetail", "material"));
    private static final int amtPrecision = 2;
    private static final String ENTRYENTITY = "entryentity";
    private static final String WAREHOUSE_PANEL = "warehousepanel";
    private static final String LOCATION_PANEL = "locationpanel";
    private static final String WAREHOUSE = "warehouseid";
    private static final String LOCATION = "locationid";
    private static final String SIGN_ADD = "sign_add";
    private static final String SIGN_REDUCE = "sign_reduce";
    private static final String AUXSIGN_ADD = "auxsign_add";
    private static final String AUXSIGN_REDUCE = "auxsign_reduce";
    private static final String SIGN_QTY = "signqty";
    private static final String AUXQTY = "auxqty";
    private static final String REFUSE_ADD = "refuse_add";
    private static final String REFUSE_REDUCE = "refuse_reduce";
    private static final String REFUSE_QTY = "refuseqty";
    private static final String SELECT_ALL = "selectall";
    private static final String SIGN_BTN = "sign_btn";
    private static final String MAX_SIGN_QTY = "maxsignqty";
    private static final String SELECTSN_BTN = "selectsn_btn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{WAREHOUSE_PANEL, LOCATION_PANEL, SELECT_ALL, SIGN_BTN, SIGN_ADD, SIGN_REDUCE, AUXSIGN_ADD, AUXSIGN_REDUCE, SIGN_QTY, REFUSE_ADD, REFUSE_REDUCE, REFUSE_QTY, SELECTSN_BTN});
        this.addF7Listener(this, new String[]{WAREHOUSE, LOCATION});
        CardEntry entryEntity = (CardEntry)this.getView().getControl(ENTRYENTITY);
        entryEntity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDeliveryRecordInfo();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(ENTRYENTITY);
        switch (key) {
            case "warehousepanel": {
                BasedataEdit warehouse = (BasedataEdit)this.getControl(WAREHOUSE);
                if (warehouse == null) break;
                warehouse.click();
                break;
            }
            case "locationpanel": {
                BasedataEdit location = (BasedataEdit)this.getControl(LOCATION);
                if (location == null) break;
                location.click();
                break;
            }
            case "sign_btn": {
                this.sign();
                break;
            }
            case "sign_add": {
                BigDecimal signQty = (BigDecimal)model.getValue(SIGN_QTY, index);
                this.getModel().setValue(SIGN_QTY, (Object)signQty.add(BigDecimal.ONE), index);
                break;
            }
            case "sign_reduce": {
                BigDecimal signQty = (BigDecimal)model.getValue(SIGN_QTY, index);
                if (signQty.subtract(BigDecimal.ONE).compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().setValue(SIGN_QTY, (Object)signQty.subtract(BigDecimal.ONE), index);
                break;
            }
            case "auxsign_add": {
                BigDecimal auxQty = (BigDecimal)model.getValue(AUXQTY, index);
                this.getModel().setValue(AUXQTY, (Object)auxQty.add(BigDecimal.ONE), index);
                break;
            }
            case "auxsign_reduce": {
                BigDecimal auxQty = (BigDecimal)model.getValue(AUXQTY, index);
                if (auxQty.subtract(BigDecimal.ONE).compareTo(BigDecimal.ZERO) <= 0) break;
                this.getModel().setValue(AUXQTY, (Object)auxQty.subtract(BigDecimal.ONE), index);
                break;
            }
            case "refuse_add": {
                BigDecimal refuseQty = (BigDecimal)model.getValue(REFUSE_QTY, index);
                this.getModel().setValue(REFUSE_QTY, (Object)refuseQty.add(BigDecimal.ONE), index);
                break;
            }
            case "refuse_reduce": {
                BigDecimal refuseQty = (BigDecimal)model.getValue(REFUSE_QTY, index);
                this.getModel().setValue(REFUSE_QTY, (Object)refuseQty.subtract(BigDecimal.ONE), index);
                break;
            }
            case "selectsn_btn": {
                String deliveryBillId = String.valueOf(this.getModel().getValue("deliverybillid", index));
                String deliveryEntryId = String.valueOf(this.getModel().getValue("deliveryentryid", index));
                String snEntryIds = (String)this.getModel().getValue("snentryids", index);
                List SNSubEntryIdList = CollectionUtil.convertToLong((Collection)StringUtils.toList((String)snEntryIds));
                QFilter filter = new QFilter("deliverydetail.subentryentity.id", "in", (Object)SNSubEntryIdList);
                DynamicObjectCollection delivery = QueryServiceHelper.query((String)"ocbsoc_delivery_record", (String)"deliverydetail.subentryentity.ocicserialid", (QFilter[])filter.toArray());
                List<Object> SNIdList = new ArrayList(16);
                if (CollectionUtil.isNotNull((List)delivery)) {
                    SNIdList = delivery.stream().map(r -> r.getLong("deliverydetail.subentryentity.ocicserialid")).collect(Collectors.toList());
                }
                MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
                mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileBillShowParameter.setFormId("ocdma_saleorder_sign_sn");
                mobileBillShowParameter.setCustomParam("deliveryBillId", (Object)deliveryBillId);
                mobileBillShowParameter.setCustomParam("deliveryEntryId", (Object)deliveryEntryId);
                mobileBillShowParameter.setCustomParam("SNIdList", SNIdList);
                mobileBillShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocdma_saleorder_sign_sn"));
                this.getView().showForm((FormShowParameter)mobileBillShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        switch (key) {
            case "ocdma_saleorder_sign_sn": {
                if (returnData == null) break;
                List selectIdList = (List)returnData;
                String subentryIds = "";
                long deliveryEntryId = Long.parseLong((String)this.getModel().getValue("deliveryentryid", index));
                QFilter filter = new QFilter("deliverydetail.subentryentity.ocicserialid", "in", (Object)selectIdList);
                filter.and("deliverydetail.id", "=", (Object)deliveryEntryId);
                DynamicObjectCollection delivery = QueryServiceHelper.query((String)"ocbsoc_delivery_record", (String)"deliverydetail.subentryentity.id,deliverydetail.subentryentity.ocicserialid", (QFilter[])filter.toArray());
                if (delivery != null && delivery.size() > 0) {
                    subentryIds = StringUtils.join((Object[])delivery.stream().map(r -> r.getString("deliverydetail.subentryentity.id")).toArray(), (String)",");
                }
                this.getModel().setValue("snentryids", (Object)subentryIds, index);
                this.getModel().setValue(SIGN_QTY, (Object)selectIdList.size(), index);
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.initDeliveryRecordInfo();
    }

    public void cancel() {
        this.initDeliveryRecordInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        CardEntry deliveryRecordEntity = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int index = this.getRowIndex(e);
        switch (key) {
            case "selectall": {
                boolean selectAll = (Boolean)this.getModel().getValue(SELECT_ALL);
                if (selectAll) {
                    this.selectAllEntry(ENTRYENTITY);
                    break;
                }
                this.unSelectAllEntry(ENTRYENTITY);
                break;
            }
            case "auxqty": {
                long unitId = (Long)this.getModel().getValue("saleunit_id");
                long assistUnitId = (Long)this.getModel().getValue("assistunit_id");
                long materielId = (Long)this.getModel().getValue("materiel_id");
                BigDecimal assistQty = (BigDecimal)this.getModel().getValue(AUXQTY);
                if (unitId == 0L || assistUnitId == 0L || materielId == 0L) break;
                BigDecimal signQty = UnitConvertHelper.calculateDestQty((BigDecimal)assistQty, (Long)materielId, (Long)assistUnitId, (Long)unitId);
                this.setValue(SIGN_QTY, signQty, true);
                break;
            }
            case "signqty": {
                BigDecimal maxSignQty = (BigDecimal)this.getModel().getValue(MAX_SIGN_QTY, index);
                BigDecimal signQty = (BigDecimal)this.getModel().getValue(SIGN_QTY, index);
                BigDecimal refuseQty = (BigDecimal)this.getModel().getValue(REFUSE_QTY, index);
                BigDecimal canSignQty = maxSignQty.subtract(refuseQty);
                if (signQty.compareTo(canSignQty) > 0) {
                    this.getModel().setValue(SIGN_QTY, (Object)canSignQty, index);
                    return;
                }
                if (signQty.compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue(SIGN_QTY, (Object)BigDecimal.ZERO, index);
                    return;
                }
                long unitId = (Long)this.getModel().getValue("saleunit_id");
                long assistUnitId = (Long)this.getModel().getValue("assistunit_id");
                long materielId = (Long)this.getModel().getValue("materiel_id");
                if (unitId == 0L || assistUnitId == 0L || materielId == 0L) break;
                BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)signQty, (Long)materielId, (Long)unitId, (Long)assistUnitId);
                this.setValue(AUXQTY, assistQty, false);
                break;
            }
            case "refuseqty": {
                BigDecimal maxSignQty = (BigDecimal)this.getModel().getValue(MAX_SIGN_QTY, index);
                BigDecimal signQty = (BigDecimal)this.getModel().getValue(SIGN_QTY, index);
                BigDecimal refuseQty = (BigDecimal)this.getModel().getValue(REFUSE_QTY, index);
                BigDecimal canRefuseQty = maxSignQty.subtract(signQty);
                if (refuseQty.compareTo(canRefuseQty) > 0) {
                    this.getModel().setValue(REFUSE_QTY, (Object)canRefuseQty, index);
                    return;
                }
                if (refuseQty.compareTo(BigDecimal.ZERO) >= 0) break;
                this.getModel().setValue(REFUSE_QTY, (Object)BigDecimal.ZERO, index);
                return;
            }
            case "warehouseid": {
                DynamicObject wareHouse = (DynamicObject)this.getModel().getValue(WAREHOUSE, index);
                if (wareHouse == null) {
                    this.getModel().setValue(LOCATION, null, index);
                    return;
                }
                if (wareHouse.getBoolean("enablelocation")) {
                    deliveryRecordEntity.setChildVisible(true, index, new String[]{LOCATION});
                    String wareHouseId = wareHouse.getString("id");
                    Map locationMap = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"ChannelService", (String)"getDefaultLocationMap", (Object[])new Object[]{Collections.singletonList(wareHouseId)});
                    if (locationMap != null) {
                        this.getModel().setValue(LOCATION, locationMap.get(wareHouseId), index);
                        break;
                    }
                    this.getModel().setValue(LOCATION, null, index);
                    break;
                }
                deliveryRecordEntity.setChildVisible(false, index, new String[]{LOCATION});
                this.getModel().setValue(LOCATION, null, index);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(ENTRYENTITY);
        switch (key) {
            case "warehouseid": {
                long orderChannelId = (Long)model.getValue("orderchannelid", index);
                ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
                filters.add(new QFilter("enable", "=", (Object)Checked.YES.toString()));
                filters.add(new QFilter("status", "=", (Object)Status.AUDITED.toString()));
                filters.add(new QFilter("ownerchannelid", "=", (Object)orderChannelId));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, filters);
                break;
            }
            case "locationid": {
                long warehouseId = 0L;
                DynamicObject warehouseInfo = (DynamicObject)model.getValue(WAREHOUSE, index);
                if (warehouseInfo != null) {
                    warehouseId = warehouseInfo.getLong("id");
                }
                ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
                filters.add(new QFilter("enable", "=", (Object)Checked.YES.toString()));
                filters.add(new QFilter(WAREHOUSE, "=", (Object)warehouseId));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, filters);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int selectRowCount;
        CardEntry entryEntity = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount == (selectRowCount = entryEntity.getSelectRows().length)) {
            this.setValue(SELECT_ALL, true, false);
        } else {
            this.setValue(SELECT_ALL, false, false);
        }
    }

    private DynamicObjectCollection getDeliveryRecord(long orderId, long deliveryId) {
        Map targetBill;
        QFilter filter = null;
        filter = deliveryId != 0L ? new QFilter("id", "=", (Object)deliveryId) : new QFilter(String.join((CharSequence)".", "deliverydetail", "mainbillid"), "=", (Object)orderId);
        DynamicObjectCollection deliveryRecord = QueryServiceHelper.query((String)"ocbsoc_delivery_record", (String)selectField, (QFilter[])filter.toArray(), (String)String.join((CharSequence)".", "deliverydetail", "id"));
        if (!(deliveryRecord != null && !deliveryRecord.isEmpty() || (targetBill = BFTrackerServiceHelper.findTargetBills((String)"ocbsoc_saleorder", (Long[])new Long[]{orderId})) == null || targetBill.isEmpty() || targetBill.get("ocbsoc_saleorder") == null || ((HashSet)targetBill.get("ocbsoc_saleorder")).isEmpty())) {
            orderId = (Long)((HashSet)targetBill.get("ocbsoc_saleorder")).toArray()[0];
            filter = new QFilter(String.join((CharSequence)".", "deliverydetail", "mainbillid"), "=", (Object)orderId);
            deliveryRecord = QueryServiceHelper.query((String)"ocbsoc_delivery_record", (String)selectField, (QFilter[])filter.toArray(), (String)String.join((CharSequence)".", "deliverydetail", "id"));
        }
        return deliveryRecord;
    }

    private void initDeliveryRecordInfo() {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orderId = customParams.containsKey("orderId") ? (Long)customParams.get("orderId") : 0L;
        long deliveryId = customParams.containsKey("deliveryid") ? Long.parseLong(customParams.get("deliveryid").toString()) : 0L;
        DynamicObjectCollection deliveryRecordCollection = this.getDeliveryRecord(orderId, deliveryId);
        if (deliveryRecordCollection == null || deliveryRecordCollection.isEmpty()) {
            return;
        }
        List<Long> itemIds = deliveryRecordCollection.stream().map(r -> r.getLong(String.join((CharSequence)".", "deliverydetail", "item"))).distinct().collect(Collectors.toList());
        Map<Long, DynamicObject> itemInfoMap = this.getItemInfoMap(itemIds);
        List orderChannelIds = deliveryRecordCollection.stream().map(r -> r.getString(String.join((CharSequence)".", "deliverydetail", "orderchannelid"))).distinct().collect(Collectors.toList());
        Map warehouseMap = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"ChannelService", (String)"getDefaultWarehouseMap", (Object[])new Object[]{orderChannelIds});
        HashMap<String, DynamicObject> locationMap = new HashMap();
        if (warehouseMap != null && warehouseMap.size() > 0) {
            ArrayList<String> warehouseIds = new ArrayList<String>();
            for (Map.Entry entrySet : warehouseMap.entrySet()) {
                if (!((DynamicObject)entrySet.getValue()).getBoolean("enablelocation")) continue;
                warehouseIds.add(((DynamicObject)entrySet.getValue()).getString("id"));
            }
            locationMap = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"ChannelService", (String)"getDefaultLocationMap", (Object[])new Object[]{warehouseIds});
        }
        Map<Long, List<DynamicObject>> deliveryRecordMap = deliveryRecordCollection.stream().collect(Collectors.groupingBy(k -> k.getLong("id")));
        ArrayList<Map.Entry<Long, List<DynamicObject>>> deliveryRecordGroupList = new ArrayList<Map.Entry<Long, List<DynamicObject>>>(deliveryRecordMap.entrySet());
        deliveryRecordGroupList.sort((o1, o2) -> {
            Date date1 = ((DynamicObject)((List)o1.getValue()).get(0)).getDate("deliverdate");
            Date date2 = ((DynamicObject)((List)o2.getValue()).get(0)).getDate("deliverdate");
            return date2.compareTo(date1);
        });
        for (Map.Entry entry : deliveryRecordGroupList) {
            List deliveryRecordList = (List)entry.getValue();
            List filterDeliveryRecordList = new ArrayList(deliveryRecordList.size());
            filterDeliveryRecordList = deliveryRecordList;
            ArrayList<DynamicObject> validDeliveryRecordList = new ArrayList<DynamicObject>(filterDeliveryRecordList.size());
            for (DynamicObject deliveryRecord : filterDeliveryRecordList) {
                BigDecimal deliverQty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", "deliverqty"));
                BigDecimal alreadysignqty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", SIGN_QTY));
                BigDecimal alreadyRefuseQty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", REFUSE_QTY));
                BigDecimal signQty = deliverQty.subtract(alreadysignqty).subtract(alreadyRefuseQty);
                if (signQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                validDeliveryRecordList.add(deliveryRecord);
            }
            this.createNewEntryRows(validDeliveryRecordList, itemInfoMap, warehouseMap, locationMap);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private Map<Long, DynamicObject> getItemInfoMap(List<Long> itemIds) {
        QFilter filter = new QFilter("id", "in", itemIds);
        String selectFields = String.join((CharSequence)",", "id", "name", "number", "thumbnail", "material", "enableserial", "enablelot", "saleunit", "baseunit", "assistunit", "serialunit", "modelnum");
        DynamicObjectCollection itemInfoList = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFields, (QFilter[])filter.toArray());
        if (itemInfoList != null) {
            return itemInfoList.stream().collect(Collectors.toMap(r -> r.getLong("id"), Function.identity(), (key1, key2) -> key2));
        }
        return new HashMap<Long, DynamicObject>();
    }

    private void createNewEntryRows(List<DynamicObject> filterDeliveryRecordList, Map<Long, DynamicObject> itemInfoMap, Map<String, DynamicObject> warehouseMap, Map<String, DynamicObject> locationMap) {
        if (filterDeliveryRecordList.size() == 0) {
            return;
        }
        CardEntry deliveryRecordEntity = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int[] indexes = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, filterDeliveryRecordList.size());
        for (int i = 0; i < indexes.length; ++i) {
            DynamicObject wareHouse;
            int index = indexes[i];
            DynamicObject dataObject = this.getRowInfo(ENTRYENTITY, index);
            DynamicObject deliveryRecord = filterDeliveryRecordList.get(i);
            String orderChannelId = deliveryRecord.getString(String.join((CharSequence)".", "deliverydetail", "orderchannelid"));
            if (i != 0) {
                deliveryRecordEntity.setChildVisible(false, index, new String[]{"delivery_info"});
            }
            dataObject.set("deliverybillid", (Object)deliveryRecord.getString("id"));
            dataObject.set("deliveryentryid", (Object)deliveryRecord.getString(String.join((CharSequence)".", "deliverydetail", "id")));
            dataObject.set("deliverybillnumber", (Object)deliveryRecord.getString("billno"));
            Date deliveryRecordDate = deliveryRecord.getDate("deliverdate");
            dataObject.set("deliverdate", (Object)DateUtil.toDateStr((Date)deliveryRecordDate));
            long itemId = deliveryRecord.getLong(String.join((CharSequence)".", "deliverydetail", "item"));
            DynamicObject itemInfo = itemInfoMap.get(itemId);
            dataObject.set("thumbnail", (Object)itemInfo.getString("thumbnail"));
            BigDecimal price = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", "taxprice"));
            dataObject.set("price", (Object)BigDecimalUtil.setScale((BigDecimal)price, (int)2));
            BigDecimal amountAndTax = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", "amountandtax"));
            dataObject.set("amountandtax", (Object)BigDecimalUtil.setScale((BigDecimal)amountAndTax, (int)2));
            BigDecimal deliverQty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", "deliverqty"));
            dataObject.set("deliverqty", (Object)deliverQty);
            BigDecimal deliverBaseQty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", "deliverbaseqty"));
            dataObject.set("deliverbaseqty", (Object)deliverBaseQty);
            BigDecimal deliverAssitQty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", "deliverassitqty"));
            dataObject.set("deliverassitqty", (Object)deliverAssitQty);
            BigDecimal alreadysignqty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", SIGN_QTY));
            dataObject.set("alreadysignqty", (Object)alreadysignqty);
            BigDecimal alreadyRefuseQty = deliveryRecord.getBigDecimal(String.join((CharSequence)".", "deliverydetail", REFUSE_QTY));
            dataObject.set("alreadyrefuseqty", (Object)alreadyRefuseQty);
            BigDecimal signQty = deliverQty.subtract(alreadysignqty).subtract(alreadyRefuseQty);
            dataObject.set(SIGN_QTY, (Object)signQty);
            dataObject.set(MAX_SIGN_QTY, (Object)signQty);
            dataObject.set(REFUSE_QTY, (Object)BigDecimal.ZERO);
            dataObject.set("orderchannelid", (Object)orderChannelId);
            long currencySign = deliveryRecord.getLong("settlecurrency");
            this.getModel().setValue("pricecurrency", (Object)currencySign, index);
            long unitId = deliveryRecord.getLong(String.join((CharSequence)".", "deliverydetail", "unit"));
            this.getModel().setValue("unit", (Object)unitId, index);
            this.getModel().setValue("item", (Object)itemId, index);
            long materielId = deliveryRecord.getLong(String.join((CharSequence)".", "deliverydetail", "material"));
            this.getModel().setValue("materiel", (Object)materielId, index);
            long auxUnitId = deliveryRecord.getLong(String.join((CharSequence)".", "deliverydetail", "assistunit"));
            this.getModel().setValue("assistunit", (Object)auxUnitId, index);
            this.getModel().setValue("saleunit", (Object)unitId, index);
            if (unitId != 0L && auxUnitId != 0L && materielId != 0L) {
                BigDecimal assistQty = UnitConvertHelper.calculateDestQty((BigDecimal)signQty, (Long)materielId, (Long)unitId, (Long)auxUnitId);
                dataObject.set(AUXQTY, (Object)assistQty);
            }
            if (warehouseMap != null && (wareHouse = warehouseMap.get(orderChannelId)) != null) {
                String warehouseId = wareHouse.getString("id");
                dataObject.set(WAREHOUSE, (Object)wareHouse);
                if (locationMap != null) {
                    dataObject.set(LOCATION, (Object)locationMap.get(warehouseId));
                }
                if (!wareHouse.getBoolean("enablelocation")) {
                    deliveryRecordEntity.setChildVisible(false, index, new String[]{LOCATION});
                }
            }
            boolean enableSerial = itemInfo.getBoolean("enableserial");
            dataObject.set("enableserial", (Object)enableSerial);
            if (enableSerial) {
                deliveryRecordEntity.setChildVisible(true, index, new String[]{SELECTSN_BTN});
                dataObject.set(SIGN_QTY, (Object)BigDecimal.ZERO);
                dataObject.set(AUXQTY, (Object)BigDecimal.ZERO);
                continue;
            }
            deliveryRecordEntity.setChildVisible(false, index, new String[]{SELECTSN_BTN});
        }
    }

    private void sign() {
        CardEntry entryGrid = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002");
            return;
        }
        DynamicObjectCollection allDeliveryRecordCollection = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectCollection selectDeliveryRecordCollection = new DynamicObjectCollection();
        for (int i = 0; i < selectRows.length; ++i) {
            selectDeliveryRecordCollection.add(allDeliveryRecordCollection.get(selectRows[i]));
        }
        String checkResult = this.checkSign(selectDeliveryRecordCollection);
        if (StringUtils.isNotNull((String)checkResult)) {
            this.getView().showTipNotification(checkResult);
            return;
        }
        Map<Long, List<DynamicObject>> detailMap = selectDeliveryRecordCollection.stream().collect(Collectors.groupingBy(r -> r.getLong("deliverybillid")));
        DynamicObject[] deliveryData = BusinessDataServiceHelper.load((Object[])detailMap.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocbsoc_delivery_record"));
        if (deliveryData != null && deliveryData.length > 0) {
            for (DynamicObject delivery : deliveryData) {
                List<DynamicObject> itemList = detailMap.get(delivery.getPkValue());
                Map pageItemMap = itemList.stream().collect(Collectors.toMap(k -> k.getLong("deliveryentryid"), Function.identity(), (r1, r2) -> r1));
                DynamicObjectCollection deliveryEntry = delivery.getDynamicObjectCollection("deliverydetail");
                for (DynamicObject entry : deliveryEntry) {
                    DynamicObject pageItem = (DynamicObject)pageItemMap.get(entry.getPkValue());
                    if (pageItem != null) {
                        DynamicObjectCollection subEntryList;
                        BigDecimal thissignqty = pageItem.getBigDecimal(SIGN_QTY);
                        BigDecimal thissignbaseqty = BigDecimal.ZERO;
                        BigDecimal thissignassistqty = BigDecimal.ZERO;
                        entry.set("stockid", pageItem.get(WAREHOUSE));
                        entry.set("stockaddrid", pageItem.get(LOCATION));
                        entry.set("thissignqty", (Object)thissignqty);
                        entry.set("thissignbotpqty", (Object)thissignqty);
                        DynamicObject materialObj = entry.getDynamicObject("material");
                        long materialId = materialObj != null ? materialObj.getLong("id") : 0L;
                        Long unitId = entry.getLong(String.join((CharSequence)"_", "unit", "id"));
                        Long baseunitId = entry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
                        Long assistunitId = entry.getLong(String.join((CharSequence)"_", "assistunit", "id"));
                        if (unitId > 0L && baseunitId > 0L) {
                            thissignbaseqty = UnitConvertHelper.calculateDestQty((BigDecimal)thissignqty, (Long)materialId, (Long)unitId, (Long)baseunitId);
                        }
                        entry.set("thissignbaseqty", (Object)thissignbaseqty);
                        if (unitId > 0L && assistunitId > 0L) {
                            thissignassistqty = UnitConvertHelper.calculateDestQty((BigDecimal)thissignqty, (Long)materialId, (Long)unitId, (Long)assistunitId);
                        }
                        entry.set("thissignassistqty", (Object)thissignassistqty);
                        if (!pageItem.getBoolean("enableserial") || (subEntryList = entry.getDynamicObjectCollection("subentryentity")) == null || subEntryList.isEmpty()) continue;
                        String pageSn = pageItem.getString("snentryids");
                        List snList = CollectionUtil.convertToLong((Collection)StringUtils.toList((String)pageSn));
                        for (DynamicObject subEntry : subEntryList) {
                            if (snList.contains(subEntry.getPkValue())) {
                                subEntry.set("isselect", (Object)true);
                                continue;
                            }
                            subEntry.set("isselect", (Object)false);
                        }
                        continue;
                    }
                    entry.set("thissignqty", (Object)BigDecimal.ZERO);
                    entry.set("thissignbotpqty", (Object)BigDecimal.ZERO);
                }
            }
            OperateOption operateOption = CommonUtils.getOperateOption();
            OperationResult result = OperationServiceHelper.executeOperate((String)"sign", (String)"ocbsoc_delivery_record", (DynamicObject[])deliveryData, (OperateOption)operateOption);
            if (!result.isSuccess()) {
                this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
            } else {
                this.getView().showSuccessNotification("\u7b7e\u6536\u6210\u529f\u3002");
            }
        }
        this.initDeliveryRecordInfo();
    }

    private String checkSign(DynamicObjectCollection detailList) {
        for (DynamicObject detail : detailList) {
            int index = detail.getInt("seq");
            BigDecimal signQty = detail.getBigDecimal(SIGN_QTY);
            BigDecimal refuseQty = detail.getBigDecimal(REFUSE_QTY);
            BigDecimal maxSignQty = detail.getBigDecimal(MAX_SIGN_QTY);
            if (signQty.compareTo(BigDecimal.ZERO) <= 0) {
                return String.format("\u7b2c%1$s\u884c\uff0c\u8bf7\u5148\u586b\u5199\u7b7e\u6536\u6570\u91cf\u3002", index);
            }
            if (refuseQty.compareTo(BigDecimal.ZERO) < 0) {
                return String.format("\u7b2c%1$s\u884c\uff0c\u8bf7\u5148\u586b\u5199\u62d2\u6536\u6570\u91cf\u3002", index);
            }
            if (signQty.add(refuseQty).compareTo(maxSignQty) > 0) {
                return String.format("\u7b2c%1$s\u884c\uff0c\u7b7e\u6536\u6570\u91cf\u548c\u62d2\u6536\u6570\u91cf\u603b\u6570\u4e0d\u80fd\u5927\u4e8e\u53ef\u7b7e\u6536\u6570\u91cf\u3002", index);
            }
            if (detail.getDynamicObject(WAREHOUSE) != null) continue;
            return String.format("\u7b2c%1$s\u884c\uff0c\u8bf7\u5148\u586b\u5199\u4ed3\u5e93\u548c\u4ed3\u4f4d\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", index);
        }
        return "";
    }
}

