/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class SaleOrderSignSNPlugin
extends OcdmaFormMobPlugin
implements RowClickEventListener {
    private static final String SELECT_ALL = "selectall";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryEntity = (CardEntry)this.getView().getControl(ENTRYENTITY);
        entryEntity.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initSN();
        int[] selectRows = this.getSelectRows();
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount == selectRows.length) {
            this.setValue(SELECT_ALL, true, false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = this.getSelectRows();
        cardEntry.selectRows(selectRows, 0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "selectall": {
                boolean selectAll = (Boolean)this.getModel().getValue(SELECT_ALL);
                if (selectAll) {
                    this.selectAllEntry(ENTRYENTITY);
                    break;
                }
                this.unSelectAllEntry(ENTRYENTITY);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int selectRowCount;
        CardEntry entryEntity = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount == (selectRowCount = entryEntity.getSelectRows().length)) {
            this.setValue(SELECT_ALL, true, false);
        } else {
            this.setValue(SELECT_ALL, false, false);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = cardEntry.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Long> selectIdList = new ArrayList<Long>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            selectIdList.add(dynamicObject.getLong("id"));
        }
        this.getView().returnDataToParent(selectIdList);
    }

    private void initSN() {
        int[] indexes;
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        DynamicObjectCollection snInfoList = this.getSNInfoList();
        if (snInfoList.size() == 0) {
            return;
        }
        for (int index : indexes = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, snInfoList.size())) {
            DynamicObject SNInfo = (DynamicObject)snInfoList.get(index);
            DynamicObject dataObject = this.getRowInfo(ENTRYENTITY, index);
            dataObject.set("number", (Object)SNInfo.getString("number"));
            dataObject.set("id", (Object)SNInfo.getString("id"));
        }
    }

    private int[] getSelectRows() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List SNIdList = (List)customParams.get("SNIdList");
        if (CollectionUtil.isNotNull((List)SNIdList)) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<Integer> selectedRows = new ArrayList<Integer>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (!SNIdList.contains(dynamicObject.getLong("id"))) continue;
                selectedRows.add(dynamicObject.getInt("seq") - 1);
            }
            return selectedRows.stream().mapToInt(Integer::intValue).toArray();
        }
        return new int[0];
    }

    private DynamicObjectCollection getSNInfoList() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long deliveryBillId = Long.parseLong((String)customParams.get("deliveryBillId"));
        long deliveryEntryId = Long.parseLong((String)customParams.get("deliveryEntryId"));
        List snIdList = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"StockService", (String)"getDeliverySerialList", (Object[])new Object[]{deliveryBillId, deliveryEntryId});
        QFilter filter = new QFilter("id", "in", (Object)CollectionUtil.convertToLong((Collection)snIdList));
        filter.and("snstatus", "in", (Object)new String[]{SnStatusEnum.ONWAY.getValue(), SnStatusEnum.CHANNELOUTSTOCK.getValue()});
        return QueryServiceHelper.query((String)"ococic_snmainfile", (String)"id,number,itemid.name", (QFilter[])filter.toArray());
    }
}

