/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.order;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.status.SaleOrderStatus;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class ValetOrderMobList
extends OcdmaFormMobPlugin
implements TabSelectListener,
MobileSearchTextChangeListener,
ListRowClickListener {
    private static final String SEARCHAP = "searchap";
    private static final String BILLLISTAP = "billlistap";
    private static final String TABAP = "tabap";
    private static final String TAB_ALL = "tab_all";
    private static final String TAB_AUDIT = "tab_audit";
    private static final String TAB_UNAUDIT = "tab_unaudit";
    private static final String TAB_DELIVERY = "tab_delivery";
    private static final String OP_AUDIT = "audit";
    private static final String OP_UNAUDIT = "unaudit";
    private static final String OP_BIZCLOSE = "bizclose";
    private static final String OP_CONFIRMDELIVERY = "confirmdelivery";
    private static final String OP_UNSUBMIT = "unsubmit";

    public void registerListener(EventObject e) {
        this.addTabSelectListener(this, new String[]{TABAP});
        MobileSearch search = (MobileSearch)this.getControl(SEARCHAP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getControl(TABAP);
        tab.selectTab(TAB_ALL);
        tab.activeTab(TAB_ALL);
        this.refreshBillList();
        super.afterCreateNewData(e);
    }

    public void click(MobileSearchTextChangeEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "searchap": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getListFilter()});
    }

    private QFilter getListFilter() {
        QFilter filter = new QFilter("supplyrelation", "=", (Object)ChannelSupplyRelation.SUPPLY_CHANNEL.getValue());
        filter.and("salechannelid", "=", (Object)B2BUserHelper.getLoginChannelId());
        Tab tab = (Tab)this.getControl(TABAP);
        String curTab = tab.getCurrentTab();
        if (TAB_ALL.equals(curTab)) {
            filter.and("billstatus", "in", Arrays.asList(SaleOrderStatus.SUBMIT.getValue(), SaleOrderStatus.AUDIT.getValue(), SaleOrderStatus.PART_DELIVERY.getValue(), SaleOrderStatus.ALL_DELIVERY.getValue(), SaleOrderStatus.COMPLETED.getValue()));
        } else if (TAB_AUDIT.equals(curTab)) {
            filter.and("billstatus", "=", (Object)SaleOrderStatus.SUBMIT.getValue());
        } else if (TAB_UNAUDIT.equals(curTab)) {
            filter.and("billstatus", "=", (Object)SaleOrderStatus.AUDIT.getValue());
        } else if (TAB_DELIVERY.equals(curTab)) {
            filter.and("billstatus", "in", Arrays.asList(SaleOrderStatus.AUDIT.getValue(), SaleOrderStatus.PART_DELIVERY.getValue()));
        }
        MobileSearch search = (MobileSearch)this.getControl(SEARCHAP);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno"}));
        }
        return filter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "confirmdelivery": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                String selectProperties = String.join((CharSequence)",", "id", "billno", "billtypeid");
                QFilter filter = new QFilter("id", "=", pkId);
                DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"ocbsoc_saleorder", (String)selectProperties, (QFilter[])filter.toArray());
                if (data.getLong("billtypeid_id") != 1415086868680214528L) break;
                String billNo = data.getString("billno");
                this.getView().showErrorNotification(String.format("\u8ba2\u5355\uff1a%s\u6e20\u9053\u76f4\u9001\u8ba2\u5355\u4e0d\u80fd\u786e\u8ba4\u53d1\u8d27\uff0c\u8bf7\u68c0\u67e5\u3002", billNo));
                evt.setCancel(true);
                return;
            }
        }
        super.beforeDoOperation(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "audit": 
            case "unaudit": 
            case "unsubmit": 
            case "bizclose": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                Object id = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                OperateOption operateOption = CommonUtils.getOperateOption();
                OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)"ocbsoc_saleorder", (Object[])new Object[]{id}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                this.refreshBillList();
                break;
            }
            case "confirmdelivery": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileFormShowParameter.setFormId("ocdma_channeloutbill_add");
                mobileFormShowParameter.setStatus(OperationStatus.ADDNEW);
                mobileFormShowParameter.setCustomParam("orderid", (Object)pkId.toString());
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_CONFIRMDELIVERY));
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
        }
        super.afterDoOperation(args);
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId("ocdma_saleorder_view");
        mobileFormShowParameter.setStatus(OperationStatus.VIEW);
        mobileFormShowParameter.setCustomParam("orderId", pkId);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocdma_saleorder_view"));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        super.listRowClick(evt);
    }
}

