/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.payment;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocdma.business.channel.ChannelAuthHelper;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class MoneyIncomeBillPlugin
extends OcdmaFormMobPlugin
implements BeforeF7SelectListener {
    private static final String btn_save = "btn_save";
    private static final String btn_submit = "btn_submit";
    private static final String btn_close = "btn_close";
    private static final String btn_payaccount = "btn_payaccount";
    private static final Log log = LogFactory.getLog(MoneyIncomeBillPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!this.isView()) {
            this.addClickListeners(new String[]{btn_save, btn_submit, btn_close, btn_payaccount});
            this.addF7Listener(this, new String[]{"paychannelid", "moneytypeid", "recaccountid"});
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        if (customParams.get("id") != null) {
            long id = Long.parseLong(customParams.get("id").toString());
            this.getModel().setValue("id", (Object)id);
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)"occba_moneyincome");
            this.getModel().setValue("billno", (Object)data.getString("billno"));
            this.getModel().setValue("pooltype", (Object)data.getString("pooltype"));
            this.getModel().setValue("billdate", (Object)data.getDate("billdate"));
            this.getModel().setValue("moneytypeid", data.get("moneytypeid"));
            this.getModel().setValue("paytype", data.get("paytype"));
            this.getModel().setValue("billstatus", data.get("billstatus"));
            this.getModel().setValue("currencyid", data.get("currencyid"));
            this.getModel().setValue("sumrecamount", data.get("sumrecamount"));
            this.getModel().setValue("remark", data.get("remark"));
            this.getModel().setValue("moneyorgid", data.get("moneyorgid"));
            this.getModel().setValue("receivechannel", data.get("receivechannel"));
            this.getModel().setValue("recaccount", data.get("recaccount"));
            this.getModel().setValue("recaccountid", data.get("recaccountid"));
            this.getModel().setValue("recbank", data.get("recbank"));
            this.getModel().setValue("paychannelid", data.get("paychannelid"));
            this.getModel().setValue("payaccount", data.get("payaccount"));
            this.getModel().setValue("paybank", data.get("paybank"));
            this.getModel().setValue("moneyaccountid", data.get("moneyaccountid"));
            this.getModel().setValue("datasources", data.get("datasources"));
            this.getModel().setValue("paycustomerid", data.get("paycustomerid"));
            MobExtendHelper.loadMobExtend((IDataModel)this.getModel(), (String)this.getView().getEntityId(), (DynamicObject)data, (String)"occba_moneyincome");
            QFilter filter = new QFilter("id", "=", (Object)id);
            DynamicObject[] entryDatas = BusinessDataServiceHelper.load((String)"occba_moneyincome", (String)String.join((CharSequence)",", "entryentity.id", "entryentity.settleorgid", "entryentity.settlechannel", "entryentity.recamount"), (QFilter[])filter.toArray());
            if (entryDatas != null) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                entryEntity.clear();
                for (DynamicObject entry : entryDatas[0].getDynamicObjectCollection("entryentity")) {
                    DynamicObject row = entryEntity.addNew();
                    row.set("id", (Object)entry.getLong("id"));
                    row.set("settleorgid", entry.get("settleorgid"));
                    row.set("settlechannel", entry.get("settlechannel"));
                    row.set("recamount", (Object)entry.getBigDecimal("recamount"));
                    MobExtendHelper.setOrmExtToMobExt((DynamicObject)row, (DynamicObject)entry, (String)this.getView().getEntityId(), (String)"occba_moneyincome");
                }
            }
            if (Status.SAVED.toString().equals(data.getString("billstatus"))) {
                this.setPoolType();
            }
        }
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        try {
            String number = CodeRuleUtil.getCodeRule((String)"occba_moneyincome");
            if (StringUtils.isNotEmpty((String)number)) {
                this.getModel().setValue("billno", (Object)number);
            }
        }
        catch (Exception e1) {
            log.error((Throwable)e1);
        }
        this.getModel().setValue("moneytypeid", (Object)1176015964144286720L);
        this.getModel().setValue("datasources", (Object)3);
        this.getModel().setValue("billdate", (Object)DateUtil.getDayFirst((Date)new Date()));
        this.getModel().setValue("billstatus", (Object)"A");
        this.getModel().setValue("moneyaccountid", (Object)1176015964144286720L);
        long currentChannelId = B2BUserHelper.getLoginChannelId();
        if (currentChannelId != 0L) {
            this.getModel().setValue("paychannelid", (Object)currentChannelId);
            DynamicObject channel = BusinessDataServiceHelper.loadSingle((Object)currentChannelId, (String)"ocdbd_channel");
            if (channel != null) {
                this.getModel().setValue("currencyid", (Object)channel.getDynamicObject("currency"));
                this.getModel().setValue("paycustomerid", (Object)channel.getDynamicObject("customer"));
                if (channel.getDynamicObject("customer") != null) {
                    String payaccount = "";
                    String paybank = "";
                    DynamicObject customerDynObj = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (String)String.join((CharSequence)",", "bankaccount", "accountname", "bank", "currency", "isdefault_bank"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)channel.getLong("customer_id"))});
                    DynamicObjectCollection entryBanks = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)customerDynObj, (String)"entry_bank");
                    for (DynamicObject bank : entryBanks) {
                        if (bank.getBoolean("isdefault_bank")) {
                            payaccount = bank.getString("bankaccount");
                            paybank = bank.getString("bank.name");
                            break;
                        }
                        if (!StringUtils.isEmpty((String)payaccount) || !StringUtils.isEmpty((String)paybank)) continue;
                        payaccount = bank.getString("bankaccount");
                        paybank = bank.getString("bank.name");
                    }
                    this.getModel().setValue("payaccount", (Object)payaccount);
                    this.getModel().setValue("paybank", (Object)paybank);
                }
            }
        }
        this.getModel().setValue("moneytypeid", (Object)1174603728347505664L);
        this.setPoolType();
        DynamicObjectCollection entryEntry = this.getModel().getEntryEntity("entryentity");
        entryEntry.addNew();
        if ("A".equals(this.getModel().getValue("pooltype"))) {
            DynamicObjectCollection channelAuth = ChannelAuthHelper.getChannelAuthOrgByOrderChannel((long)currentChannelId);
            long backRollOrg = 0L;
            if (channelAuth != null) {
                Long orgId;
                Set orgIds = channelAuth.stream().map(r -> r.getLong("saleorg")).collect(Collectors.toSet());
                Iterator iterator = orgIds.iterator();
                while (iterator.hasNext() && (backRollOrg = this.getSuperiorOrg(orgId = (Long)iterator.next())) == 0L) {
                }
                if (backRollOrg != 0L) {
                    this.getModel().setValue("moneyorgid", (Object)backRollOrg);
                }
            }
            this.getModel().setValue("settleorgid", (Object)backRollOrg, 0);
        } else {
            this.getModel().setValue("settlechannel", this.getModel().getValue("receivechannel"), 0);
        }
        super.afterCreateNewData(e);
    }

    private void setPoolType() {
        DynamicObject payChannel = (DynamicObject)this.getModel().getValue("paychannelid");
        String channelProperty = "";
        if (payChannel != null) {
            channelProperty = payChannel.getString("channelproperty");
        }
        switch (channelProperty) {
            case "A": {
                this.getModel().setValue("pooltype", (Object)"A");
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"pooltype"});
                break;
            }
            case "B": {
                this.getModel().setValue("pooltype", (Object)"B");
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"pooltype"});
                break;
            }
            case "C": {
                this.getModel().setValue("pooltype", (Object)"A");
                break;
            }
            default: {
                this.getModel().setValue("pooltype", (Object)"A");
            }
        }
    }

    private long getSuperiorOrg(long orgId) {
        if (orgId == 0L) {
            return 0L;
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"level", (QFilter[])filter.toArray());
        filter = new QFilter("org", "=", (Object)orgId);
        filter = filter.and(new QFilter("level", "=", (Object)orgDyn.getInt("level")));
        filter = filter.and(new QFilter("view", "=", (Object)1L));
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)String.join((CharSequence)",", "parent", "parent.fisbankroll", "org.fisbankroll"), (QFilter[])filter.toArray());
        if (org == null) {
            return 0L;
        }
        if (org.getBoolean("org.fisbankroll")) {
            return orgId;
        }
        if (org.getBoolean("parent.fisbankroll")) {
            return org.getLong("parent");
        }
        return this.getSuperiorOrg(org.getLong("parent"));
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getDataEntity().getLong("id") == 0L) {
            long currentChannelId = B2BUserHelper.getLoginChannelId();
            this.getModel().setValue("paychannelid", (Object)currentChannelId);
        }
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "paychannelid": {
                DynamicObject paychannel = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (paychannel != null) {
                    this.getModel().setValue("currencyid", (Object)paychannel.getDynamicObject("currency"));
                    this.getModel().setValue("paycustomerid", (Object)paychannel.getDynamicObject("customer"));
                    break;
                }
                this.getModel().setValue("currencyid", null);
                this.getModel().setValue("paycustomerid", null);
                break;
            }
            case "sumrecamount": {
                BigDecimal sumamount = (BigDecimal)e.getChangeSet()[0].getNewValue();
                DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("entryentity");
                if (entryDatas == null || entryDatas.size() <= 0) break;
                BigDecimal recamount = sumamount.divide(new BigDecimal(entryDatas.size()), 2, RoundingMode.HALF_UP);
                AtomicInteger index = new AtomicInteger();
                for (DynamicObject entryData : entryDatas) {
                    int rowId = index.getAndIncrement();
                    if (entryDatas.size() > 2 && entryDatas.size() == rowId + 1) {
                        this.getModel().setValue("recamount", (Object)sumamount.subtract(recamount.multiply(new BigDecimal(rowId))), rowId);
                    }
                    this.getModel().setValue("recamount", (Object)recamount, rowId);
                }
                break;
            }
            case "recaccountid": {
                DynamicObject recaccountId = (DynamicObject)e.getChangeSet()[0].getNewValue();
                String recaccount = "";
                String recbank = "";
                if (recaccountId != null) {
                    recaccount = recaccountId.getString("bankaccountnumber");
                    recbank = recaccountId.getString("bank.name");
                }
                this.getModel().setValue("recbank", (Object)recbank);
                this.getModel().setValue("recaccount", (Object)recaccount);
                break;
            }
            case "receivechannel": {
                this.getModel().setValue("settlechannel", this.getModel().getValue("receivechannel"), 0);
                break;
            }
            case "moneyorgid": {
                this.getModel().setValue("settleorgid", this.getModel().getValue("moneyorgid"), 0);
                break;
            }
        }
        super.propertyChanged(e);
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_save": 
            case "btn_submit": {
                long id = this.getModel().getDataEntity().getLong("id");
                DynamicObject newData = null;
                newData = id > 0L ? BusinessDataServiceHelper.loadSingle((Object)id, (String)"occba_moneyincome_b2b") : BusinessDataServiceHelper.newDynamicObject((String)"occba_moneyincome_b2b");
                boolean isSuccess = this.saveNewData(newData);
                if (isSuccess && btn_save.equals(key)) {
                    this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
                    return;
                }
                if (!btn_submit.equals(key)) break;
                try {
                    OperationResult result = OperationUtil.invokeOperation((DynamicObject[])new DynamicObject[]{newData}, (String)"submit", (OperateOption)CommonUtils.getOperateOption());
                    if (!result.isSuccess()) break;
                    this.getView().showSuccessNotification("\u63d0\u4ea4\u6210\u529f");
                    this.getModel().setValue("billstatus", (Object)"B");
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                }
                break;
            }
            case "btn_close": {
                MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
                mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileBillShowParameter.setFormId("ocdma_amountindex");
                mobileBillShowParameter.setCustomParam("view", (Object)"paymenthistory");
                this.getView().showForm((FormShowParameter)mobileBillShowParameter);
                break;
            }
            case "btn_payaccount": {
                this.showCustomerBankInfoF7();
                break;
            }
        }
        super.click(evt);
    }

    private void showCustomerBankInfoF7() {
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_selectpayaccount");
        long customerid = (Long)this.getModel().getValue("paycustomerid_id");
        mobileBillShowParameter.setCustomParam("customerid", (Object)(customerid + ""));
        mobileBillShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectpayacount"));
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "selectpayacount": {
                Object payacountid = closedCallBackEvent.getReturnData();
                if (payacountid == null) break;
                long payacountId = Long.parseLong(payacountid.toString());
                QFilter filter = new QFilter("entry_bank.id", "=", (Object)payacountId);
                DynamicObject customerDynObj = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (String)String.join((CharSequence)",", "bankaccount", "accountname", "bank", "currency", "isdefault_bank"), (QFilter[])filter.toArray());
                DynamicObjectCollection entryBanks = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)customerDynObj, (String)"entry_bank");
                String payaccount = "";
                String paybank = "";
                if (entryBanks != null && entryBanks.size() > 0) {
                    for (DynamicObject bank : entryBanks) {
                        if (bank.getLong("id") != payacountId) continue;
                        payaccount = bank.getString("bankaccount");
                        paybank = bank.getString("bank.name");
                        break;
                    }
                }
                this.getModel().setValue("payaccount", (Object)payaccount);
                this.getModel().setValue("paybank", (Object)paybank);
                this.getModel().setValue("payaccountid", payacountid);
                break;
            }
        }
    }

    private boolean saveNewData(DynamicObject newData) {
        String checkMsg;
        newData.set("billno", this.getModel().getValue("billno"));
        newData.set("pooltype", this.getModel().getValue("pooltype"));
        newData.set("moneyorgid", this.getModel().getValue("moneyorgid"));
        newData.set("receivechannel", this.getModel().getValue("receivechannel"));
        newData.set("moneytypeid", this.getModel().getValue("moneytypeid"));
        newData.set("billdate", this.getModel().getValue("billdate"));
        newData.set("paytype", this.getModel().getValue("paytype"));
        newData.set("billstatus", this.getModel().getValue("billstatus"));
        newData.set("moneyaccountid", this.getModel().getValue("moneyaccountid"));
        newData.set("datasources", this.getModel().getValue("datasources"));
        newData.set("remark", this.getModel().getValue("remark"));
        newData.set("paychannelid", this.getModel().getValue("paychannelid"));
        newData.set("payaccount", this.getModel().getValue("payaccount"));
        newData.set("paybank", this.getModel().getValue("paybank"));
        newData.set("paycustomerid", this.getModel().getValue("paycustomerid"));
        newData.set("recaccountid", this.getModel().getValue("recaccountid"));
        newData.set("recaccount", this.getModel().getValue("recaccount"));
        newData.set("recbank", this.getModel().getValue("recbank"));
        newData.set("currencyid", this.getModel().getValue("currencyid"));
        newData.set("sumrecamount", this.getModel().getValue("sumrecamount"));
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)newData, (String)this.getView().getEntityId(), (String)"occba_moneyincome");
        DynamicObjectCollection newEntryList = newData.getDynamicObjectCollection("entryentity");
        HashMap<Long, Integer> idSeqMap = new HashMap<Long, Integer>();
        if (newEntryList != null) {
            AtomicInteger index = new AtomicInteger(0);
            for (Object entry : newEntryList) {
                idSeqMap.put(entry.getLong("id"), index.getAndIncrement());
            }
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            if (entryList != null) {
                for (DynamicObject entry : entryList) {
                    if (idSeqMap.containsKey(entry.getLong("id"))) {
                        ((DynamicObject)newEntryList.get(((Integer)idSeqMap.get(entry.getLong("id"))).intValue())).set("settleorgid", entry.get("settleorgid"));
                        ((DynamicObject)newEntryList.get(((Integer)idSeqMap.get(entry.getLong("id"))).intValue())).set("settlechannel", entry.get("settlechannel"));
                        ((DynamicObject)newEntryList.get(((Integer)idSeqMap.get(entry.getLong("id"))).intValue())).set("recamount", entry.get("recamount"));
                        MobExtendHelper.setMobExtToOrmExt((DynamicObject)entry, (DynamicObject)((DynamicObject)newEntryList.get(((Integer)idSeqMap.get(entry.getLong("id"))).intValue())), (String)this.getView().getEntityId(), (String)"occba_moneyincome");
                        continue;
                    }
                    DynamicObject newEntry = newEntryList.addNew();
                    newEntry.set("settleorgid", entry.get("settleorgid"));
                    newEntry.set("recamount", entry.get("recamount"));
                    newEntry.set("settlechannel", entry.get("settlechannel"));
                    MobExtendHelper.setMobExtToOrmExt((DynamicObject)entry, (DynamicObject)newEntry, (String)this.getView().getEntityId(), (String)"occba_moneyincome");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(checkMsg = this.checkSaveData(newData)))) {
            this.getView().showTipNotification(checkMsg);
            return false;
        }
        try {
            OperationResult result = OperationUtil.invokeOperation((DynamicObject[])new DynamicObject[]{newData}, (String)"save", (OperateOption)CommonUtils.getOperateOption());
            if (result.isSuccess()) {
                this.getModel().setValue("id", newData.get("id"));
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                AtomicInteger rowIndex = new AtomicInteger(0);
                for (DynamicObject entry : newData.getDynamicObjectCollection("entryentity")) {
                    int rowId = rowIndex.getAndIncrement();
                    this.getModel().setValue("entryentity.id", (Object)entry.getLong("id"), rowId);
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            return false;
        }
        return true;
    }

    private String checkSaveData(DynamicObject newData) {
        if (newData == null) {
            return "";
        }
        if (BigDecimal.ZERO.compareTo(newData.getBigDecimal("sumrecamount")) >= 0) {
            return "\u4ed8\u6b3e\u603b\u989d\u4e0d\u80fd\u4e3a0";
        }
        return "";
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "recaccountid": {
                long moneyorgid = (Long)this.getModel().getValue("moneyorgid_id");
                QFilter filter = new QFilter("company", "=", (Object)moneyorgid);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
        }
    }
}

