/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.payment;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class PaymentHistoryListPlugin
extends OcbaseFormMobPlugin
implements TabSelectListener,
ListRowClickListener,
MobileSearchTextChangeListener {
    private static final String btn_edit = "btn_edit";
    private static final String btn_delete = "btn_delete";
    private static final String btn_submit = "btn_submit";
    private static final String btn_unsubmit = "btn_unsubmit";
    private static final String SEARCH_AP = "search";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btn_edit, btn_delete, btn_submit, btn_unsubmit});
        this.addTabSelectListener(this, new String[]{"tabap"});
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH_AP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void click(MobileSearchTextChangeEvent arg0) {
        this.serach();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String key;
        switch (key = ((Control)tabSelectEvent.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                BillList billList = (BillList)this.getControl("billlistap");
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getFilter()});
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getFilter()});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "enddate": 
            case "startdate": 
            case "daterange": {
                BillList billList = (BillList)this.getControl("billlistap");
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getFilter()});
                break;
            }
        }
    }

    private void serach() {
        BillList billList = (BillList)this.getControl("billlistap");
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getFilter()});
    }

    private QFilter getFilter() {
        Date endDate;
        Tab tab = (Tab)this.getControl("tabap");
        String curTabKey = tab.getCurrentTab();
        QFilter filter = null;
        long payChannelId = B2BUserHelper.getLoginChannelId();
        filter = new QFilter(String.join((CharSequence)".", "paychannelid", "id"), "=", (Object)payChannelId);
        MobileSearch search = (MobileSearch)this.getControl(SEARCH_AP);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"moneyorgid.name"}));
        }
        switch (curTabKey) {
            case "today": {
                filter.and("billdate", ">=", (Object)DateUtil.getCurrentDate((DateUtil.DateResetType)DateUtil.DateResetType.min));
                filter.and("billdate", "<=", (Object)DateUtil.getCurrentDate((DateUtil.DateResetType)DateUtil.DateResetType.max));
                break;
            }
            case "thisweek": {
                filter.and("billdate", ">=", (Object)DateUtil.getFirstDayOfWeek());
                filter.and("billdate", "<=", (Object)DateUtil.getLastDayOfWeek((DateUtil.DateResetType)DateUtil.DateResetType.max));
                break;
            }
            case "thismooth": {
                filter.and("billdate", ">=", (Object)DateUtil.getFirstDayOfMonth());
                filter.and("billdate", "<=", (Object)DateUtil.getLastDayOfMonth((DateUtil.DateResetType)DateUtil.DateResetType.max));
            }
        }
        Date startDate = (Date)this.getValue("startdate");
        if (startDate != null) {
            filter.and("billdate", ">=", (Object)startDate);
        }
        if ((endDate = (Date)this.getValue("enddate")) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            endDate = cal.getTime();
            filter.and("billdate", "<=", (Object)endDate);
        }
        filter.and("datasources", "=", (Object)"3");
        return filter;
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_edit": {
                BillList billList = (BillList)this.getControl("billlistap");
                Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
                mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileBillShowParameter.setFormId("ocdma_moneyincome");
                mobileBillShowParameter.setCustomParam("id", (Object)pkId.toString());
                this.getView().showForm((FormShowParameter)mobileBillShowParameter);
                break;
            }
            case "btn_delete": {
                try {
                    BillList billList = (BillList)this.getControl("billlistap");
                    Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                    DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"occba_moneyincome");
                    OperationResult result = OperationUtil.invokeOperation((DynamicObject)data, (String)"delete");
                    if (result.isSuccess()) {
                        this.getView().showTipNotification("\u5220\u9664\u6210\u529f");
                        this.getView().updateView();
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                    return;
                }
            }
            case "btn_submit": {
                try {
                    BillList billList = (BillList)this.getControl("billlistap");
                    Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                    DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"occba_moneyincome_b2b");
                    OperationResult result = OperationUtil.invokeOperation((DynamicObject)data, (String)"submit");
                    if (result.isSuccess()) {
                        this.getView().showTipNotification("\u63d0\u4ea4\u6210\u529f");
                        this.getView().updateView();
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                    return;
                }
            }
            case "btn_unsubmit": {
                try {
                    BillList billList = (BillList)this.getControl("billlistap");
                    Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                    DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"occba_moneyincome");
                    OperationResult result = OperationUtil.invokeOperation((DynamicObject)data, (String)"unsubmit");
                    if (result.isSuccess()) {
                        this.getView().showTipNotification("\u64a4\u9500\u6210\u529f");
                        this.getView().updateView();
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                    return;
                }
            }
        }
        super.click(evt);
    }
}

