/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.rebate;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class RebateBalanceList
extends OcdmaFormMobPlugin {
    public static final String OCSAA_CHANNEL = "ocsaa_channel";
    private static final String selectField = String.join((CharSequence)",", "id", "receivechannel", "receivechannel.name", "type", "customer", "channel", "accounttype", "org", "org.name", "setcurrency", "balance", "occupyamount", "availablebalance", "updatedatetime");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"incentivebalance", "prepaymentbalance", "costbalance", "buttona", "buttonb", "buttonc"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long channelId = this.getChannelId();
        this.setAccountList("A", channelId, 1);
        this.setAccountList("C", channelId, 2);
        this.setAccountList("B", channelId, 3);
    }

    private long getChannelId() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String cacheChannelId = parentPageCache.get("channelId");
        long channelId = cacheChannelId != null ? Long.parseLong(cacheChannelId) : B2BUserHelper.getLoginChannelId();
        return channelId;
    }

    public void click(EventObject evt) {
        String button;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (button = control.getKey()) {
            case "incentivebalance": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountlist2"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountlist3"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountlist1"});
                break;
            }
            case "prepaymentbalance": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountlist1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountlist3"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountlist2"});
                break;
            }
            case "costbalance": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountlist1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountlist2"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountlist3"});
                break;
            }
            case "buttona": {
                this.jumpToFlowRecord(1);
                break;
            }
            case "buttonb": {
                this.jumpToFlowRecord(2);
                break;
            }
            case "buttonc": {
                this.jumpToFlowRecord(3);
                break;
            }
        }
    }

    private void jumpToFlowRecord(int tableIndex) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("accountlist" + tableIndex);
        DynamicObject data = this.getModel().getEntryRowEntity("accountlist" + tableIndex, rowIndex);
        long channelId = data.getLong("channel" + tableIndex + "." + "id");
        long orgId = data.getLong("org" + tableIndex + "." + "id");
        long receiveChannelId = data.getLong("receivechannel" + tableIndex + "." + "id");
        long accountTypeId = data.getLong("accounttype" + tableIndex + "." + "id");
        long customerId = data.getLong("customer" + tableIndex + "." + "id");
        String type = data.getString("type" + tableIndex);
        MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setFormId("ocdma_flowrecord");
        mobileBillShowParameter.setCustomParam("channelid", (Object)(channelId + ""));
        mobileBillShowParameter.setCustomParam("orgid", (Object)(orgId + ""));
        mobileBillShowParameter.setCustomParam("receivechannelid", (Object)(receiveChannelId + ""));
        mobileBillShowParameter.setCustomParam("accounttypeid", (Object)(accountTypeId + ""));
        mobileBillShowParameter.setCustomParam("customerid", (Object)(customerId + ""));
        mobileBillShowParameter.setCustomParam("type", (Object)(StringUtils.isNotNull((String)type) ? type : "A"));
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    private void setAccountList(String accountType, long channelId, int i) {
        int[] indexes;
        QFilter qFilter = new QFilter("accounttype.accounttype", "=", (Object)accountType);
        qFilter.and(new QFilter("channel", "=", (Object)channelId));
        DynamicObjectCollection dynamicCollection = QueryServiceHelper.query((String)"ocdbd_rebateaccount", (String)selectField, (QFilter[])qFilter.toArray(), (String)"updatedatetime desc");
        IDataModel model = this.getModel();
        model.deleteEntryData("accountlist" + i);
        if (dynamicCollection.isEmpty()) {
            return;
        }
        for (int index : indexes = model.batchCreateNewEntryRow("accountlist" + i, dynamicCollection.size())) {
            DynamicObject acountInfo = (DynamicObject)dynamicCollection.get(index);
            if ("B".equals(acountInfo.getString("type"))) {
                model.setValue("supplier" + i, (Object)acountInfo.getString("receivechannel.name"), index);
            } else {
                model.setValue("supplier" + i, (Object)acountInfo.getString("org.name"), index);
            }
            model.setValue("channel" + i, (Object)acountInfo.getLong("channel"), index);
            model.setValue("org" + i, (Object)acountInfo.getLong("org"), index);
            model.setValue("receivechannel" + i, (Object)acountInfo.getLong("receivechannel"), index);
            model.setValue("customer" + i, (Object)acountInfo.getLong("customer"), index);
            model.setValue("accounttype" + i, (Object)acountInfo.getLong("accounttype"), index);
            model.setValue("type" + i, (Object)acountInfo.getString("type"), index);
            model.setValue("setcurrency" + i, (Object)acountInfo.getLong("setcurrency"), index);
            model.setValue("availablebalance" + i, (Object)acountInfo.getBigDecimal("availablebalance"), index);
            model.setValue("balance" + i, (Object)acountInfo.getBigDecimal("balance"), index);
            model.setValue("occupyamount" + i, (Object)acountInfo.getBigDecimal("occupyamount"), index);
        }
    }
}

