/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.rebate;

import java.util.Date;
import java.util.EventObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.business.helper.BillViewHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class RebateFlowList
extends OcdmaFormMobPlugin {
    private static final String enddate = "enddate";
    private static final String startdate = "startdate";
    private static final String incentivelist = "incentivelist";

    public void initialize() {
        super.initialize();
        BillViewHelper.setisVirtualLoad((IFormView)this.getView(), (String)incentivelist);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"back"});
    }

    public void beforeBindData(EventObject e) {
        BillList incentiveList = (BillList)this.getControl(incentivelist);
        MobileControlUtils.setFilter((BillList)incentiveList, (QFilter[])new QFilter[]{this.getCustomerFilter()});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "enddate": 
            case "startdate": {
                BillList incentiveList = (BillList)this.getControl(incentivelist);
                MobileControlUtils.BillListRefresh((BillList)incentiveList, (QFilter[])new QFilter[]{this.getCustomerFilter()});
                break;
            }
        }
        super.propertyChanged(e);
    }

    private QFilter getCustomerFilter() {
        long channelId = this.getLongCustomParam("channelid");
        long accountTypeId = this.getLongCustomParam("accounttypeid");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        long orgId = this.getLongCustomParam("orgid");
        long receiveChannelId = this.getLongCustomParam("receivechannelid");
        long customerId = this.getLongCustomParam("customerid");
        QFilter filter = new QFilter("channel", "=", (Object)channelId);
        filter.and("accout", "=", (Object)accountTypeId);
        filter.and("customer", "=", (Object)customerId);
        if ("A".equals(type)) {
            filter.and("org", "=", (Object)orgId);
        } else if ("B".equals(type)) {
            filter.and("receivechannel", "=", (Object)receiveChannelId);
        }
        Date startDate = (Date)this.getValue(startdate);
        Date endDate = (Date)this.getValue(enddate);
        if (startDate != null && endDate != null) {
            filter.and("createtime", ">=", (Object)DateUtil.getDayFirst((Date)startDate));
            filter.and("createtime", "<=", (Object)DateUtil.getDayLast((Date)endDate));
        }
        return filter;
    }

    private long getLongCustomParam(String param) {
        String paramStr = (String)this.getView().getFormShowParameter().getCustomParam(param);
        if (StringUtils.isNotNull((String)paramStr)) {
            return Long.parseLong(paramStr);
        }
        return 0L;
    }
}

