/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.salesvolume;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class SaleVolumeAnalysisRpt
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener {
    private static final String OP_ITEMSEARCH = "itemsearch";
    private static final String KEY_CHANNEL = "channel";
    private static final String KEY_UNDERCHANNEL = "underchannel";
    private static final String KEY_ISALLCHANNEL = "isallchannel";
    private static final String BTNCLOSE = "btnclose";
    private static final String SUMMODE = "summode";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery"});
        this.addF7Listener(this, new String[]{KEY_CHANNEL, KEY_UNDERCHANNEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formid = this.getView().getParentView().getFormShowParameter().getFormId();
        if ("ocsaa_home".equals(formid) || "ocsaa_business".equals(formid)) {
            this.getModel().setValue(KEY_ISALLCHANNEL, (Object)true);
        }
        long channelId = this.getChannelId();
        this.setValue(KEY_CHANNEL, new Long[]{channelId});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channel": 
            case "underchannel": {
                List channelIdList = CUserHelper.getAuthorizedChannelIdList();
                QFilter qFilter = new QFilter("id", "in", (Object)channelIdList);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channel": {
                Object channel = e.getChangeSet()[0].getNewValue();
                if (channel == null) break;
                this.getModel().beginInit();
                this.setValue(KEY_UNDERCHANNEL, null);
                this.getModel().endInit();
                this.getView().updateView(KEY_UNDERCHANNEL);
                break;
            }
            case "underchannel": {
                Object underchannel = e.getChangeSet()[0].getNewValue();
                if (underchannel == null) break;
                this.getModel().beginInit();
                this.setValue(KEY_CHANNEL, null);
                this.setValue(KEY_ISALLCHANNEL, false);
                this.getModel().endInit();
                this.getView().updateView(KEY_CHANNEL);
                this.getView().updateView(KEY_ISALLCHANNEL);
                break;
            }
            case "isallchannel": {
                Boolean isallchannel = (Boolean)e.getChangeSet()[0].getNewValue();
                if (!isallchannel.booleanValue()) break;
                this.getModel().beginInit();
                this.setValue(KEY_UNDERCHANNEL, null);
                this.getModel().endInit();
                this.getView().updateView(KEY_UNDERCHANNEL);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String button;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (button = control.getKey()) {
            case "btnquery": {
                this.setItemList();
                break;
            }
        }
    }

    private void setItemList() {
        int[] indexes;
        QFilter filter;
        List channelIdList = null;
        Object channels = this.getModel().getValue(KEY_CHANNEL);
        Object ounderchannel = this.getModel().getValue(KEY_UNDERCHANNEL);
        boolean isallchannel = (Boolean)this.getModel().getValue(KEY_ISALLCHANNEL);
        if (isallchannel) {
            channelIdList = CUserHelper.getAuthorizedChannelIdList();
        } else if (!ObjectUtils.isEmpty((Object)ounderchannel)) {
            DynamicObject underchannel = (DynamicObject)ounderchannel;
            filter = new QFilter("longid", "like", (Object)(underchannel.getString("longid") + ".%"));
            List underchannelIdList = QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_channel", (QFilter[])filter.toArray(), null, (int)-1);
            channelIdList = underchannelIdList.stream().map(r -> (Long)r).collect(Collectors.toList());
        } else if (channels instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection mulChannels = (MulBasedataDynamicObjectCollection)channels;
            channelIdList = mulChannels.stream().map(k -> (Long)((DynamicObject)k.get("fbasedataid")).getPkValue()).collect(Collectors.toList());
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("itemlist");
        if (channelIdList == null || channelIdList.size() == 0) {
            return;
        }
        filter = new QFilter(KEY_CHANNEL, "in", channelIdList);
        filter.and("billstatus", "=", (Object)"C");
        this.setDateFilter(filter);
        String selectFields = String.join((CharSequence)",", KEY_CHANNEL, "currency", "entryentity.material", "entryentity.item", "entryentity.unit", "entryentity.qty", "entryentity.amount");
        DynamicObjectCollection saleVolumes = QueryServiceHelper.query((String)"occbo_salevolume", (String)selectFields, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)saleVolumes)) {
            return;
        }
        int rowSize = saleVolumes.size();
        ArrayList<Object> groupKeyResults = new ArrayList<Object>(rowSize);
        HashMap<String, DynamicObject> groupKeyResultMap = new HashMap<String, DynamicObject>(rowSize);
        String summode = String.valueOf(this.getModel().getValue(SUMMODE));
        String groupField = "entryentity.item";
        if (StringUtils.equals((CharSequence)summode, (CharSequence)"B")) {
            groupField = KEY_CHANNEL;
        }
        for (DynamicObject saleVolume : saleVolumes) {
            String groupKey = saleVolume.getString(groupField);
            DynamicObject mapSaleVolume = (DynamicObject)groupKeyResultMap.get(groupKey);
            if (mapSaleVolume == null) {
                groupKeyResults.add(saleVolume);
                groupKeyResultMap.put(groupKey, saleVolume);
                continue;
            }
            BigDecimal sumQty = mapSaleVolume.getBigDecimal("entryentity.qty").add(saleVolume.getBigDecimal("entryentity.qty"));
            BigDecimal sumAmount = mapSaleVolume.getBigDecimal("entryentity.amount").add(saleVolume.getBigDecimal("entryentity.amount"));
            mapSaleVolume.set("entryentity.qty", (Object)sumQty);
            mapSaleVolume.set("entryentity.amount", (Object)sumAmount);
        }
        BigDecimal sumqty = BigDecimal.ZERO;
        BigDecimal sumamount = BigDecimal.ZERO;
        int rowcount = groupKeyResults.size();
        groupKeyResults.sort(Comparator.comparing(r -> DynamicObjectUtils.getBigDecimal((DynamicObject)((DynamicObject)r), (String)"entryentity.amount")).reversed());
        for (int index : indexes = model.batchCreateNewEntryRow("itemlist", rowcount)) {
            DynamicObject groupKeyResult = (DynamicObject)groupKeyResults.get(index);
            long channelid = groupKeyResult.getLong(KEY_CHANNEL);
            long currencyid = groupKeyResult.getLong("currency");
            long itemid = groupKeyResult.getLong("entryentity.item");
            long materialid = groupKeyResult.getLong("entryentity.material");
            long unitid = groupKeyResult.getLong("entryentity.unit");
            BigDecimal qty = groupKeyResult.getBigDecimal("entryentity.qty");
            BigDecimal amount = groupKeyResult.getBigDecimal("entryentity.amount");
            sumqty = sumqty.add(qty);
            sumamount = sumamount.add(amount);
            model.setValue("rowseq", (Object)(index + 1), index);
            model.setValue("channelid", (Object)channelid, index);
            model.setValue("itemid", (Object)itemid, index);
            model.setValue("materialid", (Object)materialid, index);
            model.setValue("qty", (Object)qty, index);
            model.setValue("amount", (Object)amount, index);
            model.setValue("unitid", (Object)unitid, index);
            model.setValue("currencyid", (Object)currencyid, index);
            if (index == rowcount - 1) {
                model.setValue("islastrow", (Object)true, index);
                model.setValue("sumqty", (Object)sumqty, index);
                model.setValue("sumamount", (Object)sumamount, index);
                continue;
            }
            model.setValue("islastrow", (Object)false, index);
        }
    }

    private void setDateFilter(QFilter filter) {
        Object outbilldateSpan = this.getValue("bizdatespan");
        String selectDate = "F";
        if (!CommonUtils.isNull((Object)outbilldateSpan)) {
            selectDate = outbilldateSpan.toString();
        }
        Date startDate = (Date)this.getValue("startdate");
        Date endDate = (Date)this.getValue("enddate");
        if (StringUtils.equals((CharSequence)selectDate, (CharSequence)"H")) {
            if (startDate != null && endDate != null) {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)startDate));
                filter.and("bizdate", "<=", (Object)DateUtil.getDayLast((Date)endDate));
            } else {
                filter.and("1", "!=", (Object)1);
            }
            return;
        }
        switch (selectDate) {
            case "A": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(6L))));
                break;
            }
            case "B": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth()));
                break;
            }
            case "C": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(90L))));
                break;
            }
            case "D": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                break;
            }
            case "E": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                break;
            }
            case "G": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                break;
            }
            case "H": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                break;
            }
            default: {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getNowDate()));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getNowDate()));
            }
        }
    }

    private long getChannelId() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String cacheChannelId = parentPageCache.get("channelId");
        long channelId = cacheChannelId != null ? Long.parseLong(cacheChannelId) : B2BUserHelper.getLoginChannelId();
        return channelId;
    }
}

