/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.salesvolume;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.helper.saleorder.SaleOrderBusinessHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.helper.CSupplierHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocdma.formplugin.OcdmaFormMobPlugin;

public class SaleVolumeBillPlugin
extends OcdmaFormMobPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(SaleVolumeBillPlugin.class);
    private static final String KEY_BILLID = "billid";
    private static final String KEY_ENTRYID = "entryid";
    private static final String OP_SELITEM = "selitem";
    private static final String OP_SAVE = "save";
    private static final String OP_ONEBILL = "onebill";
    private static final String add = "add";
    private static final String reduce = "reduce";
    private static final String scanQRCode = "scanqrcode";
    private static final String wxScanQRCode = "wxscanqrcode";
    private static final String btn_serial = "btn_serial";
    private static final String KEY_mutexbillid = "mutexbillid";
    private static final String ISWX = "iswx";
    private static final String P_ocdbd_itemmobf7 = "ocdbd_itemmobf7";
    private static final String P_ocdma_scanqrcode_sn = "ocdma_scanqrcode_sn";
    private static final String fs_attachmentpanelap = "attachmentpanelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{add, reduce, scanQRCode, btn_serial});
        this.addF7Listener(this, "channel", "saleorg");
    }

    public void pageRelease(EventObject evt) {
        this.mutexBillRelease();
        super.pageRelease(evt);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isAddNew()) {
            this.createNewBill();
        } else if (this.isEdit()) {
            this.loadBillData(0L);
            long billId = CommonUtils.stringToLong((Object)this.getModel().getValue(KEY_BILLID));
            String billNo = CommonUtils.convertObjectToString((Object)this.getModel().getValue("billno"));
            boolean rlt = this.createDataMutex(billNo, billId);
            if (!rlt) {
                this.toBillList();
            } else {
                this.getView().getPageCache().put(KEY_mutexbillid, CommonUtils.convertObjectToString((Object)billId));
            }
        } else if (this.isView()) {
            this.loadBillData(0L);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean isWx = CommonUtils.isFromWeixin((String)RequestContext.get().getUserAgent());
        if (isWx) {
            this.setValue(ISWX, true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long billId = CommonUtils.stringToLong((Object)this.getParameter(KEY_BILLID));
        if (this.isEdit() && billId > 0L) {
            List attachments = AttachmentServiceHelper.getAttachments((String)"occbo_salevolume", (Object)billId, (String)"attachmentpanel");
            AttachmentPanel panel = (AttachmentPanel)this.getControl(fs_attachmentpanelap);
            panel.bindData(attachments);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName = evt.getProperty().getName();
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>(0);
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"channel")) {
            List channelIds = CUserHelper.getAuthorizedChannelIdList();
            QFilter qFilter = new QFilter("id", "in", (Object)channelIds);
            customQFilters.add(qFilter);
            F7Utils.addF7Filter((BeforeF7SelectEvent)evt, customQFilters);
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"saleorg")) {
            Object oChannel = this.getModel().getValue("channel");
            if (oChannel != null) {
                DynamicObject channel = (DynamicObject)oChannel;
                long channelId = DynamicObjectUtils.getPkValue((DynamicObject)channel);
                List saleOrgIds = CSupplierHelper.getSupplierSaleOrgIdByChannelId((long)channelId);
                if (saleOrgIds.size() == 0) {
                    evt.setCancel(true);
                    this.getView().showErrorNotification("\u672a\u83b7\u53d6\u5230\u5f00\u5355\u95e8\u5e97\u5173\u8054\u7684\u4f9b\u8d27\u5173\u7cfb\u3002");
                    return;
                }
                Map customParams = evt.getFormShowParameter().getCustomParams();
                customParams.put("range", saleOrgIds);
            } else {
                evt.setCancel(true);
                this.getView().showErrorNotification("\u8bf7\u5148\u5f55\u5165\u5f00\u5355\u95e8\u5e97\u3002");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String ctrlKey = control.getKey();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (ctrlKey) {
            case "add": {
                this.add(rowIndex);
                break;
            }
            case "reduce": {
                this.reduce(rowIndex);
                break;
            }
            case "scanqrcode": {
                this.callScanQRCode();
                break;
            }
            case "btn_serial": {
                this.showScanQRSN(rowIndex);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        switch (opKey) {
            case "selitem": {
                this.showSelectItem();
                break;
            }
            case "save": {
                boolean rlt = this.saveValidator();
                if (!rlt) break;
                this.saveBillData();
                break;
            }
            case "onebill": {
                this.operateOneBill();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)OP_SELITEM)) {
            this.itemClosedCallBack(returnData);
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)P_ocdma_scanqrcode_sn)) {
            this.scanQRCodeSnCloseCallBack(returnData);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String customKey = e.getKey();
        String value = e.getEventArgs();
        if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"callappmethod")) {
            if (StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)scanQRCode)) {
                Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                String scanQRCode = CommonUtils.convertObjectToString(result.get("qrcode_str"));
                this.scanFillItemEntry(scanQRCode);
            }
        } else if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)wxScanQRCode) && StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)"scancode")) {
            JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
            String scanQRCode = CommonUtils.convertObjectToString((Object)result.get((Object)"value"));
            this.scanFillItemEntry(scanQRCode);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getView().getFormShowParameter().getStatus());
    }

    protected void addF7Listener(BeforeF7SelectListener form, String ... fieldNames) {
        for (String f7Name : fieldNames) {
            BasedataEdit f7 = (BasedataEdit)this.getView().getControl(f7Name);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void scanFillItemEntry(String scanQRCode) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channel");
        JSONObject data = this.scanQRCode(scanQRCode, channelId);
        if (data == null) {
            return;
        }
        JSONArray dataArray = data.getJSONArray("data");
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        if (entryColl == null) {
            return;
        }
        if (dataArray == null || dataArray.isEmpty()) {
            this.getView().showErrorNotification(String.format("\u5e8f\u5217\u53f7\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u975e\u5728\u5e93\u72b6\u6001", scanQRCode));
            return;
        }
        for (Object o : dataArray) {
            String serialNo;
            JSONObject jItem = (JSONObject)o;
            long itemId = jItem.getLong("itemid");
            if (this.existSerialNo(itemId, serialNo = jItem.getString("serialno"), entryColl)) {
                this.getView().showErrorNotification(String.format("\u5546\u54c1\u660e\u7ec6\u5e8f\u5217\u53f7\u201c%s\u201d\u5df2\u5b58\u5728\u3002", serialNo));
                return;
            }
            DynamicObject entry = entryColl.addNew();
            long materialId = jItem.getLong("material");
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"material", (long)materialId);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"item", (long)itemId);
            long unitId = jItem.getLong("retailunit");
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"unit", (long)unitId);
            long baseUnitId = jItem.getLong("baseunit");
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"baseunit", (long)baseUnitId);
            BigDecimal retailPrice = jItem.getBigDecimal("retailprice");
            entry.set("price", (Object)retailPrice);
            boolean enableSerial = jItem.getBoolean("enableserial");
            entry.set("enableserial", (Object)enableSerial);
            if (enableSerial) {
                long serialUnitId = jItem.getLong("serialunit");
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"serialunit", (long)serialUnitId);
                long serialId = jItem.getLong(String.join((CharSequence)"", "serial", "id"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"serial", (long)serialId);
                entry.set("serialno", (Object)serialNo);
                BigDecimal qty = BigDecimal.ONE;
                entry.set("qty", (Object)qty);
                BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
                entry.set("baseqty", (Object)baseQty);
                long warehouseId = jItem.getLong("channelstockid");
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"warehouse", (long)warehouseId);
                long locationId = jItem.getLong("channellocationid");
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entry, (String)"location", (long)locationId);
            }
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"qty");
            entry.set("amount", (Object)qty.multiply(retailPrice));
        }
        BusinessDataServiceHelper.loadRefence((Object[])entryColl.toArray(), (IDataEntityType)entryColl.getDynamicObjectType());
        this.getView().updateView("entryentity");
    }

    private JSONObject scanQRCode(String serialNo, long channelId) {
        if (StringUtils.isNotEmpty((CharSequence)serialNo) && channelId > 0L) {
            return CSerialHelper.getSerialDataByNumber(Collections.singletonList(serialNo), (Long)channelId, (String)SnStatusEnum.INSTOCK.getValue());
        }
        return null;
    }

    protected void callScanQRCode() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", "scanQRCode");
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("needResult", 1);
        map.put("args", args);
        this.getView().executeClientCommand("callAPPApi", new Object[]{map});
    }

    protected void add(int index) {
        BigDecimal maxQty;
        DynamicObject itemEntry = this.getModel().getEntryRowEntity("entryentity", index);
        if (itemEntry == null) {
            return;
        }
        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntry, (String)"qty");
        if (qty.compareTo(maxQty = new BigDecimal(99999999)) == 0) {
            return;
        }
        this.getModel().setValue("qty", (Object)qty.add(BigDecimal.ONE), index);
    }

    protected void reduce(int index) {
        DynamicObject itemEntry = this.getModel().getEntryRowEntity("entryentity", index);
        if (itemEntry == null) {
            return;
        }
        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntry, (String)"qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.getModel().setValue("qty", (Object)qty.subtract(BigDecimal.ONE), index);
    }

    private void createNewBill() {
        Object oSupplyRelationAuth;
        DynamicObject LoginInfo = B2BUserHelper.getLoginCustomerEntity((boolean)false);
        long channelId = DynamicObjectUtils.getLong((DynamicObject)LoginInfo, (String)"channel");
        long supplyRelationId = DynamicObjectUtils.getLong((DynamicObject)LoginInfo, (String)"supplierid");
        this.setValue("channel", channelId);
        this.setValue("supplyrelation", supplyRelationId);
        Object oChannel = this.getValue("channel");
        if (oChannel != null) {
            DynamicObject channel = (DynamicObject)oChannel;
            this.setValue("stockorg", DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"saleorg"));
            this.setValue("parentchannel", DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"parent"));
            this.setValue("up1channel", DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"up1channel"));
            this.setValue("up2channel", DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"up2channel"));
            this.setValue("currency", DynamicObjectUtils.getPkValue((DynamicObject)channel, (String)"currency"));
        }
        if ((oSupplyRelationAuth = this.getValue("supplyrelation")) != null) {
            DynamicObject supplyRelationAuth = (DynamicObject)oSupplyRelationAuth;
            this.setValue("saleorg", DynamicObjectUtils.getPkValue((DynamicObject)supplyRelationAuth, (String)"saleorg"));
        }
        this.setValue("bizdate", DateUtil.getDateFormat((Date)TimeServiceHelper.now()));
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        DynamicObject saleOrgEntryItem;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject channel = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"channel");
        if (channel == null) {
            return;
        }
        DynamicObject supplyRelation = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"supplyrelation");
        if (supplyRelation == null) {
            return;
        }
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saleorg");
        DynamicObjectCollection saleOrgColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)channel, (String)"slaeorginfo");
        if (saleOrgColl != null && saleOrgColl.size() > 0 && (saleOrgEntryItem = (DynamicObject)saleOrgColl.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"saleorginfonum") == saleOrgId).findFirst().orElse(null)) != null) {
            this.getView().getModel().setValue("seller", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrgEntryItem, (String)"saler"));
            long departId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrgEntryItem, (String)"department");
            this.getModel().setValue("depart", (Object)departId);
            long regionId = SaleOrderBusinessHelper.getRegionidByDepartment((long)departId);
            this.getModel().setValue("region", (Object)(regionId == 0L ? null : Long.valueOf(regionId)));
        }
    }

    private void loadBillData(long billId) {
        if (billId == 0L) {
            billId = CommonUtils.stringToLong((Object)this.getParameter(KEY_BILLID));
        }
        if (!QueryServiceHelper.exists((String)"occbo_salevolume", (Object)billId)) {
            this.getView().showErrorNotification("\u5355\u636e\u4e0d\u5b58\u5728");
            return;
        }
        this.getModel().setValue(KEY_BILLID, (Object)billId);
        DynamicObject saleVolumeBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"occbo_salevolume");
        this.setValue("billno", DynamicObjectUtils.getString((DynamicObject)saleVolumeBill, (String)"billno"));
        this.setValue("billtype", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"billtype"));
        this.setValue("channel", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"channel"));
        this.setValue("parentchannel", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"parentchannel"));
        this.setValue("up1channel", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"up1channel"));
        this.setValue("up2channel", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"up2channel"));
        this.setValue("vipname", DynamicObjectUtils.getString((DynamicObject)saleVolumeBill, (String)"vipname"));
        this.setValue("vipphone", DynamicObjectUtils.getString((DynamicObject)saleVolumeBill, (String)"vipphone"));
        this.setValue("vip", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"vip"));
        this.setValue("bizdate", DynamicObjectUtils.getDate((DynamicObject)saleVolumeBill, (String)"bizdate"));
        this.setValue("saleorg", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"saleorg"));
        this.setValue("stockorg", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"stockorg"));
        this.setValue("currency", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"currency"));
        this.setValue("depart", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"depart"));
        this.setValue("region", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"region"));
        this.setValue("seller", DynamicObjectUtils.getPkValue((DynamicObject)saleVolumeBill, (String)"seller"));
        MobExtendHelper.loadMobExtend((IDataModel)this.getModel(), (String)this.getView().getEntityId(), (DynamicObject)saleVolumeBill, (String)"occbo_salevolume");
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleVolumeBill, (String)"entryentity");
        if (itemEntry != null) {
            itemEntry.clear();
            if (entryColl == null || entryColl.size() == 0) {
                return;
            }
            for (DynamicObject entry : entryColl) {
                DynamicObject newEntry = itemEntry.addNew();
                DynamicObject item = DynamicObjectUtils.getDynamicObject((DynamicObject)entry, (String)"item");
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"item", (long)DynamicObjectUtils.getPkValue((DynamicObject)item));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"material", (long)DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"material"));
                newEntry.set("thumbnail", item.get("thumbnail"));
                newEntry.set("price", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"price"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"unit", (long)DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"unit"));
                newEntry.set("amount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"amount"));
                newEntry.set("qty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"qty"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"baseunit", (long)DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"baseunit"));
                newEntry.set("baseqty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"baseqty"));
                newEntry.set("enableserial", (Object)DynamicObjectUtils.getBoolean((DynamicObject)entry, (String)"enableserial"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"serialunit", (long)DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"serialunit"));
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"serial", (long)DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"serial"));
                newEntry.set("serialno", (Object)DynamicObjectUtils.getString((DynamicObject)entry, (String)"serialno"));
                newEntry.set(KEY_ENTRYID, (Object)DynamicObjectUtils.getPkValue((DynamicObject)entry));
                MobExtendHelper.setOrmExtToMobExt((DynamicObject)newEntry, (DynamicObject)entry, (String)this.getView().getEntityId(), (String)"occbo_salevolume");
            }
            BusinessDataServiceHelper.loadRefence((Object[])itemEntry.toArray(), (IDataEntityType)itemEntry.getDynamicObjectType());
            this.getView().updateView("entryentity");
        }
    }

    private void saveBillData() {
        DynamicObject saleVolumeBill = this.buildBillData();
        if (saleVolumeBill == null) {
            return;
        }
        OperateOption saveOption = CommonUtils.getOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)OP_SAVE, (String)"occbo_salevolume", (DynamicObject[])new DynamicObject[]{saleVolumeBill}, (OperateOption)saveOption);
        if (!result.isSuccess()) {
            this.showMessage(result);
            return;
        }
        long billId = CommonUtils.stringToLong(result.getSuccessPkIds().get(0));
        this.saveAttachment(billId);
        this.loadBillData(billId);
        this.getView().showTipNotification("\u4fdd\u5b58\u6210\u529f\u3002");
    }

    private void saveAttachment(long billId) {
        AttachmentPanel att = (AttachmentPanel)this.getView().getControl(fs_attachmentpanelap);
        List attachmentData = att.getAttachmentData();
        if (attachmentData == null || attachmentData.isEmpty()) {
            return;
        }
        for (Map map : attachmentData) {
            String url = CommonUtils.convertObjectToString(map.get("url"));
            String fileName = CommonUtils.convertObjectToString(map.get("name"));
            if (url.contains("configKey=redis.serversForCache&id=tempfile")) {
                url = this.uploadTempfile(url, fileName);
                map.put("url", url);
            }
            map.put("creator", UserServiceHelper.getCurrentUserId());
            map.put("modifytime", new Date().getTime());
        }
        AttachmentServiceHelper.upload((String)"occbo_salevolume", (Object)billId, (String)"attachmentpanel", (List)attachmentData);
    }

    private String uploadTempfile(String url, String fileName) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = cache.getInputStream(url);
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)fileName);
        FileItem fileItem = new FileItem(fileName, pathParam, inputStream);
        return service.upload(fileItem);
    }

    protected DynamicObject buildBillData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)KEY_BILLID);
        DynamicObject saleVolumeBill = this.isAddNew() && billId == 0L ? BusinessDataServiceHelper.newDynamicObject((String)"occbo_salevolume") : BusinessDataServiceHelper.loadSingle((Object)billId, (String)"occbo_salevolume");
        this.buildHeaderData(saleVolumeBill, dataEntity);
        this.buildItemEntryData(saleVolumeBill, dataEntity);
        return saleVolumeBill;
    }

    private void operateOneBill() {
        DynamicObject saleVolumeBill = this.buildBillData();
        OperateOption saveOption = CommonUtils.getOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)OP_SAVE, (String)"occbo_salevolume", (DynamicObject[])new DynamicObject[]{saleVolumeBill}, (OperateOption)saveOption);
        if (!result.isSuccess()) {
            this.showMessage(result);
            return;
        }
        long billId = CommonUtils.stringToLong(result.getSuccessPkIds().get(0));
        this.loadBillData(billId);
        this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
        OperateOption option = CommonUtils.getOperateOption((boolean)true);
        option.setVariableValue("ishasright", String.valueOf(true));
        result = OperationServiceHelper.executeOperate((String)"submit", (String)"occbo_salevolume", (Object[])result.getSuccessPkIds().toArray(), (OperateOption)option);
        if (!result.isSuccess()) {
            this.showMessage(result);
            return;
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"audit", (String)"occbo_salevolume", (Object[])result.getSuccessPkIds().toArray(), (OperateOption)option)).isSuccess()) {
            this.showMessage(result);
            return;
        }
        this.getView().close();
    }

    private boolean saveValidator() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channel");
        QFilter qFilter = new QFilter("id", "=", (Object)channelId);
        qFilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        if (!QueryServiceHelper.exists((String)"ocdbd_channel", (QFilter[])qFilter.toArray())) {
            this.getView().showTipNotification("\u5f00\u5355\u95e8\u5e97\u5df2\u7981\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
            return false;
        }
        DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            this.getView().showTipNotification("\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5546\u54c1\u660e\u7ec6\u5206\u5f55\u3002");
            return false;
        }
        for (int rowIndex = 0; rowIndex < entryColl.size(); ++rowIndex) {
            DynamicObject serial;
            DynamicObject itemEntry = (DynamicObject)entryColl.get(rowIndex);
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntry, (String)"qty");
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(String.format("\u7b2c%1$s\u884c\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", rowIndex + 1));
                return false;
            }
            boolean enableSerial = DynamicObjectUtils.getBoolean((DynamicObject)itemEntry, (String)"enableserial");
            boolean isNotControlSN = ChannelUtil.queryChannelIsNotControlSN((long)channelId);
            if (!enableSerial || isNotControlSN || (serial = DynamicObjectUtils.getDynamicObject((DynamicObject)itemEntry, (String)"serial")) != null) continue;
            this.getView().showTipNotification(String.format("\u7b2c%1$s\u884c\u5546\u54c1\u672a\u5f55\u5165\u5e8f\u5217\u53f7\u3002", rowIndex + 1));
            return false;
        }
        return true;
    }

    private void buildHeaderData(DynamicObject saleVolumeBill, DynamicObject dataEntity) {
        saleVolumeBill.set("billstatus", (Object)"A");
        saleVolumeBill.set("billtype", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"billtype"));
        saleVolumeBill.set("channel", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"channel"));
        saleVolumeBill.set("parentchannel", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"parentchannel"));
        saleVolumeBill.set("up1channel", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"up1channel"));
        saleVolumeBill.set("up2channel", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"up2channel"));
        saleVolumeBill.set("vipname", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"vipname"));
        saleVolumeBill.set("vipphone", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"vipphone"));
        saleVolumeBill.set("vip", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"vip"));
        saleVolumeBill.set("depart", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"depart"));
        saleVolumeBill.set("region", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"region"));
        saleVolumeBill.set("seller", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"seller"));
        saleVolumeBill.set("bizdate", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"bizdate"));
        saleVolumeBill.set("saleorg", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"saleorg"));
        saleVolumeBill.set("stockorg", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"stockorg"));
        saleVolumeBill.set("currency", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"currency"));
        saleVolumeBill.set("modifier", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"modifier"));
        saleVolumeBill.set("modifytime", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"modifytime"));
        if (this.isAddNew()) {
            saleVolumeBill.set("creator", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"creator"));
            saleVolumeBill.set("createtime", DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"createtime"));
        }
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)dataEntity, (DynamicObject)saleVolumeBill, (String)this.getView().getEntityId(), (String)"occbo_salevolume");
    }

    private void buildItemEntryData(DynamicObject saleVolumeBill, DynamicObject dataEntity) {
        DynamicObjectCollection itemColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        DynamicObjectCollection newEntryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleVolumeBill, (String)"entryentity");
        Set entryIds = itemColl.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)KEY_ENTRYID) > 0L).map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)KEY_ENTRYID)).collect(Collectors.toSet());
        newEntryColl.removeIf(x -> !entryIds.contains(DynamicObjectUtils.getPkValue((DynamicObject)x)));
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject itemEntry : itemColl) {
            DynamicObject newEntry;
            long entryId = DynamicObjectUtils.getLong((DynamicObject)itemEntry, (String)KEY_ENTRYID);
            if (entryId > 0L) {
                if (newEntryColl.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == entryId)) {
                    newEntry = newEntryColl.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == entryId).findFirst().orElse(null);
                    if (newEntry == null) {
                        newEntry = newEntryColl.addNew();
                    }
                } else {
                    newEntry = newEntryColl.addNew();
                }
            } else {
                newEntry = newEntryColl.addNew();
            }
            newEntry.set("material", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"material"));
            newEntry.set("item", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"item"));
            newEntry.set("unit", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"unit"));
            newEntry.set("enableserial", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"enableserial"));
            newEntry.set("serial", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"serial"));
            newEntry.set("serialno", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"serialno"));
            newEntry.set("serialunit", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"serialunit"));
            newEntry.set("baseunit", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"baseunit"));
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntry, (String)"qty");
            newEntry.set("qty", (Object)qty);
            totalQty = totalQty.add(qty);
            newEntry.set("baseqty", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"baseqty"));
            newEntry.set("price", DynamicObjectUtils.get((DynamicObject)itemEntry, (String)"price"));
            BigDecimal amount = DynamicObjectUtils.getBigDecimal((DynamicObject)itemEntry, (String)"amount");
            newEntry.set("amount", (Object)amount);
            totalAmount = totalAmount.add(amount);
            MobExtendHelper.setMobExtToOrmExt((DynamicObject)itemEntry, (DynamicObject)newEntry, (String)this.getView().getEntityId(), (String)"occbo_salevolume");
        }
        saleVolumeBill.set("totalqty", (Object)totalQty);
        saleVolumeBill.set("totalamount", (Object)totalAmount);
        for (int i = 0; i < newEntryColl.size(); ++i) {
            DynamicObject newEntry = (DynamicObject)newEntryColl.get(i);
            newEntry.set("seq", (Object)(i + 1));
        }
    }

    private void itemClosedCallBack(Object returnData) {
        Object[] selectIds = (Object[])returnData;
        if (selectIds.length == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)selectIds);
        String selectFields = "id,material,retailunit,baseunit,enableserial,serialunit,retailprice,thumbnail";
        DynamicObjectCollection itemColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFields, (QFilter[])qFilter.toArray());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        for (DynamicObject item : itemColl) {
            DynamicObject newEntry = entryColl.addNew();
            this.fillItemEntry(newEntry, item);
        }
        BusinessDataServiceHelper.loadRefence((Object[])entryColl.toArray(), (IDataEntityType)entryColl.getDynamicObjectType());
        this.getView().updateView("entryentity");
    }

    private void scanQRCodeSnCloseCallBack(Object returnData) {
        Map mapData = (Map)returnData;
        if (mapData == null || mapData.isEmpty()) {
            return;
        }
        int rowIndex = (Integer)mapData.get("seq");
        this.setValue("serial", mapData.get("serial"), rowIndex);
        this.setValue("serialno", mapData.get("serialno"), rowIndex);
    }

    private void fillItemEntry(DynamicObject newEntry, DynamicObject item) {
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"item", (long)DynamicObjectUtils.getLong((DynamicObject)item, (String)"id"));
        long materialId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"material");
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"material", (long)materialId);
        long saleUnitId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"retailunit");
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"unit", (long)saleUnitId);
        long baseUnitId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"baseunit");
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"baseunit", (long)baseUnitId);
        boolean enableserial = DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"enableserial");
        newEntry.set("enableserial", (Object)enableserial);
        if (enableserial) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newEntry, (String)"serialunit", (long)DynamicObjectUtils.getLong((DynamicObject)item, (String)"serialunit"));
        }
        BigDecimal qty = BigDecimal.ONE;
        newEntry.set("qty", (Object)qty);
        BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)saleUnitId, (Long)baseUnitId);
        newEntry.set("baseqty", (Object)baseQty);
        newEntry.set("price", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"retailprice"));
        BigDecimal price = DynamicObjectUtils.getBigDecimal((DynamicObject)newEntry, (String)"price");
        newEntry.set("amount", (Object)qty.multiply(price));
        newEntry.set("thumbnail", DynamicObjectUtils.get((DynamicObject)item, (String)"thumbnail"));
    }

    protected void showSelectItem() {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(P_ocdbd_itemmobf7);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>(2);
        List<Object> marketItemIds = this.getMarketItemIds();
        hashMap.put("ids", marketItemIds);
        showParameter.setCustomParams(hashMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OP_SELITEM);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void showScanQRSN(int rowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(P_ocdma_scanqrcode_sn);
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channel");
        DynamicObject itemEntry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        long itemId = 0L;
        if (itemEntry != null) {
            itemId = DynamicObjectUtils.getPkValue((DynamicObject)itemEntry, (String)"item");
        }
        mobileFormShowParameter.setCustomParam("channel", (Object)channelId);
        mobileFormShowParameter.setCustomParam("item", (Object)itemId);
        mobileFormShowParameter.setCustomParam("seq", (Object)rowIndex);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        long finalItemId = itemId;
        List selectedSerialIds = entryentity.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)String.join((CharSequence)"_", "item", "id")) == finalItemId).map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"serial")).collect(Collectors.toList());
        mobileFormShowParameter.setCustomParam("selected", selectedSerialIds);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, P_ocdma_scanqrcode_sn));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private List<Object> getMarketItemIds() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saleorg");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channel");
        DynamicObject supplyRelation = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"supplyrelation");
        long saleChannelId = DynamicObjectUtils.getPkValue((DynamicObject)supplyRelation, (String)"salechannel");
        List<QFilter> filters = this.getItemFilter(saleOrgId, saleChannelId, channelId);
        return QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_iteminfo", (QFilter[])filters.toArray(new QFilter[0]), null, (int)99999);
    }

    private List<QFilter> getItemFilter(long saleOrgId, long saleChannelId, long orderChannelId) {
        List<QFilter> filters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)saleChannelId, (long)orderChannelId);
        if (filters == null) {
            filters = Arrays.asList(new QFilter("id", "=", (Object)0L).toArray());
        } else {
            filters.add(new QFilter("itemtypeid", "!=", (Object)CommonUtils.stringToLong((Object)GoodsTypeEnum.COMBINEGOODS.getValue())));
        }
        return filters;
    }

    private boolean createDataMutex(String billNo, long billId) {
        if (billId != 0L) {
            ArrayList<Map<String, Object>> mutexData = new ArrayList<Map<String, Object>>();
            this.createMutexInfo(billId, mutexData);
            StringBuilder sb = new StringBuilder();
            try (DataMutex dataMutex = DataMutex.create();){
                Map dataMap = dataMutex.batchrequire(mutexData);
                for (Map.Entry mutexItem : dataMap.entrySet()) {
                    if (!Boolean.FALSE.equals(mutexItem.getValue())) continue;
                    sb.append(String.format("\u5355\u636e%s:\u5176\u4ed6\u4eba\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", billNo));
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (sb.length() > 0) {
                this.getView().showErrorNotification("\u4fee\u6539\u5931\u8d25\u3002".concat(sb.toString()));
                return false;
            }
        }
        return true;
    }

    private void createMutexInfo(long billId, List<Map<String, Object>> mutexData) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("dataObjId", CommonUtils.convertObjectToString((Object)billId));
        dataMap.put("entityKey", "occbo_salevolume");
        dataMap.put("operationKey", "modify");
        dataMap.put("groupId", "default_netctrl");
        dataMap.put("isStrict", true);
        mutexData.add(dataMap);
    }

    private void showMessage(OperationResult result) {
        if (result.isSuccess()) {
            return;
        }
        List allError = result.getAllErrorInfo();
        if (!allError.isEmpty()) {
            ArrayList<String> allErrorMessageList = new ArrayList<String>(1);
            for (OperateErrorInfo error : allError) {
                allErrorMessageList.add(error.getMessage());
            }
            this.getView().showErrorNotification(String.join((CharSequence)",", allErrorMessageList));
            return;
        }
        List validResultList = result.getValidateResult().getValidateErrors();
        ArrayList<String> fatalErrorMessageList = new ArrayList<String>(1);
        ArrayList<String> errorMessageList = new ArrayList<String>(1);
        ArrayList<String> warningMessageList = new ArrayList<String>(1);
        for (ValidateResult validation : validResultList) {
            List allErrorInfo = validation.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                ErrorLevel errorLevel = errorInfo.getLevel();
                switch (errorLevel) {
                    case FatalError: {
                        fatalErrorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Error: {
                        errorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Warning: {
                        warningMessageList.add(errorInfo.getMessage());
                        break;
                    }
                }
            }
        }
        if (!fatalErrorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", fatalErrorMessageList));
        } else if (!errorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", errorMessageList));
        } else if (!warningMessageList.isEmpty()) {
            this.getView().showTipNotification(String.join((CharSequence)",", warningMessageList));
        } else if (StringUtils.isNotEmpty((CharSequence)result.getMessage())) {
            this.getView().showErrorNotification(result.getMessage());
        }
    }

    private void toBillList() {
        this.getView().close();
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private boolean existSerialNo(long itemId, String serialNo, DynamicObjectCollection entryColl) {
        if (entryColl != null && entryColl.size() > 0) {
            return entryColl.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"item") == itemId && DynamicObjectUtils.getString((DynamicObject)x, (String)"serialno").equals(serialNo));
        }
        return false;
    }

    private void mutexBillRelease() {
        String mutexBillId = this.getView().getPageCache().get(KEY_mutexbillid);
        if (!CommonUtils.isNull((Object)mutexBillId)) {
            long billId = CommonUtils.stringToLong((Object)mutexBillId);
            ArrayList<Map<String, Object>> mutexData = new ArrayList<Map<String, Object>>();
            this.createMutexInfo(billId, mutexData);
            try (DataMutex dataMutex = DataMutex.create();){
                dataMutex.batchRelease(mutexData);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

