/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.salesvolume;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobBusinessPlugin;

public class SaleVolumeListPlugin
extends OcbaseFormMobBusinessPlugin
implements TabSelectListener,
MobileSearchTextChangeListener,
CreateListDataProviderListener,
ListRowClickListener {
    private static final String[] billStatusArray = new String[]{"A", "B"};
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_BILLLISTAP = "billlistap";
    private static final String BTN_ONEBILL = "btn_onebill";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_UNSUBMIT = "btn_unsubmit";
    private static final String KEY_BILLSEARCH = "billsearch";
    private static final String KEY_BILLDATESPAN = "billdatespan";
    private static final String KEY_STARTDATE = "startdate";
    private static final String KEY_ENDDATE = "enddate";
    private static final String KEY_BILLID = "billid";
    private static final String P_ocdma_salevolume_add = "ocdma_salevolume_add";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{KEY_TABAP});
        this.addClickListeners(new String[]{BTN_ADD, BTN_ONEBILL, BTN_DELETE, BTN_EDIT, BTN_UNSUBMIT});
        MobileSearch search = (MobileSearch)this.getControl(KEY_BILLSEARCH);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshBillList();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String ctlKey = ((Control)evt.getSource()).getKey();
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        switch (ctlKey) {
            case "btn_onebill": {
                String billStatus = selectedRow.getBillStatus();
                this.operateOneBill(billStatus);
                break;
            }
            case "btn_edit": {
                String billStatus = selectedRow.getBillStatus();
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
                    this.showForm(OperationStatus.EDIT);
                    break;
                }
                this.getView().showTipNotification("\u53ea\u80fd\u4fee\u6539\u6682\u5b58\u7684\u9500\u91cf\u5f00\u5355\u3002");
                break;
            }
            case "btn_delete": {
                String billStatus = selectedRow.getBillStatus();
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this);
                    this.getView().showConfirm("\u662f\u5426\u5220\u9664\u9009\u4e2d\u9500\u91cf\u5f00\u5355\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                this.getView().showTipNotification("\u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u9500\u91cf\u5f00\u5355\u3002");
                break;
            }
            case "btn_unsubmit": {
                String billStatus = billList.getCurrentSelectedRowInfo().getBillStatus();
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"B")) {
                    Object billid = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                    if (ObjectUtils.isEmpty((Object)billid)) {
                        this.getView().showTipNotification("\u8bf7\u9009\u4e2d\u6570\u636e\u884c\u3002");
                        return;
                    }
                    Object[] objectIds = new Object[]{billid};
                    OperateOption option = CommonUtils.getOperateOption();
                    OperationResult result = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"occbo_salevolume", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                        break;
                    }
                    this.getView().showSuccessNotification("\u64a4\u9500\u6210\u529f");
                    this.refreshBillList();
                    break;
                }
                this.getView().showTipNotification("\u53ea\u6709\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u8ba2\u5355\u624d\u80fd\u64a4\u9500\u3002");
                break;
            }
        }
    }

    public void click(MobileSearchTextChangeEvent evt) {
        String ctrlKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)ctrlKey, (CharSequence)KEY_BILLSEARCH)) {
            this.refreshBillList();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "new": {
                this.showForm(OperationStatus.ADDNEW);
                break;
            }
        }
        super.afterDoOperation(args);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.showForm(OperationStatus.VIEW);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "startdate": 
            case "enddate": 
            case "billdatespan": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.refreshBillList();
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)P_ocdma_salevolume_add)) {
            OperationStatus opStatus = (OperationStatus)closedCallBackEvent.getReturnData();
            if (opStatus == OperationStatus.VIEW) {
                return;
            }
            String billDateSpan = (String)this.getModel().getValue(KEY_BILLDATESPAN);
            if (StringUtils.equals((CharSequence)billDateSpan, (CharSequence)"F")) {
                this.refreshBillList();
            } else {
                this.setValue(KEY_BILLDATESPAN, "F");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        BillList billList;
        Object pkId;
        DynamicObject salesVolume;
        OperationResult delResult;
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (evt.getResult() == MessageBoxResult.No) {
            return;
        }
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)BTN_DELETE) && (delResult = OperationUtil.invokeOperation((DynamicObject)(salesVolume = BusinessDataServiceHelper.loadSingle((Object)(pkId = (billList = (BillList)this.getControl(KEY_BILLLISTAP)).getCurrentSelectedRowInfo().getPrimaryKeyValue()), (String)"occbo_salevolume")), (String)"delete")).isSuccess()) {
            this.refreshBillList();
        }
    }

    private void showForm(OperationStatus operationStatus) {
        Object pkId = null;
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        if (operationStatus.equals((Object)OperationStatus.EDIT) || operationStatus.equals((Object)OperationStatus.VIEW)) {
            pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        }
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(P_ocdma_salevolume_add);
        mobileFormShowParameter.setStatus(operationStatus);
        mobileFormShowParameter.setCustomParam(KEY_BILLID, pkId);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, P_ocdma_salevolume_add));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void operateOneBill(String billStatus) {
        OperationResult result;
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (StringUtils.isEmpty((CharSequence)billStatus) || StringUtils.equals((CharSequence)billStatus, (CharSequence)"C")) {
            return;
        }
        OperateOption option = CommonUtils.getOperateOption((boolean)true);
        option.setVariableValue("ishasright", String.valueOf(true));
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A") && !(result = OperationServiceHelper.executeOperate((String)"submit", (String)"occbo_salevolume", (Object[])new Object[]{pkId}, (OperateOption)option)).isSuccess()) {
            this.showMessage(result);
            return;
        }
        result = OperationServiceHelper.executeOperate((String)"audit", (String)"occbo_salevolume", (Object[])new Object[]{pkId}, (OperateOption)option);
        if (!result.isSuccess()) {
            this.showMessage(result);
            return;
        }
        this.getView().showMessage("\u64cd\u4f5c\u6210\u529f\u3002");
        this.refreshBillList();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        String curTabKey = tab.getCurrentTab();
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter(curTabKey)});
    }

    private QFilter getBillFilter(String tabKey) {
        List channelIds = CUserHelper.getAuthorizedChannelIdList();
        QFilter qFilter = channelIds != null && channelIds.size() > 0 ? new QFilter("channel", "in", (Object)channelIds) : new QFilter("channel", "=", (Object)0L);
        if (StringUtils.equals((CharSequence)tabKey.toUpperCase(), (CharSequence)"B")) {
            qFilter.and("billstatus", "in", (Object)billStatusArray);
        } else if (StringUtils.equals((CharSequence)tabKey.toUpperCase(), (CharSequence)"C")) {
            qFilter.and("billstatus", "=", (Object)"C");
        }
        MobileSearch search = (MobileSearch)this.getControl(KEY_BILLSEARCH);
        String searchText = search.getText();
        if (StringUtils.isNotEmpty((CharSequence)searchText.trim())) {
            qFilter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno,vipphone,vipname,entryentity.item.name,entryentity.item.number"}));
        }
        this.setDateFilter(qFilter);
        return qFilter;
    }

    private void setDateFilter(QFilter filter) {
        String selectDate;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date startDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)KEY_STARTDATE);
        Date endDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)KEY_ENDDATE);
        if (startDate != null && endDate != null) {
            filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)startDate));
            filter.and("bizdate", "<=", (Object)DateUtil.getDayLast((Date)endDate));
            return;
        }
        switch (selectDate = CommonUtils.convertObjectToString((Object)this.getValue(KEY_BILLDATESPAN))) {
            case "A": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(6L))));
                break;
            }
            case "B": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth()));
                break;
            }
            case "C": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(90L))));
                break;
            }
            case "D": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(2L))));
                break;
            }
            case "E": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(1L))));
                break;
            }
            case "G": {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                break;
            }
            default: {
                filter.and("bizdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getNowDate()));
                filter.and("bizdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getNowDate()));
            }
        }
    }

    private void showMessage(OperationResult result) {
        if (result.isSuccess()) {
            return;
        }
        List allError = result.getAllErrorInfo();
        if (!allError.isEmpty()) {
            ArrayList<String> allErrorMessageList = new ArrayList<String>(1);
            for (OperateErrorInfo error : allError) {
                allErrorMessageList.add(error.getMessage());
            }
            this.getView().showErrorNotification(String.join((CharSequence)",", allErrorMessageList));
            return;
        }
        List validResultList = result.getValidateResult().getValidateErrors();
        ArrayList<String> fatalErrorMessageList = new ArrayList<String>(1);
        ArrayList<String> errorMessageList = new ArrayList<String>(1);
        ArrayList<String> warningMessageList = new ArrayList<String>(1);
        for (ValidateResult validation : validResultList) {
            List allErrorInfo = validation.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                ErrorLevel errorLevel = errorInfo.getLevel();
                switch (errorLevel) {
                    case FatalError: {
                        fatalErrorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Error: {
                        errorMessageList.add(errorInfo.getMessage());
                        break;
                    }
                    case Warning: {
                        warningMessageList.add(errorInfo.getMessage());
                        break;
                    }
                }
            }
        }
        if (!fatalErrorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", fatalErrorMessageList));
        } else if (!errorMessageList.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)",", errorMessageList));
        } else if (!warningMessageList.isEmpty()) {
            this.getView().showMessage(String.join((CharSequence)",", warningMessageList));
        } else if (StringUtils.isNotEmpty((CharSequence)result.getMessage())) {
            this.getView().showErrorNotification(result.getMessage());
        }
    }
}

