/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.salesvolume;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ScanQRCodeSNPlugin
extends OcbaseFormMobPlugin
implements SetFilterListener,
MobileSearchTextChangeListener {
    private static final String KEY_SEARCHTEXT = "searchtext";
    private static final String SEARCH = "search";
    private static final String SCANQRCODE = "scanqrcode";
    private static final String BILLLISTAP = "billlistap";
    private static final String COMFIRM = "comfirm";
    private static final String ISWX = "iswx";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileSearch search = (MobileSearch)this.getView().getControl(KEY_SEARCHTEXT);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        this.addClickListeners(new String[]{SEARCH, SCANQRCODE, COMFIRM});
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void beforeBindData(EventObject e) {
        MobileFormShowParameter formShowParameter;
        long itemId;
        super.beforeBindData(e);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener((SetFilterListener)this);
        boolean isWx = CommonUtils.isFromWeixin((String)RequestContext.get().getUserAgent());
        if (isWx) {
            this.setValue(ISWX, true);
        }
        if ((itemId = CommonUtils.stringToLong((Object)(formShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter()).getCustomParam("item"))) > 0L) {
            this.setValue("item", itemId);
            DynamicObject item = (DynamicObject)this.getValue("item");
            this.setValue("unit", item.get("retailunit"));
            this.setValue("thumbnail", item.get("thumbnail"));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String ctrlKey = control.getKey();
        if (StringUtils.equals((CharSequence)ctrlKey, (CharSequence)COMFIRM)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            HashMap<String, Object> returnMap = new HashMap<String, Object>(0);
            Object[] selectIds = billList.getSelectedRows().getBillListSelectedRowCollection().getPrimaryKeyValues();
            ListSelectedRowCollection selectedRowColl = billList.getSelectedRows();
            if (selectedRowColl != null && !selectedRowColl.isEmpty()) {
                Object serialId = selectIds[0];
                String serialNo = selectedRowColl.get(0).getNumber();
                returnMap.put("serial", serialId);
                returnMap.put("serialno", serialNo);
                returnMap.put("seq", this.getView().getFormShowParameter().getCustomParam("seq"));
            }
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)ctrlKey, (CharSequence)SCANQRCODE)) {
            this.callScanQRCode();
        }
    }

    public void click(MobileSearchTextChangeEvent evt) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.refresh();
    }

    public void setFilter(SetFilterEvent evt) {
        MobileSearch search;
        String searchText;
        JSONArray serialIds;
        long itemId;
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
        MobileFormShowParameter mobileFormShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        customQFilters.add(new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue()));
        long channelId = CommonUtils.stringToLong((Object)mobileFormShowParameter.getCustomParam("channel"));
        if (channelId > 0L) {
            customQFilters.add(new QFilter("channelid", "=", (Object)channelId));
        }
        if ((itemId = CommonUtils.stringToLong((Object)mobileFormShowParameter.getCustomParam("item"))) > 0L) {
            customQFilters.add(new QFilter("itemid", "=", (Object)itemId));
        }
        if ((serialIds = (JSONArray)mobileFormShowParameter.getCustomParam("selected")) != null && !serialIds.isEmpty()) {
            customQFilters.add(new QFilter("id", "not in", (Object)serialIds.toJavaList(Long.class)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(searchText = (search = (MobileSearch)this.getControl(KEY_SEARCHTEXT)).getText()))) {
            QFilter searchFilter = QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"number"});
            customQFilters.add(searchFilter);
        }
        evt.setCustomQFilters(customQFilters);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String customKey = e.getKey();
        String value = e.getEventArgs();
        if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"callappmethod")) {
            if (StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)SCANQRCODE)) {
                Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                String scanQRCode = CommonUtils.convertObjectToString(result.get("qrcode_str"));
                this.scanQRCustomEvent(scanQRCode);
            }
        } else if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"wxscanqrcode_sn") && StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)"scancode")) {
            JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
            String scanQRCode = CommonUtils.convertObjectToString((Object)result.get((Object)"value"));
            this.scanQRCustomEvent(scanQRCode);
        }
    }

    private void scanQRCustomEvent(String scanQRCode) {
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        long channelId = CommonUtils.stringToLong((Object)formShowParameter.getCustomParam("channel"));
        long itemId = CommonUtils.stringToLong((Object)formShowParameter.getCustomParam("item"));
        JSONObject data = CSerialHelper.getSerialDataByNumber(Collections.singletonList(scanQRCode), (Long)channelId, (Long)itemId, (String)SnStatusEnum.INSTOCK.getValue());
        if (data == null) {
            this.getView().showTipNotification(String.format("\u5546\u54c1\u5e8f\u5217\u53f7%s\u4e0d\u5b58\u5728\u6216\u975e\u5728\u5e93\u72b6\u6001\u3002", scanQRCode));
            return;
        }
        JSONArray dataArray = data.getJSONArray("data");
        if (dataArray == null || dataArray.isEmpty()) {
            this.getView().showTipNotification(String.format("\u5546\u54c1\u5e8f\u5217\u53f7%s\u4e0d\u5b58\u5728\u6216\u975e\u5728\u5e93\u72b6\u6001\u3002", scanQRCode));
            return;
        }
        JSONObject dataItem = (JSONObject)dataArray.get(0);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(0);
        Object serialId = dataItem.get((Object)String.join((CharSequence)"", "serial", "id"));
        String serialNo = dataItem.getString("serialno");
        returnMap.put("serial", serialId);
        returnMap.put("serialno", serialNo);
        returnMap.put("seq", this.getView().getFormShowParameter().getCustomParam("seq"));
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    protected void callScanQRCode() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", "scanQRCode");
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("needResult", 1);
        map.put("args", args);
        this.getView().executeClientCommand("callAPPApi", new Object[]{map});
    }
}

