/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.transbill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.flex.FlexService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.helper.saleorder.SaleOrderBusinessHelper;
import kd.occ.ocbase.common.enums.SnStatusEnum;
import kd.occ.ocbase.common.helper.CSerialHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class TransBillEditPlugin
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String btnselectitem = "btnselectitem";
    private static final String btnselectsn = "btnselectsn";
    private static final String op_scanqrcode = "scanqrcode";
    private static final String op_add = "add";
    private static final String op_reduce = "reduce";
    private static final String op_save = "save";
    private static final String op_trans = "trans";
    private static final String btnmore = "btnmore";
    private static final String ISWX = "iswx";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!this.isView()) {
            this.addClickListeners(new String[]{btnselectitem, btnselectsn, op_add, op_reduce, op_save, op_trans});
        }
        this.addClickListeners(new String[]{btnmore});
        this.addRowClickListener(this, new String[]{"itementry"});
        this.addF7Listener(this, new String[]{"outchannelid", "outwarehouseid_h", "outwarehouseid", "inchannelid", "inwarehouseid_h", "inwarehouseid", "saleorgid", "itemid", "billtypeid"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("operationStatus", this.getView().getFormShowParameter().getStatus().toString());
        if (this.isView() || this.isEdit()) {
            Object billid = this.getParameter("billid");
            this.getModel().setValue("id", billid);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"ococic_transbill");
            this.viewOrder(bill);
        } else if (this.isAddNew()) {
            this.initNewBillHead();
        }
        boolean isWx = CommonUtils.isFromWeixin((String)RequestContext.get().getUserAgent());
        if (isWx) {
            this.setValue(ISWX, Boolean.TRUE);
        }
    }

    private void viewOrder(DynamicObject bill) {
        this.setValue("billno", bill.get("billno"));
        this.setValue("billtypeid", bill.get("billtypeid"));
        this.setValue("billtypedata", bill.get("billtypedata"));
        this.setValue("outchannelid", bill.get("outchannelid"));
        this.setValue("outwarehouseid_h", bill.get("outwarehouseid_h"));
        this.setValue("inchannelid", bill.get("inchannelid"));
        this.setValue("inwarehouseid_h", bill.get("inwarehouseid_h"));
        this.setValue("settleorgid", bill.get("settleorgid"));
        this.setValue("saleorgid", bill.get("saleorgid"));
        this.setValue("transbillchannelid", bill.get("transbillchannelid"));
        this.setValue("transbilldriver", bill.get("transbilldriver"));
        this.setValue("settlecurrencyid", bill.get("settlecurrencyid"));
        this.setValue("basecurrencyid", bill.get("basecurrencyid"));
        this.setValue("exchangeratetable", bill.get("exchangeratetable"));
        this.setValue("exchangerate", bill.get("exchangerate"));
        this.setValue("exratedate", bill.get("exratedate"));
        this.setValue("billstatus", bill.get("billstatus"));
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("itementry");
        if (CollectionUtils.isEmpty((Collection)billEntry)) {
            return;
        }
        int[] rowIndexes = this.getModel().batchCreateNewEntryRow("itementry", billEntry.size());
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntry.get(i);
            int rowIndex = rowIndexes[i];
            this.setValue("itemid", entry.get("itemid"), rowIndex);
            this.setValue("materialid", entry.get("materialid"), rowIndex);
            this.setValue("approveqty", entry.getBigDecimal("approveqty"), rowIndex);
            this.setValue("unit", entry.get("unit"), rowIndex);
            this.setValue("approvebaseqty", entry.getBigDecimal("approvebaseqty"), rowIndex);
            this.setValue("baseunit", entry.get("baseunit"), rowIndex);
            this.setValue("serialqty", entry.getBigDecimal("serialqty"), rowIndex);
            this.setValue("serialunitid", entry.get("serialunitid"), rowIndex);
            this.setValue("auxptyid", entry.get("auxptyid"), rowIndex);
            this.setValue("assistunitid", entry.get("assistunitid"), rowIndex);
            this.setValue("outwarehouseid", entry.get("outwarehouseid"), rowIndex);
            this.setValue("outlocationid", entry.get("outlocationid"), rowIndex);
            this.setValue("outstockstatusid", entry.get("outstockstatusid"), rowIndex);
            this.setValue("outstocktypeid", entry.get("outstocktypeid"), rowIndex);
            this.setValue("outownerid", entry.get("outownerid"), rowIndex);
            this.setValue("outownertype", entry.get("outownertype"), rowIndex);
            this.setValue("outkeeperid", entry.get("outkeeperid"), rowIndex);
            this.setValue("outkeepertype", entry.get("outkeepertype"), rowIndex);
            this.setValue("outprojectid", entry.get("outprojectid"), rowIndex);
            this.setValue("inwarehouseid", entry.get("inwarehouseid"), rowIndex);
            this.setValue("inlocationid", entry.get("inlocationid"), rowIndex);
            this.setValue("instockstatus", entry.get("instockstatus"), rowIndex);
            this.setValue("instocktype", entry.get("instocktype"), rowIndex);
            this.setValue("inownerid", entry.get("inownerid"), rowIndex);
            this.setValue("inownertype", entry.get("inownertype"), rowIndex);
            this.setValue("inkeeperid", entry.get("inkeeperid"), rowIndex);
            this.setValue("inkeepertype", entry.get("inkeepertype"), rowIndex);
            this.setValue("inprojectid", entry.get("inprojectid"), rowIndex);
            this.setValue("lotnumber", entry.get("lotnumber"), rowIndex);
            this.setValue("lotid", entry.get("lotid"), rowIndex);
            this.setValue("productdate", entry.get("productdate"), rowIndex);
            this.setValue("expiredate", entry.get("expiredate"), rowIndex);
            DynamicObject itemDynObj = this.getEntryF7Value("itementry", "itemid", rowIndex);
            if (itemDynObj != null) {
                this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex);
            }
            this.setValue("srcbillentity", entry.get("srcbillentity"), rowIndex);
            this.setValue("srcbillnumber", entry.get("srcbillnumber"), rowIndex);
            this.setValue("srcbillentryseq", entry.get("srcbillentryseq"), rowIndex);
            this.setValue("srcbillentryid", entry.get("srcbillentryid"), rowIndex);
            this.setValue("srcbillid", entry.get("srcbillid"), rowIndex);
            this.setValue("corebillentity", entry.get("corebillentity"), rowIndex);
            this.setValue("corebillnumber", entry.get("corebillnumber"), rowIndex);
            this.setValue("corebillentryseq", entry.get("corebillentryseq"), rowIndex);
            this.setValue("corebillid", entry.get("corebillid"), rowIndex);
            this.setValue("corebillentryid", entry.get("corebillentryid"), rowIndex);
            this.setValue("taxprice", entry.get("taxprice"), rowIndex);
            this.setValue("taxrateid", entry.get("taxrateid"), rowIndex);
            this.setValue("taxrate", entry.get("taxrate"), rowIndex);
            this.setValue("price", entry.get("price"), rowIndex);
            this.setValue("discount", entry.get("discount"), rowIndex);
            this.setValue("discounttype", entry.get("discounttype"), rowIndex);
            this.setValue("discountamount", entry.get("discountamount"), rowIndex);
            this.setValue("taxamount", entry.get("taxamount"), rowIndex);
            this.setValue("joinoutbaseqty", entry.get("joinoutbaseqty"), rowIndex);
            this.setValue("joininbaseqty", entry.get("joininbaseqty"), rowIndex);
            this.setValue("totaloutbaseqty", entry.get("totaloutbaseqty"), rowIndex);
            this.setValue("totalinbaseqty", entry.get("totalinbaseqty"), rowIndex);
            DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)subEntryEntity)) continue;
            JSONObject snJson = new JSONObject();
            boolean isFirstRow = true;
            for (DynamicObject subEntry : subEntryEntity) {
                String serialnumber = subEntry.getString("serialnumber");
                Object serialid = subEntry.getPkValue();
                snJson.put(serialnumber, serialid);
                if (!isFirstRow) continue;
                this.setValue("serialnumber", serialnumber, rowIndex);
                this.setValue("serialid", serialid, rowIndex);
                isFirstRow = false;
            }
            this.setValue("mulserialnumber", snJson, rowIndex);
            this.viewIndexSerialNumber(rowIndex);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        int rowIndex = e.getRow();
        this.viewIndexSerialNumber(rowIndex);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        switch (entryName = e.getEntryProp().getName()) {
            case "itementry": {
                int rowIndex = this.getCurrentRowIndex("itementry");
                this.viewIndexSerialNumber(rowIndex);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex("itementry");
        switch (key) {
            case "add": {
                this.addQty(index);
                break;
            }
            case "reduce": {
                this.reduceQty(index);
                break;
            }
            case "btnselectitem": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdbd_itemmobf7");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>(2);
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("itementry");
                List list = entryentity.stream().map(r -> r.getLong("itemid_id")).collect(Collectors.toList());
                hashMap.put("selected", list);
                List<Object> marketItemIds = this.getMarketItemIds();
                hashMap.put("ids", marketItemIds);
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnselectitem);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btnselectsn": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdma_transbill_sn");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
                DynamicObject rowEntry = this.getRowInfo("itementry", this.getCurrentRowIndex("itementry"));
                hashMap.put("itemid", rowEntry.getLong("itemid_id"));
                hashMap.put("unitid", rowEntry.getLong("unit_id"));
                DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
                hashMap.put("outchannelid", DynamicObjectUtils.getPkValue((DynamicObject)outchannel));
                hashMap.put("qty", rowEntry.getBigDecimal("approveqty"));
                hashMap.put("mulserialnumber", rowEntry.get("mulserialnumber"));
                hashMap.put("thumbnail", rowEntry.get("thumbnail"));
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnselectsn);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btnmore": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("ocdma_transbill_more");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(30);
                DynamicObject rowEntry = this.getRowInfo("itementry", this.getCurrentRowIndex("itementry"));
                DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
                hashMap.put("outchannelid", DynamicObjectUtils.getPkValue((DynamicObject)outchannel));
                hashMap.put("itemid", rowEntry.getLong("itemid_id"));
                hashMap.put("materialid", rowEntry.getLong("materialid_id"));
                hashMap.put("unitid", rowEntry.getLong("unit_id"));
                hashMap.put("qty", rowEntry.getBigDecimal("approveqty"));
                hashMap.put("thumbnail", rowEntry.get("thumbnail"));
                hashMap.put("auxptyid", rowEntry.get("auxptyid_id"));
                hashMap.put("lotnumber", rowEntry.get("lotnumber"));
                hashMap.put("lotid", rowEntry.get("lotid_id"));
                hashMap.put("productdate", rowEntry.get("productdate"));
                hashMap.put("expiredate", rowEntry.get("expiredate"));
                hashMap.put("outwarehouseid", rowEntry.get("outwarehouseid_id"));
                hashMap.put("outlocationid", rowEntry.get("outlocationid_id"));
                hashMap.put("outstocktypeid", rowEntry.get("outstocktypeid_id"));
                hashMap.put("outstockstatusid", rowEntry.get("outstockstatusid_id"));
                hashMap.put("outownertype", rowEntry.get("outownertype"));
                hashMap.put("outownerid", rowEntry.get("outownerid_id"));
                hashMap.put("outkeepertype", rowEntry.get("outkeepertype"));
                hashMap.put("outkeeperid", rowEntry.get("outkeeperid_id"));
                hashMap.put("outprojectid", rowEntry.get("outprojectid_id"));
                hashMap.put("inwarehouseid", rowEntry.get("inwarehouseid_id"));
                hashMap.put("inlocationid", rowEntry.get("inlocationid_id"));
                hashMap.put("instocktype", rowEntry.get("instocktype_id"));
                hashMap.put("instockstatus", rowEntry.get("instockstatus_id"));
                hashMap.put("inownertype", rowEntry.get("inownertype"));
                hashMap.put("inownerid", rowEntry.get("inownerid_id"));
                hashMap.put("inkeepertype", rowEntry.get("inkeepertype"));
                hashMap.put("inkeeperid", rowEntry.get("inkeeperid_id"));
                hashMap.put("inprojectid", rowEntry.get("inprojectid_id"));
                hashMap.put("id", rowEntry.get("id"));
                showParameter.setCustomParams(hashMap);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, btnmore);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "billtypeid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getTransbillTypeQfilter());
                break;
            }
            case "outchannelid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCommonOwnerFitler());
                break;
            }
            case "inchannelid": {
                if (this.isNullOutChannel()) {
                    e.setCancel(true);
                    return;
                }
                long outchannelid = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outchannelid"));
                Object transBillType = this.getValue("transbilltype");
                if ("0".equals(transBillType)) {
                    QFilter qFilter = new QFilter("id", "=", (Object)outchannelid);
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                    break;
                }
                Set<Long> channelIdSet = this.getUnderChannelIds();
                channelIdSet.remove(outchannelid);
                QFilter qFilter = new QFilter("id", "in", channelIdSet);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                break;
            }
            case "unit": {
                int rowIndex = e.getRow();
                this.setUnitIdF7Select(e, rowIndex);
                break;
            }
            case "outwarehouseid_h": 
            case "outwarehouseid": {
                if (this.isNullOutChannel()) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("ownerchannelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outchannelid"))));
                break;
            }
            case "inwarehouseid_h": 
            case "inwarehouseid": {
                if (this.isNullInChannel()) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("ownerchannelid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("inchannelid"))));
                break;
            }
            case "outlocationid": {
                int rowIndex = e.getRow();
                if (this.isNullOutWarehouse(rowIndex)) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("warehouseid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outwarehouseid", rowIndex))));
                break;
            }
            case "inlocationid": {
                int rowIndex = e.getRow();
                if (this.isNullInWarehouse(rowIndex)) {
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("warehouseid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("inwarehouseid", rowIndex))));
                break;
            }
        }
    }

    public QFilter getTransbillTypeQfilter() {
        HashSet<Long> bizTypeIdSet = new HashSet<Long>(10);
        QFilter qFilter = new QFilter("billformid", "=", (Object)"ococic_transbill");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        List billTypeList = QueryServiceHelper.queryPrimaryKeys((String)"bos_billtype", (QFilter[])qFilter.toArray(), null, (int)-1);
        List billTypeIdList = billTypeList.stream().map(r -> (Long)r).collect(Collectors.toList());
        for (Long billTypeId : billTypeIdList) {
            Object transbilltype = BillTypeParameterHelper.getBillTypeParameterValue((String)"ococic_transbill", (String)"ococic_transbill_btparam", (long)billTypeId, (String)"transbilltype");
            if (StringUtils.equals((CharSequence)String.valueOf(transbilltype), (CharSequence)"2")) continue;
            bizTypeIdSet.add(billTypeId);
        }
        if (CollectionUtils.isEmpty(bizTypeIdSet)) {
            return F7Utils.getEveFalseFilter();
        }
        return new QFilter("id", "in", bizTypeIdSet);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "saleorgid": {
                this.setSettleOrg((Long)this.getModel().getValue("saleorgid_id"));
                break;
            }
            case "billtypeid": {
                this.setBillTransBillType();
                break;
            }
            case "outchannelid": {
                DynamicObject channelDynObj = this.getF7Value("outchannelid");
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    this.setValue("outownerid", channelDynObj, i);
                    this.setValue("outkeeperid", channelDynObj, i);
                    this.setValue("outwarehouseid", null, i);
                }
                long settleCurrencyId = 0L;
                long saleOrgId = 0L;
                long stockId = 0L;
                long outChannelId = 0L;
                if (channelDynObj != null) {
                    outChannelId = channelDynObj.getLong("id");
                    settleCurrencyId = channelDynObj.getLong("currency_id");
                    saleOrgId = channelDynObj.getLong("saleorg_id");
                    stockId = ChannelHelper.getChannelDefaultDeliveryStockId((long)outChannelId, (boolean)false, (boolean)true, (boolean)false);
                }
                this.setValue("settlecurrencyid", settleCurrencyId);
                this.setValue("outwarehouseid_h", stockId == 0L ? null : Long.valueOf(stockId));
                this.setValue("saleorgid", saleOrgId);
                this.setTransBillChannel();
                break;
            }
            case "inchannelid": {
                DynamicObject inChannelDynObj = this.getF7Value("inchannelid");
                long inStockId = 0L;
                if (inChannelDynObj != null) {
                    inStockId = ChannelHelper.getChannelDefaultDeliveryStockId((long)inChannelDynObj.getLong("id"), (boolean)true, (boolean)false, (boolean)false);
                }
                this.setValue("inwarehouseid_h", inStockId == 0L ? null : Long.valueOf(inStockId));
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    this.setValue("inownerid", inChannelDynObj, i);
                    this.setValue("inkeeperid", inChannelDynObj, i);
                    this.setValue("inwarehouseid", inStockId == 0L ? null : Long.valueOf(inStockId), i);
                }
                this.setTransBillChannel();
                break;
            }
            case "outwarehouseid_h": 
            case "inwarehouseid_h": {
                this.batchSetEntryWarehouseId();
                break;
            }
            case "outwarehouseid": {
                this.setValue("outlocationid", null, rowIndex);
                break;
            }
            case "inwarehouseid": {
                this.setValue("inlocationid", null, rowIndex);
                break;
            }
            case "transbilldriver": {
                this.setTransBillChannel();
                break;
            }
            case "itemid": {
                this.itemidValueChanged(rowIndex);
                break;
            }
            case "approveqty": {
                this.qtyValueChanged(rowIndex);
                break;
            }
            case "serialid": {
                this.serialidValueChanged(rowIndex);
                break;
            }
            default: {
                if (!key.startsWith("$$") || !key.split("__")[0].equals("$$auxptyid")) break;
                this.getAuxptyId();
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String customKey = e.getKey();
        if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"callappmethod")) {
            Map result;
            String scanQRCode;
            boolean isAddSuccess;
            if (StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)op_scanqrcode) && (isAddSuccess = this.scanFillItemEntry(scanQRCode = CommonUtils.convertObjectToString((result = (Map)SerializationUtils.fromJsonString((String)value, Map.class)).get("qrcode_str"))))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(op_scanqrcode, (IFormPlugin)this);
                this.getView().showConfirm("\u626b\u7801\u6210\u529f\uff0c\u7ee7\u7eed\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)customKey.toLowerCase(), (CharSequence)"wxscanqrcode") && StringUtils.equals((CharSequence)eventName.toLowerCase(), (CharSequence)"scancode")) {
            JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)value, JSONObject.class);
            String qrCode = CommonUtils.convertObjectToString((Object)result.get((Object)"value"));
            this.scanFillItemEntry(qrCode);
        }
    }

    private boolean scanFillItemEntry(String scanQRCode) {
        DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
        DynamicObject outwarehouseid = (DynamicObject)this.getValue("outwarehouseid_h");
        long outchannelid = DynamicObjectUtils.getPkValue((DynamicObject)outchannel);
        JSONObject data = this.scanQRCode(scanQRCode, outchannelid);
        if (data == null) {
            this.getView().showTipNotification("\u83b7\u53d6\u5e8f\u5217\u53f7\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return false;
        }
        JSONArray dataArray = data.getJSONArray("data");
        if (dataArray == null || dataArray.isEmpty()) {
            this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u4e0d\u5b58\u5728\u6216\u975e\u5728\u5e93\u72b6\u6001", scanQRCode));
            return false;
        }
        JSONObject itemJson = (JSONObject)dataArray.get(0);
        boolean enableSerial = itemJson.getBoolean("enableserial");
        String serialNo = itemJson.getString("serialno");
        long serialId = itemJson.getLong("serialid");
        long itemid = itemJson.getLong("itemid");
        StringBuilder scanBuilder = new StringBuilder();
        scanBuilder.append(itemJson.getLong("itemid"));
        scanBuilder.append(itemJson.getLong("auxptyid"));
        scanBuilder.append(itemJson.getString("lotnum"));
        scanBuilder.append(itemJson.getLong("channelstockid"));
        scanBuilder.append(itemJson.getLong("channellocationid"));
        scanBuilder.append(itemJson.getLong("retailunit"));
        scanBuilder.append(itemJson.getLong("channelstockstatusid"));
        scanBuilder.append(itemJson.getLong("channelstocktypeid"));
        scanBuilder.append(itemJson.getString("keepertype"));
        scanBuilder.append(itemJson.getLong("keeperid"));
        scanBuilder.append(itemJson.getString("ownertype"));
        scanBuilder.append(itemJson.getLong("ownerid"));
        scanBuilder.append(itemJson.getDate("productdate"));
        scanBuilder.append(itemJson.getDate("effectivedate"));
        scanBuilder.append(itemJson.getLong("projectid"));
        String scanKey = scanBuilder.toString();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
        int rowIndex = 0;
        for (DynamicObject entry : entryColl) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getLong("itemid_id"));
            sb.append(entry.getLong("auxptyid_id"));
            sb.append(entry.getString("lotnumber"));
            sb.append(entry.getLong("outwarehouseid_id"));
            sb.append(entry.getLong("outlocationid_id"));
            sb.append(entry.getLong("unit_id"));
            sb.append(entry.getLong("outstockstatusid_id"));
            sb.append(entry.getLong("outstocktypeid_id"));
            sb.append(entry.getString("outkeepertype"));
            sb.append(entry.getLong("outkeeperid_id"));
            sb.append(entry.getString("outownertype"));
            sb.append(entry.getLong("outownerid_id"));
            sb.append(entry.getDate("productdate"));
            sb.append(entry.getDate("expiredate"));
            sb.append(entry.getLong("outprojectid_id"));
            if (StringUtils.equals((CharSequence)scanKey, (CharSequence)sb.toString())) {
                if (enableSerial) {
                    JSONObject snJson = JSONObject.parseObject((String)entry.getString("mulserialnumber"));
                    if (snJson != null && snJson.containsKey((Object)serialNo)) {
                        this.getView().showTipNotification(String.format("\u5e8f\u5217\u53f7\u3010%s\u3011\u5728\u7b2c%d\u884c\u5df2\u5b58\u5728\u3002", serialNo, rowIndex + 1));
                        return false;
                    }
                    this.updateSerialNumberFields(serialNo, serialId, rowIndex);
                    return true;
                }
                this.getView().showTipNotification(String.format("\u5546\u54c1\u5728\u7b2c%d\u884c\u5df2\u5b58\u5728\u3002", rowIndex + 1));
                return false;
            }
            ++rowIndex;
        }
        DynamicObject inchannel = (DynamicObject)this.getValue("inchannelid");
        DynamicObject inwarehouseid = (DynamicObject)this.getValue("inwarehouseid_h");
        rowIndex = this.getModel().createNewEntryRow("itementry");
        this.setValue("itemid", itemid, rowIndex);
        this.setValue("approveqty", BigDecimal.ONE, rowIndex);
        this.setValue("outwarehouseid", outwarehouseid, rowIndex);
        this.setValue("outownerid", outchannel, rowIndex);
        this.setValue("outkeeperid", outchannel, rowIndex);
        this.setValue("inwarehouseid", inwarehouseid, rowIndex);
        this.setValue("inownerid", inchannel, rowIndex);
        this.setValue("inkeeperid", inchannel, rowIndex);
        if (enableSerial) {
            JSONObject snJson = new JSONObject();
            snJson.put(serialNo, (Object)serialId);
            this.setValue("serialid", serialId, rowIndex);
            this.setValue("serialnumber", serialNo, rowIndex);
            this.setValue("mulserialnumber", snJson, rowIndex);
            this.viewIndexSerialNumber(rowIndex);
        }
        return true;
    }

    private void updateSerialNumberFields(String serialNo, Object serialId, int rowIndex) {
        Object serialnumber;
        JSONObject snJson = JSONObject.parseObject((String)String.valueOf(this.getValue("mulserialnumber", rowIndex)));
        if (snJson == null) {
            snJson = new JSONObject();
        }
        if (ObjectUtils.isEmpty((Object)(serialnumber = this.getValue("serialnumber")))) {
            this.setValue("serialid", serialId, rowIndex);
            this.setValue("serialnumber", serialNo, rowIndex);
        }
        snJson.put(serialNo, serialId);
        this.setValue("approveqty", snJson.size(), rowIndex);
        this.setValue("mulserialnumber", snJson, rowIndex);
        this.viewIndexSerialNumber(rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "save": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                long billid = Long.parseLong(String.valueOf(this.getValue("id")));
                this.saveBill(billid);
                break;
            }
            case "submit": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                this.submitBill();
                break;
            }
            case "trans": {
                boolean result = e.getOperationResult().isSuccess();
                if (!result) break;
                this.auditBill();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (key) {
            case "btnselectitem": {
                Object[] selectIds = (Object[])returnData;
                if (selectIds == null || selectIds.length == 0) {
                    return;
                }
                DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
                DynamicObject inChannelDynObj = this.getF7Value("inchannelid");
                for (Object itemId : selectIds) {
                    int rowIndex = this.getModel().createNewEntryRow("itementry");
                    this.setValue("itemid", itemId, rowIndex);
                    this.setValue("approveqty", BigDecimal.ONE, rowIndex);
                    this.setValue("outownerid", outchannel, rowIndex);
                    this.setValue("outkeeperid", outchannel, rowIndex);
                    this.setValue("inownerid", inChannelDynObj, rowIndex);
                    this.setValue("inkeeperid", inChannelDynObj, rowIndex);
                    this.setEntryWarehouseId(rowIndex);
                }
                break;
            }
            case "btnselectsn": {
                JSONObject snJson = JSONObject.parseObject((String)String.valueOf(returnData));
                int rowIndex = this.getCurrentRowIndex("itementry");
                long serialid = 0L;
                String serialnumber = "";
                if (snJson != null) {
                    Set snNumbers = snJson.entrySet();
                    for (Map.Entry entry : snNumbers) {
                        serialid = Long.parseLong(String.valueOf(entry.getValue()));
                        serialnumber = (String)entry.getKey();
                        if (serialid <= 0L) continue;
                        break;
                    }
                    this.setValue("approveqty", snNumbers.size(), rowIndex);
                }
                this.setValue("serialid", serialid, rowIndex);
                this.setValue("serialnumber", serialnumber, rowIndex);
                this.setValue("mulserialnumber", snJson, rowIndex);
                this.viewIndexSerialNumber(rowIndex);
                break;
            }
            case "btnmore": {
                JSONObject resultJson = JSONObject.parseObject((String)String.valueOf(returnData));
                int rowIndex = this.getCurrentRowIndex("itementry");
                this.setValue("auxptyid", resultJson.get((Object)"auxptyid"), rowIndex);
                this.setValue("lotnumber", resultJson.get((Object)"lotnumber"), rowIndex);
                this.setValue("lotid", resultJson.get((Object)"lotid"), rowIndex);
                this.setValue("productdate", resultJson.getDate("productdate"), rowIndex);
                this.setValue("expiredate", resultJson.getDate("expiredate"), rowIndex);
                this.setValue("outwarehouseid", resultJson.get((Object)"outwarehouseid"), rowIndex);
                this.setValue("outlocationid", resultJson.get((Object)"outlocationid"), rowIndex);
                this.setValue("outstocktypeid", resultJson.get((Object)"outstocktypeid"), rowIndex);
                this.setValue("outstockstatusid", resultJson.get((Object)"outstockstatusid"), rowIndex);
                this.setValue("outownertype", resultJson.get((Object)"outownertype"), rowIndex);
                this.setValue("outownerid", resultJson.get((Object)"outownerid"), rowIndex);
                this.setValue("outkeepertype", resultJson.get((Object)"outkeepertype"), rowIndex);
                this.setValue("outkeeperid", resultJson.get((Object)"outkeeperid"), rowIndex);
                this.setValue("outprojectid", resultJson.get((Object)"outprojectid"), rowIndex);
                this.setValue("inwarehouseid", resultJson.get((Object)"inwarehouseid"), rowIndex);
                this.setValue("inlocationid", resultJson.get((Object)"inlocationid"), rowIndex);
                this.setValue("instocktype", resultJson.get((Object)"instocktype"), rowIndex);
                this.setValue("instockstatus", resultJson.get((Object)"instockstatus"), rowIndex);
                this.setValue("inownertype", resultJson.get((Object)"inownertype"), rowIndex);
                this.setValue("inownerid", resultJson.get((Object)"inownerid"), rowIndex);
                this.setValue("inkeepertype", resultJson.get((Object)"inkeepertype"), rowIndex);
                this.setValue("inkeeperid", resultJson.get((Object)"inkeeperid"), rowIndex);
                this.setValue("inprojectid", resultJson.get((Object)"inprojectid"), rowIndex);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "scanqrcode": {
                this.getView().invokeOperation(op_scanqrcode);
                break;
            }
        }
    }

    private JSONObject scanQRCode(String serialNo, long channelId) {
        if (StringUtils.isNotEmpty((CharSequence)serialNo) && channelId > 0L) {
            return CSerialHelper.getSerialDataByNumber(Collections.singletonList(serialNo), (Long)channelId, (String)SnStatusEnum.INSTOCK.getValue());
        }
        return null;
    }

    private void viewIndexSerialNumber(int rowIndex) {
        JSONObject snJson;
        StringBuilder sb = new StringBuilder();
        if (rowIndex >= 0 && (snJson = JSONObject.parseObject((String)String.valueOf(this.getValue("mulserialnumber", rowIndex)))) != null) {
            Set snNumbers = snJson.keySet();
            for (String snNumber : snNumbers) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(snNumber);
            }
        }
        this.setValue("viewserialnumber", sb.toString());
    }

    private void submitBill() {
        long billid = Long.parseLong(String.valueOf(this.getValue("id")));
        this.saveBill(billid);
        billid = Long.parseLong(String.valueOf(this.getValue("id")));
        if (billid > 0L) {
            OperateOption option;
            Object[] objectIds = new Object[]{billid};
            OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_transbill", (Object[])objectIds, (OperateOption)(option = CommonUtils.getOperateOption()));
            if (!result.isSuccess()) {
                this.getView().showOperationResult(result);
            } else {
                this.setValue("billstatus", "B");
            }
        }
        this.getPageCache().put("nextsubmittime", "0");
    }

    private void auditBill() {
        long billid = Long.parseLong(String.valueOf(this.getValue("id")));
        if (billid == 0L) {
            this.saveBill(billid);
        }
        if ((billid = Long.parseLong(String.valueOf(this.getValue("id")))) > 0L) {
            String billstatus;
            Object[] objectIds = new Object[]{billid};
            OperateOption option = CommonUtils.getOperateOption();
            switch (billstatus = String.valueOf(this.getValue("billstatus"))) {
                case "A": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ococic_transbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                        break;
                    }
                    this.setValue("billstatus", "B");
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_transbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                    } else {
                        this.setValue("billstatus", "C");
                    }
                    result = OperationServiceHelper.executeOperate((String)"confirmpush", (String)"ococic_transbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                        break;
                    }
                    this.getView().showSuccessNotification("\u4e00\u952e\u8c03\u62e8\u6210\u529f");
                    break;
                }
                case "B": {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ococic_transbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                        return;
                    }
                    this.setValue("billstatus", "C");
                    result = OperationServiceHelper.executeOperate((String)"confirmpush", (String)"ococic_transbill", (Object[])objectIds, (OperateOption)option);
                    if (!result.isSuccess()) {
                        this.getView().showOperationResult(result);
                        break;
                    }
                    this.getView().showSuccessNotification("\u4e00\u952e\u8c03\u62e8\u6210\u529f");
                    break;
                }
            }
        }
        this.getPageCache().put("nextsubmittime", "0");
    }

    private void saveBill(long billid) {
        DynamicObject bill = null;
        BigDecimal sumqty = BigDecimal.ZERO;
        if (billid == 0L) {
            bill = BusinessDataServiceHelper.newDynamicObject((String)"ococic_transbill");
            bill.set("creator", (Object)UserUtil.getUserInfo());
            bill.set("billstatus", (Object)"A");
        } else {
            bill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"ococic_transbill");
            this.setValue("billstatus", bill.getString("billstatus"));
        }
        bill.set("billno", this.getValue("billno"));
        bill.set("billtypeid", this.getValue("billtypeid"));
        bill.set("outchannelid", this.getValue("outchannelid"));
        bill.set("outwarehouseid_h", this.getValue("outwarehouseid_h"));
        bill.set("inchannelid", this.getValue("inchannelid"));
        bill.set("inwarehouseid_h", this.getValue("inwarehouseid_h"));
        bill.set("settleorgid", this.getValue("settleorgid"));
        bill.set("saleorgid", this.getValue("saleorgid"));
        bill.set("transbilltype", this.getValue("transbilltype"));
        bill.set("transbilldriver", this.getValue("transbilldriver"));
        bill.set("transmode", this.getValue("transmode"));
        bill.set("bizdate", this.getValue("bizdate"));
        bill.set("transbillchannelid", this.getValue("transbillchannelid"));
        bill.set("basecurrencyid", this.getValue("basecurrencyid"));
        bill.set("exchangeratetable", this.getValue("exchangeratetable"));
        bill.set("exchangerate", this.getValue("exchangerate"));
        bill.set("exratedate", this.getValue("exratedate"));
        bill.set("settlecurrencyid", this.getValue("settlecurrencyid"));
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("itementry");
        entryEntity.clear();
        DynamicObjectCollection mobEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
        if (CollectionUtils.isEmpty((Collection)mobEntryEntity)) {
            this.getView().showTipNotification("\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return;
        }
        long outChannelId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)this.getValue("outchannelid")));
        int seq = 0;
        for (DynamicObject mobEntry : mobEntryEntity) {
            ++seq;
            DynamicObject item = mobEntry.getDynamicObject("itemid");
            if (item == null) {
                this.getView().showTipNotification("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return;
            }
            BigDecimal serialqty = mobEntry.getBigDecimal("serialqty");
            BigDecimal qty = mobEntry.getBigDecimal("approveqty");
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", seq));
                return;
            }
            sumqty = sumqty.add(qty);
            DynamicObject entry = entryEntity.addNew();
            entry.set("materialid", mobEntry.get("materialid"));
            entry.set("itemid", (Object)item);
            entry.set("unit", mobEntry.get("unit"));
            entry.set("auxptyid", mobEntry.get("auxptyid"));
            entry.set("assistunitid", mobEntry.get("assistunitid"));
            entry.set("approveqty", (Object)qty);
            entry.set("baseunit", mobEntry.get("baseunit"));
            entry.set("approvebaseqty", mobEntry.get("approvebaseqty"));
            entry.set("serialqty", (Object)serialqty);
            entry.set("serialunitid", mobEntry.get("serialunitid"));
            entry.set("outwarehouseid", mobEntry.get("outwarehouseid"));
            entry.set("outlocationid", mobEntry.get("outlocationid"));
            entry.set("outstockstatusid", mobEntry.get("outstockstatusid"));
            entry.set("outstocktypeid", mobEntry.get("outstocktypeid"));
            entry.set("outownerid", mobEntry.get("outownerid"));
            entry.set("outownertype", mobEntry.get("outownertype"));
            entry.set("outkeeperid", mobEntry.get("outkeeperid"));
            entry.set("outkeepertype", mobEntry.get("outkeepertype"));
            entry.set("outprojectid", mobEntry.get("outprojectid"));
            entry.set("inwarehouseid", mobEntry.get("inwarehouseid"));
            entry.set("inlocationid", mobEntry.get("inlocationid"));
            entry.set("instockstatus", mobEntry.get("instockstatus"));
            entry.set("instocktype", mobEntry.get("instocktype"));
            entry.set("inownerid", mobEntry.get("inownerid"));
            entry.set("inownertype", mobEntry.get("inownertype"));
            entry.set("inkeeperid", mobEntry.get("inkeeperid"));
            entry.set("inkeepertype", mobEntry.get("inkeepertype"));
            entry.set("inprojectid", mobEntry.get("inprojectid"));
            entry.set("lotnumber", mobEntry.get("lotnumber"));
            entry.set("lotid", mobEntry.get("lotid"));
            entry.set("productdate", mobEntry.get("productdate"));
            entry.set("expiredate", mobEntry.get("expiredate"));
            boolean enableserial = item.getBoolean("enableserial");
            boolean isNotControlSN = ChannelUtil.queryChannelIsNotControlSN((long)outChannelId);
            if (!enableserial || isNotControlSN) continue;
            String serialnumber = mobEntry.getString("serialnumber");
            if (StringUtils.isEmpty((CharSequence)serialnumber)) {
                this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u5df2\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u5e8f\u5217\u53f7\u5fc5\u5f55\u3002", seq));
                return;
            }
            if (serialqty.compareTo(BigDecimal.ONE) == 0) {
                DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
                DynamicObject subEntry = subentryentity.addNew();
                subEntry.set("serialid", mobEntry.get("serialid"));
                subEntry.set("serialnumber", (Object)serialnumber);
                continue;
            }
            if (serialqty.compareTo(BigDecimal.ONE) <= 0) continue;
            JSONObject snJson = JSONObject.parseObject((String)mobEntry.getString("mulserialnumber"));
            if (snJson == null || serialqty.intValue() != snJson.size()) {
                this.getView().showTipNotification(String.format("\u7b2c%d\u884c\u5546\u54c1\u5e8f\u5217\u53f7\u6570\u91cf\u548c\u5e8f\u5217\u53f7\u6761\u6570\u4e0d\u4e00\u81f4\u3002", seq));
                return;
            }
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
            if (snJson == null) continue;
            Set snNumbers = snJson.entrySet();
            for (Map.Entry snEntry : snNumbers) {
                DynamicObject subEntry = subentryentity.addNew();
                Object snId = snEntry.getValue();
                if (ObjectUtils.isEmpty(snId)) {
                    subEntry.set("serialid", null);
                } else {
                    DynamicObject snObject = BusinessDataServiceHelper.loadSingle(snId, (String)"ococic_snmainfile");
                    subEntry.set("serialid", (Object)snObject);
                }
                subEntry.set("serialid_id", snEntry.getValue());
                subEntry.set("serialnumber", snEntry.getKey());
            }
        }
        bill.set("sumqty", (Object)sumqty);
        OperateOption saveOption = CommonUtils.getOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)op_save, (String)"ococic_transbill", (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)saveOption);
        if (!result.isSuccess()) {
            this.getView().showOperationResult(result);
        }
        this.setValue("id", bill.getPkValue());
        this.setValue("billno", bill.getString("billno"));
    }

    private void initNewBillHead() {
        this.setBillTransBillType();
        this.setValue("billtypedata", this.getF7Value("billtypeid"));
        long channelId = this.getChannelId();
        this.setValue("outchannelid", channelId);
        DynamicObject outchannel = (DynamicObject)this.getValue("outchannelid");
        DynamicObject saleorg = outchannel.getDynamicObject("saleorg");
        this.setValue("saleorgid", saleorg);
        this.setSettleOrg(DynamicObjectUtils.getPkValue((DynamicObject)outchannel, (String)"saleorg"));
        this.setValue("exratedate", DateUtil.getNowDate());
        this.setValue("settlecurrencyid", DynamicObjectUtils.getPkValue((DynamicObject)outchannel, (String)"currency"));
        this.setValue("billstatus", "A");
        if (channelId > 0L) {
            long stockId = ChannelHelper.getChannelDefaultDeliveryStockId((long)channelId, (boolean)false, (boolean)true, (boolean)false);
            this.setValue("outwarehouseid_h", stockId == 0L ? null : Long.valueOf(stockId));
        }
        this.setTransBillChannel();
    }

    private long getAuxptyId() {
        FlexEdit flexEdit = (FlexEdit)this.getControl("auxptyid");
        IDataModel flexModel = flexEdit.getFlexModel();
        DynamicObject dataEntity = flexModel.getDataEntity();
        MainEntityType dataEntityType = flexModel.getDataEntityType();
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData(dataEntityType, dataEntity);
        long id = FlexService.saveFlexData((MainEntityType)dataEntityType, (FlexEntireData)flexEntireData);
        this.setValue("auxptyid", id, this.getCurrentRowIndex("itementry"));
        return id;
    }

    private long getChannelId() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String cacheChannelId = parentPageCache.get("channelId");
        long channelId = cacheChannelId != null ? Long.parseLong(cacheChannelId) : B2BUserHelper.getLoginChannelId();
        return channelId;
    }

    protected void addQty(int index) {
        Object qtyObj = this.getModel().getValue("approveqty", index);
        BigDecimal qty = qtyObj == null ? BigDecimal.ZERO : (BigDecimal)qtyObj;
        BigDecimal newQty = qty.add(BigDecimal.ONE);
        this.getModel().setValue("approveqty", (Object)newQty, index);
    }

    protected void reduceQty(int index) {
        Object qtyObj = this.getModel().getValue("approveqty", index);
        BigDecimal qty = qtyObj == null ? BigDecimal.ZERO : (BigDecimal)qtyObj;
        BigDecimal newQty = qty.subtract(BigDecimal.ONE);
        if (newQty.compareTo(BigDecimal.ZERO) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue("approveqty", (Object)newQty, index);
    }

    private void itemidValueChanged(int rowIndex) {
        DynamicObject itemDynObj = this.getEntryF7Value("itementry", "itemid", rowIndex);
        DynamicObject material = null;
        DynamicObject stockunit = null;
        DynamicObject baseunit = null;
        DynamicObject serialunit = null;
        DynamicObject assistunit = null;
        Object thumbnail = null;
        if (itemDynObj != null) {
            material = itemDynObj.getDynamicObject("material");
            stockunit = itemDynObj.getDynamicObject("stockunit");
            baseunit = itemDynObj.getDynamicObject("baseunit");
            serialunit = itemDynObj.getDynamicObject("serialunit");
            assistunit = itemDynObj.getDynamicObject("assistunit");
            thumbnail = itemDynObj.get("thumbnail");
        }
        this.setValue("materialid", material, rowIndex);
        this.setValue("unit", stockunit, rowIndex);
        this.setValue("baseunit", baseunit, rowIndex);
        this.setValue("serialunitid", serialunit, rowIndex);
        this.setValue("assistunitid", assistunit, rowIndex);
        this.setValue("thumbnail", thumbnail, rowIndex);
        this.triggerChangeEvent = true;
    }

    private void qtyValueChanged(int rowIndex) {
        DynamicObject rowEntry = this.getRowInfo("itementry", rowIndex);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"materialid");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"unit");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"baseunit");
        long serialunitId = DynamicObjectUtils.getPkValue((DynamicObject)rowEntry, (String)"serialunitid");
        BigDecimal qty = (BigDecimal)this.getValue("approveqty", rowIndex);
        BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
        BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)serialunitId);
        this.setValue("approvebaseqty", baseQty, rowIndex);
        this.setValue("serialqty", serialQty, rowIndex);
        this.triggerChangeEvent = true;
    }

    private void batchSetEntryWarehouseId() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("itementry");
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            this.setEntryWarehouseId(i);
        }
    }

    private void setEntryWarehouseId(int rowIndex) {
        Object outWarehouseId = this.getF7PKValue("outwarehouseid_h");
        Object inWarehouseId = this.getF7PKValue("inwarehouseid_h");
        if (this.getF7PKValue("outwarehouseid", rowIndex) == null) {
            this.setValue("outwarehouseid", outWarehouseId, rowIndex);
        }
        if (this.getF7PKValue("inwarehouseid", rowIndex) == null) {
            this.setValue("inwarehouseid", inWarehouseId, rowIndex);
        }
    }

    private void setSettleOrg(long saleOrgId) {
        Map map;
        Object settleorgId = null;
        if (saleOrgId != 0L && !CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            settleorgId = map.get("id");
        }
        this.setValue("settleorgid", settleorgId);
        this.setExRateTable();
    }

    private void setExRateTable() {
        DynamicObject settleOrgDynObj = this.getF7Value("settleorgid");
        long exratetableId = 0L;
        long basecurrrencyId = 0L;
        DynamicObject accountingSysDynObj = SaleOrderBusinessHelper.getAccountingSysbase((long)DynamicObjectUtils.getPkValue((DynamicObject)settleOrgDynObj));
        if (accountingSysDynObj != null) {
            exratetableId = accountingSysDynObj.getLong("exratetable");
            basecurrrencyId = accountingSysDynObj.getLong("basecurrrency");
        }
        long settleCurId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("settlecurrencyid"));
        BigDecimal exchangeRate = SaleOrderBusinessHelper.getExchangeRate((long)settleCurId, (long)basecurrrencyId, (long)exratetableId, (Date)((Date)this.getModel().getValue("bizdate")));
        this.setValue("exchangeratetable", exratetableId > 0L ? Long.valueOf(exratetableId) : null);
        this.setValue("exchangerate", exchangeRate);
        this.setValue("basecurrencyid", basecurrrencyId > 0L ? Long.valueOf(basecurrrencyId) : null);
    }

    private void serialidValueChanged(int rowIndex) {
        DynamicObject serialDynObj = this.getEntryF7Value("itementry", "serialid", rowIndex);
        DynamicObject lotid = null;
        String lotnum = "";
        Date productdate = null;
        Date effectivedate = null;
        String ownertype = "";
        DynamicObject ownerid = null;
        String keepertype = "";
        DynamicObject keeperid = null;
        DynamicObject auxptyid = null;
        DynamicObject channelstocktypeid = null;
        DynamicObject channelstockstatusid = null;
        DynamicObject channelstockid = null;
        DynamicObject channellocationid = null;
        if (serialDynObj != null) {
            lotid = serialDynObj.getDynamicObject("lotid");
            lotnum = serialDynObj.getString("lotnum");
            productdate = serialDynObj.getDate("productdate");
            effectivedate = serialDynObj.getDate("effectivedate");
            ownertype = serialDynObj.getString("ownertype");
            ownerid = serialDynObj.getDynamicObject("ownerid");
            keepertype = serialDynObj.getString("keepertype");
            keeperid = serialDynObj.getDynamicObject("keeperid");
            auxptyid = serialDynObj.getDynamicObject("auxptyid");
            channelstocktypeid = serialDynObj.getDynamicObject("channelstocktypeid");
            channelstockstatusid = serialDynObj.getDynamicObject("channelstockstatusid");
            channelstockid = serialDynObj.getDynamicObject("channelstockid");
            channellocationid = serialDynObj.getDynamicObject("channellocationid");
        }
        this.setValue("lotid", lotid, rowIndex);
        this.setValue("lotnumber", lotnum, rowIndex);
        this.setValue("productdate", productdate, rowIndex);
        this.setValue("expiredate", effectivedate, rowIndex);
        this.setValue("outownertype", ownertype, rowIndex);
        this.setValue("outownerid", ownerid, rowIndex);
        this.setValue("outkeepertype", keepertype, rowIndex);
        this.setValue("outkeeperid", keeperid, rowIndex);
        this.setValue("auxptyid", auxptyid, rowIndex);
        this.setValue("outstocktypeid", channelstocktypeid, rowIndex);
        this.setValue("outstockstatusid", channelstockstatusid, rowIndex);
        this.setValue("outwarehouseid", channelstockid, rowIndex);
        this.setValue("outlocationid", channellocationid, rowIndex);
        this.triggerChangeEvent = true;
    }

    private List<Object> getMarketItemIds() {
        List<QFilter> filters = this.getItemFilter();
        return QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_iteminfo", (QFilter[])filters.toArray(new QFilter[filters.size()]), null, (int)99999);
    }

    private QFilter getCommonOwnerFitler() {
        return CUserHelper.getAuthorizedChannelFilter();
    }

    private boolean isNullInChannel() {
        DynamicObject dynObj = this.getF7Value("inchannelid");
        if (dynObj == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8c03\u5165\u6e20\u9053\u3002");
            return true;
        }
        return false;
    }

    public boolean isNullOutChannel() {
        DynamicObject dynObj = this.getF7Value("outchannelid");
        if (dynObj == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8c03\u51fa\u6e20\u9053\u3002");
            return true;
        }
        return false;
    }

    private void setUnitIdF7Select(BeforeF7SelectEvent e, int rowIndex) {
        if (this.isNullItemId(rowIndex)) {
            e.setCancel(true);
            return;
        }
        Object materialId = this.getF7PKValue("materialid", rowIndex);
        Object baseUnitId = this.getF7PKValue("baseunit", rowIndex);
        List fixconunitlist = QueryUtil.getAssistMUListResult((Long)(materialId == null ? Long.valueOf(0L) : Long.valueOf(materialId.toString())), (Long)(baseUnitId == null ? Long.valueOf(0L) : Long.valueOf(baseUnitId.toString())), (String)"1");
        QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)fixconFilter);
    }

    private boolean isNullItemId(int rowIndex) {
        DynamicObject dynObj = this.getF7Value("itemid", rowIndex);
        if (dynObj == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u7f16\u7801\u3002");
            return true;
        }
        return false;
    }

    private boolean isNullOutWarehouse(int rowIndex) {
        DynamicObject dynObj = this.getF7Value("outwarehouseid", rowIndex);
        if (dynObj == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8c03\u51fa\u4ed3\u5e93\u3002");
            return true;
        }
        return false;
    }

    private boolean isNullInWarehouse(int rowIndex) {
        DynamicObject dynObj = this.getF7Value("inwarehouseid", rowIndex);
        if (dynObj == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8c03\u5165\u4ed3\u5e93\u3002");
            return true;
        }
        return false;
    }

    private List<QFilter> getItemFilter() {
        long channelId;
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("saleorgid"));
        ArrayList<QFilter> allQFilters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)0L, (long)(channelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("outchannelid"))));
        if (allQFilters == null) {
            allQFilters = new ArrayList<QFilter>(1);
            allQFilters.add(new QFilter("id", "=", (Object)0));
        }
        return allQFilters;
    }

    private Set<Long> getUnderChannelIds() {
        List channelIdList = CUserHelper.getAuthorizedChannelIdList();
        long transChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("transbillchannelid"));
        channelIdList.add(transChannelId);
        channelIdList.remove(0L);
        QFilter qFilter = new QFilter("id", "in", (Object)channelIdList);
        DynamicObjectCollection channels = QueryServiceHelper.query((String)"ocdbd_channel", (String)"longid", (QFilter[])qFilter.toArray());
        List channelLongIds = channels.stream().map(r -> r.getString("longid")).collect(Collectors.toList());
        QFilter underFilter = null;
        int count = 0;
        HashSet<Long> channelIdSet = new HashSet<Long>(0);
        channelIdSet.addAll(channelIdList);
        for (String channelLongId : channelLongIds) {
            if (underFilter == null) {
                underFilter = new QFilter("longid", "like", (Object)(channelLongId + ".%"));
            } else {
                underFilter.or("longid", "like", (Object)(channelLongId + ".%"));
            }
            if (count++ < 100) continue;
            List underchannelIdList = QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_channel", (QFilter[])underFilter.toArray(), null, (int)-1);
            Set underChannelIdList = underchannelIdList.stream().map(r -> (Long)r).collect(Collectors.toSet());
            channelIdSet.addAll(underChannelIdList);
            count = 0;
            underFilter = null;
        }
        if (underFilter != null) {
            List underchannelIdList = QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_channel", (QFilter[])underFilter.toArray(), null, (int)-1);
            Set underChannelIdList = underchannelIdList.stream().map(r -> (Long)r).collect(Collectors.toSet());
            channelIdSet.addAll(underChannelIdList);
        }
        return channelIdSet;
    }

    private void setBillTransBillType() {
        DynamicObject billTypeParam;
        DynamicObject billType = this.getF7Value("billtypeid");
        if (null != billType && (billTypeParam = BillTypeParameterHelper.getBillTypeParameterByConstants((String)"ococic_transbill", (long)billType.getLong("id"))) != null) {
            String transbillDriver;
            DynamicObject datasources;
            String transmode;
            String businesstype = billTypeParam.getString("transbilltype");
            if (businesstype != null) {
                this.setValue("transbilltype", businesstype);
                if (!"0".equals(businesstype)) {
                    this.setValue("inchannelid", null);
                }
            }
            if ((transmode = billTypeParam.getString("transmode")) != null) {
                this.setValue("transmode", transmode);
            }
            if ((datasources = billTypeParam.getDynamicObject("datasources")) != null) {
                this.setValue("datasources", datasources);
            }
            if (StringUtils.isNotBlank((CharSequence)(transbillDriver = billTypeParam.getString("transbilldriver")))) {
                this.setValue("transbilldriver", transbillDriver);
            }
        }
    }

    private void setTransBillChannel() {
        String transbillDriver = (String)this.getModel().getValue("transbilldriver");
        long transbillChannelId = 0L;
        long parent = 0L;
        switch (transbillDriver) {
            case "B": {
                DynamicObject inChannel = this.getF7Value("inchannelid");
                long inChannelId = 0L;
                if (inChannel != null) {
                    inChannelId = inChannel.getLong("id");
                    parent = inChannel.getLong("parent_id");
                }
                transbillChannelId = parent == 0L ? inChannelId : parent;
                break;
            }
            default: {
                DynamicObject outChannel = this.getF7Value("outchannelid");
                long outChannelId = 0L;
                if (outChannel != null) {
                    outChannelId = outChannel.getLong("id");
                    parent = outChannel.getLong("parent_id");
                }
                transbillChannelId = parent == 0L ? outChannelId : parent;
            }
        }
        this.setValue("transbillchannelid", transbillChannelId == 0L ? null : Long.valueOf(transbillChannelId));
    }
}

