/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdma.formplugin.transbill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.flex.FlexService;
import kd.bos.form.control.Control;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class TransBillMorePlugin
extends OcbaseFormMobPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(TransBillMorePlugin.class);
    private static final String BTNSAVE = "btnsave";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNSAVE});
        this.addF7Listener(this, new String[]{"outwarehouseid", "outlocationid", "inwarehouseid", "inlocationid"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        if (key.startsWith("$$") && key.split("__")[0].equals("$$auxptyid")) {
            this.getAuxptyId();
        } else if (key.equals("outwarehouseid")) {
            DynamicObject warehouse = (DynamicObject)this.getValue("outwarehouseid");
            boolean enableLocation = DynamicObjectUtils.getBoolean((DynamicObject)warehouse, (String)"enablelocation");
            if (enableLocation) {
                this.setValue("outlocationid", this.getDefaultLocation(DynamicObjectUtils.getPkValue((DynamicObject)warehouse)));
            } else {
                this.setValue("outlocationid", null);
            }
        } else if (key.equals("inwarehouseid")) {
            DynamicObject warehouse = (DynamicObject)this.getValue("inwarehouseid");
            boolean enableLocation = DynamicObjectUtils.getBoolean((DynamicObject)warehouse, (String)"enablelocation");
            if (enableLocation) {
                this.setValue("inlocationid", this.getDefaultLocation(DynamicObjectUtils.getPkValue((DynamicObject)warehouse)));
            } else {
                this.setValue("inlocationid", null);
            }
        } else if (key.equals("lotnumber")) {
            Object productdate = null;
            Object expiredate = null;
            DynamicObject lot = null;
            long itemid = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)this.getValue("itemid")));
            String lotnumber = String.valueOf(this.getValue("lotnumber"));
            if (itemid > 0L && StringUtil.isNotEmpty((String)lotnumber)) {
                DynamicObjectCollection lotDate;
                QFilter qFilter = new QFilter("itemid", "=", (Object)itemid);
                qFilter.and("number", "=", (Object)lotnumber);
                qFilter.and("enable", "=", (Object)"1");
                lot = BusinessDataServiceHelper.loadSingle((String)"ococic_lot", (String)"productdate,expiredate", (QFilter[])qFilter.toArray());
                if (lot != null && (lotDate = lot.getDynamicObjectCollection("ococic_lotdate")).size() > 0) {
                    productdate = ((DynamicObject)lotDate.get(0)).get("productdate");
                    expiredate = ((DynamicObject)lotDate.get(0)).get("expiredate");
                }
            }
            this.setValue("lotid", lot);
            this.setValue("productdate", productdate);
            this.setValue("expiredate", expiredate);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnsave": {
                this.returnToEditParent();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "outwarehouseid": {
                List<Long> warehouseIds = this.getIdsFromOcocicWareHouse("outchannelid");
                QFilter filter = new QFilter("id", "in", warehouseIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "outlocationid": {
                List<Long> locationIds = this.getIdsFromOcocicLocation("outwarehouseid");
                QFilter filter = new QFilter("id", "in", locationIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "inwarehouseid": {
                List<Long> warehouseIds = this.getIdsFromOcocicWareHouse("inchannelid");
                QFilter filter = new QFilter("id", "in", warehouseIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "inlocationid": {
                List<Long> locationIds = this.getIdsFromOcocicLocation("inwarehouseid");
                QFilter filter = new QFilter("id", "in", locationIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
        }
    }

    private void returnToEditParent() {
        JSONObject resultJson = new JSONObject();
        resultJson.put("auxptyid", this.getValue("auxptyid_id"));
        resultJson.put("lotnumber", this.getValue("lotnumber"));
        resultJson.put("lotid", this.getValue("lotid_id"));
        String productdatestr = "";
        Date productdate = this.getDateFieldValue("productdate");
        if (productdate != null) {
            productdatestr = DateUtil.getDateTimeFormat((Date)productdate);
        }
        resultJson.put("productdate", (Object)productdatestr);
        String expiredatestr = "";
        Date expiredate = this.getDateFieldValue("expiredate");
        if (expiredate != null) {
            expiredatestr = DateUtil.getDateTimeFormat((Date)expiredate);
        }
        resultJson.put("expiredate", (Object)expiredatestr);
        resultJson.put("outwarehouseid", this.getValue("outwarehouseid_id"));
        resultJson.put("outlocationid", this.getValue("outlocationid_id"));
        resultJson.put("outstocktypeid", this.getValue("outstocktypeid_id"));
        resultJson.put("outstockstatusid", this.getValue("outstockstatusid_id"));
        resultJson.put("outownertype", this.getValue("outownertype"));
        resultJson.put("outownerid", this.getValue("outownerid_id"));
        resultJson.put("outkeepertype", this.getValue("outkeepertype"));
        resultJson.put("outkeeperid", this.getValue("outkeeperid_id"));
        resultJson.put("outprojectid", this.getValue("outprojectid_id"));
        resultJson.put("inwarehouseid", this.getValue("inwarehouseid_id"));
        resultJson.put("inlocationid", this.getValue("inlocationid_id"));
        resultJson.put("instocktype", this.getValue("instocktype_id"));
        resultJson.put("instockstatus", this.getValue("instockstatus_id"));
        resultJson.put("inownertype", this.getValue("inownertype"));
        resultJson.put("inownerid", this.getValue("inownerid_id"));
        resultJson.put("inkeepertype", this.getValue("inkeepertype"));
        resultJson.put("inkeeperid", this.getValue("inkeeperid_id"));
        resultJson.put("inprojectid", this.getValue("inprojectid_id"));
        this.getView().returnDataToParent((Object)resultJson);
        this.getView().close();
    }

    private void initInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setValue("itemid", customParams.get("itemid"));
        this.setValue("materialid", customParams.get("materialid"));
        this.setValue("unitid", customParams.get("unitid"));
        this.setValue("qty", customParams.get("qty"));
        this.setValue("thumbnail", customParams.get("thumbnail"));
        this.setValue("auxptyid", customParams.get("auxptyid"));
        this.setValue("lotnumber", customParams.get("lotnumber"));
        this.setValue("lotid", customParams.get("lotid"));
        this.setValue("productdate", customParams.get("productdate"));
        this.setValue("expiredate", customParams.get("expiredate"));
        this.setValue("outchannelid", customParams.get("outchannelid"));
        this.setValue("outwarehouseid", customParams.get("outwarehouseid"));
        this.setValue("outlocationid", customParams.get("outlocationid"));
        this.setValue("outstocktypeid", customParams.get("outstocktypeid"));
        this.setValue("outstockstatusid", customParams.get("outstockstatusid"));
        this.setValue("outownertype", customParams.get("outownertype"));
        this.setValue("outownerid", customParams.get("outownerid"));
        this.setValue("outkeepertype", customParams.get("outkeepertype"));
        this.setValue("outkeeperid", customParams.get("outkeeperid"));
        this.setValue("outprojectid", customParams.get("outprojectid"));
        this.setValue("inchannelid", customParams.get("inchannelid"));
        this.setValue("inwarehouseid", customParams.get("inwarehouseid"));
        this.setValue("inlocationid", customParams.get("inlocationid"));
        this.setValue("instocktype", customParams.get("instocktype"));
        this.setValue("instockstatus", customParams.get("instockstatus"));
        this.setValue("inownertype", customParams.get("inownertype"));
        this.setValue("inownerid", customParams.get("inownerid"));
        this.setValue("inkeepertype", customParams.get("inkeepertype"));
        this.setValue("inkeeperid", customParams.get("inkeeperid"));
        this.setValue("inprojectid", customParams.get("inprojectid"));
        this.setValue("id", customParams.get("id"));
    }

    private List<Long> getIdsFromOcocicWareHouse(String channelidkey) {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject channel = (DynamicObject)this.getValue(channelidkey);
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)channel);
        if (channelId == 0L) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("ownerchannelid", "=", (Object)channelId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ococic_warehouse", (String)"id", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)results)) {
            for (DynamicObject result : results) {
                ids.add(result.getLong("id"));
            }
        }
        return ids;
    }

    private List<Long> getIdsFromOcocicLocation(String warehouseidkey) {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject warehouse = (DynamicObject)this.getValue(warehouseidkey);
        long warehouseId = DynamicObjectUtils.getPkValue((DynamicObject)warehouse);
        if (warehouseId == 0L) {
            return ids;
        }
        QFilter filter = new QFilter("warehouseid", "=", (Object)warehouseId);
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ococic_location", (String)"id", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)results)) {
            for (DynamicObject result : results) {
                ids.add(result.getLong("id"));
            }
        }
        return ids;
    }

    private long getAuxptyId() {
        FlexEdit flexEdit = (FlexEdit)this.getControl("auxptyid");
        IDataModel flexModel = flexEdit.getFlexModel();
        DynamicObject dataEntity = flexModel.getDataEntity();
        MainEntityType dataEntityType = flexModel.getDataEntityType();
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData(dataEntityType, dataEntity);
        long id = FlexService.saveFlexData((MainEntityType)dataEntityType, (FlexEntireData)flexEntireData);
        this.setValue("auxptyid", id, this.getCurrentRowIndex("billentry"));
        return id;
    }

    private DynamicObject getDefaultLocation(long channelWarehouseId) {
        if (channelWarehouseId <= 0L) {
            return null;
        }
        QFilter filter = new QFilter("warehouseid", "=", (Object)channelWarehouseId);
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        filter.and("enable", "=", (Object)"1");
        DynamicObject location = BusinessDataServiceHelper.loadSingle((String)"ococic_location", (String)"id", (QFilter[])filter.toArray());
        return location;
    }
}

