/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.price;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;

public class CombinPricePolicyEditPlugin
extends OcbaseFormPlugin {
    private static final String COMBINATIONITEM = "combinationitem";
    private static final String COMBINATIONPRICE = "combinationprice";
    private static final String OP_SAVE = "save";
    protected volatile boolean isChangeEvent = true;
    private static String[] Entrykeys = new String[]{"subitem", "subunit", "subitemclass", "subsaleattr", "subassistattr", "submaterial", "subflexauxprop", "subqty", "proportion", "combinprice", "pricingway"};
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object entryIds = params.get("entryIds");
        Object id = params.get("id");
        if (id != null && entryIds != null) {
            String[] pks = entryIds.toString().split(",");
            QFilter f = new QFilter("id", "=", id);
            f.and("priceentry.id", "in", (Object)pks);
            DynamicObjectCollection pricePlicys = QueryServiceHelper.query((String)"dpm_pricepolicy", (String)"id,currency,pricetype,priceentry.item,priceentry.price,priceentry.subentryentity ,priceentry.subentryentity.subitem,priceentry.subentryentity.subunit,priceentry.subentryentity.subitemclass,priceentry.subentryentity.subsaleattr,priceentry.subentryentity.subflexauxprop,priceentry.subentryentity.subassistattr,priceentry.subentryentity.submaterial,priceentry.subentryentity.subqty,priceentry.subentryentity.proportion,priceentry.subentryentity.combinprice,priceentry.subentryentity.pricingway ", (QFilter[])f.toArray());
            if (pricePlicys == null || pricePlicys.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u8981\u4fee\u6539\u7684\u4ef7\u683c\u653f\u7b56\uff0c\u8bf7\u5148\u5237\u65b0\u5217\u8868\u540e\u518d\u64cd\u4f5c\uff01", (String)"CombinPricePolicyEditPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject entry = (DynamicObject)pricePlicys.get(0);
            this.setValue(COMBINATIONITEM, entry.get("priceentry.item"));
            this.setValue(COMBINATIONPRICE, entry.get("priceentry.price"));
            this.setValue("currency", entry.get("currency"));
            this.setValue("pricetype", entry.get("pricetype"));
            String pricingway = entry.getString("priceentry.subentryentity.pricingway");
            this.setValue("combinpricingway", pricingway);
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, pricePlicys.size());
            this.setEntryExecuFieldEnable(pricingway, false);
            DynamicObject entryentity = null;
            for (int i = 0; i < pricePlicys.size(); ++i) {
                entryentity = (DynamicObject)pricePlicys.get(i);
                for (String key : Entrykeys) {
                    this.getModel().setValue("detailid", entryentity.get("priceentry.subentryentity"), i);
                    this.getModel().setValue(key, entryentity.get("priceentry.subentryentity." + key), i);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isChangeEvent) {
            return;
        }
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        this.isChangeEvent = false;
        switch (key) {
            case "combinpricingway": {
                if (newValue != null) {
                    this.setEntryExecuFieldEnable(newValue.toString(), true);
                    break;
                }
                Object oldValue = e.getChangeSet()[0].getOldValue();
                this.setValue("combinpricingway", oldValue);
                this.getView().showMessage(ResManager.loadKDString((String)"\u5b9a\u4ef7\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"CombinPricePolicyEditPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "proportion": {
                this.setSubPriceInfo(index);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                if (this.handleBeginSave()) break;
                e.cancel = true;
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
                        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(entryentitys.size());
                        String updatesql = "update t_dpm_pricepolicysentry set fpricingway =  ? ,fproportion = ? ,fcombinprice =  ?   where FDetailID = ?";
                        for (DynamicObject entryentity : entryentitys) {
                            ArrayList<Object> dataValueList = new ArrayList<Object>(4);
                            dataValueList.add(entryentity.get("pricingway"));
                            dataValueList.add(entryentity.get("proportion"));
                            dataValueList.add(entryentity.get("combinprice"));
                            dataValueList.add(entryentity.get("detailid"));
                            paramsList.add(dataValueList.toArray());
                        }
                        if (paramsList.size() > 0) {
                            DB.executeBatch((DBRoute)new DBRoute("mdr"), (String)updatesql, paramsList);
                        }
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        throw ex;
                    }
                }
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private void setEntryExecuFieldEnable(String combinpricingway, boolean isupdate) {
        switch (combinpricingway) {
            case "1": {
                this.setDisVisible(new String[]{"proportion", "combinprice"});
                break;
            }
            case "2": {
                this.setDisVisible(new String[]{"proportion"});
                this.setVisible(new String[]{"combinprice"});
                break;
            }
            case "3": {
                this.setVisible(new String[]{"proportion", "combinprice"});
                break;
            }
        }
        DynamicObjectCollection subentryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
        if (subentryentitys == null) {
            return;
        }
        for (int i = 0; i < subentryentitys.getRowCount(); ++i) {
            if (combinpricingway.compareTo("2") == 0) {
                this.setEnable(i, new String[]{"combinprice"});
            } else if (combinpricingway.compareTo("3") == 0) {
                this.setUnEnable(i, new String[]{"combinprice"});
            }
            if (!isupdate) continue;
            this.setValue("pricingway", combinpricingway, i);
            this.setValue("proportion", 0, i);
            if (combinpricingway.compareTo("1") != 0) continue;
            this.setValue("combinprice", 0, i);
        }
    }

    private void setSubPriceInfo(int index) {
        DynamicObject subentryentity = this.getRowInfo(ENTRYENTITY, index);
        BigDecimal price = this.getModel().getDataEntity().getBigDecimal(COMBINATIONPRICE);
        BigDecimal proportion = subentryentity.getBigDecimal("proportion");
        if (price.compareTo(BigDecimal.ZERO) == 0 || proportion.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal qty = subentryentity.getBigDecimal("subqty");
        BigDecimal combinprice = price.multiply(proportion).divide(qty.multiply(BigDecimal.valueOf(100L)), this.getPriceprecision(), 4);
        this.setValue("combinprice", combinprice, index);
    }

    private int getPriceprecision() {
        int amtprecision = 2;
        DynamicObject currency = this.getF7Value("currency");
        if (currency != null) {
            amtprecision = currency.getInt("priceprecision");
        }
        return amtprecision;
    }

    private boolean handleBeginSave() {
        boolean isSucess = true;
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
        if (this.getValue("combinpricingway").equals("3")) {
            BigDecimal sumProportion = BigDecimal.ZERO;
            if (entryentitys.size() > 0) {
                for (DynamicObject entryentity : entryentitys) {
                    sumProportion = sumProportion.add(entryentity.getBigDecimal("proportion"));
                }
            }
            if (sumProportion.compareTo(BigDecimal.valueOf(100L)) != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b\u5206\u914d\uff0c\u5206\u5f55\u6bd4\u4f8b\u6c47\u603b\u4e0d\u4e3a\u767e\u5206\u767e\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4", (String)"CombinPricePolicyEditPlugin_2", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                isSucess = false;
            }
        } else if (this.getValue("combinpricingway").equals("2")) {
            BigDecimal sumcombinprice = BigDecimal.ZERO;
            BigDecimal combinprice = BigDecimal.ZERO;
            for (DynamicObject entryentity : entryentitys) {
                combinprice = entryentity.getBigDecimal("combinprice");
                if (combinprice.compareTo(BigDecimal.ZERO) == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u7531\u5b9a\u4ef7\uff0c\u5206\u5f55\u5b58\u5728\u4e3a0\u4ef7\u683c\uff0c\u8bf7\u5148\u7ef4\u62a4", (String)"CombinPricePolicyEditPlugin_3", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    isSucess = false;
                    break;
                }
                sumcombinprice = combinprice.multiply(entryentity.getBigDecimal("subqty")).add(sumcombinprice);
            }
            if (sumcombinprice.compareTo(this.getModel().getDataEntity().getBigDecimal(COMBINATIONPRICE)) != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u603b\u4ef7\u8981\u548c\u5b50\u4ef6\u7684\u603b\u4ef7\u76f8\u7b49\uff01", (String)"CombinPricePolicyEditPlugin_4", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                isSucess = false;
            }
        }
        return isSucess;
    }
}

