/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.price;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.occ.ocbase.common.constants.BigDecimalConstants;
import kd.occ.ocbase.common.enums.DiscountTypeEnum;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CustomerUtil;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.PricePolicyUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocdpm.formplugin.base.PromotionBaseEdit;

public class PricePolicyEditPlugin
extends PromotionBaseEdit
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String COMBINATIONITEM = "combinationitem";
    private static final String COMBINATIONPRICE = "combinationprice";
    private static final String CUSTOMERS = "customers";
    private static final String CUSTOMERSCOPE = "customerscope";
    private static final String E_PRICEENTRY = "priceentry";
    private static final String EF_SUBENTRYENTITY = "subentryentity";
    private static final String TB_SUBITEMINFOS = "subiteminfos";
    private static final String OP_FRISTENTRY = "firstentry";
    private static final String OP_PREVIOUSENTRY = "previousentry";
    private static final String OP_NEXTENTRY = "nextentry";
    private static final String OP_LASTENTRY = "lastentry";
    private static final String OP_SAVE = "save";
    private static final String OP_SAVE_AFTERCONFIRM = "save_afterconfirm";
    protected volatile boolean isChangeEvent = true;

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDisVisible(new String[]{"assistattr", "subassistattr"});
        this.setVisible(new String[]{"subflexauxprop", "flexauxprop"});
        this.setDisVisible(new String[]{"material"});
        DynamicObject businesstype = (DynamicObject)this.getValue("businesstype");
        if (businesstype != null && businesstype.getString("commoditymode").compareTo("2") == 0) {
            this.setVisible(new String[]{"itemclass", "brand", "subitemclass"});
            this.setMustInput("item", false);
            this.setMustInput("unit", false);
        } else {
            this.setDisVisible(new String[]{"itemclass", "brand", "subitemclass"});
            this.setMustInput("item", true);
            this.setMustInput("unit", true);
        }
        this.setF7Filter("salechannel", CUserHelper.getAuthorizedChannelFilter());
        this.setFilterByOwner();
        this.setCustomerScope(this.getValue("channelrange").toString());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{"tabap"});
        this.addF7Listener(this, new String[]{"businesstype", "pricetype", "area", "city", "assistattr", "saleattr", "item", "unit", "channelgroup"});
    }

    public void tabSelected(TabSelectEvent e) {
        String key;
        switch (key = e.getTabKey()) {
            case "subiteminfos": {
                this.showItemInfo();
                this.getView().updateView(EF_SUBENTRYENTITY);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        List<QFilter> fitlers = null;
        switch (key) {
            case "businesstype": {
                this.setFilterByOwner(e, "ocdbd_item_businesstype");
                break;
            }
            case "pricetype": {
                this.setFilterByOwner(e, "ocdbd_price_type");
                break;
            }
            case "saleattr": {
                this.setFilterByOwner(e, "ocdbd_item_saleattr");
                break;
            }
            case "city": {
                fitlers = this.getAddressFilters(e, "province", rowIndex);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, fitlers);
                break;
            }
            case "area": {
                fitlers = this.getAddressFilters(e, "city", rowIndex);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, fitlers);
                break;
            }
            case "assistattr": {
                this.addAssistAttrFilter(e, rowIndex);
                break;
            }
            case "flexauxprop": {
                this.addMaterialAttrFilter(e, rowIndex);
                break;
            }
            case "item": {
                this.setItemFilter(e);
                break;
            }
            case "unit": {
                this.unit_beforeF7Select(e);
                break;
            }
            case "channelgroup": {
                DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)3L, (String)"ocdbd_channel_std_apply");
                DynamicObject standardObj = dobj.getDynamicObject("classstandardid");
                Long groupStandardPK = Long.valueOf(standardObj.get("id").toString());
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                formShowParameter.setCustomParam("groupStandard", (Object)groupStandardPK);
                QFilter standardFilter = new QFilter("classstandard", "=", (Object)groupStandardPK);
                formShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "firstentry": 
            case "previousentry": 
            case "nextentry": 
            case "lastentry": {
                this.showItemInfo();
                break;
            }
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "enable": 
            case "disable": {
                if (!e.getOperationResult().isSuccess()) break;
                boolean isshowItemInfo = false;
                Tab tab = (Tab)this.getControl("tabap");
                String tabName = tab.getCurrentTab();
                EntryGrid grid = (EntryGrid)this.getControl(E_PRICEENTRY);
                int row = 0;
                if (tabName.compareTo(TB_SUBITEMINFOS) == 0) {
                    isshowItemInfo = true;
                    row = grid.getEntryState().getFocusRow();
                }
                this.reLoadPage();
                if (!isshowItemInfo) break;
                grid.getEntryState().setFocusRow(row);
                this.showItemInfo();
                this.getView().updateView(EF_SUBENTRYENTITY);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "firstentry": 
            case "previousentry": {
                EntryGrid grid = (EntryGrid)this.getControl(E_PRICEENTRY);
                int row = grid.getEntryState().getFocusRow();
                if (row != 0) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u9996\u884c\u4e86", (String)"PricePolicyEditPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                e.cancel = true;
                break;
            }
            case "nextentry": 
            case "lastentry": {
                DynamicObjectCollection itemList = this.getModel().getEntryEntity(E_PRICEENTRY);
                EntryGrid grid = (EntryGrid)this.getControl(E_PRICEENTRY);
                int row = grid.getEntryState().getFocusRow();
                if (itemList == null || row != itemList.size() - 1) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u5c3e\u884c\u4e86", (String)"PricePolicyEditPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                e.cancel = true;
                break;
            }
            case "save": 
            case "submit": {
                RefObject afterConfirm = new RefObject();
                if (source.getOption().tryGetVariableValue(OP_SAVE_AFTERCONFIRM, afterConfirm) || this.getStringValue("channelrange").compareTo("A") != 0) break;
                HashSet<Object> customerids = new HashSet<Object>();
                DynamicObjectCollection customers = this.getModel().getEntryEntity(CUSTOMERS);
                if (customers.size() == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5ba2\u6237\u8303\u56f4\u4fe1\u606f\uff01", (String)"PricePolicyEditPlugin_2", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object pkid = this.getValue("id");
                DynamicObject object = null;
                for (DynamicObject customer : customers) {
                    if (!customer.getBoolean("isdefault") || (object = customer.getDynamicObject("channel")) == null) continue;
                    customerids.add(object.getPkValue());
                }
                if (customerids.size() == 0) {
                    return;
                }
                DynamicObject owner = this.getF7Value("salechannel");
                if (owner == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u9500\u552e\u6e20\u9053\u4fe1\u606f\uff01", (String)"PricePolicyEditPlugin_3", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (!PricePolicyUtil.defaultCustomerIsRepeat((Object)pkid, (Object)owner.getPkValue(), customerids)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9500\u552e\u6e20\u9053\u7684\u5df2\u8bbe\u7f6e\u4e86\u76f8\u540c\u7684\u9ed8\u8ba4\u6e20\u9053\uff0c\u662f\u5426\u66ff\u4ee3\uff1f", (String)"PricePolicyEditPlugin_4", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                e.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "changeOwnerCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.setValue("currency", this.getF7Value("salechannel").get("currency"));
                    this.setFilterByOwner();
                    this.getModel().deleteEntryData(CUSTOMERS);
                    this.getModel().createNewEntryRow(CUSTOMERS);
                    this.getModel().deleteEntryData(E_PRICEENTRY);
                    this.getModel().deleteEntryData(EF_SUBENTRYENTITY);
                    this.getModel().createNewEntryRow(E_PRICEENTRY);
                    break;
                }
                String oldValue = messageBoxClosedEvent.getCustomVaule();
                this.setValue("salechannel", oldValue, false);
                break;
            }
            case "save": 
            case "submit": {
                DynamicObjectCollection customers = this.getModel().getEntryEntity(CUSTOMERS);
                if (customers.size() > 0) {
                    DynamicObject customer = null;
                    for (int i = 0; i < customers.size(); ++i) {
                        customer = (DynamicObject)customers.get(i);
                        if (!customer.getBoolean("isdefault")) continue;
                        this.setValue("isdefault", 0, i);
                        if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) continue;
                        this.setValue("isdefault", 1, i);
                    }
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(OP_SAVE_AFTERCONFIRM, "true");
                this.getView().invokeOperation(key, operateOption);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (E_PRICEENTRY.compareTo(e.getEntryProp().getName()) == 0) {
            RowDataEntity[] priceentrys;
            DynamicObject businesstype = this.getF7Value("businesstype");
            boolean isSet = false;
            if (businesstype != null && businesstype.getString("commoditymode").compareTo("2") == 0) {
                isSet = true;
            }
            if ((priceentrys = e.getRowDataEntities()) != null && priceentrys.length > 0) {
                DynamicObject priceentry = null;
                String discountway = null;
                int index = 0;
                Object begindate = this.getValue("begindate");
                Object enddate = this.getValue("enddate");
                for (RowDataEntity rowDataEntity : priceentrys) {
                    index = rowDataEntity.getRowIndex();
                    this.setValue("begindt", begindate, index, false);
                    this.setValue("enddt", enddate, index, false);
                    if (!isSet) continue;
                    priceentry = rowDataEntity.getDataEntity();
                    this.setUnEnable(index, new String[]{"discountway"});
                    discountway = priceentry.getString("discountway");
                    if (discountway != null && discountway.compareTo("A") == 0) continue;
                    this.setValue("discountway", "A", index);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isChangeEvent) {
            return;
        }
        Boolean triggerChangeEventLocal = (Boolean)OcbaseFormPlugin.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            OcbaseFormPlugin.triggerChangeEventLocal.remove();
            return;
        }
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        this.isChangeEvent = false;
        switch (key) {
            case "salechannel": {
                this.ownerChange(e);
                break;
            }
            case "channel": {
                if (newValue == null) break;
                this.setValue("channelgroup", null, index);
                this.setValue("area", null, index);
                this.setValue("city", null, index);
                this.setValue("province", null, index);
                break;
            }
            case "channelgroup": {
                if (newValue == null) break;
                this.setValue("channel", null, index);
                break;
            }
            case "province": {
                if (newValue != null) {
                    this.setValue("channel", null, index);
                }
                this.setValue("area", null, index);
                this.setValue("city", null, index);
                break;
            }
            case "city": {
                this.setValue("area", null, index);
                break;
            }
            case "item": {
                this.itemChanged(e);
                break;
            }
            case "brand": 
            case "itemclass": {
                if (newValue == null) break;
                this.setValue("item", null, index);
                break;
            }
            case "begindt": {
                if (newValue == null) break;
                Date begindate = (Date)this.getValue("begindate");
                if (begindate == null) {
                    this.setValue("begindate", newValue);
                    break;
                }
                if (begindate.compareTo((Date)newValue) <= 0) break;
                this.setValue("begindate", newValue);
                break;
            }
            case "enddt": {
                if (newValue == null) break;
                Date enddt = (Date)newValue;
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(enddt);
                cal2.set(11, 23);
                cal2.set(12, 59);
                cal2.set(13, 59);
                enddt = cal2.getTime();
                this.setValue("enddt", enddt, index);
                Date enddate = (Date)this.getValue("enddate");
                if (enddate == null) {
                    this.setValue("enddate", enddt);
                    break;
                }
                if (enddate.compareTo(enddt) >= 0) break;
                this.setValue("enddate", enddt);
                break;
            }
            case "unit": {
                if (newValue != null) break;
                Object oldUnit = e.getChangeSet()[0].getOldValue();
                this.setValue(key, oldUnit, index);
                break;
            }
            case "assistattr": {
                this.itemAssistAttrChanged(index, e.getChangeSet()[0].getOldValue());
                break;
            }
            case "price": {
                this.setDetailPriceInfo(index);
                break;
            }
            case "combinpricingway": {
                if (newValue == null) break;
                this.setEntryExecuFieldEnable(newValue.toString(), true);
                break;
            }
            case "proportion": {
                this.setSubPriceInfo(index);
                break;
            }
            case "channelrange": {
                String customerrange = newValue.toString();
                this.setCustomerScope(customerrange);
                this.setCustomerScopeValue(customerrange);
                break;
            }
            case "begindate": {
                this.dateChanged(key, newValue, e.getChangeSet()[0].getOldValue());
                break;
            }
            case "enddate": {
                Date enddt = null;
                if (newValue != null) {
                    enddt = (Date)newValue;
                    Calendar cal2 = Calendar.getInstance();
                    cal2.setTime(enddt);
                    cal2.set(11, 23);
                    cal2.set(12, 59);
                    cal2.set(13, 59);
                    enddt = cal2.getTime();
                    this.setValue("enddate", enddt);
                }
                this.dateChanged(key, enddt, e.getChangeSet()[0].getOldValue());
                break;
            }
            case "businesstype": {
                this.changeBusinesstype(newValue);
                break;
            }
            case "discountway": 
            case "discount": {
                this.changeDiscountType(key, e.getChangeSet()[0].getOldValue(), newValue, index);
                break;
            }
        }
        this.isChangeEvent = true;
    }

    private void changeBusinesstype(Object newValue) {
        if (newValue != null && ((DynamicObject)newValue).getString("commoditymode").compareTo("2") == 0) {
            this.setVisible(new String[]{"itemclass", "brand", "subitemclass"});
            this.setMustInput("item", false);
            this.setMustInput("unit", false);
            DynamicObjectCollection priceentrys = this.getModel().getEntryEntity(E_PRICEENTRY);
            if (priceentrys != null && priceentrys.size() > 0) {
                DynamicObject priceentry = null;
                Object discountway = null;
                for (int i = 0; i < priceentrys.size(); ++i) {
                    this.setUnEnable(i, new String[]{"discountway"});
                    priceentry = (DynamicObject)priceentrys.get(i);
                    discountway = priceentry.get("discountway");
                    if (discountway != null && discountway.toString().compareTo("A") == 0) continue;
                    this.isChangeEvent = true;
                    this.setValue("discountway", "A", i);
                }
            }
        } else {
            DynamicObjectCollection priceentrys = this.getModel().getEntryEntity(E_PRICEENTRY);
            if (priceentrys != null && priceentrys.size() > 0) {
                for (int i = 0; i < priceentrys.size(); ++i) {
                    this.setEnable(i, new String[]{"discountway"});
                }
            }
            this.setDisVisible(new String[]{"itemclass", "brand", "subitemclass"});
            this.setMustInput("item", true);
            this.setMustInput("unit", true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void changeDiscountType(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        int discountRateScale = 2;
        String discountType = (String)model.getValue("discountway", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discount", rowIndex);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if (null != discountRate && DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            if ((discountRate = discountRate.setScale(discountRateScale, 4)).compareTo(BigDecimalConstants.ONEHUNDRED) <= 0) {
                model.setValue("discount", (Object)discountRate, rowIndex);
                return;
            }
            if (fieldName.compareTo("discountway") == 0) {
                this.setValue("discount", null, rowIndex, false);
                return;
            }
            this.setValue(fieldName, oldValue, rowIndex, false);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u7387\u65f6\uff0c\u6298\u6263\u4e0d\u80fd\u5927\u4e8e100%", (String)"PricePolicyEditPlugin_5", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null != discountRate && DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            BigDecimal price;
            discountRateScale = this.getPrecision();
            if ((discountRate = discountRate.setScale(discountRateScale, 4)).compareTo(price = (BigDecimal)model.getValue("price", rowIndex)) <= 0) {
                model.setValue("discount", (Object)discountRate, rowIndex);
                return;
            }
            if (fieldName.compareTo("discountway") == 0) {
                this.setValue("discount", null, rowIndex, false);
                return;
            }
            this.setValue(fieldName, oldValue, rowIndex, false);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u6298\u6263\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7", (String)"PricePolicyEditPlugin_6", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            return;
        }
        model.setValue("discount", null, rowIndex);
        model.setValue("discountway", null, rowIndex);
    }

    private void ownerChange(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        if (newValue == null) {
            this.setValue("salechannel", oldValue);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"PricePolicyEditPlugin_7", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection itemList = this.getModel().getEntryEntity(E_PRICEENTRY);
        this.setValue("currency", ((DynamicObject)newValue).get("currency"));
        this.setFilterByOwner();
        if (oldValue != null && itemList != null && ((DynamicObject)itemList.get(0)).get("item") != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("changeOwnerCallBack", (IFormPlugin)this);
            String oldownerid = ((DynamicObject)oldValue).getString("id");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5f52\u5c5e\u6e20\u9053\u5c06\u6e05\u7a7a\u6240\u6709\u5206\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"PricePolicyEditPlugin_8", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, oldownerid);
        }
    }

    private void itemChanged(PropertyChangedArgs e) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int index = this.getRowIndex(e);
        this.setValue("flexauxprop", null, index, false);
        this.setValue("assistattr", null, index, false);
        this.setValue("unit", null, index, false);
        if (newValue != null) {
            Object unit = newValue.get("saleunit");
            if (unit == null) {
                this.setValue("item", null, index);
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\u5546\u54c1\u6ca1\u6709\u8ba1\u91cf\u5355\u4f4d", (String)"PricePolicyEditPlugin_9", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), index + 1));
            }
            this.setValue("brand", null, index, false);
            this.setValue("itemclass", null, index, false);
            this.setValue("unit", unit, index, false);
            this.setValue("material", newValue.get("material"), index, false);
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.deleteSubItemInfos(index);
            }
            this.addSubItemInfos(index);
        } else {
            this.deleteSubItemInfos(index);
        }
    }

    private void dateChanged(String key, Object value, Object oldvalue) {
        if (value == null) {
            this.setValue(key, oldvalue, false);
            if (key.compareTo("begindate") == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"PricePolicyEditPlugin_10", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u5931\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"PricePolicyEditPlugin_11", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        DynamicObjectCollection priceentrys = this.getModel().getEntryEntity(E_PRICEENTRY);
        if (priceentrys == null || priceentrys.size() == 0) {
            return;
        }
        Date minbegindate = ((DynamicObject)priceentrys.get(0)).getDate("begindt");
        Date maxenddate = ((DynamicObject)priceentrys.get(0)).getDate("enddt");
        Date date = null;
        for (DynamicObject dynamicObject : priceentrys) {
            date = dynamicObject.getDate("begindt");
            if (date != null && (minbegindate == null || minbegindate.compareTo(date) > 0)) {
                minbegindate = date;
            }
            if ((date = dynamicObject.getDate("enddt")) == null || maxenddate != null && maxenddate.compareTo(date) >= 0) continue;
            maxenddate = date;
        }
        if (oldvalue != null && minbegindate != null && key.compareTo("begindate") == 0 && ((Date)value).compareTo(minbegindate) > 0) {
            this.setValue(key, oldvalue, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5206\u5f55\u6700\u5c0f\u751f\u6548\u65e5\u671f\uff01", (String)"PricePolicyEditPlugin_12", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (oldvalue != null && maxenddate != null && key.compareTo("enddate") == 0 && ((Date)value).compareTo(maxenddate) < 0) {
            this.setValue(key, oldvalue, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u5931\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5206\u5f55\u6700\u5927\u5931\u6548\u65e5\u671f\uff01", (String)"PricePolicyEditPlugin_13", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String dateKey = "";
        dateKey = key.compareTo("begindate") == 0 ? "begindt" : "enddt";
        DynamicObject priceentry = null;
        for (int i = 0; i < priceentrys.size(); ++i) {
            priceentry = (DynamicObject)priceentrys.get(i);
            if (priceentry.get(dateKey) != null) continue;
            this.setValue(dateKey, value, i);
        }
    }

    protected void addMaterialAttrFilter(BeforeF7SelectEvent e, int rowIndex) {
        Object material = this.getEntryF7PKValue(E_PRICEENTRY, "item", rowIndex);
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\uff01", (String)"PricePolicyEditPlugin_14", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    protected void addAssistAttrFilter(BeforeF7SelectEvent e, int rowIndex) {
        Object itemId = this.getEntryF7PKValue(E_PRICEENTRY, "item", rowIndex);
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01", (String)"PricePolicyEditPlugin_15", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    protected void itemAssistAttrChanged(int index, Object oldValue) {
        DynamicObject assistattr;
        DynamicObject item = this.getEntryF7Value(E_PRICEENTRY, "item", index);
        if (!this.itemAttrNullValidate(item, assistattr = this.getEntryF7Value(E_PRICEENTRY, "assistattr", index))) {
            if (oldValue != null) {
                this.setValue("assistattr", oldValue, index);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"PricePolicyEditPlugin_16", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private boolean itemAttrNullValidate(DynamicObject item, DynamicObject assistAttr) {
        boolean hasAssistAttr = item.getBoolean("hasattr");
        return !hasAssistAttr || assistAttr != null;
    }

    private void showItemInfo() {
        EntryGrid grid = (EntryGrid)this.getControl(E_PRICEENTRY);
        int row = grid.getEntryState().getFocusRow();
        if (row < 0) {
            row = 0;
            grid.getEntryState().setFocusRow(row);
        }
        DynamicObject priceentry = this.getRowInfo(E_PRICEENTRY, row);
        DynamicObject item = priceentry.getDynamicObject("item");
        DynamicObjectCollection subentryentitys = this.getModel().getEntryEntity(EF_SUBENTRYENTITY);
        if (item == null || subentryentitys == null) {
            this.setValue(COMBINATIONITEM, null);
            this.setValue(COMBINATIONPRICE, BigDecimal.ZERO);
            this.setValue("combinpricingway", null);
            this.setUnEnable(new String[]{"combinpricingway"});
            return;
        }
        DynamicObject itemtype = item.getDynamicObject("itemtypeid");
        if (itemtype == null || itemtype.getString("id").compareTo("870945697287898112") != 0) {
            this.setValue(COMBINATIONITEM, null);
            this.setValue(COMBINATIONPRICE, BigDecimal.ZERO);
            this.setValue("combinpricingway", null);
            return;
        }
        this.setValue(COMBINATIONITEM, item.getPkValue());
        this.setValue(COMBINATIONPRICE, priceentry.getBigDecimal("price"));
        Object enteyId = priceentry.getPkValue();
        DynamicObject subentryentity = null;
        DynamicObject parent = null;
        for (int i = 0; i < subentryentitys.getRowCount(); ++i) {
            subentryentity = (DynamicObject)subentryentitys.get(i);
            parent = (DynamicObject)subentryentity.getParent();
            if (!parent.getPkValue().equals(enteyId)) continue;
            Object pricingway = subentryentity.get("pricingway");
            this.setValue("combinpricingway", pricingway, false);
            this.setEntryExecuFieldEnable(pricingway.toString(), false);
            break;
        }
    }

    private List<QFilter> getAddressFilters(BeforeF7SelectEvent e, String fieldName, int rowindex) {
        ArrayList<QFilter> fitlers = new ArrayList<QFilter>();
        DynamicObject customer = this.getRowInfo(CUSTOMERS, rowindex);
        DynamicObject address = customer.getDynamicObject(fieldName);
        if (address == null) {
            if (fieldName.compareTo("city") == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7701\u5b57\u6bb5\u4fe1\u606f", (String)"PricePolicyEditPlugin_17", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5e02\u5b57\u6bb5\u4fe1\u606f", (String)"PricePolicyEditPlugin_18", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            }
            e.setCancel(true);
        } else {
            QFilter orgIdsFilter = new QFilter("parent", "=", address.getPkValue());
            fitlers.add(orgIdsFilter);
        }
        return fitlers;
    }

    private void deleteSubItemInfos(int index) {
        DynamicObjectCollection subentryentitys = this.getModel().getEntryEntity(EF_SUBENTRYENTITY);
        if (subentryentitys == null) {
            return;
        }
        DynamicObject priceentry = this.getRowInfo(E_PRICEENTRY, index);
        Object enteyId = priceentry.getPkValue();
        HashSet<Integer> rows = new HashSet<Integer>();
        DynamicObject subentryentity = null;
        DynamicObject parent = null;
        for (int i = 0; i < subentryentitys.getRowCount(); ++i) {
            subentryentity = (DynamicObject)subentryentitys.get(i);
            parent = (DynamicObject)subentryentity.getParent();
            if (!parent.getPkValue().equals(enteyId)) continue;
            rows.add(i);
        }
        this.deleteSubEntry(rows);
    }

    private void deleteSubEntry(Set<Integer> rows) {
        int j = 0;
        int[] rowindex = new int[rows.size()];
        for (Integer rowIndex : rows) {
            rowindex[j++] = rowIndex;
        }
        this.getModel().deleteEntryRows(EF_SUBENTRYENTITY, rowindex);
    }

    private void addSubItemInfos(int index) {
        DynamicObject priceentry = this.getRowInfo(E_PRICEENTRY, index);
        DynamicObject item = priceentry.getDynamicObject("item");
        IDataModel model = this.getModel();
        if (item == null) {
            return;
        }
        DynamicObject itemtype = item.getDynamicObject("itemtypeid");
        if (itemtype.getString("id").compareTo("870945697287898112") == 0) {
            QFilter qfilter = new QFilter("status", "=", (Object)"C");
            qfilter.and("isonsell", "=", (Object)"1");
            qfilter.and("combitemid", "=", item.getPkValue());
            DynamicObjectCollection itemcombinationinfo = QueryServiceHelper.query((String)"dpm_item_combination", (String)"id,itemdetail.item,itemdetail.unit,itemdetail.attr,itemdetail.qty,itemdetail.material,itemdetail.materialassist", (QFilter[])qfilter.toArray());
            if (itemcombinationinfo != null && itemcombinationinfo.size() > 0) {
                int a = 0;
                EntryGrid grid = (EntryGrid)this.getControl(E_PRICEENTRY);
                int oldindex = grid.getEntryState().getFocusRow();
                grid.getEntryState().setFocusRow(index);
                int[] indexes = model.batchCreateNewEntryRow(EF_SUBENTRYENTITY, itemcombinationinfo.size());
                for (DynamicObject subItem : itemcombinationinfo) {
                    int i = indexes[a];
                    model.setValue("subitem", subItem.get("itemdetail.item"), i);
                    model.setValue("subunit", subItem.get("itemdetail.unit"), i);
                    model.setValue("subassistattr", subItem.get("itemdetail.attr"), i);
                    model.setValue("subflexauxprop", subItem.get("itemdetail.materialassist"), i);
                    model.setValue("subqty", subItem.get("itemdetail.qty"), i);
                    model.setValue("submaterial", subItem.get("itemdetail.material"), i);
                    ++a;
                }
                grid.getEntryState().setFocusRow(oldindex);
            }
        }
    }

    private void setEntryExecuFieldEnable(String combinpricingway, boolean isupdate) {
        switch (combinpricingway) {
            case "1": {
                this.setDisVisible(new String[]{"proportion", "combinprice"});
                break;
            }
            case "2": {
                this.setDisVisible(new String[]{"proportion"});
                this.setVisible(new String[]{"combinprice"});
                break;
            }
            case "3": {
                this.setVisible(new String[]{"proportion", "combinprice"});
                break;
            }
        }
        DynamicObjectCollection subentryentitys = this.getModel().getEntryEntity(EF_SUBENTRYENTITY);
        if (subentryentitys == null || subentryentitys.size() == 0) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getControl(E_PRICEENTRY);
        int index = grid.getEntryState().getFocusRow();
        DynamicObject priceentry = this.getRowInfo(E_PRICEENTRY, index);
        Object enteyId = priceentry.getPkValue();
        DynamicObject subentryentity = null;
        DynamicObject parent = null;
        for (int i = 0; i < subentryentitys.getRowCount(); ++i) {
            subentryentity = (DynamicObject)subentryentitys.get(i);
            parent = (DynamicObject)subentryentity.getParent();
            if (!parent.getPkValue().equals(enteyId)) continue;
            if (combinpricingway.compareTo("2") == 0) {
                this.setEnable(i, new String[]{"combinprice"});
            } else if (combinpricingway.compareTo("3") == 0) {
                this.setUnEnable(i, new String[]{"combinprice"});
            }
            if (!isupdate) continue;
            this.setValue("pricingway", combinpricingway, i);
            this.setValue("proportion", 0, i);
            if (combinpricingway.compareTo("1") != 0) continue;
            this.setValue("combinprice", 0, i);
        }
    }

    private void setDetailPriceInfo(int index) {
        DynamicObjectCollection subentryentitys = this.getModel().getEntryEntity(EF_SUBENTRYENTITY);
        DynamicObject priceentry = this.getRowInfo(E_PRICEENTRY, index);
        if (subentryentitys == null || priceentry == null) {
            return;
        }
        BigDecimal price = priceentry.getBigDecimal("price");
        String discountType = priceentry.getString("discountway");
        BigDecimal discountRate = priceentry.getBigDecimal("discount");
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && price.compareTo(discountRate) < 0) {
            this.setValue("discount", null, index);
        }
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        Object enteyId = priceentry.getPkValue();
        DynamicObject subentryentity = null;
        DynamicObject parent = null;
        BigDecimal combinprice = BigDecimal.ZERO;
        BigDecimal proportion = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        for (int i = 0; i < subentryentitys.getRowCount(); ++i) {
            subentryentity = (DynamicObject)subentryentitys.get(i);
            parent = (DynamicObject)subentryentity.getParent();
            if (!parent.getPkValue().equals(enteyId)) continue;
            proportion = subentryentity.getBigDecimal("proportion");
            qty = subentryentity.getBigDecimal("subqty");
            if (proportion.compareTo(BigDecimal.ZERO) == 0) continue;
            combinprice = price.multiply(proportion).divide(qty.multiply(BigDecimal.valueOf(100L)), this.getPriceprecision(), 4);
            this.setValue("combinprice", combinprice, i);
        }
    }

    private void setSubPriceInfo(int index) {
        DynamicObject subentryentity = this.getRowInfo(EF_SUBENTRYENTITY, index);
        DynamicObject parent = (DynamicObject)subentryentity.getParent();
        BigDecimal price = parent.getBigDecimal("price");
        BigDecimal proportion = subentryentity.getBigDecimal("proportion");
        if (price.compareTo(BigDecimal.ZERO) == 0 || proportion.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal qty = subentryentity.getBigDecimal("subqty");
        BigDecimal combinprice = price.multiply(proportion).divide(qty.multiply(BigDecimal.valueOf(100L)), this.getPriceprecision(), 4);
        this.setValue("combinprice", combinprice, index);
    }

    private int getPriceprecision() {
        int amtprecision = 2;
        DynamicObject currency = this.getF7Value("currency");
        if (currency != null) {
            amtprecision = currency.getInt("priceprecision");
        }
        return amtprecision;
    }

    private void setCustomerScope(String customerrange) {
        switch (customerrange) {
            case "A": {
                this.setVisible(new String[]{CUSTOMERSCOPE, "channel", "channelname", "isdefault"});
                this.setDisVisible(new String[]{"channelgroup", "channelgroupname", "province", "city", "area"});
                break;
            }
            case "B": {
                this.setDisVisible(new String[]{"channel", "channelname", "isdefault"});
                this.setVisible(new String[]{CUSTOMERSCOPE, "channelgroup", "channelgroupname", "province", "city", "area"});
                break;
            }
            case "C": {
                this.setDisVisible(new String[]{CUSTOMERSCOPE});
                break;
            }
        }
    }

    private void setCustomerScopeValue(String customerrange) {
        IDataModel model = this.getModel();
        model.deleteEntryData(CUSTOMERS);
        if (customerrange.compareTo("C") != 0) {
            model.batchCreateNewEntryRow(CUSTOMERS, 1);
        }
    }

    private void setItemFilter(BeforeF7SelectEvent e) {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        DynamicObject owner = this.getModel().getDataEntity().getDynamicObject("salechannel");
        if (owner == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\u3002", (String)"PricePolicyEditPlugin_19", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
        }
        long saleOrgId = owner.getDynamicObject("bizgroup").getLong("id");
        tbFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"ocdbd_iteminfo", (Long)saleOrgId));
        tbFilters.add(new QFilter("enable", "=", (Object)"1"));
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, tbFilters);
    }

    private void setFilterByOwner(BeforeF7SelectEvent e, String pagemodelname) {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        DynamicObject owner = this.getModel().getDataEntity().getDynamicObject("salechannel");
        if (owner == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"PricePolicyEditPlugin_20", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
        }
        long createorg = owner.getDynamicObject("createorg").getLong("id");
        tbFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)pagemodelname, (Long)createorg));
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, tbFilters);
    }

    private void unit_beforeF7Select(BeforeF7SelectEvent e) {
        Object itemId = this.getEntryF7PKValue(E_PRICEENTRY, "item", e.getRow());
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01", (String)"PricePolicyEditPlugin_15", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            List ids = this.getUnitFormHandler().getUnitIdList(itemId);
            QFilter f1 = new QFilter("id", "in", (Object)ids);
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)f1);
        }
    }

    private void setFilterByOwner() {
        Object owner = this.getOwnerF7PKValue();
        this.setF7Filter("channel", CustomerUtil.getAuthSubsIdsQFilter((Object)owner));
    }

    private int getPrecision() {
        int amtprecision = 4;
        DynamicObject currency = this.getF7Value("currency");
        if (currency != null) {
            amtprecision = currency.getInt("priceprecision");
        }
        return amtprecision;
    }
}

