/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.price;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;
import org.apache.commons.lang.StringUtils;

public class PricePolicyListPlugin
extends OcbaseListPlugin {
    private static final String OP_COMBINPRICE = "combinprice";
    private static final String OP_PACKAGEPRICE = "packageprice";
    private static final String OP_ENTRYENABLE = "entryenable";
    private static final String OP_ENTRYDISABLE = "entrydisable";

    public void setFilter(SetFilterEvent e) {
        if (!this.isLookup()) {
            List fs = e.getQFilters();
            HashMap<String, QFilter> fsMap = new HashMap<String, QFilter>(fs.size());
            for (QFilter f : fs) {
                fsMap.put(f.getProperty(), f);
            }
            QFilter filter = (QFilter)fsMap.get("salechannel.id");
            boolean isContainsKey = fsMap.containsKey("salechannel.id");
            if (isContainsKey) {
                this.getPageCache().put(this.getView().getPageId() + "ownerId", filter.getValue().toString());
            } else {
                this.getPageCache().put(this.getView().getPageId() + "ownerId", "");
                fs.add(this.createFilter());
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initAuthoriedOwnerFilterComboItem(e, "salechannel.name");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "combinprice": {
                this.selectRowsCheck(e);
                break;
            }
            case "packageprice": {
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "entryenable": {
                this.setEnable(e, true);
                break;
            }
            case "entrydisable": {
                this.setEnable(e, false);
                break;
            }
            case "upgradedata": {
                if (!e.getOperationResult().isSuccess()) break;
                this.getListView().refresh();
                break;
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        IListColumn col = null;
        String propertyName = "assistattr.name";
        for (IListColumn iListColumn : columns) {
            if (iListColumn.getListFieldKey().compareTo(propertyName) != 0) continue;
            col = iListColumn;
        }
        columns.remove(col);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "refreshpricepolicy": {
                this.getListView().refresh();
            }
        }
    }

    private void selectRowsCheck(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] entryIds = selectedRows.getEntryPrimaryKeyValues();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if (ids.length > 1 || entryIds.length > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e00\u7ec4\u5408\u5546\u54c1\u5206\u5f55\u7ef4\u62a4\u5b50\u4ef6\u4ef7\u683c\u4fe1\u606f\uff01", (String)"PricePolicyListPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            e.cancel = true;
            return;
        }
        if (this.selectStatusCheck(ids[0], entryIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u6570\u636e\u4e0d\u80fd\u7ef4\u62a4\u5b50\u4ef6\u4ef7\u683c\uff01", (String)"PricePolicyListPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
        }
        this.showEditForm(ids[0], entryIds);
    }

    private void setEnable(AfterDoOperationEventArgs e, boolean isenable) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] entryIds = selectedRows.getEntryPrimaryKeyValues();
        try (TXHandle h = TX.requiresNew();){
            try {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(entryIds.length);
                String updatesql = "update t_ocdpm_pricepolicyentry set fenable = ? where FENTRYID = ?";
                for (Object object : entryIds) {
                    ArrayList<Object> dataValueList = new ArrayList<Object>(2);
                    dataValueList.add(isenable);
                    dataValueList.add(object);
                    paramsList.add(dataValueList.toArray());
                }
                if (paramsList.size() > 0) {
                    DB.executeBatch((DBRoute)new DBRoute("occ"), (String)updatesql, paramsList);
                }
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private boolean selectStatusCheck(Object id, Object[] pks) {
        boolean haAuditStatus = false;
        QFilter filter = new QFilter("id", "=", id);
        filter.and("priceentry.id", "in", (Object)pks);
        DynamicObjectCollection pricePlicys = QueryServiceHelper.query((String)"ocdpm_pricepolicy", (String)"id,status,priceentry.item", (QFilter[])filter.toArray());
        if (pricePlicys == null || pricePlicys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u8981\u4fee\u6539\u7684\u4ef7\u683c\u653f\u7b56\uff0c\u8bf7\u5148\u5237\u65b0\u5217\u8868\u540e\u518d\u64cd\u4f5c\uff01", (String)"PricePolicyListPlugin_2", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
        }
        HashSet<String> statuss = new HashSet<String>();
        statuss.add("B");
        statuss.add("C");
        DynamicObject entry = (DynamicObject)pricePlicys.get(0);
        if (statuss.contains(entry.getString("status"))) {
            haAuditStatus = true;
        } else {
            filter = new QFilter("id", "=", entry.get("priceentry.item"));
            DataSet dtset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocdbd_iteminfo", (String)"id,itemtypeid", (QFilter[])filter.toArray(), null);
            HashSet<String> itemtypeids = new HashSet<String>(1);
            while (dtset.hasNext()) {
                Row row = dtset.next();
                itemtypeids.add(row.getString("itemtypeid"));
            }
            if (!itemtypeids.contains("870945697287898112")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u5206\u5f55\u975e\u7ec4\u5408\u5546\u54c1\uff01", (String)"PricePolicyListPlugin_3", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
            }
        }
        return haAuditStatus;
    }

    private void showEditForm(Object id, Object[] pks) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ocdpm_combin_pricepolicy");
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        parameter.setCustomParam("id", id);
        parameter.setCustomParam("entryIds", (Object)StringUtils.join((Object[])pks, (String)","));
        this.getView().showForm(parameter);
    }

    private QFilter createFilter() {
        return new QFilter("salechannel.id", "in", (Object)this.getAuthoriedOwnerIDs());
    }
}

