/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocdpm.business.promote.helper.PromotionHelper;
import kd.occ.ocdpm.common.enums.PromoteItemEnum;
import kd.occ.ocdpm.formplugin.promote.AbstractPromoteFormPlugin;

public abstract class AbstractFamtFormPlugin
extends AbstractPromoteFormPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length == 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "itemclass": 
            case "itemlabel": 
            case "itembrand": {
                this.updateType(changeSet);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar", "baritem", "baritembrand", "baritemclass", "baritemlabel"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey;
        super.itemClick(evt);
        switch (itemkey = evt.getItemKey()) {
            case "baritem": {
                this.showPage("ocdbd_iteminfo", "item");
                break;
            }
            case "baritembrand": {
                this.showPage("mdr_item_brand", "itembrand");
                break;
            }
            case "baritemclass": {
                this.showPage("mdr_item_class", "itemclass");
                break;
            }
            case "baritemlabel": {
                this.showPage("ocdbd_item_label_layout", "itemlabel");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
        String callBack = e.getActionId();
        DynamicObjectCollection itemEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
        switch (callBack) {
            case "item": {
                this.fillItemEntity(returnDatas, itemEntry, "ocdbd_iteminfo");
                break;
            }
            case "itemclass": {
                this.fillItemEntity(returnDatas, itemEntry, "mdr_item_class");
                break;
            }
            case "itembrand": {
                this.fillItemEntity(returnDatas, itemEntry, "mdr_item_brand");
                break;
            }
            case "itemlabel": {
                this.fillItemEntity(returnDatas, itemEntry, "ocdbd_item_label");
                break;
            }
        }
    }

    private void updateType(ChangeData[] changeSet) {
        int row = changeSet[0].getRowIndex();
        DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry").get(row);
        int count = entry.getInt("count");
        if (changeSet[0].getNewValue() != null) {
            this.getModel().setValue("type", (Object)"5", row);
            this.getModel().setValue("count", (Object)(count + 1));
        } else {
            this.getModel().setValue("count", (Object)(count - 1));
            if (count - 1 == 0) {
                this.getModel().setValue("type", entry.get("typecopy"), row);
            }
        }
        this.getView().updateView("itementry", row);
    }

    public void fillItemEntity(ListSelectedRowCollection returnDatas, DynamicObjectCollection itemEntitys, String formId) {
        List<Object> id = returnDatas.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formId) {
            case "ocdbd_iteminfo": {
                this.addItemInfo(itemEntitys, id, formId);
                break;
            }
            case "mdr_item_class": {
                this.addItemClass(itemEntitys, id, formId);
                break;
            }
            case "mdr_item_brand": {
                this.addItemBrand(itemEntitys, id, formId);
                break;
            }
            case "ocdbd_item_label": {
                this.addItemLabel(itemEntitys, id, formId);
                break;
            }
        }
        this.getView().updateView("itementry");
    }

    public void addItemInfo(DynamicObjectCollection itemEntity, List<Object> itemId, String formId) {
        DynamicObject[] items = this.getItemEntity(itemId);
        Map itemLabelMap = PosItemUtil.getItemLabelMap(itemId);
        Map barCodeMap = PosItemUtil.getBarCodeMap(itemId);
        Map itemClassMap = PosItemUtil.getItemClassMap(itemId);
        for (DynamicObject item : items) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            String id = String.valueOf(item.getPkValue());
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("type", (Object)type);
            entry.set("material", item.get("material"));
            entry.set("item", (Object)item);
            entry.set("itembrand", (Object)item.getDynamicObject("itembrands"));
            entry.set("itemname", item.get("name"));
            entry.set("barcode", barCodeMap.get(id));
            entry.set("itemlabel", itemLabelMap.get(id));
            entry.set("itemclass", itemClassMap.get(id));
            entry.set("unit", (Object)item.getDynamicObject("retailunit"));
            entry.set("retailprice", item.get("retailprice"));
            entry.set("modelnum", item.get("modelnum"));
            itemEntity.add((Object)entry);
        }
    }

    public void addItemClass(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] classInfo;
        for (DynamicObject itemClass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("itemclass", (Object)itemClass);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public void addItemBrand(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("itembrand", (Object)brand);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    public void addItemLabel(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] labelInfo;
        for (DynamicObject label : labelInfo = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("itemlabel", (Object)label);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formId);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntity.add((Object)entry);
        }
    }

    private DynamicObject[] getItemEntity(List<Object> itemId) {
        return BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)this.getItemInfoField(), (QFilter[])new QFilter[]{new QFilter("id", "in", itemId)});
    }

    public String getItemInfoField() {
        return String.join((CharSequence)",", "itemclassentity.goodsclasssid", "itemclassentity.classstandardid", "itemclassentity", "itembrands", "retailunit", "retailprice", "modelnum", "name", "material");
    }

    public void showPage(String dataSourceFormId, String callBackTag) {
        PromotionHelper.showF7Page((IFormView)this.getView(), (AbstractFormPlugin)this, (String)dataSourceFormId, (String)callBackTag);
    }
}

