/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocdpm.business.promote.helper.AmtItemHelper;
import kd.occ.ocdpm.business.promote.helper.PromotionHelper;
import kd.occ.ocdpm.common.enums.PromoteItemEnum;
import kd.occ.ocdpm.common.util.ArabicToChineseUtils;
import kd.occ.ocdpm.formplugin.promote.GiftFormPlugintpl;

public class AmtGiftFormPlugin
extends GiftFormPlugintpl {
    @Override
    public void initpage(long pkId) {
        AmtItemHelper.initpage((IFormView)this.getView(), (long)pkId);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObjectCollection ladEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("ladentry");
        for (DynamicObject ladEntity : ladEntry) {
            this.getView().getModel().setValue("ladnumber", (Object)ArabicToChineseUtils.formatInteger((int)ladEntity.getInt("seq")), ladEntity.getInt("seq") - 1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "itemclass": 
            case "itemlabel": 
            case "itembrand": {
                this.updateType(changeSet);
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar", "baritem", "baritembrand", "baritemclass", "baritemlabel"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey;
        super.itemClick(evt);
        switch (itemkey = evt.getItemKey()) {
            case "baritem": {
                this.showPage("ocdbd_iteminfo", "item");
                break;
            }
            case "baritembrand": {
                this.showPage("mdr_item_brand", "itembrand");
                break;
            }
            case "baritemclass": {
                this.showPage("mdr_item_class", "itemclass");
                break;
            }
            case "baritemlabel": {
                this.showPage("ocdbd_item_label_layout", "itemlabel");
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        if (StringUtils.equals((CharSequence)"importitementry", (CharSequence)opKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocdpm_promote_import");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importitem_closedcallback"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnDatas = null;
        if (e.getReturnData() instanceof ListSelectedRowCollection) {
            returnDatas = (ListSelectedRowCollection)e.getReturnData();
        }
        String callBack = e.getActionId();
        DynamicObjectCollection itemEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
        switch (callBack) {
            case "item": {
                this.fillItemEntity(returnDatas, itemEntry, "ocdbd_iteminfo");
                break;
            }
            case "itemclass": {
                this.fillItemEntity(returnDatas, itemEntry, "mdr_item_class");
                break;
            }
            case "itembrand": {
                this.fillItemEntity(returnDatas, itemEntry, "mdr_item_brand");
                break;
            }
            case "itemlabel": {
                this.fillItemEntity(returnDatas, itemEntry, "ocdbd_item_label");
                break;
            }
            case "importitem_closedcallback": {
                this.fillImportDataItemEntry(e);
                break;
            }
        }
    }

    private void updateType(ChangeData[] changeSet) {
        int row = changeSet[0].getRowIndex();
        DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry").get(row);
        int count = entry.getInt("count");
        if (changeSet[0].getNewValue() != null) {
            this.getModel().setValue("type", (Object)"5", row);
            this.getModel().setValue("count", (Object)(count + 1));
        } else {
            this.getModel().setValue("count", (Object)(count - 1));
            if (count - 1 == 0) {
                this.getModel().setValue("type", entry.get("typecopy"), row);
            }
        }
        this.getView().updateView("itementry", row);
    }

    public void fillItemEntity(ListSelectedRowCollection returnDatas, DynamicObjectCollection itemEntitys, String formid) {
        if (returnDatas == null) {
            return;
        }
        List<Object> id = returnDatas.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formid) {
            case "ocdbd_iteminfo": {
                this.addItemInfo(itemEntitys, id, formid);
                break;
            }
            case "mdr_item_class": {
                this.addItemClass(itemEntitys, id, formid);
                break;
            }
            case "mdr_item_brand": {
                this.addItemBrand(itemEntitys, id, formid);
                break;
            }
            case "ocdbd_item_label": {
                this.addItemLabel(itemEntitys, id, formid);
                break;
            }
        }
        this.getView().updateView("itementry");
    }

    public void addItemInfo(DynamicObjectCollection itemEntitys, List<Object> itemId, String formid) {
        DynamicObject[] items;
        for (DynamicObject item : items = this.getItemEntity(itemId)) {
            DynamicObject entry = new DynamicObject(itemEntitys.getDynamicObjectType());
            String type = PromoteItemEnum.getTpyeValueBykey((String)formid);
            entry.set("type", (Object)type);
            entry.set("material", item.get("material"));
            entry.set("item", (Object)item);
            entry.set("itembrand", (Object)item.getDynamicObject("itembrands"));
            entry.set("itemname", item.get("name"));
            entry.set("barcode", (Object)this.getBarCodeInfo(item));
            entry.set("itemlabel", (Object)this.getItemLabel(item));
            entry.set("itemclass", (Object)PosItemUtil.queryItemClass((DynamicObject)item));
            entry.set("unit", (Object)item.getDynamicObject("retailunit"));
            entry.set("retailprice", item.get("retailprice"));
            entry.set("modelnum", item.get("modelnum"));
            itemEntitys.add((Object)entry);
        }
    }

    public void addItemClass(DynamicObjectCollection itemEntitys, List<Object> id, String formid) {
        DynamicObject[] classInfo;
        for (DynamicObject itemclass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntitys.getDynamicObjectType());
            entry.set("itemclass", (Object)itemclass);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formid);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntitys.add((Object)entry);
        }
    }

    public void addItemBrand(DynamicObjectCollection itemEntitys, List<Object> id, String formid) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntitys.getDynamicObjectType());
            entry.set("itembrand", (Object)brand);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formid);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntitys.add((Object)entry);
        }
    }

    public void addItemLabel(DynamicObjectCollection itemEntitys, List<Object> id, String formid) {
        DynamicObject[] labelInfo;
        for (DynamicObject label : labelInfo = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntitys.getDynamicObjectType());
            entry.set("itemlabel", (Object)label);
            String type = PromoteItemEnum.getTpyeValueBykey((String)formid);
            entry.set("type", (Object)type);
            entry.set("typecopy", (Object)type);
            itemEntitys.add((Object)entry);
        }
    }

    private void fillImportDataItemEntry(ClosedCallBackEvent e) {
        List importList = (List)e.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)importList)) {
            DynamicObjectCollection itemEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
            for (JSONObject importInfo : importList) {
                DynamicObject entryRow = itemEntry.addNew();
                entryRow.set("type", importInfo.get((Object)"type"));
                entryRow.set("item", importInfo.get((Object)"item"));
                entryRow.set("itemclass", importInfo.get((Object)"itemClass"));
                entryRow.set("itembrand", importInfo.get((Object)"itemBrand"));
                entryRow.set("itemlabel", importInfo.get((Object)"itemLabel"));
                entryRow.set("unit", importInfo.get((Object)"unit"));
                entryRow.set("material", importInfo.get((Object)"material"));
                entryRow.set("barcode", importInfo.get((Object)"barCode"));
                entryRow.set("retailprice", importInfo.get((Object)"retailprice"));
            }
            this.getView().updateView("itementry");
        }
    }

    private DynamicObject[] getItemEntity(List<Object> itemId) {
        return BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)this.getItemInfoField(), (QFilter[])new QFilter[]{new QFilter("id", "in", itemId)});
    }

    public String getItemInfoField() {
        return String.join((CharSequence)",", "itemclassentity.goodsclasssid", "itemclassentity.classstandardid", "itemclassentity", "itembrands", "retailunit", "retailprice", "modelnum", "name", "material");
    }

    private DynamicObject getBarCodeInfo(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_barcode", (String)"id", (QFilter[])new QFilter[]{new QFilter("item.id", "=", item.getPkValue())});
    }

    private DynamicObject getItemLabel(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.item.id", "=", item.getPkValue())});
    }

    public void showPage(String datasourceFormid, String callbacktag) {
        PromotionHelper.showF7Page((IFormView)this.getView(), (AbstractFormPlugin)this, (String)datasourceFormid, (String)callbacktag);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        int index;
        FieldEdit source = (FieldEdit)e.getSource();
        if ("targetamount".equals(source.getFieldKey()) && (index = this.getModel().getEntryCurrentRowIndex("ladentry")) > 0) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("ladentry", index);
            Object value = e.getValue();
            BigDecimal targetAmount = ObjectUtils.isEmpty((Object)value) ? BigDecimal.ZERO : new BigDecimal(value.toString());
            DynamicObject rowEntityLast = this.getModel().getEntryRowEntity("ladentry", index - 1);
            BigDecimal targetAmountLast = rowEntityLast.getBigDecimal("targetamount");
            if (targetAmountLast.compareTo(BigDecimal.ZERO) == 0) {
                NotificationUtil.showTipNotification((String)ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u524d\u4e00\u4e2a\u9636\u68af\u6ee1\u8db3\u91d1\u989d", (String)"AmtGiftFormPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), (IFormView)this.getView(), (Integer)1000);
                e.setCancel(true);
                this.getView().updateView("targetamount", index);
            } else if (targetAmount.compareTo(targetAmountLast) <= 0) {
                NotificationUtil.showTipNotification((String)ResManager.loadKDString((String)"\u5f53\u524d\u9636\u68af\u6ee1\u8db3\u91d1\u989d\u9700\u5927\u4e8e\u524d\u4e00\u4e2a\u9636\u68af\u91d1\u989d", (String)"AmtGiftFormPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), (IFormView)this.getView(), (Integer)1000);
                e.setCancel(true);
                this.getView().updateView("targetamount", index);
            }
        }
    }
}

