/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocdpm.business.promote.helper.BindPriceHelper;
import kd.occ.ocdpm.formplugin.promote.BindPromoteFormPlugin;

public class BindPriceFormplugin
extends BindPromoteFormPlugin {
    @Override
    public void initpage(long pkId) {
        BindPriceHelper.initpage((IDataModel)this.getView().getModel(), (long)pkId);
    }

    @Override
    public void customUpdate(IDataModel dataModel) {
        this.updateTotalAmount(dataModel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        IDataModel dataModel = this.getView().getModel();
        switch (fieldKey = e.getProperty().getName()) {
            case "promotionprice": {
                Object newValue = changeSet[0].getNewValue();
                int index = dataModel.getEntryCurrentRowIndex("ruleentry");
                DynamicObject rule = (DynamicObject)dataModel.getEntryEntity("ruleentry").get(index);
                DynamicObjectCollection groupitementry = rule.getDynamicObjectCollection("groupitementry");
                groupitementry.stream().forEach(a -> a.set("promotionprice", newValue));
                this.getView().updateView("groupitementry");
                this.updateTotalAmount(dataModel);
                break;
            }
        }
    }

    private void updateTotalAmount(IDataModel dataModel) {
        DynamicObjectCollection rules = dataModel.getEntryEntity("ruleentry");
        BigDecimal sum = new BigDecimal(0);
        for (DynamicObject rule : rules) {
            int pickQty = rule.getInt("pickqty");
            DynamicObjectCollection item = rule.getDynamicObjectCollection("groupitementry");
            if (CollectionUtils.isEmpty((Collection)item)) continue;
            DynamicObject subItem = (DynamicObject)item.get(0);
            int saleQty = subItem.getInt("saleqty");
            BigDecimal promotionprice = subItem.getBigDecimal("promotionprice");
            BigDecimal totalAmount = promotionprice.multiply(BigDecimal.valueOf(saleQty)).multiply(BigDecimal.valueOf(pickQty));
            sum = sum.add(totalAmount);
        }
        dataModel.setValue("bindtotalamount", (Object)sum);
        this.getView().updateView("bindtotalamount");
    }
}

