/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocdpm.business.promote.helper.PromotionHelper;
import kd.occ.ocdpm.common.enums.PromoteItemEnum;
import kd.occ.ocdpm.formplugin.promote.AbstractPromoteFormPlugin;

public abstract class BindPromoteFormPlugin
extends AbstractPromoteFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"gbaritem", "baritem", "baritembrand", "baritemclass", "baritemlabel", "gbaritembrand", "gbaritemclass", "gbaritemlabel"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        IDataModel dataModel = this.getView().getModel();
        switch (fieldKey = e.getProperty().getName()) {
            case "pickqty": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                int sumitemqty = (Integer)dataModel.getValue("sumitemqty", rowIndex);
                int pickqty = (Integer)e.getChangeSet()[0].getNewValue();
                if (pickqty > sumitemqty) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5546\u54c1\u603b\u6570\u91cf", (String)"BindPromoteFormPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    dataModel.setValue("pickqty", (Object)0, rowIndex);
                    return;
                }
                this.customUpdate(dataModel);
                this.updateBindPickQty(dataModel);
                break;
            }
            case "itemgroup": {
                String itemGroup = this.getModel().getDataEntity(true).getString("itemgroup");
                if ("3".equals(itemGroup)) {
                    dataModel.deleteEntryData("itementry");
                    break;
                }
                dataModel.deleteEntryData("ruleentry");
                dataModel.createNewEntryRow("ruleentry");
                break;
            }
            case "saleqty": {
                Object newValue = changeSet[0].getNewValue();
                int index = dataModel.getEntryCurrentRowIndex("ruleentry");
                DynamicObject rule = (DynamicObject)dataModel.getEntryEntity("ruleentry").get(index);
                DynamicObjectCollection groupitementry = rule.getDynamicObjectCollection("groupitementry");
                groupitementry.stream().forEach(a -> a.set("saleqty", newValue));
                this.updateBindPickQty(dataModel);
                this.customUpdate(dataModel);
                this.getView().updateView("groupitementry");
                break;
            }
        }
    }

    private void updateBindPickQty(IDataModel dataModel) {
        DynamicObjectCollection rules = dataModel.getEntryEntity("ruleentry");
        int bindpickqty = 0;
        for (DynamicObject rule : rules) {
            int pickQty = rule.getInt("pickqty");
            DynamicObjectCollection item = rule.getDynamicObjectCollection("groupitementry");
            if (CollectionUtils.isEmpty((Collection)item)) continue;
            int saleQty = ((DynamicObject)item.get(0)).getInt("saleqty");
            bindpickqty += pickQty * saleQty;
        }
        dataModel.setValue("bindpickqty", (Object)bindpickqty);
        this.getView().updateView("bindpickqty");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"ruleentry", (CharSequence)e.getEntryProp().getName())) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowindex = rowDataEntity.getRowIndex();
                DynamicObject currentRow = rowDataEntity.getDataEntity();
                currentRow.set("groupseqno", (Object)(rowindex + 1));
                this.getView().updateView("groupseqno", rowindex);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String propertyName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"groupitementry", (CharSequence)propertyName)) {
            int index = this.getModel().getEntryCurrentRowIndex("ruleentry");
            DynamicObjectCollection groupentity = this.getView().getModel().getEntryEntity("ruleentry");
            DynamicObject dynamicObject = (DynamicObject)groupentity.get(index);
            int sum = dynamicObject.getInt("sumitemqty");
            dynamicObject.set("sumitemqty", (Object)(sum - 1));
            this.getView().updateView("sumitemqty", index);
        } else if (StringUtils.equals((CharSequence)"ruleentry", (CharSequence)propertyName)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("ruleentry");
            int i = 1;
            for (DynamicObject dynamicObject : entryEntity) {
                dynamicObject.set("groupseqno", (Object)i);
                ++i;
            }
            this.getView().updateView("ruleentry");
            this.updateBindPickQty(this.getModel());
            this.customUpdate(this.getModel());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "baritem": {
                this.showPage("ocdbd_iteminfo", "item");
                break;
            }
            case "baritembrand": {
                this.showPage("mdr_item_brand", "baritembrand");
                break;
            }
            case "baritemclass": {
                this.showPage("mdr_item_class", "baritemclass");
                break;
            }
            case "baritemlabel": {
                this.showPage("ocdbd_item_label", "baritemlabel");
                break;
            }
            case "gbaritem": {
                this.showPage("ocdbd_iteminfo", "gitem");
                break;
            }
            case "gbaritembrand": {
                this.showPage("mdr_item_brand", "gbaritembrand");
                break;
            }
            case "gbaritemclass": {
                this.showPage("mdr_item_class", "gbaritemclass");
                break;
            }
            case "gbaritemlabel": {
                this.showPage("ocdbd_item_label", "gbaritemlabel");
                break;
            }
        }
    }

    public void showPage(String dataSourceFormId, String callBackTag) {
        PromotionHelper.showF7Page((IFormView)this.getView(), (AbstractFormPlugin)this, (String)dataSourceFormId, (String)callBackTag);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
        String callBack = e.getActionId();
        DynamicObjectCollection itemEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("ruleentry");
        DynamicObjectCollection ruleEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("ruleentry");
        DynamicObjectCollection groupItemEntry = ((DynamicObject)ruleEntry.get(entryCurrentRowIndex)).getDynamicObjectCollection("groupitementry");
        switch (callBack) {
            case "item": {
                this.fillItemEntity(returnDatas, itemEntry, "ocdbd_iteminfo");
                break;
            }
            case "baritemclass": {
                this.fillItemEntity(returnDatas, itemEntry, "mdr_item_class");
                break;
            }
            case "baritembrand": {
                this.fillItemEntity(returnDatas, itemEntry, "mdr_item_brand");
                break;
            }
            case "baritemlabel": {
                this.fillItemEntity(returnDatas, itemEntry, "ocdbd_item_label");
                break;
            }
            case "gitem": {
                this.fillExItemEntity(returnDatas, groupItemEntry, "ocdbd_iteminfo");
                break;
            }
            case "gbaritemclass": {
                this.fillExItemEntity(returnDatas, groupItemEntry, "mdr_item_class");
                break;
            }
            case "gbaritembrand": {
                this.fillExItemEntity(returnDatas, groupItemEntry, "mdr_item_brand");
                break;
            }
            case "gbaritemlabel": {
                this.fillExItemEntity(returnDatas, groupItemEntry, "ocdbd_item_label");
                break;
            }
        }
        ((DynamicObject)ruleEntry.get(entryCurrentRowIndex)).set("sumitemqty", (Object)groupItemEntry.size());
        this.getView().updateView("ruleentry", entryCurrentRowIndex);
        this.getView().updateView("groupitementry");
        EntryGrid control = (EntryGrid)this.getView().getControl("ruleentry");
        control.selectRows(entryCurrentRowIndex);
    }

    public void fillItemEntity(ListSelectedRowCollection returnData, DynamicObjectCollection itemEntity, String formId) {
        List<Object> id = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formId) {
            case "ocdbd_iteminfo": {
                this.addItemInfo(itemEntity, id, formId);
                break;
            }
            case "mdr_item_class": {
                this.addItemClass(itemEntity, id, formId);
                break;
            }
            case "mdr_item_brand": {
                this.addItemBrand(itemEntity, id, formId);
                break;
            }
            case "ocdbd_item_label": {
                this.addItemLabel(itemEntity, id, formId);
                break;
            }
        }
        this.getView().updateView("itementry");
    }

    public void fillExItemEntity(ListSelectedRowCollection returnData, DynamicObjectCollection exItemEntity, String formId) {
        List<Object> id = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formId) {
            case "ocdbd_iteminfo": {
                this.addExItemInfo(exItemEntity, id, formId);
                break;
            }
            case "mdr_item_class": {
                this.addExItemClass(exItemEntity, id, formId);
                break;
            }
            case "mdr_item_brand": {
                this.addExItemBrand(exItemEntity, id, formId);
                break;
            }
            case "ocdbd_item_label": {
                this.addExItemLabel(exItemEntity, id, formId);
                break;
            }
        }
    }

    public void addItemLabel(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] labelInfo;
        for (DynamicObject label : labelInfo = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("itemlabelid", (Object)label);
            entry.set("type", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemEntity.add((Object)entry);
        }
    }

    public void addExItemLabel(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] labelInfo;
        for (DynamicObject label : labelInfo = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("gitemlabelid", (Object)label);
            entry.set("gtype", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemEntity.add((Object)entry);
        }
    }

    public void addItemBrand(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject item = new DynamicObject(itemEntity.getDynamicObjectType());
            item.set("itembrandid", (Object)brand);
            item.set("type", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemEntity.add((Object)item);
        }
    }

    public void addExItemBrand(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject item = new DynamicObject(itemEntity.getDynamicObjectType());
            item.set("gitembrandid", (Object)brand);
            item.set("gtype", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemEntity.add((Object)item);
        }
    }

    public void addItemClass(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] classInfo;
        for (DynamicObject itemClass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("itemclassid", (Object)itemClass);
            entry.set("type", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemEntity.add((Object)entry);
        }
    }

    public void addExItemClass(DynamicObjectCollection itemEntity, List<Object> id, String formId) {
        DynamicObject[] classInfo;
        for (DynamicObject itemClass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject entry = new DynamicObject(itemEntity.getDynamicObjectType());
            entry.set("gitemclassid", (Object)itemClass);
            entry.set("gtype", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemEntity.add((Object)entry);
        }
    }

    public void addItemInfo(DynamicObjectCollection itemEntity, List<Object> itemId, String formId) {
        DynamicObject[] items = this.getItemEntity(itemId);
        Map itemLabelMap = PosItemUtil.getItemLabelMap(itemId);
        Map barCodeMap = PosItemUtil.getBarCodeMap(itemId);
        Map itemClassMap = PosItemUtil.getItemClassMap(itemId);
        for (DynamicObject item : items) {
            String id = String.valueOf(item.getPkValue());
            DynamicObject itemInfo = new DynamicObject(itemEntity.getDynamicObjectType());
            itemInfo.set("type", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemInfo.set("itemid", (Object)item);
            itemInfo.set("itembrandid", (Object)item.getDynamicObject("itembrands"));
            itemInfo.set("itemname", item.get("name"));
            itemInfo.set("barcodeid", barCodeMap.get(id));
            itemInfo.set("itemlabelid", itemLabelMap.get(id));
            itemInfo.set("itemclassid", itemClassMap.get(id));
            itemInfo.set("retailprice", item.get("retailprice"));
            itemInfo.set("modelnum", item.get("modelnum"));
            itemEntity.add((Object)itemInfo);
        }
    }

    public void addExItemInfo(DynamicObjectCollection itemEntity, List<Object> itemId, String formId) {
        DynamicObject[] items = this.getItemEntity(itemId);
        Map itemLabelMap = PosItemUtil.getItemLabelMap(itemId);
        Map barCodeMap = PosItemUtil.getBarCodeMap(itemId);
        Map itemClassMap = PosItemUtil.getItemClassMap(itemId);
        for (DynamicObject item : items) {
            String id = String.valueOf(item.getPkValue());
            DynamicObject itemInfo = new DynamicObject(itemEntity.getDynamicObjectType());
            itemInfo.set("gtype", (Object)PromoteItemEnum.getTpyeValueBykey((String)formId));
            itemInfo.set("gitemid", (Object)item);
            itemInfo.set("gitembrandid", (Object)item.getDynamicObject("itembrands"));
            itemInfo.set("gitemname", item.get("name"));
            itemInfo.set("gbarcodeid", barCodeMap.get(id));
            itemInfo.set("gitemlabelid", itemLabelMap.get(id));
            itemInfo.set("gitemclassid", itemClassMap.get(id));
            itemInfo.set("gretailprice", item.get("retailprice"));
            itemInfo.set("gmodelnum", item.get("modelnum"));
            itemEntity.add((Object)itemInfo);
        }
    }

    private DynamicObject[] getItemEntity(List<Object> itemId) {
        return BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)this.getItemInfoField(), (QFilter[])new QFilter[]{new QFilter("id", "in", itemId)});
    }

    public String getItemInfoField() {
        return String.join((CharSequence)",", "itemclassentity.goodsclasssid", "itemclassentity.classstandardid", "itemclassentity", "itembrands", "retailunit", "retailprice", "modelnum", "name");
    }

    abstract void customUpdate(IDataModel var1);
}

