/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocdpm.business.promote.helper.FamtitemHelper;
import kd.occ.ocdpm.formplugin.promote.AbstractPromoteFormPlugin;

public class FamtitemFormplugin
extends AbstractPromoteFormPlugin {
    @Override
    public void initpage(long pkId) {
        FamtitemHelper.initpage((IDataModel)this.getView().getModel(), (long)pkId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"select"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("select".equals(((Button)evt.getSource()).getKey())) {
            this.showPage("ocdbd_iteminfo", "iteminfock");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (null == changeSet) {
            return;
        }
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        switch (field = e.getProperty().getName()) {
            case "pickqty": {
                if (oldValue == null) {
                    oldValue = 0;
                }
                int index = changeSet[0].getRowIndex();
                DynamicObject selectLadEntry = (DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("ladentry").get(index);
                if (selectLadEntry.getInt("sumitemqty") < Integer.parseInt(newValue.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u91cf\u4e0d\u53ef\u5927\u4e8e\u5546\u54c1\u603b\u6570\u3002", (String)"FamtitemFormplugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                    this.getView().getModel().setValue("pickqty", (Object)Integer.parseInt(oldValue.toString()), index);
                }
                this.updateSumQty();
                break;
            }
            case "itemqty": {
                int entryCurrentRowIndex = this.getView().getModel().getEntryCurrentRowIndex("ladentry");
                DynamicObject ruleEntry = this.getView().getModel().getEntryRowEntity("ladentry", entryCurrentRowIndex);
                DynamicObjectCollection itemEntrys = ruleEntry.getDynamicObjectCollection("groupitementry");
                for (DynamicObject itemEntry : itemEntrys) {
                    itemEntry.set("itemqty", newValue);
                }
                this.getView().updateView("groupitementry");
                this.updateSumQty();
                break;
            }
        }
        this.getView().updateView("groupitementry");
    }

    private void updateSumQty() {
        int qty = 0;
        DynamicObjectCollection ladEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("ladentry");
        for (DynamicObject entry : ladEntry) {
            DynamicObjectCollection itemEntry = entry.getDynamicObjectCollection("groupitementry");
            if (CollectionUtils.isEmpty((Collection)itemEntry)) continue;
            qty += ((DynamicObject)itemEntry.get(0)).getInt("itemqty") * entry.getInt("pickqty");
        }
        this.getView().getModel().setValue("sumgiveqty", (Object)qty);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection ruleEntrys = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("ladentry");
        if (CollectionUtils.isEmpty((Collection)ruleEntrys)) {
            return;
        }
        int index = 65;
        for (DynamicObject ruleEntry : ruleEntrys) {
            ruleEntry.set("groupno", (Object)String.valueOf((char)index++));
        }
        this.getView().updateView("ladentry");
        this.getView().updateView("groupitementry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        DynamicObjectCollection ruleEntrys = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("ladentry");
        if (CollectionUtils.isEmpty((Collection)ruleEntrys)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"select", "delete"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"select", "delete"});
        }
        int index = 65;
        for (int y = 0; y < ruleEntrys.size(); ++y) {
            this.getView().getModel().setValue("groupno", (Object)String.valueOf((char)(index + y)), y);
        }
    }

    public void showPage(String datasourceFormid, String callbacktag) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        ListShowParameter listParam = FormShowUtils.openChooseList(null, (String)datasourceFormid, (ShowType)ShowType.Modal, Arrays.asList(filter.toArray()), (boolean)true, (boolean)true);
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbacktag));
        this.getView().showForm((FormShowParameter)listParam);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
        List ids = returnDatas.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        String callBack = e.getActionId();
        int index = this.getView().getModel().getEntryCurrentRowIndex("ladentry");
        DynamicObject ruleEntry = this.getView().getModel().getEntryRowEntity("ladentry", index);
        DynamicObjectCollection itemEntry = ruleEntry.getDynamicObjectCollection("groupitementry");
        if ("iteminfock".equals(callBack)) {
            StringBuilder tip = new StringBuilder();
            for (Object id : ids) {
                DynamicObject item = BusinessDataServiceHelper.loadSingle(id, (String)"ocdbd_iteminfo");
                DynamicObject itemInfo = new DynamicObject(itemEntry.getDynamicObjectType());
                itemInfo.set("itemid", (Object)item);
                itemInfo.set("itembrand", (Object)item.getDynamicObject("itembrands"));
                itemInfo.set("unit", (Object)item.getDynamicObject("retailunit"));
                itemInfo.set("itemclassid", (Object)PosItemUtil.queryItemClass((DynamicObject)item));
                itemInfo.set("itemname", (Object)item.getString("name"));
                DynamicObject barCode = FamtitemFormplugin.getBarCodeInfo(item);
                itemInfo.set("barcodeid", (Object)barCode);
                itemInfo.set("retailprice", item.get("retailprice"));
                DynamicObject materialinventoryinfo = this.getMaterialinventoryinfo(item);
                if (null == materialinventoryinfo) {
                    if (tip.length() > 0) {
                        tip.append('\u3001');
                    }
                    tip.append(item.get("name"));
                    continue;
                }
                itemInfo.set("materialinfo", (Object)materialinventoryinfo);
                if (!CollectionUtils.isEmpty((Collection)itemEntry)) {
                    itemInfo.set("itemqty", (Object)((DynamicObject)itemEntry.get(0)).getInt("itemqty"));
                }
                itemEntry.add((Object)itemInfo);
            }
            if (tip.length() > 0) {
                tip.append(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u7269\u6599\u5e93\u5b58\u4fe1\u606f,\u65e0\u6cd5\u4f5c\u4e3a\u8d60\u54c1", (String)"FamtitemFormplugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(tip.toString(), Integer.valueOf(3000));
            }
        }
        this.getView().updateView("groupitementry");
        this.getView().getModel().setValue("sumitemqty", (Object)ruleEntry.getDynamicObjectCollection("groupitementry").size(), index);
    }

    private DynamicObject getMaterialinventoryinfo(DynamicObject item) {
        QFilter filter = new QFilter("masterid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"material"));
        return BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])filter.toArray());
    }

    private static DynamicObject getBarCodeInfo(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_barcode", (String)"id", (QFilter[])new QFilter[]{new QFilter("item.id", "=", item.getPkValue())});
    }
}

