/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.PosItemUtil;

public class FqtyGiftFormSubPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getCustomParams().get("id") == null) {
            return;
        }
        String id = showParameter.getCustomParams().get("id").toString();
        DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocdpm_promote_rule"));
        DynamicObjectCollection subGroupEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("groupentry");
        FqtyGiftFormSubPlugin.setGroupEntry(group, subGroupEntry);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("pickqty".equals(e.getProperty().getName())) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue == null) {
                oldValue = 0;
            }
            Object newValue = e.getChangeSet()[0].getNewValue();
            int index = e.getChangeSet()[0].getRowIndex();
            DynamicObject selectLadEntry = (DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("groupentry").get(index);
            if (selectLadEntry.getInt("sumitemqty") < Integer.parseInt(newValue.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u91cf\u4e0d\u53ef\u5927\u4e8e\u5546\u54c1\u603b\u6570\u3002", (String)"FqtyGiftFormSubPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                this.getView().getModel().setValue("pickqty", (Object)Integer.parseInt(oldValue.toString()), index);
            }
        }
        if ("itemqty".equals(e.getProperty().getName()) && CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            int index = this.getView().getModel().getEntryCurrentRowIndex("groupentry");
            DynamicObject ruleEntry = this.getView().getModel().getEntryRowEntity("groupentry", index);
            DynamicObjectCollection itemEntrys = ruleEntry.getDynamicObjectCollection("groupitementry");
            if (CollectionUtils.isEmpty((Collection)itemEntrys)) {
                return;
            }
            for (DynamicObject itemEntry : itemEntrys) {
                itemEntry.set("itemqty", newValue);
            }
            this.getView().updateView("groupitementry");
            this.upDataNumber();
        }
        if ("pickqty".equals(e.getProperty().getName()) && CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            this.upDataNumber();
        }
        if ("deliverystocktype".equals(e.getProperty().getName()) || "deliverymode".equals(e.getProperty().getName())) {
            this.getView().updateView("groupitementry");
        }
    }

    private void upDataNumber() {
        DynamicObjectCollection ladEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("groupentry");
        if (CollectionUtils.isEmpty((Collection)ladEntry)) {
            this.upDataToParent();
            return;
        }
        int index = this.getView().getModel().getEntryCurrentRowIndex("groupentry");
        DynamicObjectCollection itemEntry = ((DynamicObject)ladEntry.get(index)).getDynamicObjectCollection("groupitementry");
        if (CollectionUtils.isEmpty((Collection)itemEntry)) {
            ((DynamicObject)ladEntry.get(index)).set("entrynumberofthis", (Object)0);
            this.getView().getModel().setValue("numberofthis", (Object)0);
        } else {
            int number = ((DynamicObject)itemEntry.get(0)).getInt("itemqty") * ((DynamicObject)ladEntry.get(index)).getInt("pickqty");
            ((DynamicObject)ladEntry.get(index)).set("entrynumberofthis", (Object)number);
            this.getView().getModel().setValue("numberofthis", (Object)((DynamicObject)itemEntry.get(0)).getInt("itemqty"));
        }
        this.upDataToParent();
    }

    private void upDataToParent() {
        DynamicObjectCollection groupentry = this.getView().getModel().getEntryEntity("groupentry");
        int sum = 0;
        for (DynamicObject dyo : groupentry) {
            sum += dyo.getInt("entrynumberofthis");
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("ladentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection ladentry = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("ladentry");
        if (selectRows.length == 1) {
            ((DynamicObject)ladentry.get(selectRows[0])).set("ladsumgiveqty", (Object)sum);
            this.getView().getParentView().updateView("ladentry");
            entryGrid.selectRows(selectRows[0], true);
            this.getView().sendFormAction(this.getView().getParentView());
        } else if (selectRows.length == 0) {
            ((DynamicObject)ladentry.get(0)).set("ladsumgiveqty", (Object)sum);
            this.getView().getParentView().updateView("ladentry");
            entryGrid.selectRows(0, true);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection ruleEntrys = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("groupentry");
        if (CollectionUtils.isEmpty((Collection)ruleEntrys)) {
            return;
        }
        int index = 65;
        for (DynamicObject ruleEntry : ruleEntrys) {
            ruleEntry.set("groupno", (Object)String.valueOf((char)index++));
        }
        this.getView().updateView("groupentry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObjectCollection ruleEntrys = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("groupentry");
        if (CollectionUtils.isEmpty((Collection)ruleEntrys)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"select", "delete"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"select", "delete"});
        }
        int index = 65;
        for (int y = 0; y < ruleEntrys.size(); ++y) {
            this.getView().getModel().setValue("groupno", (Object)String.valueOf((char)(index + y)), y);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"select"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("groupentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("select".equals(((Button)evt.getSource()).getKey())) {
            this.showPage("ocdbd_iteminfo", "iteminfock");
        }
    }

    public void showPage(String datasourceFormid, String callbacktag) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        ListShowParameter listParam = FormShowUtils.openChooseList(null, (String)datasourceFormid, (ShowType)ShowType.Modal, Arrays.asList(filter.toArray()), (boolean)true, (boolean)true);
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbacktag));
        this.getView().showForm((FormShowParameter)listParam);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.upDataNumber();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
        List ids = returnDatas.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        String callBack = e.getActionId();
        int index = this.getView().getModel().getEntryCurrentRowIndex("groupentry");
        DynamicObject ruleEntry = this.getView().getModel().getEntryRowEntity("groupentry", index);
        DynamicObjectCollection itemEntry = ruleEntry.getDynamicObjectCollection("groupitementry");
        if ("iteminfock".equals(callBack)) {
            StringBuilder tip = new StringBuilder();
            for (Object id : ids) {
                DynamicObject item = BusinessDataServiceHelper.loadSingle(id, (String)"ocdbd_iteminfo");
                DynamicObject itemInfo = new DynamicObject(itemEntry.getDynamicObjectType());
                itemInfo.set("itemid", (Object)item);
                itemInfo.set("itembrand", (Object)item.getDynamicObject("itembrands"));
                itemInfo.set("unit", (Object)item.getDynamicObject("retailunit"));
                itemInfo.set("itemclassid", (Object)PosItemUtil.queryItemClass((DynamicObject)item));
                itemInfo.set("itemname", (Object)item.getString("name"));
                DynamicObject barCode = FqtyGiftFormSubPlugin.getBarCodeInfo(item);
                itemInfo.set("barcodeid", (Object)barCode);
                itemInfo.set("retailprice", item.get("retailprice"));
                DynamicObject materialinventoryinfo = this.getMaterialinventoryinfo(item);
                if (null == materialinventoryinfo) {
                    if (tip.length() > 0) {
                        tip.append('\u3001');
                    }
                    tip.append(item.get("name"));
                    continue;
                }
                itemInfo.set("submaterialinfo", (Object)materialinventoryinfo);
                if (!CollectionUtils.isEmpty((Collection)itemEntry)) {
                    itemInfo.set("itemqty", (Object)((DynamicObject)itemEntry.get(0)).getInt("itemqty"));
                }
                itemEntry.add((Object)itemInfo);
            }
            if (tip.length() > 0) {
                tip.append(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u7269\u6599\u5e93\u5b58\u4fe1\u606f,\u65e0\u6cd5\u4f5c\u4e3a\u8d60\u54c1", (String)"FqtyGiftFormSubPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(tip.toString(), Integer.valueOf(3000));
            }
        }
        this.getView().updateView("groupitementry");
        this.getView().getModel().setValue("sumitemqty", (Object)ruleEntry.getDynamicObjectCollection("groupitementry").size(), index);
    }

    private static DynamicObject getBarCodeInfo(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_barcode", (String)"id", (QFilter[])new QFilter[]{new QFilter("item.id", "=", item.getPkValue())});
    }

    private static void setGroupEntry(DynamicObject group, DynamicObjectCollection subGroupEntry) {
        subGroupEntry.clear();
        DynamicObjectCollection ruleGroupEntry = group.getDynamicObjectCollection("groupentry");
        for (DynamicObject ruleGroup : ruleGroupEntry) {
            DynamicObject newSubGroup = new DynamicObject(subGroupEntry.getDynamicObjectType());
            newSubGroup.set("groupno", ruleGroup.get("ggroupno"));
            newSubGroup.set("sumitemqty", ruleGroup.get("gsumitemqty"));
            newSubGroup.set("pickqty", ruleGroup.get("gpickqty"));
            DynamicObjectCollection ruleItemEntry = ruleGroup.getDynamicObjectCollection("subgiftitementry");
            if (!CollectionUtils.isEmpty((Collection)ruleItemEntry)) {
                int pickQty = ruleGroup.getInt("gpickqty");
                int number = ((DynamicObject)ruleItemEntry.get(0)).getInt("subitemqty");
                newSubGroup.set("entrynumberofthis", (Object)(number * pickQty));
            }
            DynamicObjectCollection groupItemEntry = newSubGroup.getDynamicObjectCollection("groupitementry");
            for (DynamicObject ruleItem : ruleItemEntry) {
                DynamicObject subGroupItem = new DynamicObject(groupItemEntry.getDynamicObjectType());
                subGroupItem.set("itemid", ruleItem.get("subgitemid"));
                subGroupItem.set("itemname", (Object)ruleItem.getDynamicObject("subgitemid").getString("name"));
                subGroupItem.set("itemclassid", ruleItem.get("subgitemclassid"));
                subGroupItem.set("itembrand", ruleItem.get("subgbrandid"));
                subGroupItem.set("barcodeid", ruleItem.get("subgbarcodeid"));
                subGroupItem.set("itemqty", ruleItem.get("subitemqty"));
                subGroupItem.set("unit", ruleItem.getDynamicObject("subgitemid").get("retailunit"));
                subGroupItem.set("retailprice", ruleItem.get("subgpromoteprice"));
                subGroupItem.set("deliverystocktype", ruleItem.get("subgdeliverystocktype"));
                subGroupItem.set("deliverymode", ruleItem.get("subgdeliverymode"));
                groupItemEntry.add((Object)subGroupItem);
            }
            subGroupEntry.add((Object)newSubGroup);
        }
    }

    private DynamicObject getMaterialinventoryinfo(DynamicObject item) {
        QFilter filter = new QFilter("masterid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"material"));
        return BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])filter.toArray());
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        if ("groupentry".equals(((CardEntry)evt.getSource()).getEntryKey())) {
            int row = evt.getRow();
            DynamicObjectCollection groupitementry = ((DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("groupentry").get(row)).getDynamicObjectCollection("groupitementry");
            if (!CollectionUtils.isEmpty((Collection)groupitementry)) {
                this.getView().getModel().setValue("numberofthis", ((DynamicObject)groupitementry.get(0)).get("itemqty"));
            } else {
                this.getView().getModel().setValue("numberofthis", (Object)0);
            }
        }
    }
}

