/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocdpm.business.promote.helper.FqtyPointHelper;
import kd.occ.ocdpm.common.util.ArabicToChineseUtils;
import kd.occ.ocdpm.formplugin.promote.AbstractPromoteFormPlugin;

public class FqtyPointFormPlugin
extends AbstractPromoteFormPlugin {
    @Override
    public void initpage(long pkId) {
        FqtyPointHelper.initpage((IDataModel)this.getView().getModel(), (long)pkId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("pointqty".equals(key)) {
            int parentRowIndex = e.getChangeSet()[0].getParentRowIndex();
            DynamicObjectCollection rules = this.getView().getModel().getEntryEntity("ruleentity");
            DynamicObject rule = (DynamicObject)rules.get(parentRowIndex);
            this.updatePoint(parentRowIndex, rule);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"pointentity", (CharSequence)e.getEntryProp().getName())) {
            int index = this.getModel().getEntryCurrentRowIndex("ruleentity");
            DynamicObjectCollection rules = this.getView().getModel().getEntryEntity("ruleentity");
            DynamicObject rule = (DynamicObject)rules.get(index);
            this.updatePoint(index, rule);
        }
    }

    private void updatePoint(int parentRowIndex, DynamicObject rule) {
        DynamicObjectCollection pointentrys = rule.getDynamicObjectCollection("pointentity");
        int sumqty = pointentrys.stream().mapToInt(s -> s.getInt("pointqty")).sum();
        rule.set("pointsumqty", (Object)sumqty);
        this.getView().updateView("pointsumqty", parentRowIndex);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObjectCollection ladEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("ruleentity");
        for (DynamicObject ladEntity : ladEntry) {
            this.getView().getModel().setValue("ladnumber", (Object)ArabicToChineseUtils.formatInteger((int)ladEntity.getInt("seq")), ladEntity.getInt("seq") - 1);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        int index;
        FieldEdit source = (FieldEdit)e.getSource();
        if ("targetqty".equals(source.getFieldKey()) && (index = this.getModel().getEntryCurrentRowIndex("ruleentity")) > 0) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("ruleentity", index);
            Object value = e.getValue();
            int targetAmount = ObjectUtils.isEmpty((Object)value) ? 0 : Integer.parseInt(value.toString());
            DynamicObject rowEntityLast = this.getModel().getEntryRowEntity("ruleentity", index - 1);
            int targetAmountLast = rowEntityLast.getInt("targetqty");
            if (targetAmountLast == 0) {
                NotificationUtil.showTipNotification((String)ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u524d\u4e00\u4e2a\u9636\u68af\u4ef6\u6570", (String)"FqtyPointFormPlugin_0", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), (IFormView)this.getView(), (Integer)1000);
                e.setCancel(true);
                this.getView().updateView("targetqty", index);
            } else if (targetAmount <= targetAmountLast) {
                NotificationUtil.showTipNotification((String)ResManager.loadKDString((String)"\u5f53\u524d\u9636\u68af\u6ee1\u8db3\u4ef6\u6570\u9700\u5927\u4e8e\u524d\u4e00\u4e2a\u9636\u68af\u4ef6\u6570", (String)"FqtyPointFormPlugin_1", (String)"occ-ocdpm-formplugin", (Object[])new Object[0]), (IFormView)this.getView(), (Integer)1000);
                e.setCancel(true);
                this.getView().updateView("targetqty", index);
            }
        }
    }
}

