/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.formplugin.promote;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.handle.SetBranchRangeHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdpm.business.promote.helper.PromotionHelper;
import kd.occ.ocdpm.formplugin.promote.AbstractPromoteEdit;

public class PromoteHomepageEdit
extends AbstractPromoteEdit {
    private static final String COUNT = "count";
    private static final String EX_COUNT = "excount";
    private static final String KEY_IMPORTER = "importentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_member", "btn_memberlever", "btn_membertag", "btn_date", "btn_monthly", "btn_week", "btn_weekly"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String deadlock = this.getPageCache().get("prevent_dead_lock_key");
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (StringUtils.isEmpty((String)deadlock)) {
            String formId;
            this.getPageCache().put("prevent_dead_lock_key", "prevent_dead_lock_key");
            long pkId = 0L;
            Object pk = parameter.getPkId();
            if (!Objects.isNull(pk)) {
                pkId = (Long)pk;
                formId = PromotionHelper.gerformIdByPkId((long)pkId);
            } else {
                formId = (String)parameter.getCustomParam("schemekey");
            }
            this.initPromoteHomepage(pkId, formId);
        } else {
            this.initListInfo((String)parameter.getCustomParam("schemekey"));
        }
    }

    private void initPromoteHomepage(long pkId, String formId) {
        switch (formId) {
            case "ocdpm_promote_pointprice": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"discount", "allitemdisco", "discountprice"});
                this.getModel().setValue("itemselected", (Object)2);
                this.getView().setEnable(Boolean.FALSE, new String[]{"itemselected", "btn_itembrand", "btn_itemclass", "btn_itemlabel"});
                SessionManager.getCurrent().put(formId, this.getView().getPageId());
                this.initListInfo(formId);
                break;
            }
            case "ocdpm_promote_pointdisc": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"promoteprice", "quotaamount"});
                SessionManager.getCurrent().put(formId, this.getView().getPageId());
                this.initListInfo(formId);
                break;
            }
            default: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"allitemdisco", "itemprice", "discount", "promoteprice", "discountprice", "quotaamount"});
                this.initListInfo(formId);
                this.initActiveSpan(pkId, formId);
            }
        }
    }

    private void initActiveSpan(long pkId, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("activeflexpanelap");
        showParameter.setFormId(formId);
        if (pkId > 0L) {
            showParameter.setCustomParam("pkid", (Object)pkId);
        } else {
            this.initListInfo(formId);
            SessionManager.getCurrent().put(formId, showParameter.getPageId());
        }
        this.getView().showForm(showParameter);
    }

    private void initListInfo(String formId) {
        this.getView().getModel().setValue("promotetypeid", (Object)this.getPromoteTypeByformId(formId));
        this.getView().getModel().setValue("billname", (Object)PromotionEnum.getSchemenameByDynamickey((String)formId));
        this.getView().getModel().setValue("dynamicbill", (Object)formId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btn_member": {
                this.showPage("ocdbd_user", "membercallback", true);
                break;
            }
            case "btn_memberlever": {
                this.showPage("ocdbd_vip_level", "memberlevercallback", true);
                break;
            }
            case "btn_membertag": {
                this.showPage("ocdbd_member_label", "membertagcallback", true);
                break;
            }
            case "btn_week": {
                this.showPage("ocdpm_promote_week", "weekcallback", false);
                break;
            }
            case "btn_weekly": {
                this.showPage("ocdpm_promote_weekly", "weeklycallback", false);
                break;
            }
            case "btn_date": {
                this.showPage("ocdpm_promote_date", "datecallback", false);
                break;
            }
            case "btn_monthly": {
                this.showPage("ocdpm_promote_monthly", "monthcallback", false);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String opKey = op.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (opKey) {
            case "save": 
            case "unsubmit": {
                long promoteId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
                boolean exists = PromotionHelper.isExistsPromoteRule((long)promoteId);
                if (!exists) break;
                DeleteServiceHelper.delete((String)"ocdpm_promote_rule", (QFilter[])new QFilter[]{new QFilter("promotebillid", "=", (Object)promoteId)});
                break;
            }
            case "submit": {
                this.removeBlankRow(dataEntity);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("audit".equals(key) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            this.updatePromoteStatus();
        } else if (KEY_IMPORTER.equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocdpm_promote_ex_import");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ex_item"));
            this.getView().showForm(formShowParameter);
        } else if ("importitementry".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocdpm_promote_import");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "item"));
            this.getView().showForm(formShowParameter);
        }
    }

    private void updatePromoteStatus() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date auditDate = (Date)this.getModel().getValue("auditdate");
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        if (ft.format(startDate).equals(ft.format(auditDate))) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            bill.set("promotestatus", (Object)Character.valueOf('B'));
            SaveServiceHelper.update((DynamicObject)bill);
            this.getView().updateView("promotestatus");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        IDataModel dataModel = this.getView().getModel();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "orgrange": {
                DynamicObjectCollection customerGroup = (DynamicObjectCollection)dataModel.getValue("channelclassification");
                if (!customerGroup.isEmpty()) {
                    dataModel.beginInit();
                    dataModel.setValue("channelclassification", null);
                    this.getView().updateView("channelclassification");
                    dataModel.endInit();
                }
                DynamicObjectCollection range = (DynamicObjectCollection)changeSet[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)range, (boolean)true, (String)"branchreeentryentity", (String)"applyorgid", (String)"branchid");
                this.expand();
                break;
            }
            case "channelclassification": {
                DynamicObjectCollection orgRange = (DynamicObjectCollection)dataModel.getValue("orgrange");
                if (!orgRange.isEmpty()) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("orgrange", null);
                    this.getView().updateView("orgrange");
                    this.getView().getModel().endInit();
                }
                DynamicObjectCollection group = (DynamicObjectCollection)changeSet[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)group, (boolean)false, (String)"branchreeentryentity", (String)"applyorgid", (String)"branchid");
                this.expand();
                break;
            }
            case "controlmethod": {
                String controlMethod = String.valueOf(changeSet[0].getNewValue());
                if (!"A".equals(controlMethod)) break;
                dataModel.deleteEntryData("branchreeentryentity");
                break;
            }
            case "itemselected": {
                this.getModel().deleteEntryData("itemlistentry");
                break;
            }
            case "itemclassid": 
            case "itemlabelid": 
            case "brandid": {
                this.updateType(changeSet);
                break;
            }
            case "exitemclassid": 
            case "exitemlabelid": 
            case "exbrandid": {
                this.updateExType(changeSet);
                break;
            }
        }
    }

    private void updateType(ChangeData[] changeSet) {
        int row = changeSet[0].getRowIndex();
        DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("itemlistentry").get(row);
        int count = entry.getInt(COUNT);
        if (changeSet[0].getNewValue() != null) {
            this.getModel().setValue("type", (Object)"5", row);
            this.getModel().setValue(COUNT, (Object)(count + 1));
        } else {
            this.getModel().setValue(COUNT, (Object)(count - 1));
            if (count - 1 == 0) {
                this.getModel().setValue("type", entry.get("typecopy"), row);
            }
        }
        this.getView().updateView("itemlistentry", row);
    }

    private void updateExType(ChangeData[] changeSet) {
        int row = changeSet[0].getRowIndex();
        DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("exitemlistentry").get(row);
        int count = entry.getInt(EX_COUNT);
        if (changeSet[0].getNewValue() != null) {
            this.getModel().setValue("extype", (Object)"5", row);
            this.getModel().setValue(EX_COUNT, (Object)(count + 1));
        } else {
            this.getModel().setValue(EX_COUNT, (Object)(count - 1));
            if (count - 1 == 0) {
                this.getModel().setValue("extype", entry.get("extypecopy"), row);
            }
        }
        this.getView().updateView("exitemlistentry", row);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection memberEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("memberentryentity");
        DynamicObjectCollection dateEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("dateentryentity");
        switch (actionId) {
            case "membercallback": {
                this.fillMemberEntity(e, memberEntity, "ocdbd_user");
                break;
            }
            case "memberlevercallback": {
                this.fillMemberEntity(e, memberEntity, "ocdbd_vip_level");
                break;
            }
            case "membertagcallback": {
                this.fillMemberEntity(e, memberEntity, "ocdbd_member_label");
                break;
            }
            case "datecallback": {
                this.fillDateEntity(e, dateEntity, "btn_date");
                break;
            }
            case "weekcallback": {
                this.fillDateEntity(e, dateEntity, "btn_week");
                break;
            }
            case "weeklycallback": {
                this.fillDateEntity(e, dateEntity, "btn_weekly");
                break;
            }
            case "monthcallback": {
                this.fillDateEntity(e, dateEntity, "btn_monthly");
                break;
            }
            case "ex_item": {
                this.fillExImportData(e, true);
                break;
            }
            case "item": {
                this.fillExImportData(e, false);
                break;
            }
        }
    }

    private void fillExImportData(ClosedCallBackEvent e, boolean isEx) {
        List importList = (List)e.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)importList)) {
            DynamicObjectCollection receiptEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("exitemlistentry");
            DynamicObjectCollection itemEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("itemlistentry");
            int index = receiptEntry.size();
            int row = itemEntry.size();
            for (JSONObject importInfo : importList) {
                if (isEx) {
                    DynamicObject newEntryRow = receiptEntry.addNew();
                    newEntryRow.set("seq", (Object)index++);
                    newEntryRow.set("extype", importInfo.get((Object)"type"));
                    newEntryRow.set("exitemid", importInfo.get((Object)"item"));
                    newEntryRow.set("exitemclassid", importInfo.get((Object)"itemClass"));
                    newEntryRow.set("exbrandid", importInfo.get((Object)"itemBrand"));
                    newEntryRow.set("exitemlabelid", importInfo.get((Object)"itemLabel"));
                    newEntryRow.set("exunitid", importInfo.get((Object)"unit"));
                    newEntryRow.set("exmaterielid", importInfo.get((Object)"material"));
                    newEntryRow.set("exbarcodeid", importInfo.get((Object)"barCode"));
                    newEntryRow.set("exitemlabelid", importInfo.get((Object)"itemLabel"));
                    continue;
                }
                DynamicObject entryRow = itemEntry.addNew();
                entryRow.set("seq", (Object)row++);
                entryRow.set("type", importInfo.get((Object)"type"));
                entryRow.set("itemid", importInfo.get((Object)"item"));
                entryRow.set("itemclassid", importInfo.get((Object)"itemClass"));
                entryRow.set("brandid", importInfo.get((Object)"itemBrand"));
                entryRow.set("itemlabelid", importInfo.get((Object)"itemLabel"));
                entryRow.set("unitid", importInfo.get((Object)"unit"));
                entryRow.set("materielid", importInfo.get((Object)"material"));
                entryRow.set("barcodeid", importInfo.get((Object)"barCode"));
                entryRow.set("promoteprice", importInfo.get((Object)"retailprice"));
            }
            if (isEx) {
                this.getView().updateView("exitemlistentry");
            } else {
                this.getView().updateView("itemlistentry");
            }
        }
    }

    private void removeBlankRow(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("costentry");
        entryEntity.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"costobject") == 0L);
        this.getView().updateView("costentry");
    }
}

